<?php 
class ControllerSalePayActivate extends Controller {
private $error = array();
public function index() {
		$this->language->load('sale/payActivate');		 
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('sale/payActivate');
    	$this->getList();
  	}
	
public function getList() {	 
		$total  = '';
		$this->load->model('sale/payActivate');
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_stbno'])) {
			$this->data['filter_stbno'] = $this->request->get['filter_stbno'];
		} else {
			$this->data['filter_stbno'] ='';
		}

		if (isset($this->request->get['filter_package'])) {
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			
			$this->data['filter_package'] ='';
		}

		if (isset($this->request->get['payment_amount'])) {
			$this->data['payment_amount'] = $this->request->get['payment_amount'];
		} else {
			$this->data['payment_amount'] ='';
		}

		if (isset($this->request->get['filter_stbno'])) {
			$filter_stbno = $this->request->get['filter_stbno'];
		} else {
			$filter_stbno = '';
		}

		if (isset($this->request->get['filter_package'])) {
			$filter_package = $this->request->get['filter_package'];
		} else {
			$filter_package = '';
		}

		if (isset($this->request->get['payment_amount'])) {
			$payment_amount = $this->request->get['payment_amount'];
		} else {
			$payment_amount = '';
		}

		if (isset($this->error['payment_amount'])) {
			$this->data['error_payment_amount'] = $this->error['payment_amount'];
		} else {
			$this->data['error_payment_amount'] = '';
		}

		if (isset($this->error['filter_package'])) {
			$this->data['error_filter_package'] = $this->error['filter_package'];
		} else {
			$this->data['error_filter_package'] = '';
		}

		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/payActivate', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		
   		$this->data['printPdf'] = $this->url->link('sale/payActivate/printPdf', 'token=' . $this->session->data['token'] . $url.'&start='.($page - 1) * $this->config->get('config_limit_admin').'&limit='.$this->config->get('config_limit_admin'), 'SSL');
   		$this->data['action'] = $this->url->link('sale/payActivate/payment', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$data = array(
			'filter_stbno'	  => $filter_stbno,
			'payment_amount'  => $payment_amount,	
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		$pairedResult 	= $this->model_sale_payActivate->getPairedSubscribers($filter_stbno);
		
		if($this->data['filter_stbno']!='' || isset($this->request->get['filter_stbno']))	{
			if($pairedResult){
				$this->data['stbHistoryLists'] = array();
				$results = $this->model_sale_payActivate->getStbCustomerDetails($data);
				// echo "<pre>"; print_r($results); die;
				$total 	 = sizeof($results); 
				foreach ($results as $result) {	
					$this->data['stbHistoryLists'][] = array(
					'customer_no'		=> $result['customer_no'],
					'cust_name'			=> $result['cust_name'],
					'telephone' 		=> $result['telephone'],
					'region_name'  		=> $result['region_name'],
					'group_name' 		=> $result['group_name'],
					'stb_status'  		=> ($result['is_active']==0)?'De-active':'Active'
					);						
				}

				$this->data['stbPkgSubscriptionLists'] = array();
				$PkgSubsResults = $this->model_sale_payActivate->getPackageSubscriptionDetails($filter_stbno);
				// echo "<pre>"; print_r($PkgSubsResults);die;
				foreach ($PkgSubsResults as $result) {	
					$this->data['stbPkgSubscriptionLists'][] = array(
					'cmd_id'			=> $result['cmd_id'],
					'stb_status'  		=> ($result['is_active']==0)?'De-active':'Active',
					'pname'  			=> $result['pkgname'],
					'exp_date'  		=> ($result['exp_date']==null)?'N/A':$result['exp_date'] 
					);						
				}

				$this->data['stbProdSubscriptionLists'] = array();
				$ProdSubsResults = $this->model_sale_payActivate->getProductSubscriptionDetails($filter_stbno);
				foreach ($ProdSubsResults as $result) {	
					$this->data['stbProdSubscriptionLists'][] = array(
					'cmd_id'			=> $result['cmd_id'],
					'stb_status'  		=> ($result['is_active']==0)?'De-active':'Active',
					'pname'  			=> $result['prodname'],
					'exp_date'  		=> ($result['exp_date']==null)?'N/A':$result['exp_date'] 
					);						
				}

				$resultPkgs = $this->model_sale_payActivate->getPackages();
				foreach ($resultPkgs as $package) {
					$this->data['packages'][] = array(
						'package_name' =>$package['name'],
						'package_id'   =>$package['product_id'],
						);
				}
			}	
		}
		$this->data['heading_title'] 		= $this->language->get('heading_title');
		$this->data['column_cust_no'] 		= $this->language->get('column_cust_no');		
		$this->data['column_cust_name'] 	= $this->language->get('column_cust_name');
		$this->data['column_mobile_no'] 	= $this->language->get('column_mobile_no');
		$this->data['column_region'] 		= $this->language->get('column_region');
		$this->data['column_group'] 		= $this->language->get('column_group');

		$this->data['column_stb_status']    = $this->language->get('column_stb_status');
		$this->data['column_package_subs']  = $this->language->get('column_package_subs');
		$this->data['column_ala_carte_subs']= $this->language->get('column_ala_carte_subs');
		$this->data['column_package_name']  = $this->language->get('column_package_name');
		$this->data['column_ala_carte_name']= $this->language->get('column_ala_carte_name');
		$this->data['column_expiry']		= $this->language->get('column_expiry');

		$this->data['button_add'] 			= $this->language->get('button_add');
		$this->data['button_filter'] 		= $this->language->get('button_filter');
		$this->data['entry_stbno'] 			= $this->language->get('entry_stbno');
		$this->data['entry_package'] 		= $this->language->get('entry_package');
		$this->data['entry_update_payment_amt']= $this->language->get('entry_update_payment_amt');

		$this->data['text_no_results'] 		= $this->language->get('text_no_results');
		$this->data['button_invoice'] 		= $this->language->get('button_invoice');
		$this->data['token'] 				= $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		if (isset($this->request->get['filter_stbno'])) {
			$url .= '&filter_stbno=' . $this->request->get['filter_stbno'];
		}

		if (isset($this->request->get['payment_amount'])) {
			$url .= '&payment_amount=' . $this->request->get['payment_amount'];
		}

		if (isset($this->request->get['page'])) {	
			$url .= '&filter_stbno=' . $this->request->get['filter_stbno'];		
			$this->data['printPdf'] = $this->url->link('sale/payActivate/printPdf', 'token=' . $this->session->data['token'].'&page='.$this->request->get['page']. $url, 'SSL');
		} else {
			$this->data['printPdf'] = $this->url->link('sale/payActivate/printPdf', 'token=' . $this->session->data['token'].'&page='.'1'. $url, 'SSL');
		}

		$this->data['action'] = $this->url->link('sale/payActivate/payment', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/payActivate', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'sale/payActivate.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

  	public function payment() {  
  		$obj = new restapi();
		$this->language->load('sale/payActivate');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('sale/payActivate');
		$this->load->model('commands/box_activation');
		$this->load->model('sale/order');
		$this->load->model('commands/osd');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			/*=========== IF box is activated =============*/
			if(isset($this->request->post['payment_amount'])){
				$paymentAmount = $this->request->post['payment_amount'];
			}
			$stbResult 	 = $this->model_sale_payActivate->getStbCurrentStatus($this->request->get['filter_stbno']);
			$customer_id = $stbResult[0]['customer_id'];
		    $operator_id = $stbResult[0]['operator_id'];
		    $STBNO 		 = $stbResult[0]['stb_no'];
		    $error_encounter=0;
			$errorMsg="";
			$flag=false;
			$apimessage='';
			$finalExpiryDate=null;
			$i=0;
			$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
			$currentDate =  $now_datetime->getTimestamp(); 		
			$arr = array()	;
			$casop_arr = array();
			$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
			$current_date = $currDate->format('d-m-Y H:i:s');
			$expiry_time = date('Y-m-d H:i:s', strtotime('+1 year', strtotime($current_date)));
			$kms_expiry=strtotime($expiry_time);
			$subsResult = $this->model_sale_payActivate->getCurrentSubscriptionStatus($stbResult[0]['customer_id']);
			// echo "<pre>"; print_r($subsResult); die;
			if($stbResult[0]['is_active']==1){
				if(isset($this->request->post['filter_package'])){ 
					$packageId 	= $this->request->post['filter_package']; 
					$ExpiryDate = date('Y-m-d H:i:s', strtotime('+12 months', strtotime($current_date)));
					$finalExpiryDate = strtotime($ExpiryDate); 
					/************************* Check Product Expiry **************************/
					$DB_subscriptionData = $this->model_sale_order->getDBSubscriptionData($packageId,$customer_id);
					if($DB_subscriptionData){
						$datetime = new DateTime($DB_subscriptionData['expire_date'], new DateTimeZone('Asia/Calcutta'));
						$DB_expiryDate  = $datetime->getTimestamp(); 
						
						if((int)$DB_subscriptionData['is_cancel']==0){							
							if($DB_expiryDate <= $currentDate){
								$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$packageId);
							}
							elseif($DB_expiryDate > $currentDate){
								$this->model_sale_order->updateExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$packageId);
							}
						}else{
								$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$packageId);
						}
					}  
					$customer = $this->model_sale_order->getCustomerKmsId($customer_id);	
					$product  = $this->model_sale_order->getProductKmsId($packageId);
					$obj = new restapi();
					$method ="POST";
					$duration=$this->model_sale_order->getOrderPPVDuration($packageId);	
					$cmd_id='6'; 
					$data="user_id=".$customer['api_user_id']."&package_id=".$product['api_product_id']."&start_time=".$currentDate."&end_time=".$finalExpiryDate;
					$uri=KMS_API."/enablePackageSubscription";	
											
					$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					$res=$obj->callAPI($method,$hdr,$uri,$data);
					$response=json_decode($res);
					$error=true;
					$apimessage='';
					$errorMsg='';
					foreach ($response as $key => $value) {
						switch ($key) {
		    				case 'error':
		    					$error=	$value;
		    					break;
		    				case 'message':
		    					$apimessage=$value;				
		    					break;
		    				case 'id':
		    					$product_subscription_id=$value;	
		    					break;
		    				case 'mq_response':
		    					$curlresponse=$value;	
		    					break;
		    				default:
		    					$errorMsg=$errorMsg." ".$key.":".$value;	
		    					break;
		    			}
					}
					$log_target_level = "Individual";
					$log_target = $STBNO;
		    		if(!$error)	{
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
						$nack_is=-1;
						$ack_is=-1;
						if($ack=='ACK')
						{
							$ack_is=1;
						}elseif($ack=='NACK'){
							$nack_is=0;
						}
						$flag=true; 
						$data=$this->request->post;
						$p_no = $this->model_sale_order->getPNo($packageId);
						$casop_id = $this->model_sale_order->addToTransanction($customer_id,$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$nack_is,$packageId,$product['is_package'],$packageId,0,$operator_id,$log_target);
						$this->model_sale_order->addToSubscription($customer_id,$packageId,$finalExpiryDate);
						
						if($ack_is==1){
							$this->model_sale_order->addToSubscriptionDesubscription($customer_id,$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$packageId,$operator_id,$STBNO);
						}

						array_push($casop_arr,$casop_id);
						$resend_status = 0;						
						if ($product['is_package']==1) {
							$commandid = 6;
							$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PACKAGE SUBS."." - ".$p_no,$resend_status,$commandid,$p_no);
						}
					}else{
						$error_encounter=1;
						$errorMsg=$errorMsg." :".$apimessage;
					}
					/*----------------------- OSD Command------------------------*/
					$customer_id  	= $this->model_commands_osd->getCustomerId($this->request->get['filter_stbno']);
					$local_target 	= (int)$customer_id["customer_id"];
			 	  	$target 	  	= (int)$customer_id["api_user_id"];
			 	  	$operator_id  	= (int)$customer_id["operator_id"];
			 	  	$log_target_level="Individual";
			 	  	$log_target_level_numeric = 1;
			 	  	$log_target   	= $this->request->get['filter_stbno'];
					$target_level 	= 1;
					 	  	
			 	  	$language 		= "eng";
					$message 		= "Pay&Activate OSD";
					$transparency 	= "50";
					$bg_color 		= "000000";
					$fore_color 	= "FFFFFF";
					$scrolling 	    = 0;
					$display_type 	= 0;
					$forced 		= 1;

					$osdExpiry = date('Y-m-d H:i:s', strtotime('+3 days', strtotime($current_date)));
					$datetime = new DateTime($osdExpiry, new DateTimeZone('Asia/Calcutta'));
					$expiry = $datetime->getTimestamp();

					$obj = new restapi();
				    $method ="POST";
				    $data="target_level=".trim($target_level)."&target=".$target."&language=".$language."&message=".$message."&transparency=".$transparency."&bg_color=".$bg_color."&fore_color=".$fore_color."&display_type=".$display_type."&expiry=".$expiry."&forced=".$forced."&scrolling=".$scrolling;
					
				    $url="".KMS_API."/enableOSD";
				    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
				    $response=json_decode($apiresult);
				    $error=true;
				    $errorMsg='';
				    $apimessage="KMS API Failed";
				    foreach ($response as $key => $value) {
				    	switch ($key) {
				    		case 'error':
				    			$error=$value;
				    		break;
				    		case 'id':
				    			$id=$value;
				    		break;
				    		case 'message':
				    			$apimessage=$value;
				    		break;
				    		case 'mq_response':
				    			$curlresponse=$value;
				    		break;
				    		default:
				    			$errorMsg=$errorMsg." ".$key. ": ".$value;
				    		break;
				    	}
					}

					$resend_status = 0;
					$commandid = 3;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"OSD",$resend_status,$commandid,$log_target_level_numeric);
					$ack_is=-1;$nack_is=-1;
					if(!$error)
					{
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));					
						if($ack=='ACK')
						{
							$ack_is=1;
						}elseif($ack=='NACK'){
							$nack_is=-1;
						}
						$payload = $target."#".$language."#".$message."#".$transparency."#".$bg_color."#".$display_type."#".$expiry."#".$forced;
						
						$this->model_commands_osd->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id);
						$this->session->data['success'] = $apimessage;
						$url = '';
					} # End OSD Command
				}   # END IF (filter_package)
				if($subsResult){
					foreach ($subsResult as $order_product) {
						if($order_product['cmd_id']==6 || $order_product['cmd_id']==10)					
							$ExpiryDate = date('Y-m-d H:i:s', strtotime('+12 months', strtotime($current_date)));
						
						$finalExpiryDate = strtotime($ExpiryDate); 
						/************************* Check Product Expiry **************************/
						$DB_subscriptionData = $this->model_sale_order->getDBSubscriptionData($order_product['product_id'], $order_product['user_id']);
						if($DB_subscriptionData){
							$datetime = new DateTime($DB_subscriptionData['expire_date'], new DateTimeZone('Asia/Calcutta'));
							$DB_expiryDate  = $datetime->getTimestamp(); 
							
							if((int)$DB_subscriptionData['is_cancel']==0){							
								if($DB_expiryDate <= $currentDate){
									$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$order_product['user_id']);
								}
								elseif($DB_expiryDate > $currentDate){
									$this->model_sale_order->updateExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$order_product['user_id']);
								}
							}else{
									$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$order_product['user_id']);
							}
						}
						$customer=$this->model_sale_order->getCustomerKmsId($order_product['user_id']);	
						$product=$this->model_sale_order->getProductKmsId($order_product['product_id']);
						// -----------------------------------------------------------------------------------
							$is_nvod = $this->model_sale_order->isNvod($order_product['product_id']);
						// -----------------------------------------------------------------------------------
						$obj = new restapi();
						$method ="POST";	
						$duration=$this->model_sale_order->getOrderPPVDuration($order_product['product_id']);		
						if($product['is_package']==0 && $product['is_ppv']==0)	{
							$cmd_id='10';
							$data="user_id=".$customer['api_user_id']."&product_id=".$product['api_product_id']."&start_time=".$currentDate."&end_time=".$finalExpiryDate."&is_nvod=".$is_nvod['is_nvod'];
							$uri=KMS_API."/enableProductSubscription";
						}else {
							$cmd_id='6';
							$data="user_id=".$customer['api_user_id']."&package_id=".$product['api_product_id']."&start_time=".$currentDate."&end_time=".$finalExpiryDate;
							$uri=KMS_API."/enablePackageSubscription";	
						}
						
						$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
						$res=$obj->callAPI($method,$hdr,$uri,$data);
						$response=json_decode($res);
						$error=true;
						$apimessage='';
						$errorMsg='';
						foreach ($response as $key => $value) {
							switch ($key) {
			    				case 'error':
			    					$error=	$value;
			    					break;
			    				case 'message':
			    					$apimessage=$value;				
			    					break;
			    				case 'id':
			    					$product_subscription_id=$value;	
			    					break;
			    				case 'mq_response':
			    					$curlresponse=$value;	
			    					break;
			    				default:
			    					$errorMsg=$errorMsg." ".$key.":".$value;	
			    					break;
			    			}
	    				}
	    				$log_target_level = "Individual";
						$log_target = $STBNO;
			    		if(!$error)	{
							$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
							$nack_is=-1;
							$ack_is=-1;
							if($ack=='ACK')
							{
								$ack_is=1;
							}elseif($ack=='NACK'){
								$nack_is=0;
							}
							$flag=true;
							$data=$this->request->post;
							array_push($arr, $order_product);
							$p_no = $this->model_sale_order->getPNo($order_product['product_id']);
							if($product['is_ppv']==1){
								$casop_id = $this->model_sale_order->addToTransanction($order_product['user_id'],$cmd_id,$ppv_expirytime,$product_subscription_id,$ack_is,$nack_is,$order_product['product_id'],$product['is_package'],$order_product['user_id'],$duration[0]["date_added"],$operator_id,$log_target);
								$this->model_sale_order->addToSubscription($order_product['user_id'],$order_product['product_id'],$ppv_expirytime,$duration[0]["date_added"]);
							}else{
								$casop_id = $this->model_sale_order->addToTransanction($order_product['user_id'],$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$nack_is,$order_product['product_id'],$product['is_package'],$order_product['user_id'],0,$operator_id,$log_target);
								$this->model_sale_order->addToSubscription($order_product['user_id'],$order_product['product_id'],$finalExpiryDate);
							}

								$this->model_sale_order->addToSubscriptionDesubscription($order_product['user_id'],$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$order_product['product_id'],$operator_id,$STBNO);

							array_push($casop_arr,$casop_id);
							$resend_status = 0;						
							if ($product['is_package']==1) {
								$commandid = 6;
								$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PACKAGE SUBS."." - ".$p_no,$resend_status,$commandid,$p_no);
							}else{
								$commandid = 10;
								$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PRODUCT SUBS."." - ".$p_no,$resend_status,$commandid,$p_no);
							}
						}else{
							$error_encounter=1;
							$errorMsg=$errorMsg." :".$apimessage;
						}
					} # End Foreach
				}  # END Product/Package Subscription 
					/*----------------------- OSD Command------------------------*/
					$customer_id  	= $this->model_commands_osd->getCustomerId($this->request->get['filter_stbno']);
					$local_target 	= (int)$customer_id["customer_id"];
			 	  	$target 	  	= (int)$customer_id["api_user_id"];
			 	  	$operator_id  	= (int)$customer_id["operator_id"];
			 	  	$log_target_level="Individual";
			 	  	$log_target_level_numeric = 1;
			 	  	$log_target   	= $this->request->get['filter_stbno'];
					$target_level 	= 1;
					 	  	
			 	  	$language 		= "eng";
					$message 		= "Pay&Activate OSD";
					$transparency 	= "50";
					$bg_color 		= "000000";
					$fore_color 	= "FFFFFF";
					$scrolling 	    = 0;
					$display_type 	= 0;
					$forced 		= 1;

					$osdExpiry = date('Y-m-d H:i:s', strtotime('+3 days', strtotime($current_date)));
					$datetime = new DateTime($osdExpiry, new DateTimeZone('Asia/Calcutta'));
					$expiry = $datetime->getTimestamp();

					$obj = new restapi();
				    $method ="POST";
				    $data="target_level=".trim($target_level)."&target=".$target."&language=".$language."&message=".$message."&transparency=".$transparency."&bg_color=".$bg_color."&fore_color=".$fore_color."&display_type=".$display_type."&expiry=".$expiry."&forced=".$forced."&scrolling=".$scrolling;
					
				    $url="".KMS_API."/enableOSD";
				    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
				    $response=json_decode($apiresult);
				    $error=true;
				    $errorMsg='';
				    $apimessage="KMS API Failed";
				    foreach ($response as $key => $value) {
				    	switch ($key) {
				    		case 'error':
				    			$error=$value;
				    		break;
				    		case 'id':
				    			$id=$value;
				    		break;
				    		case 'message':
				    			$apimessage=$value;
				    		break;
				    		case 'mq_response':
				    			$curlresponse=$value;
				    		break;
				    		default:
				    			$errorMsg=$errorMsg." ".$key. ": ".$value;
				    		break;
				    	}
					}

					$resend_status = 0;
					$commandid = 3;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"OSD",$resend_status,$commandid,$log_target_level_numeric);
					$ack_is=-1;$nack_is=-1;
					if(!$error)
					{
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));					
						if($ack=='ACK')
						{
							$ack_is=1;
						}elseif($ack=='NACK'){
							$nack_is=-1;
						}
						$payload = $target."#".$language."#".$message."#".$transparency."#".$bg_color."#".$display_type."#".$expiry."#".$forced;
						
						$this->model_commands_osd->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id);
						$this->session->data['success'] = $apimessage;
						$url = '';
					} # End OSD Command

			}else{ 
				/*---------------- BOX ACTIVATION ---------------------*/
				$data="stb_no=".$STBNO."&expiry=".$kms_expiry;
		 		$method ="POST";
		 		$url=KMS_API."/enableSTBActivation";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);

	    		$response=json_decode($apiresult);
	    		$apimessage='';
	    		$errorMsg='';
	    		$error=true;	
	    		$cmd_id=0;
				foreach ($response as $key => $value) {
					switch ($key) {
					case 'error':
						$error=$value;
						break;
					case 'id':
						$id=$value;
						break;
					case 'mq_response':
						$curlresponse=$value;
						break;
					case 'message':
						$apimessage=$value;
						break;
					default:
						$errorMsg=$key.':'.$value;
						break;
					}
				}
				$log_target_level = "Individual";
				$log_target = $stbResult[0]['stb_no'];
				
				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{
					$resend_status = 0;
					$commandid = 0;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"BOX ACTIVATION",$resend_status,$commandid);
					$cust_id=$customer_id;
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
						$this->model_commands_box_activation->setSTBActiveDeactive(1,$cust_id,1);	
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					
					$payload=$STBNO."#";//.$this->request->post['chip_no'];
					$target=1;
					$results = $this->model_commands_box_activation->addToCasOpTransanction($cust_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$expiry_time,$operator_id,$STBNO);
					$this->model_commands_box_activation->addPasscode($STBNO,0);
					/*=======================================================*/
						if($ack_is==1){
							$this->model_commands_box_activation->addToActivationDeactivation($cust_id,$cmd_id,$id,$ack_is,$expiry_time,$operator_id,$STBNO);
						}
					/*=======================================================*/

					$this->session->data['success']=$apimessage;
					$url = '';
									
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}

					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}

					if (isset($this->request->get['page'])) {
						$url .= '&page=' . $this->request->get['page'];
					}
				}/* End box Activation*/
				/*---------------- PRODUCT/PACKAGE SUBSCRIPTION -----------------------------*/
				if($subsResult){
					foreach ($subsResult as $order_product) {
						if($order_product['cmd_id']==6 || $order_product['cmd_id']==10)					
							$ExpiryDate = date('Y-m-d H:i:s', strtotime('+12 months', strtotime($current_date)));
						
						$finalExpiryDate = strtotime($ExpiryDate); 
						/************************* Check Product Expiry **************************/
						$DB_subscriptionData = $this->model_sale_order->getDBSubscriptionData($order_product['product_id'], $order_product['user_id']);
						if($DB_subscriptionData){
							$datetime = new DateTime($DB_subscriptionData['expire_date'], new DateTimeZone('Asia/Calcutta'));
							$DB_expiryDate  = $datetime->getTimestamp(); 
							
							if((int)$DB_subscriptionData['is_cancel']==0){							
								if($DB_expiryDate <= $currentDate){
									$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$order_product['user_id']);
								}
								elseif($DB_expiryDate > $currentDate){
									$this->model_sale_order->updateExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$order_product['user_id']);
								}
							}else{
									$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$order_product['user_id']);
							}
						}
						$customer=$this->model_sale_order->getCustomerKmsId($order_product['user_id']);	
						$product=$this->model_sale_order->getProductKmsId($order_product['product_id']);
						// -----------------------------------------------------------------------------------
							$is_nvod = $this->model_sale_order->isNvod($order_product['product_id']);
						// -----------------------------------------------------------------------------------
						$obj = new restapi();
						$method ="POST";	
						$duration=$this->model_sale_order->getOrderPPVDuration($order_product['product_id']);		
						if($product['is_package']==0 && $product['is_ppv']==0)	{
							$cmd_id='10';
							$data="user_id=".$customer['api_user_id']."&product_id=".$product['api_product_id']."&start_time=".$currentDate."&end_time=".$finalExpiryDate."&is_nvod=".$is_nvod['is_nvod'];
							$uri=KMS_API."/enableProductSubscription";
						}else {
							$cmd_id='6';
							$data="user_id=".$customer['api_user_id']."&package_id=".$product['api_product_id']."&start_time=".$currentDate."&end_time=".$finalExpiryDate;
							$uri=KMS_API."/enablePackageSubscription";	
						}
						
						$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
						$res=$obj->callAPI($method,$hdr,$uri,$data);
						$response=json_decode($res);
						$error=true;
						$apimessage='';
						$errorMsg='';
						foreach ($response as $key => $value) {
							switch ($key) {
			    				case 'error':
			    					$error=	$value;
			    					break;
			    				case 'message':
			    					$apimessage=$value;				
			    					break;
			    				case 'id':
			    					$product_subscription_id=$value;	
			    					break;
			    				case 'mq_response':
			    					$curlresponse=$value;	
			    					break;
			    				default:
			    					$errorMsg=$errorMsg." ".$key.":".$value;	
			    					break;
			    			}
	    				}
	    				$log_target_level = "Individual";
						$log_target = $STBNO;
			    		if(!$error)	{
							$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
							$nack_is=-1;
							$ack_is=-1;
							if($ack=='ACK')
							{
								$ack_is=1;
							}elseif($ack=='NACK'){
								$nack_is=0;
							}
							$flag=true;
							$data=$this->request->post;
							array_push($arr, $order_product);
							$p_no = $this->model_sale_order->getPNo($order_product['product_id']);
							if($product['is_ppv']==1){
								$casop_id = $this->model_sale_order->addToTransanction($order_product['user_id'],$cmd_id,$ppv_expirytime,$product_subscription_id,$ack_is,$nack_is,$order_product['product_id'],$product['is_package'],$order_product['user_id'],$duration[0]["date_added"],$operator_id,$log_target);
								$this->model_sale_order->addToSubscription($order_product['user_id'],$order_product['product_id'],$ppv_expirytime,$duration[0]["date_added"]);
							}else{
								$casop_id = $this->model_sale_order->addToTransanction($order_product['user_id'],$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$nack_is,$order_product['product_id'],$product['is_package'],$order_product['user_id'],0,$operator_id,$log_target);
								$this->model_sale_order->addToSubscription($order_product['user_id'],$order_product['product_id'],$finalExpiryDate);
							}

								$this->model_sale_order->addToSubscriptionDesubscription($order_product['user_id'],$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$order_product['product_id'],$operator_id,$STBNO);

							array_push($casop_arr,$casop_id);
							$resend_status = 0;						
							if ($product['is_package']==1) {
								$commandid = 6;
								$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PACKAGE SUBS."." - ".$p_no,$resend_status,$commandid,$p_no);
							}else{
								$commandid = 10;
								$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PRODUCT SUBS."." - ".$p_no,$resend_status,$commandid,$p_no);
							}
						}else{
							$error_encounter=1;
							$errorMsg=$errorMsg." :".$apimessage;
						}
					} # End Foreach
				}  # END Product/Package Subscription 
					/*----------------------- OSD Command------------------------*/
					$customer_id  	= $this->model_commands_osd->getCustomerId($this->request->get['filter_stbno']);
					$local_target 	= (int)$customer_id["customer_id"];
			 	  	$target 	  	= (int)$customer_id["api_user_id"];
			 	  	$operator_id  	= (int)$customer_id["operator_id"];
			 	  	$log_target_level="Individual";
			 	  	$log_target_level_numeric = 1;
			 	  	$log_target   	= $this->request->get['filter_stbno'];
					$target_level 	= 1;
					 	  	
			 	  	$language 		= "eng";
					$message 		= "Pay&Activate OSD";
					$transparency 	= "50";
					$bg_color 		= "000000";
					$fore_color 	= "FFFFFF";
					$scrolling 	    = 0;
					$display_type 	= 0;
					$forced 		= 1;

					$osdExpiry = date('Y-m-d H:i:s', strtotime('+3 days', strtotime($current_date)));
					$datetime = new DateTime($osdExpiry, new DateTimeZone('Asia/Calcutta'));
					$expiry = $datetime->getTimestamp();

					$obj = new restapi();
				    $method ="POST";
				    $data="target_level=".trim($target_level)."&target=".$target."&language=".$language."&message=".$message."&transparency=".$transparency."&bg_color=".$bg_color."&fore_color=".$fore_color."&display_type=".$display_type."&expiry=".$expiry."&forced=".$forced."&scrolling=".$scrolling;
					
				    $url="".KMS_API."/enableOSD";
				    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
				    $response=json_decode($apiresult);
				    $error=true;
				    $errorMsg='';
				    $apimessage="KMS API Failed";
				    foreach ($response as $key => $value) {
				    	switch ($key) {
				    		case 'error':
				    			$error=$value;
				    		break;
				    		case 'id':
				    			$id=$value;
				    		break;
				    		case 'message':
				    			$apimessage=$value;
				    		break;
				    		case 'mq_response':
				    			$curlresponse=$value;
				    		break;
				    		default:
				    			$errorMsg=$errorMsg." ".$key. ": ".$value;
				    		break;
				    	}
					}

					$resend_status = 0;
					$commandid = 3;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"OSD",$resend_status,$commandid,$log_target_level_numeric);
					$ack_is=-1;$nack_is=-1;
					if(!$error)
					{
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));					
						if($ack=='ACK')
						{
							$ack_is=1;
						}elseif($ack=='NACK'){
							$nack_is=-1;
						}
						$payload = $target."#".$language."#".$message."#".$transparency."#".$bg_color."#".$display_type."#".$expiry."#".$forced;
						
						$this->model_commands_osd->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id);
						$this->session->data['success'] = $apimessage;
						$url = '';
					} # End OSD Command
			} # End Else 
			$this->model_sale_payActivate->addCustomerPayment($stbResult[0]['customer_id'],$stbResult[0]['stb_no'],$paymentAmount);
			if(!$error)
				$this->session->data['success'] = "Payment done successfully.!!";
		} # End 1st IF	
		
		$this->getList();
  	}

  	protected function validateForm() { 

  		if (!$this->user->hasPermission('modify', 'sale/payActivate')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

		if($this->request->post['payment_amount'] == ''){
			$this->error['payment_amount'] = "Required payment amount..!";
		}

		if(isset($this->request->post['filter_package'])){
			if($this->request->post['filter_package'] == '-1'){
				$this->error['filter_package'] = "Please select any package..!";
			}
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}

  	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");

    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
        // ------------------------------only for stb activation------------------------------------
        $log_file = fopen(DIR_LOGS."sms_stb_activation.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target,24," ").$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$command_id,$resend_status);
    }

 }
?> 
