<?php
/*
@File customer_group.php(Controller)
ADMIN CUSTOMER_GROUP PAGE
    This class manages the customer_group by inserting/deleting/updating for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerSaleCustomerGroup extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer_group option in the dopdown list.
						It get all the customer_group list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_group page showing all the customer_group in a list.
*/ 
	public function index() {
		$this->language->load('sale/customer_group');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/customer_group');
		
		$this->getList();
	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_group form page where the admin can give the
						details of the new customer_group. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_group form page.
*/
	public function insert() {
		$obj = new restapi();
		$this->language->load('sale/customer_group');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer_group');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			
			$temp=$this->request->post;
			$data="group_name=".$temp ["customer_group_description"][1]["name"];
	 		$method ="POST";
	 		$url=KMS_API."/enableGroup";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded', API_AUTH_NAME.':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
        	$kms_group_id="";
        	$apimessage='';
		    $errorMsg='';
		    $error=true;
        	$response=json_decode($apiresult);
        	foreach ($response as $key => $value) {
    			switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$kms_group_id=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			if(!$error)
			{
				$customer_group_id=$this->model_sale_customer_group->addCustomerGroup($this->request->post);
        	 	$this->model_sale_customer_group->addApiResponceId($kms_group_id,$customer_group_id);
				$this->session->data['success'] = $this->language->get('text_insert_success');
			
				$url = '';

				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("SUCCESS:","NA",$temp["customer_group_description"][1]["name"],"addGroup");
				// ----------------------------------------------------------------------------	
				$this->redirect($this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("ERROR:","NA",$temp["customer_group_description"][1]["name"],"addGroup");
				// ----------------------------------------------------------------------------	
				$this->error['warning'] = $errorMsg.' '.$apimessage;
				$this->getForm();
			}
		}

		$this->getForm();
	}
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer_group details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/

	public function update() {
		$obj = new restapi();
		$this->language->load('sale/customer_group');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer_group');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$temp=$this->request->post;
			$data="group_name=".$temp ["customer_group_description"][1]["name"]."&update_id=1";
	 		$method ="POST";
	 		$url=KMS_API."/enableGroup";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
        	$kms_group_id="";
        	$apimessage='';
		    $errorMsg='';
		    $error=true;
        	$response=json_decode($apiresult);
        	foreach ($response as $key => $value) {
    			switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$kms_group_id=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			if(!$error)
			{
				$this->model_sale_customer_group->editCustomerGroup($this->request->get['customer_group_id'], $this->request->post);
				
				$this->session->data['success'] = $this->language->get('text_success');
				
				$url = '';

				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("SUCCESS:","NA",$temp["customer_group_description"][1]["name"],"modifyGroup");
				// ----------------------------------------------------------------------------	
				$this->redirect($this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("ERROR:","NA",$temp["customer_group_description"][1]["name"],"modifyGroup");
				// ----------------------------------------------------------------------------	
				$this->error['warning'] = $errorMsg.' '.$apimessage;
				$this->getForm();
			}
		}
		$this->getForm();
	}
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_group listed on the page. Admin selects the 
						checkbox against the customer_group in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_group list page after deleting the customer_group from the list.
*/
	public function delete() { 
		$obj = new restapi();
		$this->language->load('sale/customer_group');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer_group');
		$this->load->model('sale/customer');
		
		if ( $this->validateDelete() && $this->request->post) {
      		foreach ($this->request->post['selected'] as $customer_group_id) {
	      		$customer_status = $this->model_sale_customer_group->getCustomerGroupStatus($customer_group_id);
				if ((int)$customer_status['is_default']) {
					$this->session->data['warning'] = $this->language->get('text_warning_delete_check_def');
					$this->getList();
					return;
				}
				$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($customer_group_id);
				if ($customer_total) {
					$this->session->data['warning'] = $this->language->get('text_warning_delete_check');
					$this->getList();
					return;
				}
	      			$deleted_flag=false;
					$p = $this->model_sale_customer_group->getApiResponceId($customer_group_id);
					$data="group_id=".$p['kms_group_id'];	
			 		$method ="POST";
			 		$url=KMS_API."/disableGroup";
			 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
		        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
		        	$temp=json_decode($apiresult);
	        	  	foreach ($temp as $key => $value) {
	    		 		if((strcmp($key, "error")==0)&&$value==false){
	    		 			$this->model_sale_customer_group->deleteCustomerGroup($customer_group_id);	
	    		 			$deleted_flag=true;
	    		 			break;
	    		 		}
	 	   		 		
	    		 	}
	    		 	if(!$deleted_flag)
	    		 		break;
			}
			if($deleted_flag){
				$this->session->data['success'] = "Success: You have deleted Customer Group(s) successfully!";//$this->language->get('text_success_delete');
				$this->redirect($this->url->link('sale/customer_group', 'token=' . $this->session->data['token'], 'SSL'));
			}else{
				$this->session->data['warning'] = "Error: Unable to delete group!";
				$this->getList();
				return;
			}
		}else{
			$this->getList();	
		}
		
	}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the customer_group added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the customer_group list.
*/
	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'cgd.name';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['defaultGroup'] = $this->url->link('sale/customer_group/defaultGroup', 'token=' . $this->session->data['token'] . $url, 'SSL');					
		$this->data['insert'] = $this->url->link('sale/customer_group/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/customer_group/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['customer_groups'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$customer_group_total = $this->model_sale_customer_group->getTotalCustomerGroups($data);
		
		$results = $this->model_sale_customer_group->getCustomerGroups($data);
		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/customer_group/update', 'token=' . $this->session->data['token'] . '&customer_group_id=' . $result['customer_group_id'] . $url, 'SSL')
			);		
		
			$this->data['customer_groups'][] = array(
				'customer_group_id' => $result['customer_group_id'],
				'name'              => $result['name'] . (($result['is_default'] ==1) ? $this->language->get('text_default') : null),
				'sort_order'        => $result['sort_order'],
				'selected'          => isset($this->request->post['selected']) && in_array($result['customer_group_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_sort_order'] = $this->language->get('column_sort_order');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 	
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if(isset($this->session->data['warning'])){
 			$this->data['error_warning'] =$this->session->data['warning'];

 			unset($this->session->data['warning']);
 		}
 		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
	
		
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_name'] = $this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . '&sort=cgd.name' . $url, 'SSL');
		$this->data['sort_sort_order'] = $this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . '&sort=cg.sort_order' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $customer_group_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/customer_group_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}
 	//---------
 /*
FUNCTION NAME 		-	defaultGroup
DESCRIPTION 		-	Loads when the admin wants to change the  the customer_group added as default customer group. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function defaultGroup() {
		$this->language->load('sale/customer_group');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('sale/customer_group');
		if (isset($this->request->post['selected'])) {
			if (count($this->request->post['selected'])>1) {
				$this->session->data['warning'] = "Please select one Group to make it default.";//$this->language->get('text_mult_select');
					$this->getList();
					return;
			}
			if($this->validateDefault() && isset($this->request->post['selected'])) {
				$x=$this->model_sale_customer_group->defaultCustomerGroup($this->request->post['selected'][0]);
				$this->session->data['success'] = "Set the default Group!";//$this->language->get('text_success');
				$url = '';
				$this->redirect($this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}
		}else{
			$this->session->data['warning'] = "Warning: Please select a Customer Group to set as default!";
			$this->getList();
		}
	}

 	//----------
/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_group content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_group form page.
*/
	protected function getForm() {
		$this->language->load('sale/customer_group');
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
				
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_approval'] = $this->language->get('entry_approval');
		$this->data['entry_company_id_display'] = $this->language->get('entry_company_id_display');
		$this->data['entry_company_id_required'] = $this->language->get('entry_company_id_required');
		$this->data['entry_tax_id_display'] = $this->language->get('entry_tax_id_display');
		$this->data['entry_tax_id_required'] = $this->language->get('entry_tax_id_required');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = array();
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['customer_group_id'])) {
			$this->data['action'] = $this->url->link('sale/customer_group/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/customer_group/update', 'token=' . $this->session->data['token'] . '&customer_group_id=' . $this->request->get['customer_group_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/customer_group', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['customer_group_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$customer_group_info = $this->model_sale_customer_group->getCustomerGroup($this->request->get['customer_group_id']);
		}
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['customer_group_description'])) {
			$this->data['customer_group_description'] = $this->request->post['customer_group_description'];
		} elseif (isset($this->request->get['customer_group_id'])) {
			$this->data['customer_group_description'] = $this->model_sale_customer_group->getCustomerGroupDescriptions($this->request->get['customer_group_id']);
		} else {
			$this->data['customer_group_description'] = array();
		}	
		
		if (isset($this->request->post['approval'])) {
			$this->data['approval'] = $this->request->post['approval'];
		} elseif (!empty($customer_group_info)) {
			$this->data['approval'] = $customer_group_info['approval'];
		} else {
			$this->data['approval'] = '';
		}	
					
		if (isset($this->request->post['company_id_display'])) {
			$this->data['company_id_display'] = $this->request->post['company_id_display'];
		} elseif (!empty($customer_group_info)) {
			$this->data['company_id_display'] = $customer_group_info['company_id_display'];
		} else {
			$this->data['company_id_display'] = '';
		}			
			
		if (isset($this->request->post['company_id_required'])) {
			$this->data['company_id_required'] = $this->request->post['company_id_required'];
		} elseif (!empty($customer_group_info)) {
			$this->data['company_id_required'] = $customer_group_info['company_id_required'];
		} else {
			$this->data['company_id_required'] = '';
		}		
		
		if (isset($this->request->post['tax_id_display'])) {
			$this->data['tax_id_display'] = $this->request->post['tax_id_display'];
		} elseif (!empty($customer_group_info)) {
			$this->data['tax_id_display'] = $customer_group_info['tax_id_display'];
		} else {
			$this->data['tax_id_display'] = '';
		}			
			
		if (isset($this->request->post['tax_id_required'])) {
			$this->data['tax_id_required'] = $this->request->post['tax_id_required'];
		} elseif (!empty($customer_group_info)) {
			$this->data['tax_id_required'] = $customer_group_info['tax_id_required'];
		} else {
			$this->data['tax_id_required'] = '';
		}	
		
		if (isset($this->request->post['sort_order'])) {
			$this->data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($customer_group_info)) {
			$this->data['sort_order'] = $customer_group_info['sort_order'];
		} else {
			$this->data['sort_order'] = '';
		}	
									
		$this->template = 'sale/customer_group_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_group details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	public function isValid($str) {
    	return preg_match('/[^A-Za-z0-9 ]/', $str);
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/customer_group')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		foreach ($this->request->post['customer_group_description'] as $language_id => $value) {
			if($value['name']==''){
				$this->error['name'][$language_id] = "Customer group name is mandatory!";
			}
			else if ((utf8_strlen($value['name']) < 3) || (utf8_strlen($value['name']) > 32)) {
				$this->error['name'][$language_id] = $this->language->get('error_name');
			}

			if ( preg_match('/^\s/',$value['name']) ){
				$this->error['name'][$language_id] = $this->language->get('Space not allowed!');
			}

			if ( $this->isValid($value['name'])){
  				$this->error['name'][$language_id] = $this->language->get('Special Characters not allowed!');
  			}
			
		}
		$this->load->model('sale/customer_group');
		$customer_group_id=isset($this->request->get['customer_group_id'])?$this->request->get['customer_group_id']:-1;
    	$flag = $this->model_sale_customer_group->isGroupExist($this->request->post["customer_group_description"][1]["name"],$customer_group_id);
    	if($flag)
    		$this->error['name'][$language_id] = $this->language->get('group_exist');
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
//-------
	/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_group details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/

	protected function validateDefault() {
		if (!$this->user->hasPermission('modify', 'sale/customer_group')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		// foreach ($this->request->post['customer_group_description'] as $language_id => $value) {
		// 	if ((utf8_strlen($value['name']) < 3) || (utf8_strlen($value['name']) > 32)) {
		// 		$this->error['name'][$language_id] = $this->language->get('error_name');
		// 	}
		// }
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

//-------	
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_group content when deleted. 
						Checks if the deteled customer_group is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	protected function validateDelete() {
	
			if (!$this->user->hasPermission('modify', 'sale/customer_group')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');

		if(!isset($this->request->post['selected'])){
			$this->error['warning'] =$this->language->get('text_warning_delete');
		}else{
			foreach ($this->request->post['selected'] as $customer_group_id) {
	   //  		if ($this->config->get('config_customer_group_id') == $customer_group_id) {
		  // 			$this->error['warning'] = $this->language->get('error_default');	
				// }  
				
				$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($customer_group_id);

				if ($store_total) {
					$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
				}
				
				$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($customer_group_id);

				if ($customer_total) {
					$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
				}
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t\t\t".$log_target."\t\t\t\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
    }
}
?>
