<?php    
/*
@File customer.php(Controller)
ADMIN CUSTOMER PAGE
    This class manages the customer account by inserting/deleting/updating or by 
    approving the account.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerSaleCustomer extends Controller { 
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer page showing all the customer in a list.
*/  
  	public function index() {
		$this->language->load('sale/customer');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer form page where the admin can give the
						details of the new customer. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer form page.
*/  
  	public function insert() {

  		$obj = new restapi();
  			
		$this->language->load('sale/customer');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer');
		
		//---------------------------Firstname & lastname removed----------------------------------------
		// if (isset($this->request->post['address'])) {		
		// 	for ($i=1; $i <= sizeof($this->request->post['address']); $i++) { 
		// 		$this->request->post['address'][$i]['firstname'] = $this->request->post['firstname'];
		// 		$this->request->post['address'][$i]['lastname'] = $this->request->post['lastname'];
		// 	}      		
  //     	}      	
		//-------------------------------------------------------------------------------
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
      	  	$post=$this->request->post;
      	  	foreach ($post['address'] as $key => $value) { 
      	  		if(isset($value['default'])){
      	  			$postcode = $value['postcode'];
      	  			break;
      	  		}else{
					$postcode = $value['postcode'];
				//break;
				}
			}

			// echo $smsRegionId;
			// echo '<pre>';print_r($smsRegionId);
			
			$unique_rand_num = $this->model_sale_customer->generateUniqueCustomerID();
      	  	$stbno=$this->model_sale_customer->getSTBNOById($post['STBNO']);
  			$cust_groupid=$this->model_sale_customer->getApigroupid($post['customer_group_id']);
  			// $cust_regionid=$this->model_sale_customer->getApiregionid($smsRegionId);
  			// echo '<pre>';print_r($cust_regionid);
  			if(!empty($stbno['id']))
  			$stb=$this->model_sale_customer->getApiStbid($stbno['id']);

  			$opr_id=$this->model_sale_customer->getOperatorIdOfSTB($post['STBNO']);
  			// var_dump($this->session->data['user_id']);var_dump($opr_id["operator_id"]);exit();

// die;
      	  	$data="customer_no=".$unique_rand_num."&first_name=".$post['firstname']."&last_name=".$post['lastname']."&stb_no=".$post['STBNO']."&email=".$post['email']."&mobile_no=".$post['telephone']."&region_pin=".$postcode."&group_id=".$cust_groupid['kms_group_id']."&is_enabled=".$post['status'];
    	// var_dump($data);
      	  	$method ="POST";
	 		$url=KMS_API."/enableUser";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
			$error=true;
			$group_id="";
			$user_id="";
			$api_user_id="";
			$response=json_decode($apiresult);
    	// var_dump($response);exit();
			$errorMsg="";
			
			foreach ($response as $key => $value) {
				switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$api_user_id=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
    		if(!$error) {
    			$user_id =$this->model_sale_customer->addCustomer($this->request->post,$opr_id["operator_id"],$unique_rand_num);
    			//$user_id =$this->model_sale_customer->addCustomer($this->request->post,$this->session->data['user_id'],$unique_rand_num);
    			// $result=$this->model_sale_customer->getCustomerIdBySTB($post['STBNO']);
    		 // 	$user_id=$result['customer_id'];
    		 	$this->model_sale_customer->addApiResponceId($api_user_id,$user_id);
  
				$this->session->data['success'] =$apimessage;
			    $url = '';
				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_email'])) {
					$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_customer_group_id'])) {
					$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
				}
				
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
				
				if (isset($this->request->get['filter_approved'])) {
					$url .= '&filter_approved=' . $this->request->get['filter_approved'];
				}

				if (isset($this->request->get['filter_ip'])) {
					$url .= '&filter_ip=' . $this->request->get['filter_ip'];
				}
						
				if (isset($this->request->get['filter_date_added'])) {
					$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
				}
								
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				// ----------------------------------------------------------------------------
				$this->WriteMessageLog("SUCCESS:","NA",$post['STBNO'],"addCustomer");
				// ----------------------------------------------------------------------------	
				$this->redirect($this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				// ----------------------------------------------------------------------------
				$this->WriteMessageLog("ERROR:","NA",$post['STBNO'],"addCustomer");
				// ----------------------------------------------------------------------------	
				$this->error['warning']=$errorMsg;
				
				$this->getForm();
			}
		}
    	
    	$this->getForm();
  	}

  	public function exportFormat(){  
    	/*********************** Export Bulk Upload Customer CSV Format *****************************/
    	$results = array("Should be empty..!", "admin", "first", "customer", "SDA40000000001", "999000000001", "firstcustomer@bydesign.com", 
    					 "9685745674", "passwd", "passwd", "Disabled", "Friends",	"Electronic City", "E City", "Bangalore", "India", "560100", 
    					 "Karnataka", "1", "7485698956", "7458");
    	if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=CustomerBulkUploadSampleFormat.csv');
			$output = fopen('php://output', 'w');
			fputcsv($output, array('SUBSCRIPTION', 'OPERATOR', 'FIRST NAME', 'LAST NAME', 'STB NO', 'SC NO', 'EMAIL', 'TELEPHONE', 'PASSWORD', 'CONFIRM',
								   'NEWSLETTER', 'GROUP NAME', 'REGION NAME', 'ADDRESS', 'CITY', 'COUNTRY', 'POSTCODE', 'ZONE NAME', 'ENABLED',
								   'LANDLINE NO', 'STD CODE'  ));
			fputcsv($output, $results);
		}
    } 

  	/*
FUNCTION NAME 		-	upload_bulk_customer
DESCRIPTION 		-	Loads the insert customer form page where the admin can give the
						details of the new customer. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer form page.
*/  
  	public function upload_bulk_customer() {
  		$obj = new restapi();
		$this->language->load('sale/customer');
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer');
		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateFile()) {
			$apimessage='';
    		$errorMsg="";
    		$error=true;	
    		$flag=false;
    		$stb=array();
			  	$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
			  	if($ext=='csv'){
			  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name'], "r");
			  		$checkData = fgetcsv($handle, 1000, ",");
			  		if(count($checkData)!=21){ 
			  			$this->error['warning'] = "Warning: Invalid file format, Submitted data not in csv file format..!!";
			  			unlink(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name']);
			  		}else{
				  		$i=0;
				  		$customers=array();
					    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {   
					    	// if($i>0){
					    		$customers[$i-1]['subscription']=$data[0];
					    		$customers[$i-1]['operator']=$data[1];
					    		$customers[$i-1]['firstname']=$data[2];
					    		$customers[$i-1]['lastname']=$data[3];
					    		$customers[$i-1]['STBNO']=$data[4];
					    		$customers[$i-1]['SCNO']=$data[5];
					    		$customers[$i-1]['email']=$data[6];
					    		$customers[$i-1]['telephone']=$data[7];
					    		$customers[$i-1]['password']=$data[8];
					    		$customers[$i-1]['confirm_pass']=$data[9];
					    		$customers[$i-1]['newsletter']=$data[10];
					    		$customers[$i-1]['group_name']=$data[11];
					    		$customers[$i-1]['region_name']=$data[12];
					    		$customers[$i-1]['address']=$data[13];
					    		$customers[$i-1]['city']=$data[14];
					    		$customers[$i-1]['country']=$data[15];
					    		$customers[$i-1]['postcode']=$data[16];
					    		$customers[$i-1]['zone']=$data[17];
					    		$customers[$i-1]['is_enabled']=$data[18];
					    	// }
					    	$i++; 
					    } // End while loop

			    $warnings=array(array());
			    $j=0;
			    $err_encounter=0;
		    	$log_separator = "-------------------------------------\n";
				$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
				$current_date = $currDate->format('d-m-Y H:i:s');	
				file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);	
				foreach ($customers as $row) {  
				 	if(!preg_match("/^[a-zA-Z0-9 ]+$/", $row['operator']) || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['firstname']) 
							 || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['lastname']) || !preg_match("/^[a-zA-Z0-9]+$/", $row['STBNO'])
							 || !preg_match("/^[0-9]+$/", $row['SCNO']) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', trim($row['email']))
							 || !preg_match("/^[0-9]+$/", $row['telephone']) 
							 || !preg_match("/^[a-zA-Z0-9!@#$%^&*()_+\-=\[\]{};':|,.<>\/?]*$/", $row['password'])
							 || !preg_match("/^[a-zA-Z0-9!@#$%^&*()_+\-=\[\]{};':|,.<>\/?]*$/", $row['confirm_pass'])
							 || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['newsletter']) || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['group_name'])
							 || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['region_name']) 
							 || !preg_match("/^[a-zA-Z0-9!@#$%^&*()_+\-=\[\]{};':|,.<>\/? ]*$/", $row['address'])
							 || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['city']) || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['country'])
							 || !preg_match("/^[0-9]+$/", $row['postcode']) || !preg_match("/^[a-zA-Z0-9 ]+$/", $row['zone'])
							 || !preg_match("/^[0-9]+$/", $row['is_enabled']))
				 	{		
							$warnings[$j]['warning']	= " File pattern not proper.!";
							$err_encounter=1;
					}else{	
				    		
			    		$operator= $this->model_sale_customer->getOperatorIdFromName($row['operator']);
			    		if(isset($operator['user_id'])){
			    			$customer['operator'] = $row['operator'];
			    		}else{
			    			$err_encounter=1;
			    			$warnings[$j]['operator'] = "Invalid operator '".$row['operator']."' assigned to customer '".$row['firstname']." ".$row['lastname']."'";
			    		}
			    		if ((utf8_strlen($row['firstname']) < 1) || (utf8_strlen($row['firstname']) > 32)) {
				      		$warnings[$j]['firstname'] = $this->language->get('error_firstname');
				      		$err_encounter=1;
				    	}else{
				    		$customer['firstname'] = $row['firstname'];
				    	}

				    	if ((utf8_strlen($row['lastname']) < 1) || (utf8_strlen($row['lastname']) > 32)) {
				      		$warnings[$j]['lastname'] = $this->language->get('error_lastname');
				      		$err_encounter=1;
				    	}else{
				    		$customer['lastname'] = $row['lastname'];
				    	}

				    	if ((strlen(trim($row['STBNO']))<14)||(strlen(trim($row['STBNO']))>14)){
				            $warnings[$j]['STBNO'] = $this->language->get('error_STBNO');
				            $err_encounter=1;
				        }
				        else{
				        	$customer['STBNO'] = $row['STBNO'];
						        $stb_exist = $this->model_sale_customer->getSTBExist($row['STBNO']);
					        if($stb_exist){
						        $customer_info = $this->model_sale_customer->getCustomerBySTBNO($row['STBNO']);
								$stb_blackList = $this->model_sale_customer->getSTBblackList($row['STBNO']);
								if ((int)$stb_blackList["is_black_list"]) {
					        		$warnings[$j]['STBNO'] = 'STBNO is Black listed!';
					        		$err_encounter=1;
					        	}
								if ($customer_info) {
									$warnings[$j]['STB NO'] = 'Warning: STBNO is already registered!';
									$err_encounter=1;
								}
								$stb_operator = $this->model_sale_customer->getOperatorIdOfSTB($row['STBNO']);
								if((int)$this->session->data['user_id']!=1){
									if((int)$stb_operator['operator_id']!=(int)$this->session->data['user_id'])
									{
										$warnings[$j]['STB'] = 'Warning: STB No. is not belongs to this user!';	
										$err_encounter=1;
									}
								}
							}else{
								$warnings[$j]['STB NO'] = 'Warning: STB No. does not exist!';
							}
						}
						if($row['SCNO'] != -1 && $row['SCNO'] != ''){
							$row['SCNO']=trim($row['SCNO'],"'");
							if((strlen($row['SCNO'])<12)||(strlen($row['SCNO'])>12)||!is_numeric($row['SCNO'])){
					            $warnings[$j]['SCNO']=$this->language->get('error_SCNO');//"Should be only digits of length 12!";
					            $err_encounter=1;
					        }
					        else{
						        $customer_info = $this->model_sale_customer->getCustomerBySCNO($row['SCNO']);
								if ($customer_info) {
									$warnings[$j]['SCNO'] = 'Warning: SCNO is already registered!';
									$err_encounter=1;
								}
							}
							$customer['SCNO'] = $row['SCNO'];
						}else{
							$customer['SCNO'] = -1;
						}
						if ((utf8_strlen(trim($row['email'])) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', trim($row['email']))) {
				      		$warnings[$j]['email'] = $this->language->get('error_email');
				      		$err_encounter=1;
				    	}else{
				    		$customer['email'] = trim($row['email']);
				    	}
						
						$customer_info = $this->model_sale_customer->getCustomerByEmail($row['email']);
						if ($customer_info) {
							$warnings[$j]['email'] = $this->language->get('error_exists');
							$err_encounter=1;
						}
						
				    	if ((utf8_strlen($row['telephone']) < 10) || (utf8_strlen($row['telephone']) > 10)) {
				      			$warnings[$j]['telephone'] = $this->language->get('error_telephone');
				      			$err_encounter=1;
				    	}
				    	elseif(!is_numeric($row['telephone'])){
				    			$warnings[$j]['telephone'] = $this->language->get('error_telephone_digits');
				    			$err_encounter=1;
				    	}else{
				    		$customer['telephone'] = $row['telephone'];
				    	}
				    
				    	$customer_tel = $this->model_sale_customer->getCustomerByMobile($row['telephone']);
						if ($customer_tel) {
							$warnings[$j]['telephone'] = $this->language->get('error_exist'); 
							$err_encounter=1;
						}
				    	
				    	if ($row['group_name']== '') {
				      		$warnings[$j]['group'] = "Please give group";
				      		$err_encounter=1;
				    	}else{
				    		$customer_group = $this->model_sale_customer->getGroupIdByName($row['group_name']);
				    		if(!isset($customer_group['customer_group_id']))
				    		{
				    			$warnings[$j]['group_id'] = "Group '".$row['group_name']."' is not exist !";	
				    			$err_encounter=1;
				    		}else{
				    			$customer['customer_group_id'] = $customer_group['customer_group_id'];
				    		}
				    	}

				    	if ($row['region_name']==''){
				      		$warnings[$j]['region'] = "Please give region";
				      		$err_encounter=1;
				    	}else{
				    		$customer_region = $this->model_sale_customer->getRegionIdByName($row['region_name']);
				    		if(!isset($customer_region['region_id']))
				    		{
				    			$warnings[$j]['region_id'] = "Region '".$row['region_name']."' is not exist !";	
				    			$err_encounter=1;
				    		}else{
				    			$customer['customer_region_id'] = $customer_region['region_id'];
				    		}
				    	}
				    	
				    	if ($row['password']) {
				      		if ((utf8_strlen($row['password']) < 4) || (utf8_strlen($row['password']) > 20)) {
				        		$warnings[$j]['password'] = $this->language->get('error_password');
				        		$err_encounter=1;
				      		}
					  		if ($row['password'] != $row['confirm_pass']) {
					    		$warnings[$j]['confirm'] = $this->language->get('error_confirm');
					    		$err_encounter=1;
					  		}
					  		$customer['password'] = $row['password'];
				    	}

				    	if ((utf8_strlen($row['address']) < 3) || (utf8_strlen($row['address']) > 128)) {
							$warnings[$j]['address_address_1'] = $this->language->get('error_address_1');
							$err_encounter=1;
						}else{
							$customer['address_1'] = $row['address'];
						}
					
						if ((utf8_strlen($row['city']) < 2) || (utf8_strlen($row['city']) > 128)) {
							$warnings[$j]['address_city'] = $this->language->get('error_city');
							$err_encounter=1;
						}else{
							$customer['city'] = $row['city'];
						} 

						if ($row['country'] == '') {
							$warnings[$j]['address_country'] = $this->language->get('error_country');
							$err_encounter=1;
						}
						$country_info = $this->model_sale_customer->getCountryIdByName($row['country']);
						if (isset($country_info['country_id'])) {
							$customer['country_id'] = $country_info['country_id'];
							if (!isset($row['zone']) || $row['zone'] == '') {
								$warnings[$j]['address_zone'] = $this->language->get('error_zone');
								$err_encounter=1;
							}else{
								$zone_info = $this->model_sale_customer->getZoneIdByName($row['zone'],$customer['country_id']);
								if(!isset($zone_info['zone_id'])){
									$warnings[$j]['zone'] = "Zone '".$row['zone']."' is not exists !";
									$err_encounter=1;
								}else{
									$customer['zone_id'] = $zone_info['zone_id'];
								}
							}
						}else{
							$warnings[$j]['country'] = "Country '".$row['country']."' is not exists !";
							$err_encounter=1;
						}

						if (!isset($row['postcode']) || $row['postcode'] == '') {
							$warnings[$j]['address_postcode'] = $this->language->get('error_password');
							$err_encounter=1;
						}else if(strlen($row['postcode']) != 6){
							$warnings[$j]['postcode'] = "Invalid Postcode '".$row['postcode']."'!";
							$err_encounter=1;
						}else{
							$customer['postcode'] = $row['postcode'];
						}

						if (!isset($row['is_enabled']) || $row['is_enabled'] == '') {
							$customer['status']=0;
						}else{
							$customer['status']=$row['is_enabled'];
						}
						$customer['fax']="";

						if (!isset($row['newsletter']) || $row['newsletter'] == '') {
							$customer['newsletter']=0;
						}else{
							$customer['newsletter']=$row['newsletter'];
						}
						if(!$err_encounter)
				    	{
				    		$unique_rand_num = $this->model_sale_customer->generateUniqueCustomerID();
				    		$stbno=$this->model_sale_customer->getSTBNOById($customer['STBNO']);
				  			$cust_groupid=$this->model_sale_customer->getApigroupid((int)$customer['customer_group_id']);
				  			// $cust_regionid=$this->model_sale_customer->getApiregionid((int)$customer['customer_region_id']);
				  			if(!empty($stbno['id']))
				  			$stb=$this->model_sale_customer->getApiStbid($stbno['id']);
				  			$opr_id=$this->model_sale_customer->getOperatorIdOfSTB($customer['STBNO']);

				      	  	$data="customer_no=".$unique_rand_num."&first_name=".$customer['firstname']."&last_name=".$customer['lastname']."&stb_no=".$row['STBNO']."&email=".$customer['email']."&mobile_no=".$customer['telephone']."&region_pin=".$customer['postcode']."&group_id=".$cust_groupid['kms_group_id']."&is_enabled=".$customer['status'];
				      	  	$method ="POST";
					 		$url=KMS_API."/enableUser";
					 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
							$error=true;
							$group_id="";
							$user_id="";
							$api_user_id="";$response=array();
							$response=json_decode($apiresult,true);
							$errorMsg="";
							foreach ($response as $key => $value) {
								switch ($key) {
				    				case 'error':
				    					$error=	$value;
				    					break;
				    				case 'message':
				    					$apimessage=$value;				
				    					break;
				    				case 'id':
				    					$api_user_id=$value;	
				    					break;
				    				default:
				    					$errorMsg=$errorMsg." ".$key.":".$value;	
				    					break;
				    			}
							}
							
							if(!$error){
								$customer_id = $this->model_sale_customer->addCustomer($customer,$opr_id['operator_id'],$unique_rand_num);
							 	// $customer_id = $this->model_sale_customer->addCustomer($customer,$this->session->data['user_id'],$unique_rand_num);
								$this->model_sale_customer->addApiResponceId($api_user_id,$customer_id);
								$warnings[$j]['message'] = $apimessage;
								$warnings[$j]['error'] = 0;
							}else{
								$warnings[$j]['warning'] = $apimessage.' ,'.$errorMsg;
								$warnings[$j]['error'] = 1;
							}
				    	}else{
				    		$warnings[$j]['error'] = 1;
				    	}
				    	$err_encounter=0;
				    	// ------------ERROR LOGS---------------------
					} // End else patternMatch
						if(isset($warnings[$j])){
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt",$log_separator.$row['STBNO']."\n", FILE_APPEND);	
							foreach ($warnings[$j] as $key => $value) {
								if($key!='error'){
									$line = $key . " : " .$value."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt", $line, FILE_APPEND);
								}
							}
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt",$log_separator, FILE_APPEND);	
						}
							$user_id = "_".$this->session->data['user_id'];
							// $file = DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt";
							$gzfile = DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.$user_id.".gz";
							$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
							gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
							gzclose($fp);
							
					   // ------------ERROR LOGS---------------------
			    		$j++;
			    	} // End Foreach loop
			    	unlink(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt");
			    	unlink(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name']);
			    	$this->error['error_log'] = $warnings;
				    fclose($handle);
			    }// End else checkData
			}else{ // End if .ext csv statement
				$error_encounter=1;
				$errorMsg='Invalid file format, Only .CSV files are accepted';
				$this->error['warning']	= "Warning: Invalid file format, Only .CSV files are accepted!";
			}
		} // End First if statement
    
      $this->getUploadForm();
  	} // End function

  	public function validateFile(){
  		if(!sizeof($_FILES)){
  			$this->error['warning']	= "Warning: Please select .csv file of customer registration.!!";
  			return false;
  		}else{
  				$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
				if($ext!='csv'){
					$this->error['warning']	= "Warning: Please select .csv file of customer registration.!!";
	  				return false;
				}else{
				  		$newloc = DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name'];
				  		move_uploaded_file($_FILES['filename']['tmp_name'], $newloc);
				  		$lines = count(file($newloc)); 

				  		if($_FILES['filename']['name']==""){
				  			$this->error['warning'] = "Warning: Please select .csv file of customer registration.!!";  			
				  			return false;
				  		}
				  		$count = 0;
				  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name'], "r");
						while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
							if($count==0){
								if($data[0]!="SUBSCRIPTION" || $data[1]!="OPERATOR" || $data[2]!="FIRST NAME" || $data[3]!="LAST NAME" || $data[4]!="STB NO" || $data[5]!="SC NO" || $data[6]!="EMAIL" || $data[7]!="TELEPHONE" || $data[8]!="PASSWORD" || $data[9]!="CONFIRM" || $data[10]!="NEWSLETTER" || $data[11]!="GROUP NAME" || $data[12]!="REGION NAME" || $data[13]!="ADDRESS" || $data[14]!="CITY" || $data[15]!="COUNTRY" || $data[16]!="POSTCODE" || $data[17]!="ZONE NAME" || $data[18]!="ENABLED" || $data[19]!="LANDLINE NO" || $data[20]!="STD CODE"){
										$this->error['warning'] = "Warning: Invalid file!";
										return false;
								}
								$count++;
							}
						}
				  		
				  		$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
				  		if($ext!='csv'){
				  			$this->error['warning'] = "Warning: Invalid file format, Only .CSV files are accepted!";
				  			unlink(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name']);
				  			return false;
				  		}

				  		if( $lines > 1001){
							$this->error['warning'] = "Can't process csv, records count is more than 1000.!";
							unlink(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name']); 
							return false;
						}else {
								if($lines){
									// $this->session->data['success'] = "File upload successfully.!!";
									return true;
								}else {
									$this->error['warning']	= "Please select .csv file of customer registration.!";
								}
						}
					}
				}
		 } 
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
  		 $obj = new restapi();
		$this->language->load('sale/customer');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer');

		$oprr_id = $this->model_sale_customer->getOperatorIdOfCustomer($this->request->get["customer_id"]);
		if($this->session->data['user_id']!=1 && $this->session->data['user_id']!=$oprr_id['operator_id']){
			$this->redirect($this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url.'&error=1', 'SSL'));
		}

		//---------------------------Firstname & lastname removed----------------------------------------
		// if (isset($this->request->post['address'])) {		
		// 	for ($i=1; $i <= sizeof($this->request->post['address']); $i++) { 
		// 		$this->request->post['address'][$i]['firstname'] = $this->request->post['firstname'];
		// 		$this->request->post['address'][$i]['lastname'] = $this->request->post['lastname'];
		// 	}      		
  //     	}      	
		//-------------------------------------------------------------------------------

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$post=$this->request->post;
			foreach ($post['address'] as $key => $value) { 
      	  		if(isset($value['default'])){
      	  			$postcode = $value['postcode'];
      	  			break;
      	  		}else{
				$postcode = $value['postcode'];
				//break;
			}
			}

// var_dump($post);exit();
			
			//--------------------------- 3rd Oct 2016--------------------------------------
			$customer_id=$this->request->get['customer_id'];
			$r= $this->model_sale_customer->getApiResponceId($customer_id);
			//-----------------------------3rd Oct 2016-------------------------------------------
      	  	$stbno=$this->model_sale_customer->getSTBNOById($post['STBNO']);
  			$cust_groupid=$this->model_sale_customer->getApigroupid($post['customer_group_id']);
  			// $cust_regionid=$this->model_sale_customer->getApiregionid($smsRegionId);
  			if(!empty($stbno['id']))
  			$stb=$this->model_sale_customer->getApiStbid($stbno['id']);
      	  	$data="user_id=".$r['api_user_id']."&first_name=".$post['firstname']."&last_name=".$post['lastname']."&stb_no=".$post['STBNO']."&email=".$post['email']."&mobile_no=".$post['telephone']."&region_pin=".$postcode."&group_id=".$cust_groupid['kms_group_id']."&is_enabled=".$post['status'];
      	  	$method ="POST";
	 		$url=KMS_API."/updateUser";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
      	
        	$response=json_decode($apiresult);
			$error=true;
			$errorMsg='';
			foreach ($response as $key => $value) {
				switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				// case 'id':
    				// 	$api_user_id=$value;	
    				// 	break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			if(!$error)
			{
	 			$this->model_sale_customer->editCustomer($this->request->get['customer_id'], $this->request->post);
	 			$this->session->data['success'] = $this->language->get('text_success');
			}else{
				$this->session->data['success'] = "Error: Invalid enrties";//$this->language->get('text_success');
			}
    		
			$url = '';

			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_email'])) {
				$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_customer_group_id'])) {
				$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
			}
			
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
			
			if (isset($this->request->get['filter_approved'])) {
				$url .= '&filter_approved=' . $this->request->get['filter_approved'];
			}
			
			if (isset($this->request->get['filter_ip'])) {
				$url .= '&filter_ip=' . $this->request->get['filter_ip'];
			}
					
			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			// ----------------------------------------------------------------------------
				$this->WriteMessageLog("SUCCESS:","NA",$post['STBNO'],"modifyCustomer");
			// ----------------------------------------------------------------------------	
			$this->redirect($this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer listed on the page. Admin selects the 
						checkbox against the customer in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer list page after deleting the customer from the list.
*/
  	public function delete() {
  		$obj = new restapi();
		$this->language->load('sale/customer');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer');
			
    	if (isset($this->request->post['selected']) && $this->validateDelete()) {
    		$err_encounter=0;
    		$apimessage="";
    		$custmers=array();
			foreach ($this->request->post['selected'] as $customer_id) {
				$post = $this->model_sale_customer->getApiResponceId($customer_id);
				$data="user_id=".$post['api_user_id'];
		 		$method ="POST";
		 		$url=KMS_API."/disableUser";;
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        		$apiresult=$obj->callAPI($method,$hdr,$url,$data);
        		$response=json_decode($apiresult);
        	 	$error=true;
        	 	$errorMsg='';
				foreach ($response as $key => $value) {
					switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				case 'id':
	    					$api_user_id=$value;	
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
	    			}
				}
				if(!$error)
				{
					$this->model_sale_customer->deleteCustomer($customer_id);
				}else{
					$user = $this->model_sale_customer->getCustomer($customer_id);
					array_push($custmers,$user['firstname']." ".$user['lastname']);
					$err_encounter++;
				}
			}	
			if(!$err_encounter)
			{	
				$this->session->data['success'] = $this->language->get('text_success_delete');

				$url = '';

				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_email'])) {
					$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_customer_group_id'])) {
					$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
				}
				
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
				
				if (isset($this->request->get['filter_approved'])) {
					$url .= '&filter_approved=' . $this->request->get['filter_approved'];
				}	
					
				if (isset($this->request->get['filter_ip'])) {
					$url .= '&filter_ip=' . $this->request->get['filter_ip'];
				}
						
				if (isset($this->request->get['filter_date_added'])) {
					$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
				}
							
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				
				$this->redirect($this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				$this->error['warning'] =implode(',',$custmers)." ". $apimessage;
	    		$this->getList();
			}
    	}else{
	    	$this->error['error'] =$this->language->get('text_warning_delete');
	    	$this->getList();
    	}
  	}  
/*
FUNCTION NAME 		-	approve
DESCRIPTION 		-	This function approves the customer account by allowing 
						him to maintain his account. Without this approval customer 
						cann't access his account.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the customer list after approving the selected customer account.
*/	
	public function approve() {
		$this->language->load('sale/customer');
    	
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/customer');
		
		if (!$this->user->hasPermission('modify', 'sale/customer')) {
			$this->error['warning'] = $this->language->get('error_permission');
		} elseif (isset($this->request->post['selected'])) {
			$approved = 0;
			$resp=0;
			foreach ($this->request->post['selected'] as $customer_id) {
				$customer_info = $this->model_sale_customer->getCustomer($customer_id);
				
				if ($customer_info && !$customer_info['approved']) {
					$resp= $this->model_sale_customer->approve($customer_id);
					$approved++;
				}
			} 
			if($resp)
				$this->session->data['success'] = sprintf($this->language->get('text_approved'), $approved);
			else
				$this->session->data['success'] = sprintf($this->language->get('text_approved'), $approved)." ".$this->language->get('error_fail_to_send_mail');		
			
			$url = '';
		
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
		
			if (isset($this->request->get['filter_email'])) {
				$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_customer_group_id'])) {
				$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
			}
		
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
			
			if (isset($this->request->get['filter_approved'])) {
				$url .= '&filter_approved=' . $this->request->get['filter_approved'];
			}
				
			if (isset($this->request->get['filter_ip'])) {
				$url .= '&filter_ip=' . $this->request->get['filter_ip'];
			}
						
			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
	
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
							
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}	
	
			$this->redirect($this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'));			
		}else{
			$this->error['warning']="Please select customer to approve!";
			
		}
		
		$this->getList();
	} 
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the customer added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the customer list.
*/    
  	protected function getList() {
		if (isset($this->request->get['filter_customer_unique_id'])) {
			$filter_customer_unique_id = $this->request->get['filter_customer_unique_id'];
		} else {
			$filter_customer_unique_id = null;
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if (isset($this->request->get['filter_stb'])) {
			$filter_stb = $this->request->get['filter_stb'];
		} else {
			$filter_stb = null;
		}

		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
		} else {
			$filter_email = null;
		}
		
		if (isset($this->request->get['filter_customer_group_id'])) {
			$filter_customer_group_id = $this->request->get['filter_customer_group_id'];
		} else {
			$filter_customer_group_id = null;
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}
		
		if (isset($this->request->get['filter_approved'])) {
			$filter_approved = $this->request->get['filter_approved'];
		} else {
			$filter_approved = null;
		}
		
		if (isset($this->request->get['filter_ip'])) {
			$filter_ip = $this->request->get['filter_ip'];
		} else {
			$filter_ip = null;
		}
				
		if (isset($this->request->get['filter_date_added'])) {
			$filter_date_added = $this->request->get['filter_date_added'];
		} else {
			$filter_date_added = null;
		}	

		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
		} else {
			$filter_operator = null;
		}	

		if (isset($this->request->get['sort_customer_unique_id'])) {
			$sort = $this->request->get['sort_customer_unique_id'];
		} else {
			$sort = 'customer_unique_id'; 
		}	
		
		if (isset($this->request->get['sort_name'])) {
			$sort = $this->request->get['sort_name'];
		} else {
			$sort = 'name'; 
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];  
		} else {
			$sort = 'operator'; 
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_customer_unique_id'])) {
			$url .= '&filter_customer_unique_id=' . urlencode(html_entity_decode($this->request->get['filter_customer_unique_id'], ENT_QUOTES, 'UTF-8'));
		}
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_stb'])) {
			$url .= '&filter_stb=' . urlencode(html_entity_decode($this->request->get['filter_stb'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_customer_group_id'])) {
			$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
		}
			
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		
		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}	
		
		if (isset($this->request->get['filter_ip'])) {
			$url .= '&filter_ip=' . $this->request->get['filter_ip'];
		}
					
		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}
		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}
						
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		if(isset($this->request->get['filter_customer_unique_id']) || isset($this->request->get['filter_name'])||isset($this->request->get['filter_stb'])||isset($this->request->get['filter_email'])||isset($this->request->get['filter_customer_group_id'])||isset($this->request->get['filter_status'])||isset($this->request->get['filter_approved'])||isset($this->request->get['filter_ip'])||isset($this->request->get['filter_date_added'])){
   			$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('sale/customer', 'token=' . $this->session->data['token'], 'SSL'),
	      		'separator' => ' :: '
	   		);

	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_filter'),
				'href'      => $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);

   		}
   		else{
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);
		}
		$this->data['upload_bulk_customer'] = $this->url->link('sale/customer/upload_bulk_customer', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['approve'] = $this->url->link('sale/customer/approve', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['insert'] = $this->url->link('sale/customer/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/customer/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$this->data['customers'] = array();

		$data = array(
			'filter_customer_unique_id'=>$filter_customer_unique_id,
			'filter_name'              => $filter_name, 
			'filter_stb'               => $filter_stb, 
			'filter_email'             => $filter_email, 
			'filter_customer_group_id' => $filter_customer_group_id, 
			'filter_status'            => $filter_status, 
			'filter_approved'          => $filter_approved, 
			'filter_date_added'        => $filter_date_added,
			'filter_operator'          => $filter_operator,
			'filter_ip'                => $filter_ip,
			'sort'                     => $sort,
			'order'                    => $order,
			'start'                    => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                    => $this->config->get('config_admin_limit')
		);
		$resultOperators = $this->model_sale_customer->getOperators();

		foreach ($resultOperators as $operator) {
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}
		// var_dump($this->data['operators']);
		// exit();
		$customer_total = $this->model_sale_customer->getTotalCustomers($data,$this->session->data['user_id']);
	
		$results = $this->model_sale_customer->getCustomers($data,$this->session->data['user_id']);
		
 		$user_group_id = $this->model_sale_customer->getUserGroupId($this->session->data['user_id']);
    	foreach ($results as $result) {
			$action = array();
		
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/customer/update', 'token=' . $this->session->data['token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL')
			);
			
			$this->data['customers'][] = array(
				'customer_id'    => $result['customer_id'],
				'customer_unique_id' => $result['customer_unique_id'],
				'name'           => $result['name'],
				// 'email'          => $result['email'],
				'sstbno'         => ($result["STBNO"]?$result["STBNO"]:"N/A"),
				'operator'       => isset($result['operator'])?$result['operator']:'',
				'customer_group' => $result['customer_group'],
				'status'         => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				// 'status'         => ($result["STBNO"]?($result['status'] ? "Acitvated" : "De-Activated"):"Unpaired"),
				// 'approved'       => ($result['approved'] ? $this->language->get('text_yes') : $this->language->get('text_no')),
				// 'ip'             => $result['ip'],
				//'date_added'     => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'date_added'     => $result['date_added'],
				'selected'       => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
				'action'         => $action
			);
		}	
		$this->data['user_group_id'] = $user_group_id;		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');	
		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_default'] = $this->language->get('text_default');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_email'] = $this->language->get('column_email');
		$this->data['column_customer_group'] = $this->language->get('column_customer_group');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_approved'] = $this->language->get('column_approved');
		$this->data['column_ip'] = $this->language->get('column_ip');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_login'] = $this->language->get('column_login');
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['column_operator'] = $this->language->get('column_operator');	
			
		
		$this->data['button_approve'] = $this->language->get('button_approve');
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			// $this->data['error_warning'] = '';
			if(isset($this->request->get['error'])){
				$this->data['error_warning'] = "Warning: Access Denied!";
			}else{
				$this->data['error_warning'] = '';
			}

		}
		
		if (isset($this->error['unpair'])) {
			$this->data['error_warning'] = $this->error['unpair'];
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if (isset($this->request->get['filter_customer_unique_id'])) {
			$url .= '&filter_customer_unique_id=' . urlencode(html_entity_decode($this->request->get['filter_customer_unique_id'], ENT_QUOTES, 'UTF-8'));
		}
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_stb'])) {
			$url .= '&filter_stb=' . urlencode(html_entity_decode($this->request->get['filter_stb'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_customer_group_id'])) {
			$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
		}
			
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		
		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}	
		
		if (isset($this->request->get['filter_ip'])) {
			$url .= '&filter_ip=' . $this->request->get['filter_ip'];
		}
				
		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}
			
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$this->data['sort_customer_unique_id'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=customer_unique_id' . $url, 'SSL');
		$this->data['sort_name'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
		$this->data['sort_operator'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=operator' . $url, 'SSL');
		$this->data['sort_email'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=c.email' . $url, 'SSL');
		$this->data['sort_customer_group'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=customer_group' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=c.status' . $url, 'SSL');
		$this->data['sort_approved'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=c.approved' . $url, 'SSL');
		$this->data['sort_ip'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=c.ip' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['filter_customer_unique_id'])) {
			$url .= '&filter_customer_unique_id=' . urlencode(html_entity_decode($this->request->get['filter_customer_unique_id'], ENT_QUOTES, 'UTF-8'));
		}
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_stb'])) {
			$url .= '&filter_stb=' . urlencode(html_entity_decode($this->request->get['filter_stb'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_customer_group_id'])) {
			$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}
		
		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}
		
		if (isset($this->request->get['filter_ip'])) {
			$url .= '&filter_ip=' . $this->request->get['filter_ip'];
		}
				
		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $customer_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$this->data['filter_customer_unique_id'] 	= $filter_customer_unique_id;
		$this->data['filter_name'] 					= $filter_name;
		$this->data['filter_stb'] 					= $filter_stb;
		$this->data['filter_email'] 				= $filter_email;
		$this->data['filter_customer_group_id'] 	= $filter_customer_group_id;
		$this->data['filter_status'] 				= $filter_status;
		$this->data['filter_approved'] 				= $filter_approved;
		$this->data['filter_ip'] 					= $filter_ip;
		$this->data['filter_date_added'] 			= $filter_date_added;
		$this->data['filter_operator'] 				= $filter_operator; 
		
		$this->load->model('sale/customer_group');
		
    	$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

		$this->load->model('setting/store');
		
		$this->data['stores'] = $this->model_setting_store->getStores();
				
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;
		
		$this->template = 'sale/customer_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer form page.
*/  
  	protected function getForm() {
  		// var_dump($this->error);exit();
    	$this->data['heading_title'] = $this->language->get('heading_title');
 
    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_add_ban_ip'] = $this->language->get('text_add_ban_ip');
		$this->data['text_remove_ban_ip'] = $this->language->get('text_remove_ban_ip');
		
		$this->data['column_ip'] = $this->language->get('column_ip');
		$this->data['column_total'] = $this->language->get('column_total');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_action'] = $this->language->get('column_action');
		
		$this->data['btn_subs'] = $this->language->get('btn_subs');
		$this->data['tab_subscription'] = $this->language->get('tab_subscription');
    	$this->data['entry_subscription'] = $this->language->get('entry_subscription');
    	$this->data['entry_firstname'] = $this->language->get('entry_firstname');
    	$this->data['entry_lastname'] = $this->language->get('entry_lastname');
    	$this->data['entry_email'] = $this->language->get('entry_email');
    	$this->data['entry_telephone'] = $this->language->get('entry_telephone');
    	$this->data['entry_fax'] = $this->language->get('entry_fax');
    	$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
    	$this->data['entry_customer_region'] = $this->language->get('entry_customer_region');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_company'] = $this->language->get('entry_company');
		$this->data['entry_company_id'] = $this->language->get('entry_company_id');
		$this->data['entry_tax_id'] = $this->language->get('entry_tax_id');
		$this->data['entry_address_1'] = $this->language->get('entry_address_1');
		$this->data['entry_address_2'] = $this->language->get('entry_address_2');
		$this->data['entry_city'] = $this->language->get('entry_city');
		$this->data['entry_region'] = $this->language->get('entry_region');
		$this->data['entry_postcode'] = $this->language->get('entry_postcode');
		$this->data['entry_zone'] = $this->language->get('entry_zone');
		$this->data['entry_country'] = $this->language->get('entry_country');
		$this->data['entry_default'] = $this->language->get('entry_default');
		$this->data['entry_comment'] = $this->language->get('entry_comment');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_amount'] = $this->language->get('entry_amount');
		$this->data['entry_points'] = $this->language->get('entry_points');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
    	$this->data['button_add_address'] = $this->language->get('button_add_address');
		$this->data['button_add_history'] = $this->language->get('button_add_history');
		$this->data['button_add_transaction'] = $this->language->get('button_add_transaction');
		$this->data['button_add_reward'] = $this->language->get('button_add_reward');
    	$this->data['button_remove'] = $this->language->get('button_remove');
	
		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_address'] = $this->language->get('tab_address');
		$this->data['tab_history'] = $this->language->get('tab_history');
		$this->data['tab_transaction'] = $this->language->get('tab_transaction');
		$this->data['tab_reward'] = $this->language->get('tab_reward');
		$this->data['tab_ip'] = $this->language->get('tab_ip');

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->get['customer_id'])) {
			$this->data['customer_id'] = $this->request->get['customer_id'];
		} else {
			$this->data['customer_id'] = 0;
		}

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['subscription'])) {
			$this->data['error_subs'] = $this->error['subscription'];
		} else {
			$this->data['error_subs'] = '';
		}

 		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

 		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}


		if (isset($this->error['STBNO'])){
		    $this->data['error_STBNO']=$this->error['STBNO'];
        } else {
            $this->data['error_STBNO']='';
        }
        if (isset($this->error['address'])){
		    $this->data['wrning_address']=$this->error['address'];
        } else {
            $this->data['wrning_address']='';
        }
	     

	    // if (isset($this->error['CASNO'])){
	    //     $this->data['error_CASNO']=$this->error['CASNO'];
	    // } else {
	    //     $this->data['error_CASNO']='';
	    // }
	    //----------
	     if (isset($this->error['SCNO'])){
	        $this->data['error_SCNO']=$this->error['SCNO'];
	    } else {
	        $this->data['error_SCNO']='';
	    }

 		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}
		
 		if (isset($this->error['telephone'])) {
			$this->data['error_telephone'] = $this->error['telephone'];
		} else {
			$this->data['error_telephone'] = '';
		}

		if (isset($this->error['group'])) {
			$this->data['error_group'] = $this->error['group'];
		} else {
			$this->data['error_group'] = '';
		}

		if (isset($this->error['region'])) {
			$this->data['error_region'] = $this->error['region'];
		} else {
			$this->data['error_region'] = '';
		}
		
 		if (isset($this->error['password'])) {
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}
		
 		if (isset($this->error['confirm'])) {
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}
		
		if (isset($this->error['address_default'])) {
			$this->data['error_address_default'] = $this->error['address_default'];
		} else {
			$this->data['error_address_default'] = '';
		}

		if (isset($this->error['address_firstname'])) {
			$this->data['error_address_firstname'] = $this->error['address_firstname'];
		} else {
			$this->data['error_address_firstname'] = '';
		}

 		if (isset($this->error['address_lastname'])) {
			$this->data['error_address_lastname'] = $this->error['address_lastname'];
		} else {
			$this->data['error_address_lastname'] = '';
		}
		
  		if (isset($this->error['address_tax_id'])) {
			$this->data['error_address_tax_id'] = $this->error['address_tax_id'];
		} else {
			$this->data['error_address_tax_id'] = '';
		}
				
		if (isset($this->error['address_address_1'])) {
			$this->data['error_address_address_1'] = $this->error['address_address_1'];
		} else {
			$this->data['error_address_address_1'] = '';
		}
		
		if (isset($this->error['address_city'])) {
			$this->data['error_address_city'] = $this->error['address_city'];
		} else {
			$this->data['error_address_city'] = '';
		}
		
		if (isset($this->error['address_postcode'])) {
			$this->data['error_address_postcode'] = $this->error['address_postcode'];
		} else {
			$this->data['error_address_postcode'] = '';
		}
		
		if (isset($this->error['address_country'])) {
			$this->data['error_address_country'] = $this->error['address_country'];
		} else {
			$this->data['error_address_country'] = '';
		}
		
		if (isset($this->error['address_zone'])) {
			$this->data['error_address_zone'] = $this->error['address_zone'];
		} else {
			$this->data['error_address_zone'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_customer_group_id'])) {
			$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
		}
		if (isset($this->request->get['filter_customer_region_id'])) {
			$url .= '&filter_customer_region_id=' . $this->request->get['filter_customer_region_id'];
		}
		
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		
		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}	
		
		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['customer_id'])) {
			$this->data['action'] = $this->url->link('sale/customer/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/customer/update', 'token=' . $this->session->data['token'] . '&customer_id=' . $this->request->get['customer_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['customer_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$customer_info = $this->model_sale_customer->getCustomer($this->request->get['customer_id']);
      		$custAddrInfo  = $this->model_sale_customer->getAddressId($this->request->get['customer_id']); 
      		$addr=$this->model_sale_customer->getAddress($customer_info['address_id']);
    	}
		
		if (isset($this->request->post['subscription'])) {
      		$this->data['subscription'] = $this->request->post['subscription'];
		} elseif (!empty($customer_info)) { 
			$this->data['subscription'] =explode(',',$customer_info['product_subscribed_list']);
		} else {
      		$this->data['subscription'] = array();
    	}

    	if (isset($this->request->post['customer_no'])) {
      		$this->data['customer_no'] = $this->request->post['customer_no'];
    	} elseif (!empty($customer_info)) { 
			$this->data['customer_no'] = $customer_info['customer_unique_id'];
		} else {
      		$this->data['customer_no'] = '';
    	}

    	if (isset($this->request->post['firstname'])) {
      		$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (!empty($customer_info)) { 
			$this->data['firstname'] = $customer_info['firstname'];
		} else {
      		$this->data['firstname'] = '';
    	}

    	if (isset($this->request->post['lastname'])) {
      		$this->data['lastname'] = $this->request->post['lastname'];
    	} elseif (!empty($customer_info)) { 
			$this->data['lastname'] = $customer_info['lastname'];
		} else {
      		$this->data['lastname'] = '';
    	}

    	if (isset($this->request->post['STBNO'])){
            $this->data['STBNO']=$this->request->post['STBNO'];
        } elseif (!empty($customer_info)) { 
            $this->data['STBNO']=$customer_info['STBNO'];
        } else {
            $this->data['STBNO']= '';
        }
      

        // if(isset($this->request->post['CASNO'])){
        //     $this->data['CASNO']=$this->request->post['CASNO'];

        // } elseif(!empty($customer_info)){
        //     $this->data['CASNO']=$customer_info['CASNO'];
        // } else{
        //     $this->data['CASNO']='';
        // }
        //-----------
        if(isset($this->request->post['SCNO'])){
            $this->data['SCNO']=$this->request->post['SCNO'];

        } elseif(!empty($customer_info)){
            $this->data['SCNO']=$customer_info['SCNO'];
        } else{
            $this->data['SCNO']='';
        }

        //----------




    	if (isset($this->request->post['email'])) {
      		$this->data['email'] = $this->request->post['email'];
    	} elseif (!empty($customer_info)) { 
			$this->data['email'] = $customer_info['email'];
		} else {
      		$this->data['email'] = '';
    	}

    	if (isset($this->request->post['telephone'])) {
      		$this->data['telephone'] = $this->request->post['telephone'];
    	} elseif (!empty($customer_info)) { 
			$this->data['telephone'] = $customer_info['telephone'];
		} else {
      		$this->data['telephone'] = '';
    	}

    	if (isset($this->request->post['fax'])) {
      		$this->data['fax'] = $this->request->post['fax'];
    	} elseif (!empty($customer_info)) { 
			$this->data['fax'] = $customer_info['fax'];
		} else {
      		$this->data['fax'] = '';
    	}

    	if (isset($this->request->post['newsletter'])) {
      		$this->data['newsletter'] = $this->request->post['newsletter'];
    	} elseif (!empty($customer_info)) { 
			$this->data['newsletter'] = $customer_info['newsletter'];
		} else {
      		$this->data['newsletter'] = '';
    	}
		$this->data['products']=array();
		
		$this->load->model('sale/customer_group');

		$products = $this->model_sale_customer->getAllProducts();	
		$packages = $this->model_sale_customer->getAllPackages();
		foreach ($packages as $package) {
			$this->data['products'][]=array(
				'product_id' => $package['product_id'],
				'name'       => $package['name']
				);	
		}
		foreach ($products as $product) {
			$this->data['products'][]=array(
				'product_id' => $product['product_id'],
				'name'       => $product['name']
				);	
		}
		
		$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
    	if (isset($this->request->post['customer_group_id'])) {
      		$this->data['customer_group_id'] = $this->request->post['customer_group_id'];
    	} elseif (!empty($customer_info)) { 
			$this->data['customer_group_id'] = $customer_info['customer_group_id'];
		} else {
      		$this->data['customer_group_id'] = $this->config->get('config_customer_group_id');
    	}

    	$this->load->model('sale/customer');
		// var_dump($this->request->post);exit();	
		$this->data['customer_regions'] = $this->model_sale_customer->getCustomerRegions();
		if (isset($this->request->post['region_id'])) {
      		$this->data['region_id'] = $this->request->post['region_id'];
    	} elseif (!empty($customer_info)) { 
			$this->data['region_id'] = $customer_info['region_id'];
		} else {
      		$this->data['region_id'] = $this->config->get('region_id');
    	}
    	if (isset($this->request->post['status'])) {
      		$this->data['status'] = $this->request->post['status'];
    	} elseif (!empty($customer_info)) { 
			$this->data['status'] = $customer_info['status'];
		} else {
      		$this->data['status'] = 1;
    	}

    	if (isset($this->request->post['password'])) { 
			$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}
		
		if (isset($this->request->post['confirm'])) { 
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}

		// if (isset($this->request->post['address_1'])) { 
		// 	$this->data['address_1'] = $this->request->post['address_1'];
		// }elseif (!empty($addr)) { 
		// 	$this->data['address_1'] = $addr['address_1'];
		// } else {
		// 	$this->data['address_1'] = '';
		// }

		if (isset($this->request->post['city'])) { 
			$this->data['city'] = $this->request->post['city'];
		}elseif (!empty($addr)) { 
			$this->data['city'] = $addr['city'];
		} else {
			$this->data['city'] = '';
		}

		if (isset($this->request->post['country_id'])) { 
			$this->data['country_id'] = $this->request->post['country_id'];
			$this->data['zones'] =$this->model_sale_customer->getZoneList($this->request->post['country_id']);
		}elseif (!empty($addr)) { 
			$this->data['country_id'] = $addr['country_id'];
			$this->data['zones'] =$this->model_sale_customer->getZoneList($addr['country_id']);
		} else {
			$this->data['zones'] =$this->model_sale_customer->getZoneList(99);
			$this->data['country_id'] = 99;
		}

		if (isset($this->request->post['zone_id'])) { 
			$this->data['zone_id'] = $this->request->post['zone_id'];
		}elseif (!empty($addr)) { 
			$this->data['zone_id'] = $addr['zone_id'];
		} else {
			$this->data['zone_id'] = '';
		}		
		if (isset($this->request->post['address'][1]['region_id']) && $this->request->post['address'][1]['region_id']!='') { 
			$this->data['region_id'] = $this->request->post['address'][1]['region_id'];
			$this->data['region'] =$this->model_sale_customer->getRegionList($this->request->post['address'][1]['zone_id']); 
		}elseif (!empty($addr)) { 
			$this->data['region_id'] = $addr['region_id'];
		} else {
			$this->data['region_id'] = '';
		}

		if (isset($this->request->post['postcode'])) { 
			$this->data['postcode'] = $this->request->post['postcode'];
		}elseif (!empty($addr)) { 
			$this->data['postcode'] = $addr['postcode'];
		} else {
			$this->data['postcode'] = '';
		}
// Below Line changed in Build 2.5.15
// Issue while editing the customer		
		/*if(isset($customer_info)){
            $this->data['operator'] = $this->model_sale_customer->getUserName($customer_info['operator_id']);   
        }else{
            $this->data['operator'] = $this->model_sale_customer->getUserName($this->session->data['user_id']);
        }*/
		// $this->data['operator'] = $this->model_sale_customer->getUserName($this->session->data['user_id']);

		//===== Above line no (1828-1832) comments for operator name issue in Build 2.5.22 (Bug.no:- 2740).  
		//===== Also changed in customer model add one join of oc_user table for operator name. (FunName:- getCustomer()).
		if (isset($this->request->post['operator'])) {
      		$this->data['operator'] = $this->request->post['operator'];
    	} elseif (!empty($customer_info)) { 
			$this->data['operator'] = $customer_info['operator'];
		} else {
      		$this->data['operator'] = '';
    	}
    	
		$this->load->model('localisation/country');
		
		$this->data['countries'] = $this->model_localisation_country->getCountries();
			
		if (isset($this->request->post['address'])) { 
      		$this->data['addresses'] = $this->request->post['address'];
		} elseif (isset($this->request->get['customer_id'])) {
			$this->data['addresses'] = $this->model_sale_customer->getAddresses($this->request->get['customer_id']);
		} else {
			$this->data['addresses'] = array();
    	}

    	if (isset($this->request->post['address_id'])) {
      		$this->data['address_id'] = $this->request->post['address_id'];
    	} elseif (!empty($custAddrInfo)) { 
			$this->data['address_id'] = $custAddrInfo['address_id'];
		} else {
      		$this->data['address_id'] = '';
    	}
		
		$this->data['ips'] = array();
    	
		if (!empty($customer_info)) {
			$results = $this->model_sale_customer->getIpsByCustomerId($this->request->get['customer_id']);
		
			foreach ($results as $result) {
				$ban_ip_total = $this->model_sale_customer->getTotalBanIpsByIp($result['ip']);
				
				$this->data['ips'][] = array(
					'ip'         => $result['ip'],
					'total'      => $this->model_sale_customer->getTotalCustomersByIp($result['ip']),
					'date_added' => date('d/m/y', strtotime($result['date_added'])),
					'filter_ip'  => $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . '&filter_ip=' . $result['ip'], 'SSL'),
					'ban_ip'     => $ban_ip_total
				);
			}
		}		
		
		$this->template = 'sale/customer_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer form page.
*/  
  	protected function getUploadForm() {

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		$data = array(
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

   		$this->data['bulk_registration_log_list'] = array();
   		$total = $this->model_sale_customer->getTotal();
		$results = $this->model_sale_customer->getBulkRegistrationLogList($data);
		$count =0;
		if($results)
			foreach ($results as $result) {
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){			
					$useridwithextension = explode("_",$result['name']);
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_registration_log_list'][] = array(
							'name'    => $result['name'],
							'date'         => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		$total = $count;

		// if (!isset($this->request->get['customer_id'])) {
		// 	$this->data['action'] = $this->url->link('sale/customer/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		// } else {
		$this->data['upload_bulk_customer'] = $this->url->link('sale/customer/upload_bulk_customer', 'token=' . $this->session->data['token'] . $url, 'SSL');
		//}
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 
		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 
		
    	$this->data['cancel'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'] . $url, 'SSL');
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/historicalactivation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();		

		$this->template = 'sale/upload_bulk_customer.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	public function isValid($str) {
    	return preg_match('/[^A-Za-z0-9 ]/', $str);
	}


/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
// var_dump($this->request->post);exit();
    	if (!$this->user->hasPermission('modify', 'sale/customer')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

    	// if(isset($this->request->post['subscription'])){
	    // 	if (count($this->request->post['subscription']) < 1) {
	    //   		$this->error['subscription'] = $this->language->get('error_subs');
	    // 	}
	    // 	if (count($this->request->post['subscription'])> 0) {
	    // 		if (in_array(-1, $this->request->post['subscription'])) {
	    //   			$this->error['subscription'] = $this->language->get('error_subs_select');
	    //   		}
	    // 	}
    	// }else{
    	// 	$this->error['subscription'] = $this->language->get('error_subs');
    	// }
    	if(isset($this->request->post['subscription'])){
	    	if (count($this->request->post['subscription'])>1) {
	    		$cnt_array = array_count_values($this->request->post['subscription']);
				print_r($cnt_array);
				foreach($cnt_array as $key=>$val){
				   if($val != 1){
				   	$this->error['subscription'] = $this->language->get('error_duplicate_subs');
				   }
				}
	    	}
	    }
    	if(!isset($this->request->post['address']))
    	{
    		$this->error['address'] = 'Warning: Add address!';
    	}
    	
    	if ((utf8_strlen(trim($this->request->post['firstname'])) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
      		$this->error['firstname'] = $this->language->get('error_firstname');
    	}elseif ( preg_match('/^\s/',$this->request->post['firstname']) ){
			$this->error['firstname'] = $this->language->get('Space not allowed!');
		}

    	if ((utf8_strlen(trim($this->request->post['lastname'])) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
      		$this->error['lastname'] = $this->language->get('error_lastname');
    	}elseif ( preg_match('/^\s/',$this->request->post['lastname']) ){
			$this->error['lastname'] = $this->language->get('Space not allowed!');
		}

    	if ( $this->isValid($this->request->post['firstname'])){
  			$this->error['firstname'] = $this->language->get('Special Characters not allowed!');
  		}

  		if ( $this->isValid($this->request->post['lastname'])){
  			$this->error['lastname']= $this->language->get('Special Characters not allowed!');
  		}


    	if ((strlen($this->request->post['STBNO'])<14)||(strlen($this->request->post['STBNO'])>14)){
            $this->error['STBNO'] = $this->language->get('error_STBNO');
        }
        else{
	        $stb_exist = $this->model_sale_customer->getSTBExist($this->request->post['STBNO']);
	        if($stb_exist){
		        $customer_info = $this->model_sale_customer->getCustomerBySTBNO($this->request->post['STBNO']);
				$stb_blackList = $this->model_sale_customer->getSTBblackList($this->request->post['STBNO']);
				$stb_operator = $this->model_sale_customer->getOperatorIdOfSTB($this->request->post['STBNO']);
				if ((int)$stb_blackList["is_black_list"]) {
	        		$this->error['STBNO'] = 'STBNO is Black listed!';
	        	}
				if (!isset($this->request->get['customer_id'])) {
					if ($customer_info) {
						$this->error['STBNO'] = 'Warning: STBNO is already registered!';
					}else
					if($this->session->data['user_id']!=1 && (int)$stb_operator['operator_id']!=(int)$this->session->data['user_id']){
						$this->error['STBNO'] = 'Warning: STB No. is not belongs to this user!';	
					}
				} else {
					$customer_operator = $this->model_sale_customer->getOperatorIdOfCustomer($this->request->get['customer_id']);
					if ($customer_info && ($this->request->get['customer_id'] != $customer_info['customer_id'])) {
						$this->error['STBNO'] = 'Warning: STBNO is already registered!';
					}
					if($customer_operator['operator_id'] != $stb_operator['operator_id']){
						$this->error['STBNO'] = 'Warning: Customer AND STB are not be to same operator!';	
					}

				}

			}else{
				$this->error['STBNO'] = 'Warning: STB No. does not exist!';
			}
		}

  //       if((strlen($this->request->post['CASNO'])<16)||(strlen($this->request->post['CASNO'])>16)){
  //           $this->error['CASNO']=$this->language->get('error_CASNO');
  //       }
  //       else{
  //       	$cas_exist = $this->model_sale_customer->getCASExist($this->request->post['CASNO']);
	 //        if($cas_exist){
		//         $customer_info = $this->model_sale_customer->getCustomerByCASNO($this->request->post['CASNO']);
				
		// 		if (!isset($this->request->get['customer_id'])) {
		// 			if ($customer_info) {
		// 				$this->error['CASNO'] = 'Warning: CASNO is already registered!';
		// 			}
		// 		} else {
		// 			if ($customer_info && ($this->request->get['customer_id'] != $customer_info['customer_id'])) {
		// 				$this->error['CASNO'] = 'Warning: CASNO is already registered!';
		// 			}
		// 		}
		// 	}else{
		// 		$this->error['CASNO'] = 'Warning: CAS No. does not exist!'.$cas_exist;
		// 	}
		// }
		//-----------------
		  if((strlen($this->request->post['SCNO'])<12)||(strlen($this->request->post['SCNO'])>12)||!is_numeric($this->request->post['SCNO'])){
            $this->error['SCNO']=$this->language->get('error_SCNO');
        }
        else{
		        $customer_info = $this->model_sale_customer->getCustomerBySCNO($this->request->post['SCNO']);
				
				if (!isset($this->request->get['customer_id'])) {
					if ($customer_info) {
						$this->error['SCNO'] = 'Warning: CFNO is already registered!';
					}
				} else {
					if ($customer_info && ($this->request->get['customer_id'] != $customer_info['customer_id'])) {
						$this->error['SCNO'] = 'Warning: CFNO is already registered!';
					}
				}

		}
		//-----------------

		// if ((utf8_strlen(trim($this->request->post['email'])) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
  //     		$this->error['email'] = $this->language->get('error_email');
  //   	}
		if ((utf8_strlen(trim($this->request->post['email'])) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
      		$this->error['email'] = $this->language->get('error_email');
    	}
    	
		if (count(explode(' ', $this->request->post['email'])) > 1) {
			$this->error['email'] = $this->language->get('Space not allowed!');
		}

		$customer_info = $this->model_sale_customer->getCustomerByEmail($this->request->post['email']);
		
		if (!isset($this->request->get['customer_id'])) {
			if ($customer_info) {
				$this->error['email'] = $this->language->get('error_exists');
			}
		} else {
			if ($customer_info && ($this->request->get['customer_id'] != $customer_info['customer_id'])) {
				$this->error['email'] = $this->language->get('error_exists');
			}
		}
		
    	if ((utf8_strlen(trim($this->request->post['telephone'])) < 10) || (utf8_strlen($this->request->post['telephone']) > 10)) {
      			$this->error['telephone'] = $this->language->get('error_telephone');
    	}elseif(!is_numeric($this->request->post['telephone'])){
    			$this->error['telephone'] = $this->language->get('error_telephone_digits');
    	}elseif(substr($this->request->post['telephone'], 0,1)==0){
    			$this->error['telephone'] = $this->language->get('Invalid telephone number entered!');
    	}
    
    	$customer_tel = $this->model_sale_customer->getCustomerByMobile($this->request->post['telephone']);
    	if (!isset($this->request->get['customer_id'])) {
			if ($customer_tel) {
				$this->error['warning'] = $this->language->get('error_exist'); 
			}
		} else {
			if ($customer_tel && ($this->request->get['customer_id'] != $customer_tel['customer_id'])) {
				$this->error['telephone'] = "Mobile No. already exist!";//$this->language->get('error_exists');
			}
		}


    	// if (!isset($this->request->post['customer_region_id'])){
     //  			$this->error['region'] = "add region";
    	// }
    	
    	if (!isset($this->request->post['customer_group_id'])) {
      			$this->error['group'] = "add group";
    	}
    	


    	if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
      		if ((utf8_strlen(trim($this->request->post['password'])) < 4) || (utf8_strlen(trim($this->request->post['password'])) > 20)) {
        		$this->error['password'] = $this->language->get('error_password');
      		}
	
	  		if (trim($this->request->post['password']) != trim($this->request->post['confirm'])) {
	    		$this->error['confirm'] = $this->language->get('error_confirm');
	  		}
    	}

  //   	if ((utf8_strlen($this->request->post['address_1']) < 3) || (utf8_strlen($this->request->post['address_1']) > 128)) {
		// 	$this->error['address_address_1'] = $this->language->get('error_address_1');
		// }
	
		// if ((utf8_strlen($this->request->post['city']) < 2) || (utf8_strlen($this->request->post['city']) > 128)) {
		// 	$this->error['address_city'] = $this->language->get('error_city');
		// } 

		// $this->load->model('localisation/country');
		
		// $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);
				
		// if ($country_info) {
		// 	if ($country_info['postcode_required'] && (utf8_strlen($this->request->post['postcode']) < 2) || (utf8_strlen($this->request->post['postcode']) > 10)) {
		// 		$this->error['address_postcode'] = $this->language->get('error_postcode');
		// 	}
		// }
	
		// if ($this->request->post['country_id'] == '') {
		// 	$this->error['address_country'] = $this->language->get('error_country');
		// }
		
		// if (!isset($this->request->post['zone_id']) || $this->request->post['zone_id'] == '') {
		// 	$this->error['address_zone'] = $this->language->get('error_zone');
		// }
		if (isset($this->request->post['address'])) {
			$count = 0;
			foreach ($this->request->post['address'] as $key => $value) {
				

				if ($value['country_id']=="") {
					$this->error['address_country'][$key] = $this->language->get('error_country');
				}

				if(isset($value['zone_id'])){
					if ($value['zone_id'] == '') {
						$this->error['address_zone'][$key] = $this->language->get('error_zone');
					}	
				}

				if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 32)) {
						$this->error['address_firstname'][$key] = $this->language->get('error_firstname');
					}
					
					if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
						$this->error['address_lastname'][$key] = $this->language->get('error_lastname');
					}	
					
					if ((utf8_strlen(trim($value['address_1'])) < 3) || (utf8_strlen(trim($value['address_1'])) > 128)) {
						$this->error['address_address_1'][$key] = $this->language->get('error_address_1');
					}
				
					if ((utf8_strlen(trim($value['city'])) < 2) || (utf8_strlen(trim($value['city'])) > 128)) {
						$this->error['address_city'][$key] = $this->language->get('error_city');
					}
					if ( preg_match('/^\s/',$value['city']) ){
						$this->error['address_city'][$key] = $this->language->get('Space not allowed!');
					}  
					if(preg_match('/[^a-z0-9 ]+/i', $value['city'])) {
						// preg_match will return true if it finds 
						// a character *other than* a-z, 0-9, space *anywhere* inside the string
						$this->error['address_city'][$key] = $this->language->get('Special characters not allowed!');
					}

					if ($value['region_id'] == '') {
						$this->error['address_region'][$key] = $this->language->get('error_region');
					}

				if(sizeof($this->request->post['address'])==9 || sizeof($this->request->post['address'])==10){
					if(isset($value['default'])){
						$count += 1;
					} 
					if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 32)) {
						$this->error['address_firstname'][$key] = $this->language->get('error_firstname');
					}
					
					if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
						$this->error['address_lastname'][$key] = $this->language->get('error_lastname');
					}	
					
					if ((utf8_strlen(trim($value['address_1'])) < 3) || (utf8_strlen(trim($value['address_1'])) > 128)) {
						$this->error['address_address_1'][$key] = $this->language->get('error_address_1');
					}
				
					if ((utf8_strlen(trim($value['city'])) < 2) || (utf8_strlen(trim($value['city'])) > 128)) {
						$this->error['address_city'][$key] = $this->language->get('error_city');
					}
					if ( preg_match('/^\s/',$value['city']) ){
						$this->error['address_city'][$key] = $this->language->get('Space not allowed!');
					}  
					if(preg_match('/[^a-z0-9 ]+/i', $value['city'])) {
						// preg_match will return true if it finds 
						// a character *other than* a-z, 0-9, space *anywhere* inside the string
						$this->error['address_city'][$key] = $this->language->get('Special characters not allowed!');
					}
		
					$this->load->model('localisation/country');
					
					$country_info = $this->model_localisation_country->getCountry($value['country_id']);
							
					if ($country_info) {
						if ($country_info['postcode_required'] && (utf8_strlen($value['postcode']) < 2) || (utf8_strlen($value['postcode']) > 10)) {
							$this->error['address_postcode'][$key] = $this->language->get('error_postcode');
						}
						
						// VAT Validation
						// $this->load->helper('vat');
						
						// if ($this->config->get('config_vat') && $value['tax_id'] && (vat_validation($country_info['iso_code_2'], $value['tax_id']) == 'invalid')) {
						// 	$this->error['address_tax_id'][$key] = $this->language->get('error_vat');
						// }
					}
				
					if ($value['country_id'] == '') {
						$this->error['address_country'][$key] = $this->language->get('error_country');
					}
					
					// if (!isset($value['zone_id']) || $value['zone_id'] == '') {
					if(isset($value['zone_id'])){
						if ($value['zone_id'] == '') {
							$this->error['address_zone'][$key] = $this->language->get('error_zone');
						}	
					}
					// if (!isset($value['region_id']) || $value['region_id'] == '') {
					if ($value['region_id'] == '') {
						$this->error['address_region'][$key] = $this->language->get('error_region');
					}
				}
			}
			if( $count > 1){
				$this->error['address_default'][$key] = $this->language->get('error_address_default');
			}	 
		}
		/*$add_count = 1;
		if(isset($this->request->post['address'])){
			if(sizeof($this->request->post['address'])>1){			
				foreach ($this->request->post['address'] as $key => $value) {
					$add_count++;
				}
				if ($add_count != sizeof($this->request->post['address'])) {
					$this->error['warning'] = $this->language->get('error_warning');
				}
			}
		}*/
		
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer content when deleted. 
						Checks if the deteled customer is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'sale/customer')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	if(isset($this->request->post['selected'])){ 
	  		foreach ($this->request->post['selected'] as $customer_id) { 
				$check = $this->model_sale_customer->CheckBeforedeleteCustomer($customer_id);  
				if($check)
					break;
			}
			if($check)
				$this->error['unpair'] = $this->language->get('error_unpair');
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	} 
/*
FUNCTION NAME 		-	login
DESCRIPTION 		-	Loads the selected customers home page on the store. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the selected customers home page. 
*/	
	public function login() {
		$json = array();
		
		if (isset($this->request->get['customer_id'])) {
			$customer_id = $this->request->get['customer_id'];
		} else {
			$customer_id = 0;
		}
		
		$this->load->model('sale/customer');
		
		$customer_info = $this->model_sale_customer->getCustomer($customer_id);
				
		if ($customer_info) {
			$token = md5(mt_rand());
			
			$this->model_sale_customer->editToken($customer_id, $token);
			
			if (isset($this->request->get['store_id'])) {
				$store_id = $this->request->get['store_id'];
			} else {
				$store_id = 0;
			}
					
			$this->load->model('setting/store');
			
			$store_info = $this->model_setting_store->getStore($store_id);
			
			if ($store_info) {
				$this->redirect($store_info['url'] . 'index.php?route=account/login&token=' . $token);
			} else { 
				$this->redirect(HTTP_CATALOG . 'index.php?route=account/login&token=' . $token);
			}
		} else {
			$this->language->load('error/not_found');

			$this->document->setTitle($this->language->get('heading_title'));

			$this->data['heading_title'] = $this->language->get('heading_title');

			$this->data['text_not_found'] = $this->language->get('text_not_found');

			$this->data['breadcrumbs'] = array();

			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
				'separator' => false
			);

			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('error/not_found', 'token=' . $this->session->data['token'], 'SSL'),
				'separator' => ' :: '
			);
		
			$this->template = 'error/not_found.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
		
			$this->response->setOutput($this->render());
		}
	}
/*
FUNCTION NAME 		-	history
DESCRIPTION 		-	Load the list of all the order made by the customer 
						in a new tab named HISTORY on the customer edit page.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list of orders as a list
*/		
	public function history() {
    	$this->language->load('sale/customer');
		
		$this->load->model('sale/customer');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->user->hasPermission('modify', 'sale/customer')) { 
			$this->model_sale_customer->addHistory($this->request->get['customer_id'], $this->request->post['comment']);
				
			$this->data['success'] = $this->language->get('text_success');
		} else {
			$this->data['success'] = '';
		}
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !$this->user->hasPermission('modify', 'sale/customer')) {
			$this->data['error_warning'] = $this->language->get('error_permission');
		} else {
			$this->data['error_warning'] = '';
		}		
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_comment'] = $this->language->get('column_comment');
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}  
		
		$this->data['histories'] = array();
			
		$results = $this->model_sale_customer->getHistories($this->request->get['customer_id'], ($page - 1) * 10, 10);
      		
		foreach ($results as $result) {
        	$this->data['histories'][] = array(
				'comment'     => $result['comment'],
        		'date_added'  => date($this->language->get('date_format_short'), strtotime($result['date_added']))
        	);
      	}			
		
		$transaction_total = $this->model_sale_customer->getTotalHistories($this->request->get['customer_id']);
			
		$pagination = new Pagination();
		$pagination->total = $transaction_total;
		$pagination->page = $page;
		$pagination->limit = 10; 
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/customer/history', 'token=' . $this->session->data['token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$this->template = 'sale/customer_history.tpl';		
		
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	transaction
DESCRIPTION 		-	Loads the customer account transaction details as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the transaction list. 
*/	
	public function transaction() {
    	$this->language->load('sale/customer');
		
		$this->load->model('sale/customer');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->user->hasPermission('modify', 'sale/customer')) { 
			$this->model_sale_customer->addTransaction($this->request->get['customer_id'], $this->request->post['description'], $this->request->post['amount']);
				
			$this->data['success'] = $this->language->get('text_success');
		} else {
			$this->data['success'] = '';
		}
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !$this->user->hasPermission('modify', 'sale/customer')) {
			$this->data['error_warning'] = $this->language->get('error_permission');
		} else {
			$this->data['error_warning'] = '';
		}		
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_balance'] = $this->language->get('text_balance');
		
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_description'] = $this->language->get('column_description');
		$this->data['column_amount'] = $this->language->get('column_amount');
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}  
		
		$this->data['transactions'] = array();
			
		$results = $this->model_sale_customer->getTransactions($this->request->get['customer_id'], ($page - 1) * 10, 10);
      		
		foreach ($results as $result) {
        	$this->data['transactions'][] = array(
				'amount'      => $this->currency->format($result['amount'], $this->config->get('config_currency')),
				'description' => $result['description'],
        		'date_added'  => date($this->language->get('date_format_short'), strtotime($result['date_added']))
        	);
      	}			
		
		$this->data['balance'] = $this->currency->format($this->model_sale_customer->getTransactionTotal($this->request->get['customer_id']), $this->config->get('config_currency'));
		
		$transaction_total = $this->model_sale_customer->getTotalTransactions($this->request->get['customer_id']);
			
		$pagination = new Pagination();
		$pagination->total = $transaction_total;
		$pagination->page = $page;
		$pagination->limit = 10; 
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/customer/transaction', 'token=' . $this->session->data['token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$this->template = 'sale/customer_transaction.tpl';		
		
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	reward
DESCRIPTION 		-	Load the list of all the reward points given to the customer
						and can also add reward to his customer account. This is shown 
						in a new tab named REWARD POINTS on the customer edit page.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list of reward points as a list
*/		
	public function reward() {
    	$this->language->load('sale/customer');
		
		$this->load->model('sale/customer');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->user->hasPermission('modify', 'sale/customer')) { 
			$this->model_sale_customer->addReward($this->request->get['customer_id'], $this->request->post['description'], $this->request->post['points']);
				
			$this->data['success'] = $this->language->get('text_success');
		} else {
			$this->data['success'] = '';
		}
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && !$this->user->hasPermission('modify', 'sale/customer')) {
			$this->data['error_warning'] = $this->language->get('error_permission');
		} else {
			$this->data['error_warning'] = '';
		}	
				
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_balance'] = $this->language->get('text_balance');
		
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_description'] = $this->language->get('column_description');
		$this->data['column_points'] = $this->language->get('column_points');

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}  
		
		$this->data['rewards'] = array();
			
		$results = $this->model_sale_customer->getRewards($this->request->get['customer_id'], ($page - 1) * 10, 10);
      		
		foreach ($results as $result) {
        	$this->data['rewards'][] = array(
				'points'      => $result['points'],
				'description' => $result['description'],
        		'date_added'  => date($this->language->get('date_format_short'), strtotime($result['date_added']))
        	);
      	}			
		
		$this->data['balance'] = $this->model_sale_customer->getRewardTotal($this->request->get['customer_id']);
		
		$reward_total = $this->model_sale_customer->getTotalRewards($this->request->get['customer_id']);
			
		$pagination = new Pagination();
		$pagination->total = $reward_total;
		$pagination->page = $page;
		$pagination->limit = 10; 
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/customer/reward', 'token=' . $this->session->data['token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$this->template = 'sale/customer_reward.tpl';		
		
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	addBanIP
DESCRIPTION 		-	Adds the customers IP as the ban IP for the network.
						After this the customer is not allowed to access the store.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the customer edit page
*/	
	public function addBanIP() {
		$this->language->load('sale/customer');
		
		$json = array();

		if (isset($this->request->post['ip'])) { 
			if (!$this->user->hasPermission('modify', 'sale/customer')) {
				$json['error'] = $this->language->get('error_permission');
			} else {
				$this->load->model('sale/customer');
				
				$this->model_sale_customer->addBanIP($this->request->post['ip']);
				
				$json['success'] = $this->language->get('text_success');
			}
		}
		
		$this->response->setOutput(json_encode($json));
	}
/*
FUNCTION NAME 		-	removeBanIP
DESCRIPTION 		-	Removes the customers IP as the ban IP from the network.
						After this the customer is allowed to access the store.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the customer edit page
*/
	public function removeBanIP() {
		$this->language->load('sale/customer');
		
		$json = array();

		if (isset($this->request->post['ip'])) { 
			if (!$this->user->hasPermission('modify', 'sale/customer')) {
				$json['error'] = $this->language->get('error_permission');
			} else {
				$this->load->model('sale/customer');
				
				$this->model_sale_customer->removeBanIP($this->request->post['ip']);
				
				$json['success'] = $this->language->get('text_success');
			}
		}
		
		$this->response->setOutput(json_encode($json));
	}
/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	The filter anme is auto filled as the user type 
						few of the starting letters.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Shows the pattern search list as a drop down.
*/
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_name'])) {
			$this->load->model('sale/customer');
			
			$data = array(
				'filter_name' => $this->request->get['filter_name'],
				'start'       => 0,
				'limit'       => 20
			);
		
			$results = $this->model_sale_customer->getCustomers($data,$this->session->data['user_id']);
			
			foreach ($results as $result) {
				$json[] = array(
					'customer_id'       => $result['customer_id'], 
					'customer_group_id' => $result['customer_group_id'],
					'name'              => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
					'customer_group'    => $result['customer_group'],
					'firstname'         => $result['firstname'],
					'lastname'          => $result['lastname'],
				    'STBNO'             => $result['STBNO'],
					'email'             => $result['email'],
					'telephone'         => $result['telephone'],
					'fax'               => $result['fax'],
					'address'           => $this->model_sale_customer->getAddresses($result['customer_id'])
				);					
			}
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}		
/*
FUNCTION NAME 		-	country
DESCRIPTION 		-	Loads the country information form the database to a json
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the json values for the country retrieved.
*/		
	public function country() {
		$json = array();
		
		$this->load->model('localisation/country');

    	$country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);
		
		if ($country_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'country_id'        => $country_info['country_id'],
				'name'              => $country_info['name'],
				'iso_code_2'        => $country_info['iso_code_2'],
				'iso_code_3'        => $country_info['iso_code_3'],
				'address_format'    => $country_info['address_format'],
				'postcode_required' => $country_info['postcode_required'],
				'zone'              => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
				'status'            => $country_info['status']		
			);
		}
		
		$this->response->setOutput(json_encode($json));
	}

/*
FUNCTION NAME 		-	region
DESCRIPTION 		-	Loads the regions information form the database to a json
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the json values for the country retrieved.
*/		
	public function region() {
		$json = array();
		
		$this->load->model('localisation/country');

    	$zone_info = $this->model_localisation_country->getZone($this->request->get['zone_id']);
		if ($zone_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'zone_id'        	=> $zone_info['zone_id'],
				'name'              => $zone_info['name'],
				'region'            => $this->model_localisation_zone->getRegionsByZoneId($this->request->get['zone_id'])
			);
		} 
		$this->response->setOutput(json_encode($json));
	}

/*
FUNCTION NAME 		-	postcode
DESCRIPTION 		-	Loads the regions information form the database to a json for postcode data
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the json values for the country retrieved.
*/		
	public function postcode() {
		$json = array();
		
		$this->load->model('localisation/country');

    	$postcode_info = $this->model_localisation_country->getPostCode($this->request->get['region_id']);
		if ($postcode_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'region_id'        	=> $postcode_info['region_id'],
				'region_name'       => $postcode_info['region_name'],
				'postcode'          => $this->model_localisation_zone->getPostcodeByRegionId($this->request->get['region_id'])
			);
		} 
		$this->response->setOutput(json_encode($json));
	}	

/*
FUNCTION NAME 		-	address
DESCRIPTION 		-	Loads the different address for the customer in a Address tab.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list of different addresses.
*/		
	public function address() {
		$json = array();
		
		if (!empty($this->request->get['address_id'])) {
			$this->load->model('sale/customer');
			
			$json = $this->model_sale_customer->getAddress($this->request->get['address_id']);
		}

		$this->response->setOutput(json_encode($json));		
	}
	private function getUserIdFromApiResponce($obj1){
		//var_dump($obj1);
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
				//return $value['package_id'];
				/*var_dump($value);
				exit(0);*/return $value;
			 }
			 var_dump($obj1);
			 //exit(0);
			 return;
	}
	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t\t\t".$log_target."\t\t\t\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
    } 
}
?>