<?php
 /*
@File transaction_status.php(Controller)
    This class show the transaction statu where the admin can filter based on the 
    user_id and cmd id

@Author Mahesh 
@date 7th Oct. 2015
*/
class ControllerReportTransactionStatus extends Controller {
	private $error = array(); 
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the Transaction data and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the 
*/	
	public function index() {     
		$this->language->load('report/transaction_status');

		$this->document->setTitle($this->language->get('heading_title'));
		$this->getList();

	}
/*
FUNCTION NAME 		-	resend
DESCRIPTION 		-	calls api Resend and stores response in database for track.
INPUT PARAMETER 	-	transaction id,cmd id,user id
OUTPUT PARAMETER 	- 	Rendering of the 
*/	
	function resend()
	{
		
		$obj = new restapi();
		$this->language->load('report/transaction_status');
    	$this->document->setTitle($this->language->get('heading_title'));
    	$this->load->model('report/transaction_status');
  		
    	if($this->validateForm())
    	{
    		$customer_id=$this->request->get['user_id'];
    		$user=$this->model_report_transaction_status->getCustomerKmsId($customer_id);
    		$user_id=$user['api_user_id'];
    		$target_lvl=1;
    		$obj = new restapi();
    		$trans_id=$this->request->get['tx_id'];
    		$cmd_id=$this->request->get['command_id'];
    		
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;
		  	$method ="POST";
			$url=KMS_API."/Resend";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$url,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);			
		    $error=true;
		    $errorMsg='';
		    $apimessage="";
		    foreach ($response as $key => $value) {
		    	switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$id=$value;	
    					break;
    				case 'mq_response':
    					$curlresponse=$value;
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$end_time=trim(substr($resp[2],0, strrpos($resp[2], "=")	));
				$payload="#".$user_id;
				$target=1;
				$targetdata=0;
				$order_data=$this->model_report_transaction_status->getTransactionOrderProductIds($customer_id,$cmd_id,$trans_id);
				$results = $this->model_report_transaction_status->addToCasOpTransanction($customer_id,$cmd_id,$order_data["exp_date"],
						   $id,$ack_is,$nack_is,$order_data['order_id'],$order_data['product_id'],$order_data['modify_date']);
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
			$this->redirect($this->url->link('report/transaction_status', 'token=' . $this->session->data['token'], 'SSL'));
		}
	}
/*
FUNCTION NAME 		-	disable
DESCRIPTION 		-	calls api Disable and stores response in database for tracking.
INPUT PARAMETER 	-	transaction id,cmd id,user id
OUTPUT PARAMETER 	- 	Rendering of the 
*/
	function disable()
	{
		$obj = new restapi();
		$this->language->load('report/transaction_status');
    	$this->document->setTitle($this->language->get('heading_title'));
    	$this->load->model('report/transaction_status');
  
    	if($this->validateForm())
    	{
    		$obj = new restapi();

    		$customer_id=$this->request->get['user_id'];
    		$user=$this->model_report_transaction_status->getCustomerKmsId($customer_id);
    		$user_id=$user['api_user_id'];
    		$trans_id=$this->request->get['tx_id'];
    		$cmd_id=$this->request->get['command_id'];
    		$command_id=$cmd_id;
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=1";
		  	$method ="POST";
			$url=KMS_API."/Disable";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$url,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);		
		    $error=true;
		    $errorMsg='';
		    $apimessage="";
		    foreach ($response as $key => $value) {
		    	switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$id=$value;	
    					break;
    				case 'mq_response':
    					$curlresponse=$value;
    					break;
    				case 'disble_command_id':
    					$cmd_id=$value;
    					break; 
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$end_time=trim(substr($resp[2],0, strrpos($resp[2], "=")));
				$payload="#".$user_id;
				$target=1;
				$targetdata=0;
				$order_data=$this->model_report_transaction_status->getTransactionOrderProductIds($customer_id,$command_id,$trans_id);
				$date=date('Y-m-d H:i:s');
				$results = $this->model_report_transaction_status->addToCasOpTransanction($customer_id,$cmd_id,$end_time,
						   $id,$ack_is,$nack_is,$order_data['order_id'],$order_data['product_id'],$date);

				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
			$this->redirect($this->url->link('report/transaction_status', 'token=' . $this->session->data['token'], 'SSL'));
			//$this->getList();
		}
	}

	/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected order listed on the page. Admin selects the 
						checkbox against the transactions in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction list page after deleting the transaction from the list.
*/	
  	public function delete() {
		$this->language->load('report/transaction_status');

		$this->document->setTitle($this->language->get('heading_title'));
    	$this->load->model('report/transaction_status');

    	if (isset($this->request->post['selected']) && ($this->validateDelete())) {
			foreach ($this->request->post['selected'] as $transaction) {
				$trans=split('~',$transaction);
				$this->model_report_transaction_status->deleteTransaction($trans[1],$trans[0]);
				$this->session->data['success'] =$this->language->get('text_delete_success');
			}

			$url = '';

			if (isset($this->request->get['filter_tx_id'])) {
				$filter_tx_id = $this->request->get['filter_tx_id'];
			} else {
				$filter_tx_id = '';
			}
			if (isset($this->request->get['filter_order_id'])) {
				$filter_order_id = $this->request->get['filter_order_id'];
			} else {
				$filter_order_id = '';
			}
			if (isset($this->request->get['filter_cmd_id'])) {
				$url .= '&filter_cmd_id=' . $this->request->get['filter_cmd_id'];
			}
			if (isset($this->request->get['filter_tx_id'])) {
				$url .= '&filter_tx_id=' . $this->request->get['filter_tx_id'];
			}if (isset($this->request->get['filter_order_id'])) {
				$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

				$this->redirect($this->url->link('report/transaction_status', 'token=' . $this->session->data['token'] . $url, 'SSL'));
	    }
	    $this->session->data['warning']=$this->language->get('text_delete_warning');

    	$this->getList();
  	}

/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the transaction content when deleted. 
						Checks if the deteled order is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/	
   	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'report/transaction_status')) {
			$this->error['warning'] = $this->language->get('error_permission');
    	}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Loads all the Transaction data and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the 
*/	
	function getList()
	{

		if (isset($this->request->get['filter_tx_id'])) {
			$filter_tx_id = $this->request->get['filter_tx_id'];
		} else {
			$filter_tx_id = '';
		}
		if (isset($this->request->get['filter_order_id'])) {
			$filter_order_id = $this->request->get['filter_order_id'];
		} else {
			$filter_order_id = '';
		}
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
		
		if (isset($this->request->get['filter_cmd_id'])) {
			$url .= '&filter_cmd_id=' . $this->request->get['filter_cmd_id'];
		}
		if (isset($this->request->get['filter_tx_id'])) {
			$url .= '&filter_tx_id=' . $this->request->get['filter_tx_id'];
		}if (isset($this->request->get['filter_order_id'])) {
			$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
						
		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/transaction_status', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);		
		
		$this->load->model('report/transaction_status');
		
		$this->data['transactions'] = array();
		
		$data = array(
			'filter_tx_id'	    => $filter_tx_id,
			'filter_order_id'	    => $filter_order_id,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);


		
		$affiliate_total = $this->model_report_transaction_status->getTotalTransactions($data,$this->session->data['user_id']); 
		
		$results = $this->model_report_transaction_status->getTransactions($data,$this->session->data['user_id']);
		$cmd_name=array('6'  => 'Package Subscription',
					   '10' => 'Product Subscription',
					   '18' => 'PPV Subscription',
					   '7'  => 'Package DeSubscription',
					   '19' => 'PPV DeSubscription',
					   '11' => 'Product DeSubscription'
					   );
		foreach ($results as $result) {
			$action = array();
		
			$action1 = array(
				'text' => $this->language->get('text_resend'),
				'href' => $this->url->link('report/transaction_status/resend', 'token=' . $this->session->data['token'] . '&tx_id=' . $result['tx_id']."&command_id=".$result['cmd_id']."&user_id=".$result['user_id']. $url, 'SSL')
			);
			$action2 = array(
				'text' => $this->language->get('text_disable'),
				'href' => $this->url->link('report/transaction_status/disable', 'token=' . $this->session->data['token'] .'&tx_id=' . $result['tx_id']."&command_id=".$result['cmd_id']."&user_id=".$result['user_id'] . $url, 'SSL')
			);
			$usr_name= $this->model_report_transaction_status->getUserName($result['user_id']);
			
			$prod_name= $this->model_report_transaction_status->getProductName($result['product_id']);
			//$duration=date_diff(date("Y-d-m H:i:s",strtotime($result['modify_date'])),date("Y-d-m H:i:s",strtotime($result['exp_date'])));
			$date1 = new DateTime($result['modify_date']);
			$date2 = new DateTime($result['exp_date']);

			if($date1!='' && $date2!=''){
				// $diff = $date2->getTimestamp()-$date1->getTimestamp();
				// $mins=$diff/60;
				// $hours=$mins/60;
				// $hour=$hours%24;
				// $days=$hours/24;
				// $diff=floor($days)." days ".$hour."hours";
				//$diff = $date2->diff($date2,$date1);
				$interval=$date1->diff($date2);
				if($interval->format('%a')=='0' && $interval->format('%H')=='0')
					$diff=$interval->format('--');
				else
					$diff=$interval->format('%a days %H hours %i Mins');
			}
			else{
				$diff = '';
			}
			
			$this->data['transactions'][] = array(
				'tx_id'       => $result['tx_id'],
				'order_id'    => $result['order_id'],
				'user_name'   => $usr_name["name"],
				'cmd_id'      => $result['cmd_id'],
				'cmd_name'    => $cmd_name[$result['cmd_id']],
				'product_name'=> (isset($prod_name['name'])?$prod_name['name']:''),
				'start_date'  => $result['modify_date'],
				'duration'    => ($result['cmd_id']!=7 && $result['cmd_id']!=11)? $diff : '',
				'user_id'     => $result['user_id'],
				'ack_ctr'     => ($result['ack_ctr']==1)?'ACK':'NACK',
				'selected'      => isset($this->request->post['selected']) && in_array($result['tx_id'], $this->request->post['selected']),
				'action1'     => $action1,
				'action2'     => $action2
			);
		}
		// var_dump($this->data);
		// 	exit();
		$this->data['delete'] = $this->url->link('report/transaction_status/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$result = $this->model_report_transaction_status->getUserGroupBelongs($this->session->data['user_id']);		
		$this->data['user_group_id'] = $result['user_group_id'];

 		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		
		$this->data['column_transaction_id'] = $this->language->get('column_transaction_id');
		$this->data['column_command_data'] = $this->language->get('column_command_data');
		$this->data['column_response'] = $this->language->get('column_response');
		$this->data['column_action1'] = $this->language->get('column_action1');
		$this->data['column_action2'] = $this->language->get('column_action2');
		$this->data['column_user_id'] = $this->language->get('column_user_id');
		$this->data['column_order_id'] = $this->language->get('column_order_id');
		$this->data['column_user_name'] = $this->language->get('column_user_name');
		$this->data['column_cmd_name'] = $this->language->get('column_cmd_name');
		$this->data['column_orderd_for'] = $this->language->get('column_orderd_for');
		$this->data['column_start_time'] = $this->language->get('column_start_time');
		$this->data['column_duration'] = $this->language->get('column_duration');
		$this->data['column_total'] = $this->language->get('column_total');
		$this->data['column_action'] = $this->language->get('column_action');
		
		$this->data['entry_date_start'] = $this->language->get('entry_date_start');
		$this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['entry_user_name'] = $this->language->get('entry_user_name');
		$this->data['entry_tx_id'] = $this->language->get('entry_tx_id');
		$this->data['entry_order_id'] = $this->language->get('entry_order_id');
		$this->data['entry_cmd_id'] = $this->language->get('entry_cmd_id');

		$this->data['button_filter'] = $this->language->get('button_filter');
		
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_delete'] = $this->language->get('button_delete');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}elseif (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['success'])) {
			$this->data['success'] = $this->error['success'];
		}elseif (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if (isset($this->error['warning'])) {
			$this->data['warning'] = $this->error['warning'];
		}elseif (isset($this->session->data['warning'])) {
			$this->data['warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['warning'] = '';
		}
		$url = '';
		
		$pagination = new Pagination();
		$pagination->total = $affiliate_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/transaction_status', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$this->data['filter_tx_id'] = $filter_tx_id;
		$this->data['filter_order_id'] = $filter_order_id;
		$this->template = 'report/transaction_status.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'report/transaction_status')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
}
?>