<?php 
 /*
@File customer.php(Controller)
ADMIN CUSTOMER PAGE
    This class show total authorized subscribers in the store

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerReportSubsListReport extends Controller { 
	private $error = array();
  /*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the authorized subscriber details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  authorized subscriber page
*/
  	public function index() {
		$this->language->load('report/subslistreport');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/subslistreport');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  
  	public function printPdf(){

	    if(isset($this->request->post['selected']))
	    {
		    $this->pdf->AddPage();
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    
		    $this->load->model('report/subsnetworkreport');
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_subsnetworkreport->getUserDetails($this->session->data['user_id']);
			
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(8);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(12);
			$this->pdf->SetX(65);
			$this->pdf->Cell(191,6,$user['email'],0,0,'C',0);

			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(20);
			$this->pdf->Cell(190,6,'-:  Subscriber List Report :-',1,0,'C',1);
			$this->pdf->SetY(30);

		    $w = array(10,24,64,84,104,124,169,185);
		    $c = array(14,40,20,20,20,  45,16,15);
		    $header =  array('S.No.','Customer Name','Custom No.','Mobile','Reg. Date','Address','Status','Pay/Free');
			
			
		    for( $i = 0; $i < count($header) ; $i++){
			  if($i==0)
		    	$this->pdf->SetX($w[0]);
		      else
			   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
			 
			   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			
	        $this->load->model('report/customer');
	        $this->load->model('report/subslistreport');
		   	$i=0;
	        $count=0;
		    if (isset($this->request->post['selected']))
			{
		      foreach ($this->request->post['selected'] as $customer) {
		      	$customer_id=substr($customer,0,strpos($customer,'~'));
	      		$sl_no=substr($customer,strpos($customer,'~')+1);
		        $results = $this->model_report_subslistreport->getCustomer($customer_id);
		        
		    foreach($results as $result){
		    	$hw = $this->model_report_customer->getStbHw($result['STBNO']);
		    	$date=date("d/m/y",strtotime($result['date_added']));
		    	$type=($result["STBNO"]?'Active':'DeActive');
				$data[] = array($sl_no,$result['name'],$result['SCNO'],$result["telephone"],$date,$result["address"],$type,"paid");
		     $count++;
	        }
	        }
	       }

		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
		        
			for ($i=0; $i < $count ; $i++) { 
		 	  for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'L',0);
		    $this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		 
		    $this->pdf->Output();
		}else{
			$this->language->load('report/subslistreport');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] ="Please Select item to print PDF";
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the authorized subscribers details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/    
  	protected function getList() {	

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/subslistreport', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		
		$this->data['customers'] = array();

		
		$this->load->model('report/subslistreport');
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_subslistreport->getTotalAuthSubs();
		$results = $this->model_report_subslistreport->getCustomers($data);
 			
 			$i=0;
    	foreach ($results as $result) {
    		$hw = $this->model_report_subslistreport->getStbHw($result['STBNO']);
			$i=$i+1;
			$this->data['customers'][] = array(
				'customer_id'    => $result['customer_id'],
				'customer_no'    =>($page - 1) * $this->config->get('config_admin_limit')+$i,
				'custom'         => $result['SCNO'],
				'telephone'      => $result["telephone"],
				'name'           => $result['name'],
				'address'        => $result['address_1'],
				'date_added'     => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'status'         => ($result['STBNO']?'Active':'DeActive'),
				'pay'            => 'paid',
				'balance'        => '-- --',
				'selected'       => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);
		}	
					
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');	
		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_default'] = $this->language->get('text_default');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_caf'] = $this->language->get('column_caf');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_pay'] = $this->language->get('column_pay');
		$this->data['column_balance'] = $this->language->get('column_balance');
		$this->data['printPdf'] = $this->url->link('report/subslistreport/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$url = '';

		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/subslistreport', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
		
		$this->data['sort_name'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
	    $this->data['sort_stbno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=STBNO' . $url, 'SSL');
		$this->data['sort_casno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=CASNO' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';
		
		$this->template = 'report/subslistreport.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
}
?>