<?php 
  /*
@File pkgwisechannellist.php(Controller)
ADMIN pkgwisechannellist PAGE
    This class show all the A la carte wise Active Conn to it.

@Author Ravi Ranjan
@date 20th Nov. 2015
*/
class ControllerReportProductWiseSubscriberList extends Controller {

public function index() {

		$this->language->load('report/product_wise_subscriber_list');
		 
		$this->document->setTitle($this->language->get('heading_title'));
	
		$this->load->model('report/product_wise_subscriber_list');

		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		if(isset($this->request->post['selected']))
		{
			$this->load->model('report/product_wise_subscriber_list');
		    $this->pdf->AddPage();
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,15,50);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_product_wise_subscriber_list->getUserDetails($this->session->data['user_id']);
		   
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(15);
			$this->pdf->SetX(50);
			$this->pdf->Cell(225,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(18);
			$this->pdf->SetX(50);
			$this->pdf->Cell(227,6,$user['email'],0,0,'C',0);
			
			$this->pdf->SetY(30);
			$this->pdf->SetX(10);
			$this->pdf->Cell(192,6,'-: Product Wise Subscription List Report :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(40);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
		    $w = array(10,25,55,75,87,102,124,146,168,185);
		    $c = array(15,30,20,12,15, 22, 22, 22, 17,17);
		    $header =  array('Customer ID','Customer Name','Area','Bill/Type','Type','Start Time','End Time','STB NO','Days Used','Month Used');
			
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],8,$header[$i],1,0,'L',1);
		    }
			$this->load->model('report/prdsummary');    
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=0;
	      	foreach ($this->request->post['selected'] as $oredr) {
	      		$customer_id=substr($oredr,0,strpos($oredr,'~'));
	      		$product_id=substr($oredr,strpos($oredr,'~')+1);
	      		$filter_data=array('filter_package' => $product_id);
	      		$results = $this->model_report_product_wise_subscriber_list->getChannelListDetails($filter_data);
	      		$res = $this->model_report_product_wise_subscriber_list->getCustomerDetails($customer_id);
				$area = $this->model_report_product_wise_subscriber_list->getCustomerArea($customer_id);
				if($area)
					$address_1=$area[0]['address_1'];
				else
					$address_1='NULL';
				foreach ($res as $value) {
					$name=($value['firstname'].' '.$value['lastname']);
					$now=date("Y/m/d") ;
					$date2=new DateTime($now);
					$date1=new DateTime($results[0]['start_date']);
				 	$interval=$date1->diff($date2);
					if($interval->format('%a')=='0' && $interval->format('%H')=='0'){
						$day_used=$interval->format('--');
						$month_used=$interval->format('--');
					}
					else{
						$day_used=$interval->format('%a days');
						$month_used=$interval->format('%m month');
					}
					$data[] = array($customer_id,$name,$address_1,'COD',($value["STBNO"] AND strtotime($results[0]['expire_date']) > time())?'Active':'De Active',date('d-m-Y H:i',strtotime($results[0]['start_date'])),date('d-m-Y H:i',strtotime($results[0]['expire_date'])),$value["STBNO"],$day_used,$month_used);
			     	$count++;
		     	}
        	}  	
			for ($i=0; $i < $count ; $i++) {
				$this->pdf->SetX(10); 
			 	for($j=0; $j < count($header) ; $j++)
			 	{
			 	  	$this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'L',0);
			    }   
			    $this->pdf->Ln();
		    }            
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('report/product_wise_subscriber_list');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/product_wise_subscriber_list');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_package'])) {
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] ='';
		}
		
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/product_wise_subscriber_list', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_package'])) {
			$data['filter_package']=$this->request->get['filter_package'];
			$this->data['filter_package'] = $this->request->get['filter_package'];
			$url.='&filter_package='.$this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] = '';
		}
		$total = 0;
		$this->data['channels'] = array();
		$resultPkgs = $this->model_report_product_wise_subscriber_list->getProducts();
		foreach ($resultPkgs as $package) {
			$this->data['packages'][] = array(
				'package_name' =>$package['name'],
				'package_id' =>$package['product_id'],
				);
		}
		if($this->data['filter_package']!='')
		{
			$data['filter_package']=$this->data['filter_package'];
			$total = $this->model_report_product_wise_subscriber_list->getChannelListCount($data);
			// var_dump($totals);exit();
			$results = $this->model_report_product_wise_subscriber_list->getChannelListDetails($data);
			foreach ($results as $result) {	
				$res = $this->model_report_product_wise_subscriber_list->getCustomerDetails($result["customer_id"]);
				$area = $this->model_report_product_wise_subscriber_list->getCustomerArea($result["customer_id"]);
				foreach ($res as $value) {
					$name=($value['firstname'].' '.$value['lastname']);
					$stb=$value["STBNO"];
					$mob=$value["telephone"];
				}
				$date=new DateTime($result["start_date"]);
				$now=new DateTime();
				$interval=$date->diff($now);
				if($interval->format('%a')=='0' && $interval->format('%H')=='0'){
						$day_used=$interval->format('--');
						$month_used=$interval->format('--');
					}
					else{
						$day_used=$interval->format('%a days');
						$month_used=$interval->format('%m month');
					}
				$day=($result["expire_date"]-$result["start_date"]);
				$this->data['channels'][] = array(
				'customer_id'  	=> $result['customer_id'],
				'product_id'	=> $result['product_id'],
				'name' 			=> $name,
				'Area' 			=> $area[0]['address_1'],
				'Bill_type' 	=> 'cash on delivery',
				'type' 			=> (($stb AND strtotime($result["expire_date"]) > time()) ?'Activate':'DeActivate'),
				'package' 		=> '-- --',
				'start'			=> date('d-m-Y H:i',strtotime($result["start_date"])),
			    'end' 			=> date('d-m-Y H:i',strtotime($result["expire_date"])),
				'stb' 			=> $stb,
				// 'cas' 		=> $cas,				
				'month' 		=> $month_used,
				'day'        	=> $day_used,
				'selected'      => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
				);										
			}
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_ch_name'] = $this->language->get('column_ch_name');
		$this->data['column_area'] = $this->language->get('column_area');
		$this->data['column_bill'] = $this->language->get('column_bill');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_package'] = $this->language->get('column_package');
		$this->data['column_start'] = $this->language->get('column_start');
		$this->data['column_end'] = $this->language->get('column_end');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_cas'] = $this->language->get('column_cas');
		$this->data['column_month'] = $this->language->get('column_month');
		$this->data['column_yearly'] = $this->language->get('column_yearly');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');
		$this->data['column_day'] = $this->language->get('column_day');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/product_wise_subscriber_list/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/product_wise_subscriber_list', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/product_wise_subscriber_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
