<?php
/*
@File package_activation_deactivation_history.php(Controller)
ADMIN package_activation_deactivation_history PAGE
    This class show Subscription made by the customer date wise.

@Author Mahesh Yallure 
@date 23rd Nov. 2015
*/
class ControllerReportPackageActivationDeactivationHistory extends Controller { 
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
public function index() {

		$this->language->load('report/package_activation_deactivation_history');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/package_activation_deactivation_history');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		if(isset($this->request->post['selected']))
		{
			$this->load->model('report/package_activation_deactivation_history');
		    $this->pdf->AddPage('P',array(220,220));
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,7,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_package_activation_deactivation_history->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(15);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(12);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);
			
			$this->pdf->SetY(17);
			$this->pdf->SetX(5);
			$this->pdf->Cell(197,6,'-: Package Activation/Deactivation History :-',1,0,'C',1);
			$this->pdf->SetY(25);
		    $w = array(5,35,65,83,93,120,147,174,186);
		    $c = array(30,30,18,10,27, 27, 27, 12, 17);
		    $header =  array('Transaction ID','Send Time','Particulars','Type','STBNo','Start Date','End Date','Status','Package No');//,'OpeningVC','ActiveVC','DeActiveVC','ClosingVC');
			for( $i = 0; $i < count($header) ; $i++){
				if($i==0)
			    	$this->pdf->SetX($w[0]);
			    else
					$this->pdf->SetX($w[$i-1]+$c[$i-1]);
				$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}
	        $count=0;
	        if (isset($this->request->post['selected']))
			{
	      	foreach ($this->request->post['selected'] as $subscriptions) {
	      		$subs=explode('~', $subscriptions);
	      		$subscriptions = $this->model_report_package_activation_deactivation_history->getPkgSubscriptionDetail($subs['0'],$subs['1'],$subs['2']);
				 // var_dump($subscriptions);exit();
				foreach ($subscriptions as $sub) {
					$start_time=date('d-m-y H:i',strtotime($sub['modify_date']));
					$end_time=date('d-m-y H:i',strtotime($sub['exp_date']));
					$data[] = array($sub['id'],$sub['modify_date'],$sub['name'],'NA',$sub['stb_no'],$start_time,$end_time,($sub['exp_date']<(date('Y-m-d H:i:s')))?'Expired':'Active',$sub['model']);
			    	$count++; 	
				}

        	}
        	}  
	        $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
			for ($i=0; $i < $count ; $i++) { 
			  	$this->pdf->SetX(5);
		 	 	for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'L',0);
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('report/package_activation_deactivation_history');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/package_activation_deactivation_history');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/package_activation_deactivation_history', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$total=0;
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total=$this->model_report_package_activation_deactivation_history->getPkgSubscriptionCount($data);
		// var_dump($total);exit();
		$subscriptions = $this->model_report_package_activation_deactivation_history->getPkgSubscriptionDetails($data);
		// var_dump($subscriptions);exit();
		$this->data['subscriptions'] = array();
		// $total=19;//count($subscriptions);
		foreach ($subscriptions as $sub) {

			$this->data['subscriptions'][] = array(
			'id'			=> $sub['id'],
			'customer_id'  		=> $sub['user_id'],
			'product_id' 		=> $sub['product_id'],
			'send_time' 		=> $sub['modify_date'],
			'particulars' 		=> $sub['name'],
			'type' 		    	=> 'NA',
			'stbno'			    => $sub['stb_no'],
			// 'vcno'            	=> ($sub['smart_card_no']!=-1)?$sub['smart_card_no']:'-- --',
			'start_date' 		=> date('d-m-y H:i',strtotime($sub['modify_date'])),
			'end_date' 			=> date('d-m-y H:i',strtotime($sub['exp_date'])),
			'status' 			=> ($sub['exp_date']<(date('Y-m-d H:i:s')))?'Expired':'Active',
			'packageno' 		=> $sub['model'],
			'total'        		=> $total,
			'selected'      	=> isset($this->request->post['selected']) && in_array($sub['user_id'], $this->request->post['selected']),
			);					
			
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_sendtime'] = $this->language->get('column_sendtime');
		$this->data['column_particulars'] = $this->language->get('column_particulars');
		$this->data['column_type'] = $this->language->get('column_type');
    	$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_vcno'] = $this->language->get('column_vcno');
		$this->data['column_start_date'] = $this->language->get('column_start_date');
		$this->data['column_end_date'] = $this->language->get('column_end_date');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_serviceid'] = $this->language->get('column_serviceid');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/package_activation_deactivation_history/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/package_activation_deactivation_history', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		// $pagination->url = $this->url->link('report/package_activation_deactivation_history', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
	
		$this->template = 'report/package_activation_deactivation_history.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
}
?>
