<?php 
  /*
@File daily_active_stbvc.php(Controller)
ADMIN daily_active_stbvc PAGE
    This class show all the A la carte wise Active Conn to it.

@Author MAHESH YALLURE
@date 20th Nov. 2015
*/
class ControllerReportDailyActiveStbvc extends Controller {

public function index() {

		$this->language->load('report/daily_active_stbvc');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/daily_active_stbvc');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		$this->language->load('report/daily_active_stbvc');
		$this->load->model('report/daily_active_stbvc');
		if (isset($this->request->post['selected']))
		{
		    $this->pdf->AddPage();
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);    
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_daily_active_stbvc->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(30);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);			
			$this->pdf->SetY(40);
			$this->pdf->SetX(10);
			$this->pdf->Cell(190,6,'-: Daily Summary of Active STB VC :-',1,0,'C',1);
			$this->pdf->SetY(55);
		    $w = array(40, 80,120);
		    $c = array(40, 40,40);
		    $header =  array('Date','STB Count','VC Count');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=0;
	      	foreach ($this->request->post['selected'] as $date) {
	      		$data['filter_date'] =$date;
	      		$resultsStb = $this->model_report_daily_active_stbvc->getDailyActiveStbCount($data);
				$resultsSc = $this->model_report_daily_active_stbvc->getDailyActiveSCCount($data);
	      		if ($resultsStb['stb_count'] || $resultsSc['sc_count']) {	
					$data[] = array($date,$resultsStb['stb_count'],$resultsSc['sc_count']);
			     	$count++;
		     	}
        	}      
	        $this->pdf->SetX(40);
			for ($i=0; $i < $count ; $i++) {
			$this->pdf->SetX(40); 
		 	  	for($j=0; $j < count($header) ; $j++)
		 	  	{
		 	  		$this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'L',0);
		      	}   
		    	$this->pdf->Ln();
		    }            
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(120,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(120,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/daily_active_stbvc', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_date'])) {
			$data['filter_date']=$this->request->get['filter_date'];
			$this->data['filter_date'] = $this->request->get['filter_date'];
			if(strtotime($data['filter_date'])>strtotime(date('d-m-Y H:i')))
				$this->data['error_warning']='Filter date is grater than current date !';
		} else {
			$this->data['filter_date'] = '';
		}
		$total = 1;
		$this->data['channels'] = array();
		if(!isset($this->data['error_warning']))
		{
			$resultsStb = $this->model_report_daily_active_stbvc->getDailyActiveStbCount($data);
			$resultsSc = $this->model_report_daily_active_stbvc->getDailyActiveSCCount($data);

			if ($resultsStb['stb_count'] || $resultsSc['sc_count']) {			
				$this->data['channels'][] = array(
					'date' => ($this->data['filter_date']!='')?$this->data['filter_date']:date('Y-m-d H:i:s'),
					'stb_count' => $resultsStb['stb_count'],
					'vc_count'    => $resultsSc['sc_count'],
					'total'        => $total,
					'selected'       => isset($this->request->post['selected']) && in_array($this->data['filter_date'], $this->request->post['selected']),
				);	
			}
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_stb_count'] = $this->language->get('column_stb_count');
		$this->data['column_vc_count'] = $this->language->get('column_vc_count');
		$this->data['entry_date'] = $this->language->get('entry_date');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/daily_active_stbvc/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/daily_active_stbvc', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->template = 'report/daily_active_stbvc.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('report/daily_active_stbvc');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && $this->validateDate()){
			
			
		 }
		$this->getList();
	}
/*
FUNCTION NAME 		-	validateDate
DESCRIPTION 		-	validates the filter dates given to filter.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/	
	public function validateDate(){
		if(!isset($this->request->get['filter_date']))
		{
			$this->data['error_start'] = $this->language->get('error_startdate_req');;
		}
		else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date']))
    	{
        		$this->data['error_start'] = $this->language->get('error_date_format');
        }
		
	
	if (!$this->data) {
	  		return true;
		} else {
	  		return false;
		}

	}

}
?> 
