<?php
 /*
@File customer_order.php(Controller)
ADMIN CUSTOMER_ORDER PAGE
    This class show all the customer orders from the store

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportCustomerOrder extends Controller {

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the sale order details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the sale order  page
*/	
	public function index() {  
		$this->language->load('report/customer_order');

		$this->document->setTitle($this->language->get('heading_title'));
		$this->getList();
	}	
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the customer orders and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer orders page
*/	
	public function getList() {     
		$this->language->load('report/customer_order');

		$this->document->setTitle($this->language->get('heading_title'));

		if(isset($this->data['error_start']))
			$this->data['error_filter_date_start']=$this->data['error_start'];
		else
			$this->data['error_filter_date_start']='';

		if(isset($this->data['error_end']))
			$this->data['error_filter_date_end']=$this->data['error_end'];
		else
			$this->data['error_filter_date_end']='';
		
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}	
				
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
						
		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/customer_order', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);		
		$this->data['error_warning']='';
		$this->load->model('report/customer');
		
		$this->data['customers'] = array();
		$error_encounter=0;
		$customer_total=0;
		if(isset($this->request->get['filter_date_start']) || isset($this->request->get['filter_date_end']))
		{
			if(!isset($this->request->get['filter_date_start']))
			{
				$this->data['error_start'] = $this->language->get('error_startdate_req');
				// $this->data['error_warning']='Please enter Start date!';
				$error_encounter=1;
			}
			else if(!isset($this->request->get['filter_date_end']))
			{
				// $this->data['error_warning']='Please enter end date!';
				$this->data['error_end'] = $this->language->get('error_enddate_req');
				$error_encounter=1;
			}
			else
			if(strtotime($this->request->get['filter_date_start'])>strtotime($this->request->get['filter_date_end']))
			{
				$this->data['error_warning']='Start date is greater than End date!';
				$error_encounter=1;
			}else{
				$error_encounter=0;
			}
		}
		if(!$error_encounter)
		{
			$data = array(
			'filter_date_start'	     => $filter_date_start, 
			'filter_date_end'	     => $filter_date_end, 
			'filter_order_status_id' => $filter_order_status_id,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
			);

			$customer_total = $this->model_report_customer->getTotalOrders($data,$this->session->data['user_id']); 
			
			$results = $this->model_report_customer->getOrders($data,$this->session->data['user_id']);
			
			foreach ($results as $result) {
				$action = array();
			
				$action[] = array(
					'text' => $this->language->get('text_edit'),
					'href' => $this->url->link('sale/customer/update', 'token=' . $this->session->data['token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL')
				);
							
				$this->data['customers'][] = array(
					'customer_id'	 => $result['customer_id'],	
					'customer'       => $result['customer'],
					'email'          => $result['email'],
					'customer_group' => $result['customer_group'],
					'status'         => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
					'orders'         => $result['orders'],
					'products'       => $result['products'],
					'total'          => $this->currency->format($result['total'], $this->config->get('config_currency')),
					'action'         => $action
				);
			}
		 
		}
 		$this->data['heading_title'] = $this->language->get('heading_title');
		 
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_all_status'] = $this->language->get('text_all_status');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_customer'] = $this->language->get('column_customer');
		$this->data['column_email'] = $this->language->get('column_email');
		$this->data['column_customer_group'] = $this->language->get('column_customer_group');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_orders'] = $this->language->get('column_orders');
		$this->data['column_products'] = $this->language->get('column_products');
		$this->data['column_total'] = $this->language->get('column_total');
		$this->data['column_action'] = $this->language->get('column_action');
		
		$this->data['entry_date_start'] = $this->language->get('entry_date_start');
		$this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['entry_status'] = $this->language->get('entry_status');

		$this->data['button_filter'] = $this->language->get('button_filter');
		
		$this->data['token'] = $this->session->data['token'];
		
		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
			
		$url = '';
						
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $customer_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/customer_order', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$this->data['filter_date_start'] = $filter_date_start;
		$this->data['filter_date_end'] = $filter_date_end;		
		$this->data['filter_order_status_id'] = $filter_order_status_id;
				 
		$this->template = 'report/customer_order.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('report/customer_order');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && $this->validateDate()){
		 }
		$this->getList();
	}
	/*
FUNCTION NAME 		-	validateDate
DESCRIPTION 		-	validates the filter dates given to filter.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/	
	public function validateDate(){
		if(!isset($this->request->get['filter_date_start']))
		{
			$this->data['error_start'] = $this->language->get('error_startdate_req');;
		}
		else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_start']))
    	{
        		$this->data['error_start'] = $this->language->get('error_date_format');
        }
		if(!isset($this->request->get['filter_date_end']))
		{
			$this->data['error_end'] = $this->language->get('error_enddate_req');
		}
		else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_end']))
    			{
        			$this->data['error_end'] = $this->language->get('error_date_format');
        		}
	if (!$this->data) {
	  		return true;
		} else {
	  		return false;
		}

	}

}
?>
