<?php 
ini_set("memory_limit", "-1");
ini_set('max_execution_time', '-1');
class ControllerReportAuditReports extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('report/audit_reports');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('report/audit_reports');
    	$this->getList();
  	}
  	
  	public function getList() {	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/audit_reports', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['generate_report'] = $this->url->link('report/audit_reports/generate', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['heading_title']   = $this->language->get('heading_title');
		$this->data['column_date'] 	   = $this->language->get('column_date');
		$this->data['column_generated_by'] = $this->language->get('column_generated_by');
		$this->data['column_status']   = $this->language->get('column_status');
		$this->data['column_link']     = $this->language->get('column_link');
		$this->data['button_generate'] = $this->language->get('button_generate');
		
		if(isset($this->request->get['filter_year']))
			$this->data['filter_year']	= $this->request->get['filter_year'];
		else
			$this->data['filter_year']=-1;

		$this->data['reports'] = array();
		$this->data['broadcasters'] = $this->model_report_audit_reports->getBroadcasters();
		$this->data['process_count'] = $this->model_report_audit_reports->getTotalRunningProcess();
		$generatelist = $this->model_report_audit_reports->getGeneratedReportsList();
		foreach ($generatelist as  $reports) {
			$this->data['reports'][] = array(
					'id' => $reports['id'],
					'generated_date'=> $reports['generated_date'],			
					'generated_by'=> $reports['generated_by'],			
					'status'=> $reports['status'],
					'download_status'=> $reports['download_status'],
					'download_url'	=> HTTP_SERVER."/".$reports['download_url']
				);
		}
		
		$this->data['token'] = $this->session->data['token'];
		$this->data['user_id'] = $this->session->data['user_id'];
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';
		$pagination = new Pagination();
		$pagination->total = count($generatelist);
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/audit_reports', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$this->template = 'report/audit_reports.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

  	function generate(){
  		$this->language->load('report/audit_reports');
		$this->document->setTitle($this->language->get('heading_title'));
  		$this->load->model('report/audit_reports');
		$this->model_report_audit_reports->getListsReports();
		$this->getList();
  		
		
	}
	
  	
}
