<?php 
  /*
@File alacartewise_activeconnection_summary.php(Controller)
ADMIN alacartewise_activeconnection PAGE
    This class show all the A la carte wise Active Conn Summary to it.

@Author MAHESH YALLURE
@date 20th Nov. 2015
*/
class ControllerReportAlacarteWiseActiveconnectionSummary extends Controller {

public function index() {

		$this->language->load('report/alacartewise_activeconnection_summary');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/alacartewise_activeconnection_summary');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		if (isset($this->request->post['selected']))
		{
			$this->load->model('report/alacartewise_activeconnection_summary');
		    $this->pdf->AddPage();
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_alacartewise_activeconnection_summary->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(30);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);	
			$this->pdf->SetY(40);
			$this->pdf->SetX(10);
			$this->pdf->Cell(192,6,'-: Ala Carte Wise Active Connection Summary:-',1,0,'C',1);
			$this->pdf->SetY(55);
		    $w = array(10,37,85,100,120,148,176,187);
		    $c = array(27,48,15,20, 28, 28, 11, 15);
		    $header =  array('Send Time','Particulars','Type','STB NO','Start Date','End Date','Status','Service Id');
			for( $i = 0; $i < count($header) ; $i++){
				if($i==0)
			    	$this->pdf->SetX($w[0]);
			    else
					$this->pdf->SetX($w[$i-1]+$c[$i-1]);
					$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}
			$this->load->model('report/alacartewise_activeconnection_summary');    
	        $count=0;
		    if (isset($this->request->post['selected']))
			{
		      	foreach ($this->request->post['selected'] as $product_id) {
		      		$results=$this->model_report_alacartewise_activeconnection_summary->getAlacarte($product_id);  
			    	foreach($results as $result){
			    		$type=($result['cmd_id']==10)? 'Active':'DeActive';
			    		$start_date=date('d-m-Y H:i',strtotime($result['modify_date']));
			    		$end_date=date('d-m-Y H:i',strtotime($result['exp_date']));
						$data[] = array($result['modify_date'],$result['name'],$type,$result['current_stbno'],$start_date,$end_date,($result['status']==1)?'Enable':'Disable',$result['service_id']);
				     	$count++;
		        	}
	        	}
	        }  
	        $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);		
			for ($i=0; $i < $count ; $i++) { 
			  	//$this->pdf->SetX(5);
		 	 	for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'L',0);
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('report/alacartewise_activeconnection_summary');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/alacartewise_activeconnection_summary');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/alacartewise_activeconnection_summary', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_alacartewise_activeconnection_summary->getTotalAlaCarteWiseActiveConn();
		$this->data['channels'] = array();
		$results = $this->model_report_alacartewise_activeconnection_summary->getAlacarteWiseActiveConn($data);
		foreach ($results as $result) {			
			$this->data['channels'][] = array(
				'tx_id'  		=> $result['tx_id'],
				'product_id'  	=> $result['product_id'],
				'modify_date' 	=> date('d-m-Y H:i',strtotime($result['modify_date']	)),
				'name' 			=> $result['name'],
				'pname' 			=> $result['pname'],
				'type' 			=> ($result['cmd_id']==10)?'Subscription':'De-Subscription',
				'stbno' 		=> $result['current_stbno'],
				// 'casno' 		=> $result['current_casno'],
				'exp_date' 		=> date('d-m-Y H:i',strtotime($result['exp_date'])),				
				'service_id' 	=> $result['service_id'],
				'total'        	=> $total,
				'selected'      => isset($this->request->post['selected']) && in_array($result['tx_id'], $this->request->post['selected']),
			);	
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_send_time'] = $this->language->get('column_send_time');
		$this->data['column_particulars'] = $this->language->get('column_particulars');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_vcno'] = $this->language->get('column_vcno');
		$this->data['column_start_date'] = $this->language->get('column_start_date');
		$this->data['column_end_date'] = $this->language->get('column_end_date');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_service_id'] = $this->language->get('column_service_id');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/alacartewise_activeconnection_summary/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/alacartewise_activeconnection_summary', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/alacartewise_activeconnection_summary.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 