<?php    
/*
@File customer_ban_ip.php(Controller)
ADMIN CUSTOMER_BAN_IP PAGE
    This class manages the customer_ban_ip by inserting/deleting/updating for the store

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerPairingRelease extends Controller { 
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer_ban_ip option in the dopdown list.
						It get all the customer_ban_ip list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip page showing all the customer_ban_ip in a list.
*/  
  	public function index() {
		$this->language->load('pairing/release');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('pairing/release');
		
    	$this->getForm();
  	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
		$this->language->load('pairing/release');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('pairing/release');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
       	  	$temp = $this->model_pairing_release->UnPair($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success').$temp;
		  
			$url = '';
							
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('pairing/release', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    	
     	$this->getForm();
  	} 

/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['text_customer_name'] = $this->language->get('text_customer_name');
    	$this->data['text_stb_no'] = $this->language->get('text_stb_no');
    	$this->data['text_cas_no'] = $this->language->get('text_cas_no');
 
		$this->data['button_save'] = $this->language->get('button_unpair');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = '';
		}

	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$url = '';
		
	
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('pairing/release', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = $this->url->link('pairing/release/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		  
    	$this->data['cancel'] = $this->url->link('pairing/release', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	
			
    	if (isset($this->request->post['name'])) {
      		$this->data['name'] = $this->request->post['name'];
		} else {
      		$this->data['name'] = '';
    	}

		
		$this->template = 'pairing/release.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'sale/customer_ban_ip')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

    	if ($this->request->post['name']=='') {
      		$this->error['name'] = $this->language->get('error_name');
    	}

		
		    	
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    

}
?>