<?php   
/*
@File home.php(Controller)
ADMIN PAIRING STB CAS HOME  PAGE
    This class manages the link between the stb number, cas number and the 
    customer id. Here we can create a new link as well as delete the existing 
    link also to release the stb and cas numbers to make it available.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerPairingHome extends Controller { 
	private $error = array();  
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the pairing details page with all the details regarding 
						stb number, cas number and customer.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin review page showing all the reviews in a list.
*/	
	public function index() {
    	$this->language->load('pairing/home');
	 
		$this->document->setTitle($this->language->get('heading_title'));
    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->getList();
	}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the description regarding the stb number availability, 
						cas number availability and the links created between the customer id,
						stb,cas numbers.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the pairing detail page
*/		
	public function getList(){
		$this->data['text_stb_details'] = $this->language->get('text_stb_details');
		$this->data['text_cas_details'] = $this->language->get('text_cas_details');
		$this->data['text_stb_cas_cust_pair'] = $this->language->get('text_stb_cas_cust_pair');
		$this->data['text_remove_stb_cas_pair'] = $this->language->get('text_remove_stb_cas_pair');
		$this->data['text_create_stb_cas_pair'] = $this->language->get('text_create_stb_cas_pair');
		$this->data['text_customer_id'] = $this->language->get('text_customer_id');
		$this->data['text_stb_no'] = $this->language->get('text_stb_no');
		$this->data['text_cas_no'] = $this->language->get('text_cas_no');

		$this->data['column_stb_no'] = $this->language->get('column_stb_no');
		$this->data['column_availability'] = $this->language->get('column_availability');
		$this->data['column_buildin_smartcard'] = $this->language->get('column_buildin_smartcard');
		$this->data['column_cas_no'] = $this->language->get('column_cas_no');
		$this->data['column_customer_id'] = $this->language->get('column_customer_id');
		$this->data['column_current_stb_no'] = $this->language->get('column_current_stb_no');
		$this->data['column_current_cas_no'] = $this->language->get('column_current_cas_no');
		$this->data['column_previous_stb_no'] = $this->language->get('column_previous_stb_no');
		$this->data['column_previous_cas_no'] = $this->language->get('column_previous_cas_no');

		$this->data['entry_range'] = $this->language->get('entry_range');
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if(isset($this->error['warning'])){
			$this->data['warning'] = $this->error['warning'];
		}
		else{
			$this->data['warning'] = '';
		}

		if (isset($this->error['error_customer_id'])) {
			$this->data['error_customer_id'] = $this->error['error_customer_id'];
		} else {
			$this->data['error_customer_id'] = '';
		}

		if (isset($this->error['error_rm_customer_id'])) {
			$this->data['error_rm_customer_id'] = $this->error['error_rm_customer_id'];
		} else {
			$this->data['error_rm_customer_id'] = '';
		}


		if (isset($this->error['error_stb_no'])) {
			$this->data['error_stb_no'] = $this->error['error_stb_no'];
		} else {
			$this->data['error_stb_no'] = '';
		}
		if (isset($this->error['error_cas_no'])) {
			$this->data['error_cas_no'] = $this->error['error_cas_no'];
		} else {
			$this->data['error_cas_no'] = '';
		}

		
		// Check cache directory is writable
		$file = DIR_CACHE . 'test';
		
		$handle = fopen($file, 'a+'); 
		
		fwrite($handle, '');
			
		fclose($handle); 		
		
		if (!file_exists($file)) {
			$this->data['error_cache'] = sprintf($this->language->get('error_image_cache'). DIR_CACHE);
		} else {
			$this->data['error_cache'] = '';
			
			unlink($file);
		}
		
		// Check logs directory is writable
		$file = DIR_LOGS . 'test';
		
		$handle = fopen($file, 'a+'); 
		
		fwrite($handle, '');
			
		fclose($handle); 		
		
		if (!file_exists($file)) {
			$this->data['error_logs'] = sprintf($this->language->get('error_logs'). DIR_LOGS);
		} else {
			$this->data['error_logs'] = '';
			
			unlink($file);
		}
										
		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_link'),
			'href'      => $this->url->link('pairing/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['token'] = $this->session->data['token'];
		
		//if (!isset($this->request->post['cust_id'])) {
		//	$this->data['action'] = $this->url->link('catalog/package/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		//} else {
			$this->data['action'] = $this->url->link('pairing/home/removeCustomerBond', 'token=' . $this->session->data['token'] , 'SSL');
			$this->data['action2'] = $this->url->link('pairing/home/setBond', 'token=' . $this->session->data['token'] , 'SSL');
		//}
	 	$this->load->model('json/feed');
				
	 	if(!file_exists(DIR_JSON."STBCAS/stb.json")){
	 		$this->model_json_feed->CreateSTBFeed();
	 	}
	        $string = file_get_contents(DIR_JSON."STBCAS/stb.json");
	        $js_a=json_decode($string,true);
			foreach($js_a as $j)
	        { 
	            foreach ($j as $key => $value) {
	        	    $this->data['stb'][$key]=array(
	              		'is_avail' => $value['is_avail'],
	              		'is_smart_card' => $value['is_smart_card']
	              	);
	            }
	        }

    	if(!file_exists(DIR_JSON."STBCAS/cas.json")){
    		$this->model_json_feed->CreateCASFeed();
    	}
    	    $string = file_get_contents(DIR_JSON."STBCAS/cas.json");
	        $js_b=json_decode($string,true);
	        foreach($js_b as $j)
	        { 
	            foreach ($j as $key => $value) {
	        	    $this->data['cas'][$key]=array(
	              		'is_avail' => $value['is_avail'],
	              		'is_smart_card' => $value['is_smart_card']
	              	);
	            }
	        }
	    
    	if(!file_exists(DIR_JSON."STBCAS/cust_stb_cas.json")){
    		$this->model_json_feed->CreateBondFeed();
    	}
	        $string = file_get_contents(DIR_JSON."STBCAS/cust_stb_cas.json");
	        $js_c=json_decode($string,true);
	        foreach($js_c as $j)
	        { 
	          foreach ($j as $key => $value) {
	    		$this->data['pairing'][$key]=array(
	              		'current_stbno' => $value['current_stbno'],
	              		'current_casno' => $value['current_casno'],
	              		'prev_stbno' => $value['prev_stbno'],
	              		'prev_casno' => $value['prev_casno'],
	              	);
	            }
	        }
	    
	    $this->load->model("pairing/home");
	    $cust_with_bond = $this->model_pairing_home->getCustomerIdHavingBond();
	    foreach ($cust_with_bond->rows as  $child) {
	    	$this->data['cust_with_bond'][]=$child['customer_id']." ( ".$child['fname']." ".$child['lname']." )";;
	    }

	    $cust_without_bond = $this->model_pairing_home->getCustomerIdHavingNoBond();
	    foreach ($cust_without_bond->rows as  $child) {
	    	$this->data['cust_without_bond'][]=$child['customer_id']." ( ".$child['fname']." ".$child['lname']." )";
	    }

	    $avail_stb = $this->model_pairing_home->getAvailableSTB();
	    foreach ($avail_stb->rows as  $child) {
	    	$this->data['avail_stb'][]=array($child['stb_id']);
	    }

	    $avail_cas = $this->model_pairing_home->getAvailableCAS();
	    foreach ($avail_cas->rows as  $child) {
	    	$this->data['avail_cas'][]=array($child['cas_id']);
	    }

		if ($this->config->get('config_currency_auto')) {
			$this->load->model('localisation/currency');
		
			$this->model_localisation_currency->updateCurrencies();
		}
		
		$this->template = 'pairing/home.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	removeCustomerBond
DESCRIPTION 		-	This function removes the bond and make the stb and cas number
						available to bond with other customers. It also updates the json 
						for the respective details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the pairing detail page after making changes.
*/	
	public function removeCustomerBond(){
		$File = DIR_LOGFILE."create_remove_bond.log"; 
		$Handle = fopen($File,"a+");

		$this->language->load('pairing/home');
		$this->document->setTitle($this->language->get('heading_title'));
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateCustomerBond()) {
    		$this->load->model('pairing/home');
    		//$this->session->data['success'] = $this->language->get('text_success');
    		$cust_id = explode('(', $this->request->post['cust_id']);
    		$customerPair = $this->model_pairing_home->getCustomerPair(trim($cust_id[0]));
    		if($customerPair['customer_id']=='')
    			$this->session->data['success'] = "CUSTOMER IS NOT REGISTERED";
    		else if($customerPair['current_stbno']=='0' && $customerPair['current_casno']=='0')
    			$this->session->data['success'] = "PAIR OF STB & CAS DOESN'T EXIST FOR THE REQUESTED CUSTOMER";
    		else{

	   			$this->model_pairing_home->removeBond(trim($cust_id[0]));

    			$this->load->model('json/feed');
				$this->model_json_feed->CreateSTBFeed();
				$this->model_json_feed->CreateCASFeed();
				$this->model_json_feed->CreateBondFeed();

				$this->session->data['success'] = $this->language->get('text_success');
    			
   			}
   			fwrite($Handle, "\nSUCCESS:\tRELEASE\t\t".$this->request->post['cust_id']."\t\t\t".$customerPair['current_stbno']."\t".$customerPair['current_casno']."\t".date('Y-m-d H:i:s'));		

    		$this->redirect($this->url->link('pairing/home', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}
		else
		{
			fwrite($Handle, "\nERROR:\t\tRELEASE\t\t\t\t\t\t\t\t\t\t\t\t\t\t".date('Y-m-d H:i:s'));
			$this->getList();
    	}
    	fclose($Handle);
	}
/*
FUNCTION NAME 		-	validateCustomerBond
DESCRIPTION 		-	Checks whether the account holder has selected the customer id for removing
						the bond or not.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	public function validateCustomerBond(){
		
		if($this->request->post['cust_id']=='--Select--')
			$this->error['error_rm_customer_id']= $this->language->get("error_customer_id");
		//$this->error['warning']=$this->language->get('error_customer_id');

		if (!$this->error) {
			return true;
    	} else {
    		$this->error['warning']= $this->language->get("warning_set_bond");
      		return false;
    	}
	}
/*
FUNCTION NAME 		-	setBond
DESCRIPTION 		-	This function creates the bond and make the stb and cas number
						unavailable to restrict bond with other customers. It also updates the json 
						for the respective details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the pairing detail page after making changes.
*/	

//-------------Following two functions written for creating bond b/w stb-cas-customer.
	public function setBond(){
		$File = DIR_LOGFILE."create_remove_bond.log"; 
		$Handle = fopen($File,"a+");

		$this->language->load('pairing/home');
		$this->document->setTitle($this->language->get('heading_title'));
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validateForm1())) {
    		$this->load->model('pairing/home');
    		//$this->session->data['success'] = $this->language->get('text_success');
    		$cust_id = explode('(', $this->request->post['customer_id']);
    		$customerPair = $this->model_pairing_home->getCustomerPair(trim($cust_id[0]));
    		if($customerPair['customer_id']=='')
    			$this->session->data['success'] = "CUSTOMER IS NOT REGISTERED";
    		else if($customerPair['current_stbno']!='0' && $customerPair['current_casno']!='0')
    			$this->session->data['success'] = "PAIRING ALREADY EXIST WITH STB NO=".$customerPair['current_stbno']." AND CAS NO=".$customerPair['current_casno'];
    		else{
    			$this->session->data['success'] = $this->language->get('text_success');
    			
    			$this->model_pairing_home->createBond(trim($cust_id[0]),$this->request->post['stb_no'],$this->request->post['cas_no']);

    			$this->load->model('json/feed');
				$this->model_json_feed->CreateSTBFeed();
				$this->model_json_feed->CreateCASFeed();
				$this->model_json_feed->CreateBondFeed();
   			}

   			fwrite($Handle, "\nSUCCESS:\tSET\t\t\t".$this->request->post['customer_id']."\t\t\t".$this->request->post['stb_no']."\t".$this->request->post['cas_no']."\t".date('Y-m-d H:i:s'));
    		$this->redirect($this->url->link('pairing/home', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}
		else
		{
			fwrite($Handle, "\nERROR:\t\tSET\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".date('Y-m-d H:i:s'));
			$this->getList();
		}
		fclose($Handle);
	}
/*
FUNCTION NAME 		-	validateForm1
DESCRIPTION 		-	Checks whether the account holder has selected the customer id, stb number 
						and cas number for creating the bond.
						the bond or not.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/	
	public function validateForm1(){
		if($this->request->post['customer_id']=='--Select--')
			//$this->error['warning']= $this->language->get("error_customer_id");
			$this->error['error_customer_id']= $this->language->get("error_customer_id");
		if($this->request->post['stb_no']=='--Select--')
			$this->error['error_stb_no']= $this->language->get("error_stb_id");
		if($this->request->post['cas_no']=='--Select--')
			$this->error['error_cas_no']= $this->language->get("error_cas_id");
		

		if (!$this->error) {
			return true;
    	} else {
    		$this->error['warning']= $this->language->get("warning_set_bond");
      		return false;
    	}

		return true;
	}

}
?>