<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerKmsapiUriconfig extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('kmsapi/uriconfig');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/uriconfig');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/uriconfig', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		

   		$this->data['insert'] = $this->url->link('kmsapi/uriconfig/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('kmsapi/uriconfig/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');


		$this->data['uriconfigs'] = array();

		
		$results = $this->model_kmsapi_uriconfig->getDetail();
		foreach ($results as $result) {	
			$this->data['uriconfigs'][] = array(
				'uriconfig_id'          => $result['uriconfig_id'],
				'uri_length'    => $result['uri_length'],
				'uri_data'          => $result['uri_data'],
				'kms_reply_set'          => $result['kms_reply_set'],
				'kms_reply_load'          => $result['kms_reply_load'],
				'selected'           => isset($this->request->post['selected']) && in_array($result['uriconfig_id'], $this->request->post['selected'])
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_uriconfig_id'] = $this->language->get('column_uriconfig_id');
		$this->data['column_uri_length'] = $this->language->get('column_uri_length');
		$this->data['column_uri_data'] = $this->language->get('column_uri_data');
		$this->data['column_uri_set'] = $this->language->get('column_uri_set');
		$this->data['column_uri_load'] = $this->language->get('column_uri_load');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kmsapi/uriconfig.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
		$this->language->load('kmsapi/uriconfig');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/uriconfig');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
      	  	$this->model_kmsapi_uriconfig->addUriConfig($this->request->post);

		//-------------------------------------------------------------------------------- 	
 
     	 	$obj = new restapi();
     	     $data="uri_length=".$this->request->post['uri_length']."&uri_data=".$this->request->post['uri_data'];
     	     $z ="78fef98a91761cf1b171451b49289000";
	 			$method ="POST";
	 			$url="http://localhost/kmsapi/v1//SetUri";
	 			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
     	     $apiresult = $obj->callAPI($method,$hdr,$url,$data);
    	   	$res=json_decode($apiresult,true);
     	   	$this->model_kmsapi_uriconfig->updateUriConfig($res['curlresponse'],$res['uri_id']);
    	
        //-----------------------------------------------------------------------------------
			$this->session->data['success'] = $this->language->get('text_success');
		  
			$url = '';
							
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/uriconfig', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    	
    	$this->getForm();
  	} 
 
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
		$this->language->load('kmsapi/uriconfig');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/uriconfig');
			
    	if (isset($this->request->post['selected']) && $this->validateDelete()) {
    		//check if the stb is paired with any customer or not. write code
			
			 $obj = new restapi();
			foreach ($this->request->post['selected'] as $stb_id) {
				$kmsid  = $this->model_kmsapi_uriconfig->getkmsuriid($stb_id);	
         	  	$data="uri_id=".$kmsid;
         	  	$z ="78fef98a91761cf1b171451b49289000";
	 	  		$method ="POST";
	 	  		$url="http://localhost/kmsapi/v1/LoadFromUri";
	 	  		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	   	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
   		  	   	$res=json_decode($apiresult,true);
    	   		$this->model_kmsapi_uriconfig->updateUriConfigLoad($res['error'],$stb_id);
			}
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/uriconfig', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}
    	
    	$this->error['warning'] = $this->language->get('error_checkbox');
    	$this->getList();
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_uri_length'] = $this->language->get('entry_uri_length');
    	$this->data['entry_uri_data'] = $this->language->get('entry_uri_data');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['uri_data'])) {
			$this->data['error_uri_data'] = $this->error['uri_data'];
		} else {
			$this->data['error_uri_data'] = '';
		}

		if (isset($this->error['uri_length'])) {
			$this->data['error_uri_length'] = $this->error['uri_length'];
		} else {
			$this->data['error_uri_length'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/uriconfig', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		
			$this->data['action'] = $this->url->link('kmsapi/uriconfig/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		  
    	$this->data['cancel'] = $this->url->link('kmsapi/uriconfig', 'token=' . $this->session->data['token'] . $url, 'SSL');

    				
    	if (isset($this->request->post['uri_data'])) {
      		$this->data['uri_data'] = $this->request->post['uri_data'];
		}  else {
      		$this->data['uri_data'] = '';
    	}

    	if (isset($this->request->post['uri_length'])) {
      		$this->data['uri_length'] = $this->request->post['uri_length'];
		} else {
      		$this->data['uri_length'] = '';
    	}
		
		$this->template = 'kmsapi/uriconfig_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'kmsapi/uriconfig')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

  		if ((utf8_strlen($this->request->post['uri_length']) <1) || (utf8_strlen($this->request->post['uri_length']) > 3)) {
      		$this->error['uri_length'] = "Length should be between 1-3!";
    	}elseif(($this->request->post['uri_length'] <1) || ($this->request->post['uri_length'] >255)){
    		$this->error['uri_length'] = "value should be between 1-255";
    	}

    	if ((utf8_strlen($this->request->post['uri_data']) <1) || (utf8_strlen($this->request->post['uri_data']) > 64)) {
      		$this->error['uri_data'] = "Length should be between 1-64!";
    	}elseif(preg_match('/[^a-z_\-0-9 ]/i', $this->request->post['uri_data'])){
    		$this->error['uri_data'] = "Accepts only strings!";
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'kmsapi/uriconfig')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	 
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	} 
 }
?> 