<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerKmsapiOtaupdate extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('kmsapi/otaupdate');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/otaupdate');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/otaupdate', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		

   		$this->data['insert'] = $this->url->link('kmsapi/otaupdate/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		// $this->data['delete'] = $this->url->link('inventry/stb/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	// $this->data['button_delete'] = $this->language->get('button_delete');


		$this->data['stbs'] = array();

		
		$results = $this->model_kmsapi_otaupdate->getDetail();
		foreach ($results as $result) {	
			$action = array();
		
			// $action[] = array(
			// 	'text' => $this->language->get('text_edit'),
			// 	'href' => $this->url->link('kmsapi/otaupdate/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $result['stb_no'] . $url, 'SSL')
			// );



			$this->data['stbs'][] = array(
				'user_id'    => $result['user_id'],
				'url'          => $result['url'],
				'is_group'          => $result['is_group'],
				
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_avail'] = $this->language->get('column_avail');
		$this->data['column_sc'] = $this->language->get('column_sc');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kmsapi/otaupdate.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		
			$obj = new restapi();

		$this->language->load('kmsapi/otaupdate');

    	$this->document->setTitle($this->language->get('heading_title'));
					
		$this->load->model('kmsapi/otaupdate');

  			 
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
      	 	$this->model_kmsapi_otaupdate->addOtaupdate($this->request->post);
      	 	$temp =$this->request->post;
      	 	
    	//-------------------------------------------------------------------------------- 	
      	  $result= $this->model_kmsapi_otaupdate->getApiUserid($this->request->post['sc1']);
      	  	
       	  	$data="is_group=".$temp['sc3']."&user_id=".$result['api_user_id']."&url=".$temp['sc2'];
       	  	$z ="78fef98a91761cf1b171451b49289d83";
	 		$method ="POST";
	 		$url="http://localhost/kmsapi/v1/OTAUpdate";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
    	  	
   
    // //     //-----------------------------------------------------------------------------------	
			
			$this->session->data['success'] = $this->language->get('text_success');
		  
			$url = '';
							
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/otaupdate', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    	
    	$this->getForm();
  	} 


  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_id'] = $this->language->get('entry_id');
    	$this->data['entry_url'] = $this->language->get('entry_url');
    	$this->data['entry_isgroup'] = $this->language->get('entry_isgroup');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb'])) {
			$this->data['error_stb'] = $this->error['stb'];
		} else {
			$this->data['error_stb'] = '';
		}
		if (isset($this->error['sc'])) {
			$this->data['error_sc'] = $this->error['sc'];
		} else {
			$this->data['error_sc'] = '';
		}


		if (isset($this->error['sc1'])) {
			$this->data['error_sc1'] = $this->error['sc1'];
		} else {
			$this->data['error_sc1'] = '';
		}
		if (isset($this->error['sc2'])) {
			$this->data['error_sc2'] = $this->error['sc2'];
		} else {
			$this->data['error_sc2'] = '';
		}
		if (isset($this->error['sc3'])) {
			$this->data['error_sc3'] = $this->error['sc3'];
		} else {
			$this->data['error_sc3'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/otaupdate', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('kmsapi/otaupdate/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('kmsapi/otaupdate/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('kmsapi/otaupdate', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['stb_no']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$stb_info = $this->model_kmsapi_otaupdate->getSTB($this->request->get['stb_no']);
    	}
			
    	if (isset($this->request->post['sc1'])) {
      		$this->data['sc1'] = $this->request->post['sc1'];
		} elseif (!empty($stb_info)) { 
			$this->data['sc1'] = $stb_info['user_id'];
		} else {
      		$this->data['sc1'] = '';
    	}
    	if (isset($this->request->post['sc2'])) {
      		$this->data['sc2'] = $this->request->post['sc2'];
		} elseif (!empty($stb_info)) { 
			$this->data['sc2'] = $stb_info['url'];
		} else {
      		$this->data['sc2'] = '';
    	}

		if (isset($this->request->post['sc3'])) {
      		$this->data['sc3'] = $this->request->post['sc3'];
		} elseif (!empty($stb_info)) { 
			$this->data['sc3'] = $stb_info['is_group'];
		} else {
      		$this->data['sc3'] = '';
    	}


    	
		
		$this->template = 'kmsapi/otaupdate_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
  			
    	if (!$this->user->hasPermission('modify', 'kmsapi/otaupdate')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
			$this->load->model('kmsapi/otaupdate');

		$results1= $this->model_kmsapi_otaupdate->getApiUserid($this->request->post['sc1']);
    	
    	if(!$results1){
    		$this->error['sc1'] = "invalid user";
    	}

    	$res= $this->model_kmsapi_otaupdate->isExistOtaUpdateIdForUser($this->request->post['sc1']);
    	if($res){
    		$this->error['warning'] = "ota update for user exist!";	
    	}

    	if ((utf8_strlen($this->request->post['sc3']) <1) || (utf8_strlen($this->request->post['sc3']) > 1)) {
      		$this->error['sc3'] = "Length should be one digit!!";
    	}elseif(($this->request->post['sc3'] <0) || ($this->request->post['sc3'] >1)){
    		$this->error['sc3'] = "value should be between 0-1";
    	}

    	if ((utf8_strlen($this->request->post['sc2']) <1) || (utf8_strlen($this->request->post['sc2']) > 64)) {
      		$this->error['sc2'] = "Length should be between 1-64!";
    	}elseif(preg_match('/[^a-z_\-0-9]/i', $this->request->post['sc2'])){
    		$this->error['sc2'] = "Accepts only strings!";
    	}


    		
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	 
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	}
  	private function getUserIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
			
				return $value;
			 }
			 return;
	} 
 }
?> 