<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerKmsapiBmail extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('kmsapi/bmail');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/bmail');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		

   		$this->data['insert'] = $this->url->link('kmsapi/bmail/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');

		$this->data['bmail_details'] = array();

		
		$results = $this->model_kmsapi_bmail->getBmailDetail();
		foreach ($results as $result) {	
			$this->data['bmail_details'][] = array(
				'type'    => $result['type'],
				'customer_id'          => $result['customer_id'],
				'priority_level'          => $result['priority_level'],
				'expiry_date'          => $result['expiry_date'],
				'subject'          => $result['subject'],
				'message'             => $result['message'],
				'kms_reply'             => $result['kms_reply']
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_user_id'] = $this->language->get('column_user_id');
		$this->data['column_priority_level'] = $this->language->get('column_priority_level');
		$this->data['column_expiry_date'] = $this->language->get('column_expiry_date');
		
		$this->data['column_subject'] = $this->language->get('column_subject');
		$this->data['column_message'] = $this->language->get('column_message');
		$this->data['column_kms_reply'] = $this->language->get('column_kms_reply');
		

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kmsapi/bmail.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
		$this->language->load('kmsapi/bmail');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/bmail');
			$this->load->model('kmsapi/boxreset');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
      	  	$this->model_kmsapi_bmail->addBmail($this->request->post);
			
	   	//-------------------------------------------------------------------------------- 	
 			$expiry_timestamp = strtotime($this->request->post['expiry_date']);
 		

 			$x=$this->model_kmsapi_boxreset->getApiUserid($this->request->post['customer_id']);
    		$obj = new restapi();
 	    	$data="type=".$this->request->post['type']."&user_id=".$x['api_user_id']."&priority_level=".$this->request->post['priority_level']."&expiry_date=".$expiry_timestamp."&subject=".$this->request->post['subject']."&message=".$this->request->post['message'];

     	 	$z ="78fef98a91761cf1b171451b49289000";
	 	 	$method ="POST";
	 		$url="http://localhost/kmsapi/v1/BMail";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
     	 	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
    	 	$res=json_decode($apiresult,true);
     	  	$this->model_kmsapi_bmail->updateBmail($res['curlresponse']);
    	
        //-----------------------------------------------------------------------------------


			$this->session->data['success'] = $this->language->get('text_success');
		  
			$url = '';
							
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    	
    	$this->getForm();
  	} 

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_type'] = $this->language->get('entry_type');
    	$this->data['entry_customer_id'] = $this->language->get('entry_customer_id');
    	$this->data['entry_priority_level'] = $this->language->get('entry_priority_level');
    	$this->data['entry_expiry_date'] = $this->language->get('entry_expiry_date');
    	$this->data['entry_subject'] = $this->language->get('entry_subject');
    	$this->data['entry_message'] = $this->language->get('entry_message');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['type'])) {
			$this->data['error_type'] = $this->error['type'];
		} else {
			$this->data['error_type'] = '';
		}

		if (isset($this->error['customer_id'])) {
			$this->data['error_customer_id'] = $this->error['customer_id'];
		} else {
			$this->data['error_customer_id'] = '';
		}

		if (isset($this->error['priority_level'])) {
			$this->data['error_priority_level'] = $this->error['priority_level'];
		} else {
			$this->data['error_priority_level'] = '';
		}

		
		if (isset($this->error['expiry_date'])) {
			$this->data['error_expiry_date'] = $this->error['expiry_date'];
		} else {
			$this->data['error_expiry_date'] = '';
		}


		if (isset($this->error['subject'])) {
			$this->data['error_subject'] = $this->error['subject'];
		} else {
			$this->data['error_subject'] = '';
		}

		if (isset($this->error['message'])) {
			$this->data['error_message'] = $this->error['message'];
		} else {
			$this->data['error_message'] = '';
		}
				
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = $this->url->link('kmsapi/bmail/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		  
    	$this->data['cancel'] = $this->url->link('kmsapi/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL');
			
    	if (isset($this->request->post['type'])) {
      		$this->data['type'] = $this->request->post['type'];
		} else {
      		$this->data['type'] = '';
    	}

    	if (isset($this->request->post['customer_id'])) {
      		$this->data['customer_id'] = $this->request->post['customer_id'];
		} else {
      		$this->data['customer_id'] = '';
    	}

    	if (isset($this->request->post['priority_level'])) {
      		$this->data['priority_level'] = $this->request->post['priority_level'];
		} else {
      		$this->data['priority_level'] = '';
    	}

    	if (isset($this->request->post['expiry_date'])) {
      		$this->data['expiry_date'] = $this->request->post['expiry_date'];
		} else {
      		$this->data['expiry_date'] = '';
    	}


    	if (isset($this->request->post['subject'])) {
      		$this->data['subject'] = $this->request->post['subject'];
		}  else {
      		$this->data['subject'] = '';
    	}

    	if (isset($this->request->post['message'])) {
      		$this->data['message'] = $this->request->post['message'];
		}else {
      		$this->data['message'] = '';
    	}
		
		$this->template = 'kmsapi/bmail_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'kmsapi/bmail')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
    	$this->load->model('sale/customer');
    	if(!preg_match('/[^0-9]/i', $this->request->post['customer_id'])){
    		$customer_info = $this->model_sale_customer->getCustomer($this->request->post['customer_id']);
    		if(!$customer_info)
    			$this->error['customer_id']	 = "invalid customer id!".$customer_info['customer_id'];
    	}else{
    		$this->error['customer_id']	 = "accept only integer!";
    	}

    	if ((utf8_strlen($this->request->post['type']) <1) || (utf8_strlen($this->request->post['type']) > 1)) {
      		$this->error['type'] = "Length should be one digit!";
    	}elseif(($this->request->post['type'] <1) || ($this->request->post['type'] >9)){
    		$this->error['type'] = "value should be between 1-9";
    	}

    	if ((utf8_strlen($this->request->post['priority_level']) <1) || (utf8_strlen($this->request->post['priority_level']) > 1)) {
      		$this->error['priority_level'] = "Length should be one digit!";
    	}elseif(($this->request->post['priority_level'] <1) || ($this->request->post['priority_level'] >9)){
    		$this->error['priority_level'] = "value should be between 1-9";
    	}

    	if ((utf8_strlen($this->request->post['subject']) <1) || (utf8_strlen($this->request->post['subject']) > 64)) {
      		$this->error['subject'] = "Length should be between 1-64!";
    	}elseif(preg_match('/[^a-z_\-0-9]/i', $this->request->post['subject'])){
    		$this->error['subject'] = "Accepts only strings!";
    	}

    	if($this->request->post['expiry_date']){
	    	if(new DateTime() >= new DateTime($this->request->post['expiry_date'])){
	    			$this->error['expiry_date'] = "Expiry date is less than current date!";
			}
		}else{
			$this->error['expiry_date']="Expiry date missing!"	;
		}

    	if ((utf8_strlen($this->request->post['message']) <1) || (utf8_strlen($this->request->post['message']) > 255)) {
      		$this->error['message'] = "Length should be between 1-255!";
    	}elseif(preg_match('/[^a-z_\-0-9]/i', $this->request->post['message'])){
    		$this->error['message'] = "Accepts only strings!";
    	}
    	

		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    

 }
?> 