<?php 
 /*
@File cas.php(Controller)
ADMIN CAS PAGE
    This class manages the all the cas numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerKmsCommands extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the cas detail option in the dopdown list.
						It get all the cas number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin cas page showing all the cas number in a list.
*/
public function index() {
		$this->language->load('kms/commands');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		

		//$this->load->model('kmsapi/boxreset');
    	$this->getList();

  	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the cas number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the cas number list.
*/

public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';




   		//$this->data['insert'] = $this->url->link('kmsapi/boxreset/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		// $this->data['delete'] = $this->url->link('inventry/cas/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
	//	$this->data['button_insert'] = $this->language->get('button_insert');
    	// $this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['enable_stb'] = $this->language->get('enable_stb');
		$this->data['disable_stb'] = $this->language->get('disable_stb');
		$this->data['get_details'] = $this->language->get('get_details');
		//---------------
	//	$this->data['getuserdetails'] = $this->url->link('kms/commands/getuserdetails', 'token=' . $this->session->data['token'] . $url, 'SSL');

		
		
		$this->data['cass'] = array();

		
		


		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->request->get['filter_option'])) {
				 	$this->data['filter_option']= $this->request->get['filter_option'];
				} else {
		 	$this->data['filter_option']="";
		}
		if (isset($this->request->get['filter_value'])) {
		 	$this->data['filter_value']= $this->request->get['filter_value'];
		} else {
		 	$this->data['filter_value']="";
		}

/*
		$this->data['lastname']="";
		$this->data['email']="";
		$this->data['STBNO']="";

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
*/	
		$url .= '&option_filter=CustomerID&option_value=140';
		$this->data['getDetails'] = $this->url->link('kms/commands/getuserdetails', 'token=' . $this->session->data['token'] .$url, 'SSL');
	
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kms/commands.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		$this->language->load('kms/commands');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kms/commands');
  
  		/*if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}


		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/boxreset', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);


   		$this->data['insert'] = $this->url->link('kmsapi/boxreset/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		// $this->data['delete'] = $this->url->link('inventry/cas/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	// $this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['enable_stb'] = $this->language->get('disable_stb');
		$this->data['disable_stb'] = $this->language->get('disable_stb');
		$this->data['get_details'] = $this->language->get('get_details');



		
		$this->data['cass'] = array();

		
		$results = $this->model_kmsapi_boxreset->getDetail();
		foreach ($results as $result) {			

			// $action = array();
		
		 // $action[] = array(
		 // 	'text' => $this->language->get('text_edit'),
			// // 	'href' => $this->url->link('kmsapi/boxreset/update', 'token=' . $this->session->data['token'] . '&cas_id=' . $result['cas_id'] . $url, 'SSL')
			//  );

			$this->data['cass'][] = array(
				'user_id'    => $result['user_id'],
				'stbid'		 =>$result['stbid'],
				'casid'      => $result['casid'],
				'reset_flag'          => ($result['reset_flag']),
				
			);	
		}				
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_user_id'] = $this->language->get('column_user_id');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_casno'] = $this->language->get('column_casno');
		$this->data['column_flag'] = $this->language->get('column_flag');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		

*/

		if (isset($this->request->get['filter_option'])) {
		 	$this->data['filter_option']= $this->request->get['filter_option'];
		} else {
		 	$this->data['filter_option']="";
		}
		if (isset($this->request->get['filter_value'])) {
		 	$this->data['filter_value']= $this->request->get['filter_value'];
		} else {
		 	$this->data['filter_value']="";
		}

		$this->load->model('kms/commands');
		$results = $this->model_kms_commands->getuserdetails();


			$this->data['lastname']= $results['lastname'];
			$this->data['email']= $results['email'];
			$this->data['STBNO']= $results['STBNO'];
		$this->session->data['success'] = $this->language->get('text_success');
		$url = '';
		$this->redirect($this->url->link('kms/commands', 'token=' . $this->session->data['token'] . $url, 'SSL'));
/*		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kms/commands.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
*/
		$this->getForm();
  	} 
//----------------------





  	public function getuserdetails() {
  		$this->language->load('kms/commands');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kms/commands');
  
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}


		$url = '';


		$this->data['enable_stb'] = $this->language->get('enable_stb');
		$this->data['disable_stb'] = $this->language->get('disable_stb');
		$this->data['get_details'] = $this->language->get('get_details');



		

		
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_user_id'] = $this->language->get('column_user_id');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_casno'] = $this->language->get('column_casno');
		$this->data['column_flag'] = $this->language->get('column_flag');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		



		if (isset($this->request->get['filter_option'])) {
		 	$this->data['filter_option']= $this->request->get['filter_option'];
		} else {
		 	$this->data['filter_option']="";
		}
		if (isset($this->request->get['filter_value'])) {
		 	$this->data['filter_value']= $this->request->get['filter_value'];
		} else {
		 	$this->data['filter_value']="";
		}

		$this->load->model('kms/commands');

		switch($this->data['filter_option'])
		{
			case 'mobileno':
				$user_option = 'telephone';
			break;
			case 'customerid':
				$user_option = 'customer_id';
				break;
			default:
				$user_option = '';
				break;
		} 

if(isset($user_option))
{


	$results = $this->model_kms_commands->getuserdetails($user_option,$this->data['filter_value']);

			$this->data['lastname']= $results['lastname'];
			$this->data['email']= $results['email'];
			$this->data['STBNO']= $results['STBNO'];
			$this->data['kms_user_id']= $results['kms_user_id'];
			$this->data['customer_id']= $results['customer_id'];



		//$this->session->data['success'] = $this->language->get('text_success');
		$url = '';

}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kms/commands.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

		//$this->getForm();
  	} 





//----------------------
  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_user_id'] = $this->language->get('entry_user_id');
 		$this->data['entry_cas'] = $this->language->get('entry_cas');
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_flag'] = $this->language->get('entry_flag');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['cas'])) {
			$this->data['error_cas'] = $this->error['cas'];
		} else {
			$this->data['error_cas'] = '';
		}

		if (isset($this->error['cas1'])) {
			$this->data['error_cas1'] = $this->error['cas1'];
		} else {
			$this->data['error_cas1'] = '';
		}

		if (isset($this->error['cas2'])) {
			$this->data['error_cas2'] = $this->error['cas2'];
		} else {
			$this->data['error_cas2'] = '';
		}

		if (isset($this->error['cas3'])) {
			$this->data['error_cas3'] = $this->error['cas3'];
		} else {
			$this->data['error_cas3'] = '';
		}

		if (isset($this->error['cas4'])) {
			$this->data['error_cas4'] = $this->error['cas4'];
		} else {
			$this->data['error_cas4'] = '';
		}

		if (isset($this->error['sc'])) {
			$this->data['error_sc'] = $this->error['sc'];
		} else {
			$this->data['error_sc'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/boxreset', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['cas_id'])) {
			$this->data['action'] = $this->url->link('kmsapi/boxreset/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} 
		  
    	$this->data['cancel'] = $this->url->link('kmsapi/boxreset', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['casid']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$cas_info = $this->model__kmsapi_boxreset->getCAS($this->request->get['casid']);
    	}
			
    	
    	if (isset($this->request->post['cas1'])) {
      		$this->data['cas1'] = $this->request->post['cas1'];
		} elseif (!empty($cas_info)) { 
			$this->data['cas1'] = $cas_info['user_id'];
		} else {
      		$this->data['cas1'] = '';
    	}
    	
    	if (isset($this->request->post['cas2'])) {
      		$this->data['cas2'] = $this->request->post['cas2'];
		} elseif (!empty($cas_info)) { 
			$this->data['cas2'] = $cas_info['stbid'];
		} else {
      		$this->data['cas2'] = '';
    	}

    	if (isset($this->request->post['cas3'])) {
      		$this->data['cas3'] = $this->request->post['cas3'];
		} elseif (!empty($cas_info)) { 
			$this->data['cas3'] = $cas_info['casid'];
		} else {
      		$this->data['cas3'] = '';
    	}


    	if (isset($this->request->post['cas4'])) {
      		$this->data['cas4'] = $this->request->post['cas4'];
		} elseif (!empty($cas_info)) { 
			$this->data['cas4'] = $cas_info['reset_flag'];
		} else {
      		$this->data['cas4'] = '';
    	}

    	
		
		$this->template = 'kmsapi/boxreset_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'kmsapi/boxreset')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

    	
    	$this->load->model('sale/customer');
    	$this->load->model('inventry/stb');
    	$this->load->model('inventry/cas');
    	if(!preg_match('/[^0-9]/i', $this->request->post['cas1'])){
    		$customer_info = $this->model_sale_customer->getCustomer($this->request->post['cas1']);
    		if(!$customer_info)
    		{
    			$this->error['cas1']	 = "invalid customer id!";
    		}
    	}else{
    		$this->error['cas1']	 = "accept only integer!";
    	}

     	if(!preg_match('/[^0-9]/i', $this->request->post['cas2'])){
     		$customer_info = $this->model_sale_customer->getCustomer($this->request->post['cas1']);
     		$casno = $this->model_inventry_cas->getCASNOById($this->request->post['cas2']);
     		if($casno){
     			if($casno['cas_id'] != $customer_info['CASNO'])
     				$this->error['cas2']	 = "not mapped!";		
     		}else{
     			$this->error['cas2']	 = "invalid cas id!";	
     		}
    	}else{
    		$this->error['cas2']	 = "accept only integer!";	
    	}

    	if(!preg_match('/[^0-9]/i', $this->request->post['cas3'])){
     		$customer_info = $this->model_sale_customer->getCustomer($this->request->post['cas1']);
     		$stbno = $this->model_inventry_stb->getSTBNOById($this->request->post['cas3']);
     		if($stbno['stb_no']){
     			if($stbno['stb_no'] != $customer_info['STBNO'])
     				$this->error['cas3']	 = "not mapped!";		
     		}else{
     			$this->error['cas3']	 = "invalid stb id!";	
     		}
    	}else{
    		$this->error['cas3']	 = "accept only integer!";	
    	}

    	



		// $this->load->model('kmsapi/boxreset');
    	
  //   	$results1= $this->model_kmsapi_boxreset->getApiUserid($this->request->post['cas1']);
  //   	if(!$results1){
  //   		$this->error['cas1'] = "invalid user";
  //   	}

  //   	$results2= $this->model_kmsapi_boxreset->getApiCasid($this->request->post['cas2']);
  //   	if(!$results2){
  //   		$this->error['cas2'] = "invalid cas id";
  //   	}

  //   	$results3= $this->model_kmsapi_boxreset->getApiStbid($this->request->post['cas3']);
  //   	if(!$results3){
  //   		$this->error['cas3'] = "invalid stb id";
  //   	}
    	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
		
  	}    

// FUNCTION NAME 		-	validateDelete
// DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
// 						Checks if the deteled customer_ban_ip is already there in the database or not. 
// INPUT PARAMETER 	-	void
// OUTPUT PARAMETER 	- 	Returns true if no error else returns false.

  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'inventry/cas')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	 
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	} 

  		private function getUserIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
		
				return $value;
			 }

			 return;
	}



 }
?> 