<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerInventrySTB extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('inventry/stb');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb');
    	$this->getList();
  	}

public function exportFormat(){  
	/*********************** Export STB Inventory CSV Format *****************************/
	$results = array('SDA40000000001,'.'1,'.'5,'.'0,'.'1');
	if($results){
		header('Content-Type: text/csv; charset=utf-8');
		header('Content-Disposition: attachment; filename=StbInventorySampleFormat.csv');
		$output = fopen('php://output', 'w'); ob_clean();
		fputcsv($output, array('STB NO', 's/w version', 'h/w version', 'STB Type','Operator Id'));
		foreach ( $results as $line ) {
			$val = explode(",", $line);
			fputcsv($output, $val);
		}
	}
}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
	public function getList() {	

		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . urlencode(html_entity_decode($this->request->get['filter_operator'], ENT_QUOTES, 'UTF-8'));
		}
		if (isset($this->request->get['filter_box_type'])) {
			$url .= '&filter_box_type=' . urlencode(html_entity_decode($this->request->get['filter_box_type'], ENT_QUOTES, 'UTF-8'));
		}
		if (isset($this->request->get['filter_box_status'])) {
			$url .= '&filter_box_status=' . urlencode(html_entity_decode($this->request->get['filter_box_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		if (isset($this->request->get['suspend_status'])) {
			$url .= '&suspend_status=' . $this->request->get['suspend_status'];
		}
		if (isset($this->request->get['filter_paired_status'])) {
			$url .= '&filter_paired_status=' . $this->request->get['filter_paired_status'];
		}
		if (isset($this->request->get['filter_blacklist_status'])) {
			$url .= '&filter_blacklist_status=' . $this->request->get['filter_blacklist_status'];
		}

		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
  		if (isset($this->request->get['filter_passcode'])) {
			$url .= '&filter_passcode=' . urlencode(html_entity_decode($this->request->get['filter_passcode'], ENT_QUOTES, 'UTF-8'));
		}
		
   		if(isset($this->request->get['download']))
   		{
   			$this->data['download'] = $this->url->link('inventry/stb/download', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		}
   		$this->data['upload_bulk_stb'] = $this->url->link('inventry/stb/upload_bulk_stb', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		$this->data['sync'] = $this->url->link('inventry/stb/sync', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		$this->data['insert'] = $this->url->link('inventry/stb/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('inventry/stb/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['blacklist'] = $this->url->link('inventry/stb/blacklist', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_sync'] = $this->language->get('button_sync');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_black_list'] = $this->language->get('button_black_list');

		$this->data['stbs'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		if (isset($this->request->get['filter_operator'])) {
			$this->data['filter_operator'] = $this->request->get['filter_operator'];
			$data['filter_operator']=$this->request->get['filter_operator'];
		} else {
			$this->data['filter_operator'] ='';
		}
		if (isset($this->request->get['filter_box_type'])) {
			$this->data['filter_box_type'] = $this->request->get['filter_box_type'];
			$data['filter_box_type']=$this->request->get['filter_box_type'];
		} else {
			$this->data['filter_box_type'] ='-1';
		}
		if (isset($this->request->get['filter_box_status'])) {
			$this->data['filter_box_status'] = $this->request->get['filter_box_status'];
			$data['filter_box_status']=$this->request->get['filter_box_status'];
		} else {
			$this->data['filter_box_status'] ='-1';
		}

		if (isset($this->request->get['filter_status'])) {
			$this->data['filter_status'] = $this->request->get['filter_status'];
			$data['filter_status']=$this->request->get['filter_status'];
		} else {
			$this->data['filter_status'] = null;
		}
		if (isset($this->request->get['suspend_status'])) {
			$this->data['suspend_status'] = $this->request->get['suspend_status'];
			$data['suspend_status']=$this->request->get['suspend_status'];
		} else {
			$this->data['suspend_status'] = null;
		}
		if (isset($this->request->get['filter_paired_status'])) {
			$this->data['filter_paired_status'] = $this->request->get['filter_paired_status'];
			$data['filter_paired_status']=$this->request->get['filter_paired_status'];
		} else {
			$this->data['filter_paired_status'] = null;
		}
		if (isset($this->request->get['filter_blacklist_status'])) {
			$this->data['filter_blacklist_status'] = $this->request->get['filter_blacklist_status'];
			$data['filter_blacklist_status']=$this->request->get['filter_blacklist_status'];
		} else {
			$this->data['filter_blacklist_status'] = null;
		}

		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		if (isset($this->request->get['filter_passcode'])) {
			$this->data['filter_passcode'] = $this->request->get['filter_passcode'];
			$data['filter_passcode']=$this->request->get['filter_passcode'];
		} else {
			$this->data['filter_passcode'] ='';
		}

		$resultOperators = $this->model_inventry_stb->getOperators();
		foreach ($resultOperators as $operator) {
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}

		$total = $this->model_inventry_stb->getTotalStb($data);

		$results = $this->model_inventry_stb->getDetail($data);
		
		foreach ($results as $result) {	
			$action = array();
		
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('inventry/stb/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $result['stb_no'] . $url, 'SSL')
			);

			$this->data['stbs'][] = array(
				// 'customer_id'    => $result['customer_id'],
				'STBNO'          => $result['stb_no'],
				'pass_code'      => $result['pass_code'],
				'avail'          => ($result['is_avail'] ? $this->language->get('text_not_avail') : $this->language->get('text_avail')),
				'name'           => $result['name'],
				// 'smart_card'     => ($result['sc_no']!=-1 ? $result['sc_no'] : $this->language->get('text_not_sc')),
				'box_type'     => ($result['box_type'] ? "HD" : "SD"),
				'box_status'     => ($result['box_status'] ? "RMA" : "In Stock"),
				'blacklist'      => ($result['is_black_list'] ? $this->language->get('text_blacklist') : $this->language->get('text_not_blacklist')),
				'is_active'      => (is_null($result['stbno']) ? $this->language->get('text_not_active') : $this->language->get('text_active')),
				'is_suspend'      => $result['suspend'],//($result['is_suspend']==1 ? $this->language->get('Suspended') : $this->language->get('Not Suspended')),
				'hw_version'	 =>$result['hw_version_no'],
				'sw_version'	 =>$result['sw_version_no'],
				'action'		=> $action,
				'selected'       => isset($this->request->post['selected']) && in_array($result['stb_no'], $this->request->post['selected'])
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_paired'] = $this->language->get('column_paired');
		$this->data['column_sc'] = $this->language->get('column_sc');
		$this->data['column_pass_code'] = $this->language->get('column_pass_code');
		$this->data['column_blacklist'] = $this->language->get('column_blacklist');
		$this->data['column_hw_version'] = $this->language->get('column_hw_version');
		$this->data['column_sw_version'] = $this->language->get('column_sw_version');
		$this->data['column_box_type'] = $this->language->get('column_box_type');
		$this->data['column_box_status'] = $this->language->get('column_box_status');
		

		$this->data['text_active'] = $this->language->get('text_active');
		$this->data['text_not_active'] = $this->language->get('text_not_active');
		$this->data['text_paired'] = $this->language->get('text_paired');
		$this->data['text_not_paired'] = $this->language->get('text_not_paired');
		$this->data['text_blacklist'] = $this->language->get('text_blacklist');
		$this->data['text_not_blacklist'] = $this->language->get('text_not_blacklist');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['text_sd'] = $this->language->get('text_sd');
    	$this->data['text_hd'] = $this->language->get('text_hd');
    	$this->data['text_instock'] = $this->language->get('text_instock');
    	$this->data['text_rma'] = $this->language->get('text_rma');

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		//----------------------
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'inventry/stb.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}

  
  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		
		$obj = new restapi();
		$this->language->load('inventry/stb');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb');
		$stb_list=array();
		$stb_sw_hw=array();

		if (($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm())) {
			// echo "<pre>"; print_r($this->request->post); die;
			$apimessage='';
    		$errorMsg="KMS Failed! ";
    		$error=true;	
    		$flag=false;
    		$stb_input=array();
	    	$error_encounter=0;
	    	$sw_hw=array();
	    	$stb_input['stb']=$this->request->post['stb'];
	    	$stb_input['operator_id']=$this->request->post['filter_operator'];
	    	array_push($sw_hw, $this->request->post['sw']);
		    array_push($sw_hw, $this->request->post['hw']);
		    array_push($sw_hw, $this->request->post['box_status']);
		    array_push($sw_hw, $this->request->post['box_type']);
		    array_push($sw_hw, $this->request->post['filter_operator']);
		    if($this->request->post['sc']==1){
		    	$stb_input['sc_no']=$this->request->post['smart_card'];
		    }
		    else{
		    	$stb_input['sc_no']='-1';
		    }
		    array_push($stb_list,$stb_input);
		    array_push($stb_sw_hw,$sw_hw);

			$json_stb=json_encode($stb_list,JSON_FORCE_OBJECT);
		    $data="stb_list=".$json_stb;
		    // var_dump($data); die;
	 		$method ="POST";
	 		$url=KMS_API."/enableStb";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME.':'.API_AUTH);
	 		$apiresult = $obj->callAPI($method,$hdr,$url,$data);
        	$kms_stb_id="";
    		$response=json_decode($apiresult,true);
			foreach ($response as $key => $value) {
				switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'stb_list':
    					$kms_stb_list=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
		 	}
			$count=0;
			$myfile = fopen("stblog.txt", "a+") or die("Unable to open file!");
			$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
			$today = $currDate->format('d-m-Y H:i:s');	
			// $today = date("Y-m-d H:i:s");
			fwrite($myfile,"-----------------------------------------------------------------------------------------------\n");
			foreach ($kms_stb_list as $stb) {
			 	if(strcmp($stb['resp'], 'ACK')==0)
			 	{
					$sms_stb_id=$this->model_inventry_stb->addSTB($stb,$stb_sw_hw[$count],-1);
		        	$this->model_inventry_stb->addApiResponceId($stb['id'],$sms_stb_id);
		        	// fwrite($myfile, $stb['stb_no']." KMS response ==> ".$stb['resp']."  Message ==> ".$stb['message']."  ".$today."\n");
		        	fwrite($myfile, "SUCCESS"."\t\t".$today."\t\t".str_pad($stb['stb_no'],24," ")."addSTB"."\n");
			 	}else {
			 		// fwrite($myfile, $stb['stb_no']." KMS response ==> ".$stb['resp']."  Message ==> ".$stb['message']."  ".$today."\n");
			 		fwrite($myfile, "ERROR"."\t\t".$today."\t\t".str_pad($stb['stb_no'],24," ")."addSTB"."\n");
        			$flag=true;	
			 	}
			 	$count=$count+1;	
			 		
			}
			fclose($myfile);
			

    		if(!$error)	{ 
				$url = '';
								
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				if(!$flag){
					$this->session->data['success'] = $this->language->get('success');
					$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url."&download=1", 'SSL'));
				}else{
					$this->session->data['success'] = $this->language->get('partial_success');
					$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url."&download=1", 'SSL'));
				}

			}else{
				$this->error['warning']=$errorMsg;
		 		$this->getForm();
			}
		}
    	
    	$this->getForm();	
  	} 

	public function validateFile(){
	  	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
    	$errorFlag = false;
		$this->load->model('inventry/stb');
		switch ($_FILES['filename']['error']) { 
			case UPLOAD_ERR_OK:
				$message = "";//"There is no error, the file uploaded with success";
				break;
            case UPLOAD_ERR_INI_SIZE: 
                $message = "The uploaded file exceeds the upload_max_filesize directive in php.ini"; 
                break; 
            case UPLOAD_ERR_FORM_SIZE: 
                $message = "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form"; 
                break; 
            case UPLOAD_ERR_PARTIAL: 
                $message = "The uploaded file was only partially uploaded"; 
                break; 
            case UPLOAD_ERR_NO_FILE: 
                $message = "No file was uploaded"; 
                break; 
            case UPLOAD_ERR_NO_TMP_DIR: 
                $message = "Missing a temporary folder"; 
                break; 
            case UPLOAD_ERR_CANT_WRITE: 
                $message = "Failed to write file to disk"; 
                break; 
            case UPLOAD_ERR_EXTENSION: 
                $message = "File upload stopped by extension"; 
                break; 
            default: 
                $message = "Unknown upload error"; 
                break; 
        }
        $mimes = array('text/csv');
		if(in_array($_FILES['filename']['type'],$mimes)){
			$lines = count(file($_FILES['filename']['tmp_name'])); 
			if( $lines > 1001)
				$message = "Can't process csv, records more than 1000!";
		}

		$ext = pathinfo($_FILES['filename']['name'], PATHINFO_EXTENSION);
		if($ext!='csv'){
			$message = "Invalid file format, Only .CSV files are accepted!";	
		}

		/*$stbArr = array();
		$i=0;
		if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
		    $handle = fopen($_FILES['filename']['tmp_name'], "r");
		    // var_dump($this->request->post);die;
		    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
		    	$stbArr[$i-1]['STB NO']=$data[0];
	    		$stbArr[$i-1]['s/w version']=$data[1];
	    		$stbArr[$i-1]['h/w version']=$data[2];
	    		$stbArr[$i-1]['sc no']=$data[3];
	    		$stbArr[$i-1]['STB Type']=$data[4];
		    }
		}

		$log_separator = "-------------------------------------\n";
		$TodayDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$today = $TodayDate->format('d-m-Y H:i:s');	
		$file_name = DIR_ADMIN_LOGS."Bulk_Stb_LogList/".$today.".txt";
		file_put_contents($file_name, $log_separator.$today."\n"  , FILE_APPEND);

		foreach ($stbArr as $row) {
	    	// var_dump(!preg_match("/^[a-zA-Z0-9]+$/", $row['STB NO']));
	    	// var_dump(!preg_match("/^[0-1]+$/", $row['STB Type']));
	    	// var_dump("here".(!preg_match("/^[0-1]+$/", $row['STB Type']))); die;
	    	if(!preg_match("/^[a-zA-Z0-9]+$/", $row['STB NO']) 
	    		|| !preg_match("/^[\d.]+$/", $row['s/w version'])
	    		|| !preg_match("/^[\d.]+$/", $row['h/w version'])
	    		|| !preg_match("/[^a-z0-9]/i", $row['sc no'])
	    		|| !preg_match("/^[0-1]+$/", $row['STB Type']))
			 	{	
			 		$message = "Invalid Data.!";	
			 		file_put_contents($file_name, $row['STB NO']."\t".$message."\t".$today."\n", FILE_APPEND );
				}	    
	    }

	    //------------make .gz file to download
		$gzfile = DIR_ADMIN_LOGS."Bulk_Stb_LogList/".$today.".gz";
		$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
		gzwrite($fp, file_get_contents($file_name, FILE_USE_INCLUDE_PATH));
		gzclose($fp);
		unlink($file_name);*/

		if(!empty($message))
			$this->error['warning'] = $message;
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
	} 		
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
		$this->language->load('inventry/stb');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateUpdateForm()) {
    		// var_dump($this->request->post);die;
			$this->model_inventry_stb->editSTB($this->request->get['stb_no'], $this->request->post);
	  		
			$this->session->data['success'] = $this->language->get('text_success_update');
	  
			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		$obj = new restapi();
		$this->language->load('inventry/stb');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb');
    	if ($this->validateDelete() && isset($this->request->post['selected'])) {
    		//check if the stb is paired with any customer or not. write code
    		$error_encounter=0;
    		$flag=false;
    		$errorMsg='';
			foreach ($this->request->post['selected'] as $stb_no) {
				$delete_flag=false;
				$x = $this->model_inventry_stb->getSTB($stb_no);
				$p = $this->model_inventry_stb->getApiResponceId($x['id']);
				$data="stb_id=".$p['kms_stb_id'];	
		 		$method ="POST";
		 		$url=KMS_API."/disableStb";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
		       	$response=json_decode($apiresult);
		       	$error=true;
		
	        	foreach ($response as $key => $value) {
	        		switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
	    			}
				}
    			if($error){
    				$error_encounter=1;
    				$errorMsg=$errorMsg." :".$apimessage;
    			}else{
    				$flag=true;
    				$this->model_inventry_stb->deleteSTB($stb_no);
    			}
	  		}
	  		if($error_encounter)
	  		{		
				if($flag)
	  				$this->session->data['warning'] =$this->language->get('text_warning_partial_delete').' ('.$errorMsg.')';
		  		else
		  			$this->session->data['warning'] =$errorMsg;
			  	$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
			}else{
				$this->session->data['success'] = $this->language->get('text_success_deleted');
				$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
			}
    	}else
    		// $this->error['warning'] = $this->language->get('error_checkbox');
    		$this->getList();
  	}  
/*
FUNCTION NAME 		-	blacklist
DESCRIPTION 		-	Black list the selected stb listed on the page. Admin selects the 
						checkbox against the stb in the list to be black listed and it gets black list 
						after clicking the black list button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the stb list page after black listing the stb from the list.
*/
  	public function blacklist() {
		$this->language->load('inventry/stb');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb');
    	if($this->validateBlacklist() && isset($this->request->post['selected'])) {
    		$obj = new restapi();
			foreach ($this->request->post['selected'] as $stb_no) {
				$getId = $this->model_inventry_stb->getStbidByStbno($stb_no);
				if((int)$getId["customer_id"]){
				$kmsstbId = $this->model_inventry_stb->getApiResponceId($getId['id']);
				$kms_user_Id = $this->model_inventry_stb->getApiCustomerId($getId["customer_id"]);				
				//========
				$data="stb_id=".$kmsstbId['kms_stb_id']."&user_id=".$kms_user_Id['api_user_id'];
		 		$method ="POST";
		 		$url=KMS_API."/blackListSTB";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
	    		$temp=json_decode($apiresult);
	    		$error=true;
	    		foreach ($temp as $key => $value) {
	    		 	if($key=='error')
	    		 	{	
	    		 		if($value==false)
	 	   		 		$error =false;
	    		 		break;
	    		 	}
	    		}
	    		if(!$error)
	    		{
					$temp=$this->model_inventry_stb->blacklistSTB($stb_no);
				}else{
					$this->error['warning'] = "Error: Unable to blacklist STB!".$apiresult.$kms_user_Id;
					$this->getList();
					return;
				}
				}
				else{
					$this->error['warning'] = "Error:customer id missing Unable to blacklist !";
					$this->getList();
					return;
				}
			}
			$this->session->data['success'] = $this->language->get('text_success_blacklisted');
			$url = '';
			$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
    	}
    	$this->getList();
  	}  
  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
  		$this->language->load('inventry/stb');
  		$this->load->model('inventry/stb');
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
 		$this->data['text_active'] = $this->language->get('text_active');
    	$this->data['text_not_active'] = $this->language->get('text_not_active');
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_sc'] = $this->language->get('entry_sc');
    	$this->data['entry_sw'] = $this->language->get('entry_sw');
    	$this->data['entry_hw'] = $this->language->get('entry_hw');
    	$this->data['entry_smart_card'] = $this->language->get('entry_smart_card');
    	$this->data['entry_box_type'] = $this->language->get('entry_box_type');
    	$this->data['entry_box_status'] = $this->language->get('entry_box_status');

    	$this->data['text_sc'] = $this->language->get('text_sc');
    	$this->data['text_not_sc'] = $this->language->get('text_not_sc');
    	$this->data['text_sd'] = $this->language->get('text_sd');
    	$this->data['text_hd'] = $this->language->get('text_hd');
    	$this->data['text_instock'] = $this->language->get('text_instock');
    	$this->data['text_rma'] = $this->language->get('text_rma');
	
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
    	$this->data['token'] = $this->session->data['token'];

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		//--------------
		if (isset($this->error['sw'])) {
			$this->data['error_sw'] = $this->error['sw'];
		} else {
			$this->data['error_sw'] = '';
		}
		if (isset($this->error['hw'])) {
			$this->data['error_hw'] = $this->error['hw'];
		} else {
			$this->data['error_hw'] = '';
		}
		//--------------
 		if (isset($this->error['stb'])) {
			$this->data['error_stb'] = $this->error['stb'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['box_status'])) {
			$this->data['error_box_status'] = $this->error['box_status'];
		} else {
			$this->data['error_box_status'] = '';
		}

		if (isset($this->error['sc'])) {
			$this->data['error_sc'] = $this->error['sc'];
		} else {
			$this->data['error_sc'] = '';
		}
		if (isset($this->error['smart_card'])) {
			$this->data['error_smart_card'] = $this->error['smart_card'];
		} else {
			$this->data['error_smart_card'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('inventry/stb/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('inventry/stb/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	$this->data['box_status_options']=array(
    						'0' => $this->language->get('text_instock')
    						);
    	if(isset($this->request->get['stb_no'])){
    		$this->data['box_status_options']['1'] =$this->language->get('text_rma');
    	}
    	if (isset($this->request->get['stb_no']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$stb_info = $this->model_inventry_stb->getSTB($this->request->get['stb_no']);
      	}

      	$resultOperators = $this->model_inventry_stb->getOperators();
		foreach ($resultOperators as $operator) {
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}
			
    	if (isset($this->request->post['stb'])) {
      		$this->data['stb'] = $this->request->post['stb'];
		} elseif (!empty($stb_info)) { 
			$this->data['stb'] = $stb_info['stb_no'];
		} else {
      		$this->data['stb'] = '';
    	}

    	if (isset($this->request->post['sc'])) {
      		$this->data['sc'] = $this->request->post['sc'];
		}elseif (!empty($stb_info)) { 
			$this->data['sc'] = $stb_info['is_smart_card'];
		} else {
      		$this->data['sc'] = '';
    	}
    	if (isset($this->request->post['smart_card'])) {
      		$this->data['smart_card'] = $this->request->post['smart_card'];
		} elseif (!empty($stb_info)) { 
			$this->data['smart_card'] = $stb_info['sc_no'];
		} else {
      		$this->data['smart_card'] = '';
    	}

    	if (isset($this->request->post['sw'])) {
      		$this->data['sw_ver'] = $this->request->post['sw'];
		} elseif (!empty($stb_info)) { 
			$this->data['sw_ver'] = $stb_info['sw_version_no'];
		} else {
      		$this->data['sw_ver'] = '';
    	}

    	if (isset($this->request->post['hw'])) {
      		$this->data['hw_ver'] = $this->request->post['hw'];
		} elseif (!empty($stb_info)) { 
			$this->data['hw_ver'] = $stb_info['hw_version_no'];
		} else {
      		$this->data['hw_ver'] = '';
    	}
    	if (isset($this->request->post['box_type'])) {
      		$this->data['box_type'] = $this->request->post['box_type'];
		}elseif (!empty($stb_info)) { 
			$this->data['box_type'] = $stb_info['box_type'];
		} else {
      		$this->data['box_type'] = '';
    	}
    	if (isset($this->request->post['box_status'])) {
      		$this->data['box_status'] = $this->request->post['box_status'];
		}elseif (!empty($stb_info)) { 
			$this->data['box_status'] = $stb_info['box_status'];
		} else {
      		$this->data['box_status'] = '';
    	}

    	if (isset($this->request->post['filter_operator'])) {
      		$this->data['filter_operator'] = $this->request->post['filter_operator'];
		}elseif (!empty($stb_info)) {  
			$this->data['filter_operator'] = $stb_info['operator_id'];
		} else {
      		$this->data['filter_operator'] = '';
    	}

		$this->template = 'inventry/stb_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
  			
    	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('inventry/stb');

		if(!empty($_FILES)){
	    	if(is_uploaded_file($_FILES['filename']['tmp_name']))
	    	{
	    		$lines = count(file($_FILES['filename']['tmp_name'])); 
	    		$ext = pathinfo($_FILES['filename']['name'], PATHINFO_EXTENSION);
		  		if($ext!='csv'){
		  			$this->error['warning'] = "Warning: Invalid file format, Only .CSV files are accepted!";
		  		}elseif( $lines > 1001){
					$this->error['warning'] = "Can't process csv, records count is more than 1000.!";
				}
			}
    	}else{
		    	if(preg_match("#^[a-zA-Z0-9 ]+$#", $this->request->post['stb']) && !isset($this->request->get['stb_no'])){
		    		$result = $this->model_inventry_stb->isSTBExist($this->request->post['stb']);
		    		$isSCNOExit = $this->model_inventry_stb->isSCNoExist($this->request->post['smart_card']);
			    	if ((strlen($this->request->post['stb'])!=14)){
			            $this->error['stb'] = $this->language->get('error_length');
			       	}
			        elseif($result)
			    	{
			    		$this->error['stb'] = $this->language->get('error_duplicate');
			    	}
		      	}else{
		      		$this->error['stb'] = $this->language->get('error_stb_not_exist');
		      	}

		      	if (!is_numeric($this->request->post['sw']) || $this->request->post['sw']=='' ) {
		      		$this->error['sw'] = $this->language->get('error_sw');
		    	}else if(!preg_match("/^[0-9]{1,2}(\.[0-9]{1,2})?$/", $this->request->post['sw'])){
		      		$this->error['sw'] = $this->language->get(' S/W Version accept two decimal value only (e.g:- 11.22)');
		      	}

		      	if(!is_numeric($this->request->post['hw']) || $this->request->post['hw']==''){
		    		$this->error['hw'] = $this->language->get('error_hw');
		    	}else if(!preg_match("/^[0-9]{1,2}(\.[0-9]{1,2})?$/", $this->request->post['hw'])){
		    		$this->error['hw'] = $this->language->get('H/W Version accept two decimal value only (e.g:- 11.22)');
		    	}

		     //  	if (!is_numeric($this->request->post['sw']) || $this->request->post['sw']=='' ) {
		     //  		$this->error['sw'] = $this->language->get('error_sw');
		    	// }
		    	// if(!is_numeric($this->request->post['hw']) || $this->request->post['hw']==''){
		    	// 	$this->error['hw'] = $this->language->get('error_hw');
		    	// }
		    	if($this->request->post['sc']==1)
		    		if ((strlen($this->request->post['smart_card'])!=16)){
		            	$this->error['smart_card'] = "Smart card no is mandatory, Length should be 16!";
		       		 }
		       		elseif($isSCNOExit!='')
			    	{
			    		$this->error['smart_card'] = "Duplicate smart card number!";
			    	}elseif (preg_match('/[^a-z0-9]/i', $this->request->post['smart_card'])) {
			    		$this->error['smart_card'] = "Special Characters not allowed!";
			    	}
		    }
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	if(!isset($this->request->post['selected']))
    		$this->error['warning'] =  $this->language->get('error_checkbox');

    	if(isset($this->request->post['selected'])){ 
    	foreach ($this->request->post['selected'] as $stb_no) { 
  			$stb_pair_info = $this->model_inventry_stb->checkSTBPairedBySTBNO($stb_no);
  			if ($stb_pair_info!=NULL) { 
	  			$this->error['warning'] = "STB is paired with user!";
  				}
  			}
  		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateBlacklist() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('inventry/stb');
    	if (isset($this->request->post['selected'])) {
    		foreach ($this->request->post['selected'] as $stb_no) {
    			$flag = $this->model_inventry_stb->CheckBlackList($stb_no);
    			if($flag)
    			{
    				$this->error['warning'] = $this->language->get('error_blacklist');
    			}
    		}
    	}
    	else{
    		// $this->error['warning'] =  $this->language->get('error_checkbox');
    	}
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
  	private function getSTBIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {

			 if($value['error']==false)
					
				return $value;
			 }
			 return 'id';
	}


	public function download()
	{
		$file='stblog.txt';
		header('Content-Description: File Transfer');
      	header('Content-Type: application/pdf');
      	header('Content-Disposition: attachment; filename='.basename($file));
      	header('Content-Transfer-Encoding: binary');
      	header('Expires: 0');
      	header('Cache-Control: must-revalidate');
      	header('Pragma: public');
      	header('Content-Length: ' . filesize($file));
      	ob_clean();
      	flush();
      	readfile($file);
	         
	} 

	public function validateUpdateForm(){
		if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('inventry/stb');

		if($this->request->post['box_status']==1){
	   		if($this->model_inventry_stb->isSTBActive($this->request->post['stb'])){
	   			$this->error['box_status'] = $this->language->get('error_box_status');	
	   		}
		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}

	}

	public function upload_bulk_stb() {
  		$obj = new restapi();
		$this->language->load('inventry/stb');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb');
		$stb_list=array();
		$stb_sw_hw=array();
		$stb_list_details=array();
		$stb_error=array();
		$error_array = array();
		

		if (($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateFile())) {

			$apimessage='';
    		$errorMsg="KMS Failed! ";
    		$error=true;	
    		$flag=false;
    		$stb=array();
    		$stb_input=array();
    		$stbArr=array();
    		$skip=1;
    		$i=1;
    		if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
$log_separator = "-------------------------------------\n";
$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
$current_date = $currDate->format('d-M-Y H:i:s');	
$file_name = DIR_ADMIN_LOGS."Bulk_Stb_LogList/".$current_date.".txt";
file_put_contents($file_name, $log_separator.$current_date."\n"  , FILE_APPEND);    			
			    $handle = fopen($_FILES['filename']['tmp_name'], "r");
			    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
			    	// echo "<pre>"; print_r($data); die;
			    	if($skip){
			    		$i++;
			    		$skip=0;
			    		continue;
			    	}else{ 
			    		if(count($data)!=5){
							$error_array['format']="Invalid Format.";
							file_put_contents($file_name, "Error at line: ".$data[0]."\t".$error_array['format']."\t".$current_date."\n", FILE_APPEND );
							$i++;
							continue;
						}else{
							/*if(!preg_match("/^[a-zA-Z0-9]{14}$/", $data[0]) 
					    		|| !preg_match("/^[0-9]{1,2}(\.[0-9]{1,2})?$/", $data[1])
					    		|| !preg_match("/^[0-9]{1,2}(\.[0-9]{1,2})?$/", $data[2])
					    		|| !preg_match("/^\-1$/i", $data[3])
					    		|| !preg_match("/^[0-1]{1}$/", $data[4])
					    		|| !preg_match("/^[1-9]\d{0,2}$/", $data[5]))
							 	{		
							 		file_put_contents($file_name, "Error at line: ".$data[0]."\tInvalid Stbno.\t".$today."\n", FILE_APPEND );
							 		$i++;
									continue;
								}*/	 
								if(!preg_match("/^[a-zA-Z0-9]{14}$/", $data[0])){
									file_put_contents($file_name, "Error at line: ".$data[0]."\tInvalid STB No : ".$data[0]."\n", FILE_APPEND );
									$i++;
									continue;
								}elseif(!preg_match("/^[0-9]{1,2}(\.[0-9]{1,2})?$/", $data[1])){
									file_put_contents($file_name, "Error at line: ".$data[0]."\tInvalid s/w version :".$data[1]."\n", FILE_APPEND );
									$i++;
									continue;
								}elseif(!preg_match("/^[0-9]{1,2}(\.[0-9]{1,2})?$/", $data[2])){
									file_put_contents($file_name, "Error at line: ".$data[0]."\tInvalid h/w version :".$data[2]."\n", FILE_APPEND );
									$i++;
									continue;
								}/*elseif(!preg_match("/^\-1$/i", $data[3])){
									file_put_contents($file_name, "Error at line: ".$data[0]."\tInvalid SC No :".$data[3]."\n", FILE_APPEND );
									$i++;
									continue;
								}*/elseif(!preg_match("/^[0-1]{1}$/", $data[3])){
									file_put_contents($file_name, "Error at line: ".$data[0]."\tInvalid STB type:".$data[3]."\n", FILE_APPEND );
									$i++;
									continue;
								}elseif(!preg_match("/^[1-9]\d{0,2}$/", $data[4])){		
							 		file_put_contents($file_name, "Error at line: ".$data[0]."\tInvalid LCO id :".$data[4]."\n", FILE_APPEND );
							 		$i++;
									continue;
								}	 


						}
					    	$sw_hw=array();
						    $stb_input['stb']=trim($data[0]);
						    // $stb_input['sc_no']=trim($data[3],"'");
						    $stb_input['operator_id']=trim($data[4]);
						    array_push($sw_hw, trim($data[1]));
						    array_push($sw_hw, trim($data[2]));
						    array_push($sw_hw, 0);
				    		array_push($sw_hw, trim($data[3]));
				    		array_push($sw_hw, trim($data[4]));
					        array_push($stb_sw_hw,$sw_hw);
					        array_push($stb_list,$stb_input);
					}
				    reset($error_array);
				    $i++;
			    }


			    fclose($handle);
				$json_stb=json_encode($stb_list,JSON_FORCE_OBJECT);
			    $data="stb_list=".$json_stb;
		 		$method ="POST";
		 		$url=KMS_API."/enableStb";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME.':'.API_AUTH);
	        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
	        	
	      		$kms_stb_id="";
	    		$response=json_decode($apiresult,true);
				foreach ($response as $key => $value) {
					switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				case 'stb_list':
	    					$kms_stb_list=$value;	
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
	    			}
			 	}

			$count=0;
			

			foreach ($kms_stb_list as $stb) {
				$TodayDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
				$today = $currDate->format('d-m-Y H:i:s');
			 	if(strcmp($stb['resp'], 'ACK')==0)
			 	{
		        	$sms_stb_id=$this->model_inventry_stb->addSTB($stb,$stb_sw_hw[$count],-1);
			        $this->model_inventry_stb->addApiResponceId($stb['id'],$sms_stb_id);
		        	file_put_contents($file_name, $stb['stb_no']."\t".$stb['resp']."\t".$stb['message']."\n", FILE_APPEND );
			 	}else {
			 		file_put_contents($file_name, $stb['stb_no']."\t".$stb['resp']."\t".$stb['message']."\n", FILE_APPEND);
        			$flag=true;	
			 	}
			 	$count=$count+1;	
			}
			//------------make .gz file to download
			$gzfile = DIR_ADMIN_LOGS."Bulk_Stb_LogList/".$current_date.".gz";
			$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
			gzwrite($fp, file_get_contents($file_name, FILE_USE_INCLUDE_PATH));
			gzclose($fp);
			unlink($file_name);
				
			$url='';
			$this->session->data['success'] = "Please check the log file for detials!";//$this->language->get('success');
			$this->redirect($this->url->link('inventry/stb/upload_bulk_stb', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}
		}
      $this->getUploadForm();
  	}

  	protected function getUploadForm() {

    	if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		$data = array(
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

   		$total = $this->model_inventry_stb->getTotalLogList();
		$results = $this->model_inventry_stb->getBulkStbLogList($data);
		// var_dump($results);exit();
		$this->data['bulk_registration_log_list']=array();
		$count =0;
		if($results)
			foreach ($results as $result) {			
					$this->data['bulk_registration_log_list'][] = array(
						'name'    => $result['name'],
						'date'         => $result['date'],
						'download_url'	=> $result['download_url']
					);	
					$count++;
		}
		$total = $count;

		// if (!isset($this->request->get['customer_id'])) {
		// 	$this->data['action'] = $this->url->link('sale/customer/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		// } else {
		$this->data['upload_bulk_stb'] = $this->url->link('inventry/stb/upload_bulk_stb', 'token=' . $this->session->data['token'] . $url, 'SSL');
		//}
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 
		
    	$this->data['cancel'] = $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL');
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('inventry/stb/upload_bulk_stb', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();		

		$this->template = 'inventry/upload_bulk_stb.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
 }
?> 
