<?php 
 /*
@File cas.php(Controller)
ADMIN CAS PAGE
    This class manages the all the cas numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerInventryCAS extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the cas detail option in the dopdown list.
						It get all the cas number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin cas page showing all the cas number in a list.
*/
public function index() {
		$this->language->load('inventry/cas');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/cas');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the cas number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the cas number list.
*/

public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/cas', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);


   		$this->data['insert'] = $this->url->link('inventry/cas/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('inventry/cas/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');

		
		$this->data['cass'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		$total = $this->model_inventry_cas->getTotalCas();
		$results = $this->model_inventry_cas->getDetail($data);
		foreach ($results as $result) {			

			$action = array();
		
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('inventry/cas/update', 'token=' . $this->session->data['token'] . '&cas_id=' . $result['cas_id'] . $url, 'SSL')
			);

			$this->data['cass'][] = array(
				'customer_id'    => $result['customer_id'],
				'CASNO'          => $result['cas_id'],
				'id'          	 => $result['id'],
				'avail'          => ($result['is_avail'] ? $this->language->get('text_not_avail') : $this->language->get('text_avail')),
				'name'           => $result['name'],
				'smart_card'     => $result['smart_card_no'],
				'selected'       => isset($this->request->post['selected']) && in_array($result['cas_id'], $this->request->post['selected']),
				'action'         => $action
			);	
		}	
			
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_casno'] = $this->language->get('column_casno');
		$this->data['column_paired'] = $this->language->get('column_paired');
		$this->data['column_sc'] = $this->language->get('column_sc');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		}else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		//------------

		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('inventry/cas', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//------------
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'inventry/cas.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		$obj = new restapi();
		$this->language->load('inventry/cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/cas');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
      	  	$temp=$this->request->post;
      	  	if($temp['sc']==0)
      	  	{	
      	  		$data="cas_no=".$temp['cas']."&sc_no=-1";
      		}
      		else{
      			$data="cas_no=".$temp['cas']."&sc_no=".$temp['smart_card'];	
      		}
	 		$method ="POST";
	 		$url=KMS_API."/enableCas";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
    		$kms_cas_id="";
    		$temp=json_decode($apiresult);
    		$apimessage='';
    		$errorMsg="KMS Failed! ";

			foreach ($temp as $key => $value) {
			 	if($key=='id')
			 	{	
		   		 	$kms_cas_id=$value;
			 	}
			 	if($key=='error'&&$value==false)
				{
					$error=false;
				}if($key=='error'&&$value==true)
				{
					$error=true;	
				}if($key=='message')
				{
					$apimessage=$value;			
				}if($key!='id' && $key!='error')
				{
					$errorMsg=$errorMsg." ".$key.":".$value;
				}
			 }
    		
		  	if(!$error)
		  	{
		  		$temp=$this->model_inventry_cas->addCAS($this->request->post);
    		 	$result = $this->model_inventry_cas->getCAS($this->request->post['cas']);
    		 	$sms_cas_id=$result['id'];
    			$this->model_inventry_cas->addApiResponceId($kms_cas_id,$sms_cas_id);
		 		$this->session->data['success'] = $apimessage;
			
				$url = '';
								
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				$this->redirect($this->url->link('inventry/cas', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    		 }
    		 else{
		 		$this->error['warning']=$errorMsg;
		 		$this->getForm();
    		}		
		}
    	
    	$this->getForm();
  	} 
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
		$this->language->load('inventry/cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/cas');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_inventry_cas->editCAS($this->request->get['cas_id'], $this->request->post);
	  		
			$this->session->data['success'] = $this->language->get('text_success');
	  
			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('inventry/cas', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		$obj = new restapi();
		$this->language->load('inventry/cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/cas');
    	if (isset($this->request->post['selected']) && $this->validateDelete()) {
    		//check if the cas is paired with any customer or not. write code
    		$error_encounter=0;
    		$flag=false;
    		$errorMsg='';
			foreach ($this->request->post['selected'] as $cas_id) {
				$x = $this->model_inventry_cas->getCAS($cas_id);
				$p = $this->model_inventry_cas->getApiResponceId($x['id']);
				$data="cas_id=".$p['kms_cas_id'];	
		 		$method ="POST";
		 		$url=KMS_API."/disableCas";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
	        	$response=json_decode($apiresult);
	        	$error=true;
	        	foreach ($response as $key => $value) {
		        	if((strcmp($key,"error")==0) && $value==false){
						$error=false;
					}if($key=='message'){
						$apimessage=$value;
					}
					if($key!='id' && $key!='error' && $key!='mq_response' && $key!='message'){
						$errorMsg=$errorMsg." ".$key." :".$value;
					}
				}
    			if($error){
    				$error_encounter=1;
    				$errorMsg=$errorMsg." ".$key." :".$apimessage;
    			}else{
    				$flag=true;
    				$this->model_inventry_cas->deleteCAS($cas_id);
    			}
	  		}
	  		if($error_encounter)
	  		{		
				if($flag)
	  				$this->session->data['warning'] =$this->language->get('text_warning_partial_delete').' ('.$errorMsg.')';
		  		else
		  			$this->session->data['warning'] =$errorMsg;
			  	$this->redirect($this->url->link('inventry/cas', 'token=' . $this->session->data['token'], 'SSL'));
			}else{
				$this->session->data['success'] =$this->language->get('text_delete_success');//"Success: CAS deleted sucessfully!";//$this->language->get('text_success_deleted');
				$this->redirect($this->url->link('inventry/cas', 'token=' . $this->session->data['token'], 'SSL'));				
			}
    	}else
    		$this->error['warning'] = $this->language->get('error_checkbox');
    	$this->getList();
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the (insert)ion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_cas'] = $this->language->get('entry_cas');
    	$this->data['entry_sc'] = $this->language->get('entry_sc');
    	$this->data['entry_smart_card'] = $this->language->get('entry_smart_card');
    	$this->data['text_sc'] = $this->language->get('text_sc');
    	$this->data['text_not_sc'] = $this->language->get('text_not_sc');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['cas'])) {
			$this->data['error_cas'] = $this->error['cas'];
		} else {
			$this->data['error_cas'] = '';
		}
		if (isset($this->error['smart_card'])) {
			$this->data['error_smart_card'] = $this->error['smart_card'];
		} else {
			$this->data['error_smart_card'] = '';
		}

		if (isset($this->error['sc'])) {
			$this->data['error_sc'] = $this->error['sc'];
		} else {
			$this->data['error_sc'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/cas', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['cas_id'])) {
			$this->data['action'] = $this->url->link('inventry/cas/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('inventry/cas/update', 'token=' . $this->session->data['token'] . '&cas_id=' . $this->request->get['cas_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('inventry/cas', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['cas_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$cas_info = $this->model_inventry_cas->getCAS($this->request->get['cas_id']);
    	}
			
    	if (isset($this->request->post['cas'])) {
      		$this->data['cas'] = $this->request->post['cas'];
		} elseif (!empty($cas_info)) { 
			$this->data['cas'] = $cas_info['cas_id'];
		} else {
      		$this->data['cas'] = '';
    	}

    	if (isset($this->request->post['sc'])) {
      		$this->data['sc'] = $this->request->post['sc'];
		}elseif (!empty($cas_info)) { 
			$this->data['sc'] = $cas_info['is_smart_card'];
		} else {
      		$this->data['sc'] = '';
    	}
    	if (isset($this->request->post['smart_card'])) {
      		$this->data['smart_card'] = $this->request->post['smart_card'];
		} elseif (!empty($cas_info)) { 
			$this->data['smart_card'] = $cas_info['smart_card'];
		} else {
      		$this->data['smart_card'] = '';
    	}
		
		$this->template = 'inventry/cas_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'inventry/cas')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

 
		$this->load->model('inventry/cas');
    	if(!isset($this->request->get['cas_id'])){


    		$x = $this->model_inventry_cas->getCAS($this->request->post['cas']);
    	 if ((strlen($this->request->post['cas'])!=16)){
            $this->error['cas'] = "length error";
       		 }
       	 elseif($x && $x['cas_id'])
    		{
    	 		$this->error['cas'] = "Duplicate";	
    		}
    	if($this->request->post['sc']==1)
    		if ((strlen($this->request->post['smart_card'])!=16)){
            	$this->error['smart_card'] = "length error";
       		 }
      }
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'inventry/cas')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	 
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	} 

  		private function getUserIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
		
				return $value;
			 }

			 return;
	} 


 }
?> 