<?php 
 /*
@File box_activation.php(Controller)
ADMIN BoxActivation PAGE
    This class manages the all the BoxActivation  status.
    

@Author Mahesh Yallure 
@date 19 Jan. 2016
*/
class ControllerInventryBoxActivation extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
public function index() {
		$this->language->load('inventry/box_activation');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/box_activation');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the transaction list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['insert'] = $this->url->link('inventry/box_activation/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');

		$this->data['stb_activations'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_inventry_box_activation->getTotalStbActivations();

		$results = $this->model_inventry_box_activation->getActivationTransactions($data);
		foreach ($results as $result) 
		{	
			$resend = $this->url->link('inventry/box_activation/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
			$de_activation = $this->url->link('inventry/box_activation/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
			
			$this->data['stb_activations'][] = array(
				'id'  		 	 => $result['id'],
				'tx_id'  		 => $result['tx_id'],
				'customer_id'    => $result['user_id'],
				'name'           => $result['name'],
				'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
				'type'         	 => (($result['cmd_id']==0)?'Activation' :'De-Activation'),
				'cmd_id'         => $result['cmd_id'],
				'resend'         => $resend,
				'de_activation'  => $de_activation,
				'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_cust_id'] = $this->language->get('column_cust_id');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('inventry/box_activation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'inventry/box_activation.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		
		$obj = new restapi();
		$this->language->load('inventry/box_activation');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/box_activation');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if($this->validateForm($this->request->post)) {

		  		$customer_id = $this->model_inventry_box_activation->getCustomerId($this->request->post['stb_no']);
			    $data="stb_no=".$this->request->post['stb_no']."&xor_chipno=".$this->request->post['chip_no'];
		 		$method ="POST";
		 		$url=KMS_API."/enableSTBActivation";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
	    		$response=json_decode($apiresult);
	    		$apimessage='';
	    		$errorMsg="";
	    		$error=true;	
	    		$cmd_id=0;
	    		
				foreach ($response as $key => $value) {
					switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				case 'id':
	    					$id=$value;	
	    					break;
	    				case 'mq_response':
	    					$curlresponse=$value;
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
	    			}
				}
				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					$resp=split('`', $curlresponse);
					$payload=$this->request->post['stb_no']."#".$this->request->post['chip_no'];
					$target=1;
					$results = $this->model_inventry_box_activation->addToCasOpTransanction($customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload);
					$this->session->data['success']=$apimessage;
					$url = '';
									
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}

					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}

					if (isset($this->request->get['page'])) {
						$url .= '&page=' . $this->request->get['page'];
					}
					$this->redirect($this->url->link('inventry/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'));
				}else{
					$this->error['warning']=$errorMsg;
			 		$this->getForm();
				}
			}
		}
    	
    	$this->getForm();
  	} 

 /*
FUNCTION NAME 		-	resend
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function resend() {

		$this->language->load('inventry/box_activation');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/box_activation');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{
    		
     		$transaction_details=$this->model_inventry_box_activation->getTransactionDetails($this->request->get['id']);
     		$customer_id=$transaction_details['user_id'];
    		$user_id=$transaction_details['api_user_id'];
    		$target_lvl=1;
    		$trans_id=$transaction_details['tx_id'];
    		$cmd_id=$transaction_details['cmd_id'];
    		
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;
		  	$method ="POST";
			$uri=KMS_API."/Resend";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);			
		    $error=true;
		    $errorMsg='';
		    $apimessage=" Kms fail to enable STB";

		    foreach ($response as $key => $value) {
		    	switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$id=$value;	
    					break;
    				case 'mq_response':
    					$curlresponse=$value;
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$payload=$user_id."#".$cmd_id."#".$trans_id;
				$target=1;
				$targetdata=0;
				$results = $this->model_inventry_box_activation->addToCasOpTransanction($customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload);
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
		}
     	$this->redirect($this->url->link('inventry/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  	}  

/*
FUNCTION NAME 		-	deActivation
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function deActivation() {
		$this->language->load('inventry/box_activation');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/box_activation');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{
    		
     		$transaction_details=$this->model_inventry_box_activation->getTransactionDetails($this->request->get['id']);
     		$customer_id=$transaction_details['user_id'];
    		$user_id=$transaction_details['api_user_id'];
    		$target_lvl=1;
    		$trans_id=$transaction_details['tx_id'];
    		$cmd_id=$transaction_details['cmd_id'];
    		
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;
		  	$method ="POST";
			$uri=KMS_API."/Disable";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);			
		    $error=true;
		    $errorMsg='';
		    $apimessage=" Kms fail to enable STB";

		    foreach ($response as $key => $value) {
		    	switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$id=$value;	
    					break;
    				case 'mq_response':
    					$curlresponse=$value;
    					break;
    				case 'disble_command_id':
    					$cmd_id=$value;
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$payload=$user_id."#".$cmd_id."#".$trans_id;
				$target=1;
				$targetdata=0;
				$results = $this->model_inventry_box_activation->addToCasOpTransanction($customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload);
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
		}
     	$this->redirect($this->url->link('inventry/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_chip_no'] = $this->language->get('entry_chip_no');
    	$this->data['entry_confirm_chip_no'] = $this->language->get('entry_confirm_chip_no');
 	
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['chip_no'])) {
			$this->data['error_chip_no'] = $this->error['chip_no'];
		} else {
			$this->data['error_chip_no'] = '';
		}

		if (isset($this->request->post['chip_no'])) {
      		$this->data['chip_no'] = $this->request->post['chip_no'];
		}else {
      		$this->data['chip_no'] = '';
    	}

    	if (isset($this->request->post['confirm_chip_no'])) {
      		$this->data['confirm_chip_no'] = $this->request->post['confirm_chip_no'];
		}else {
      		$this->data['confirm_chip_no'] = '';
    	}

    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('inventry/box_activation/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('inventry/box_activation/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('inventry/box_activation/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	// $this->data['stbs']=array();
	    	// $stb_info = $this->model_inventry_box_activation->getSTBs();
	    	// foreach ($stb_info as $stb) {
	    	// 	$this->data['stbs'][] = array('stb_id' => $stb['id'],
	    	// 								  'stb_no' => $stb['stb_no'],
	    	// 								  'customer_id' => $stb['customer_id'],
	    	// 								  'name' => $stb['name']);
	    	// }
    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'inventry/box_activation_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'inventry/box_activation')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
			$this->load->model('inventry/box_activation');
    	$stb_no=$post['stb_no'];
    	if($stb_no){
    		$result = $this->model_inventry_box_activation->isSTBPaired($stb_no);
	    	if ((strlen($stb_no)!=12)){
	            $this->error['stb_no'] = $this->language->get('error_length');
	       	}
	        elseif(!$result)
	    	{
	    		$this->error['stb_no'] = $this->language->get('error_stb_pair');
	    	}
      	}
		
		if(strcmp($post['chip_no'], $post['confirm_chip_no'])!==0)
		{
			$this->error['chip_no'] = $this->language->get('error_chip_no');
		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'inventry/box_activation')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('inventry/box_activation');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_inventry_box_activation->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}
 }
?> 