<?php    
/*
@File not_found.php(Controller)
ADMIN NOT_FOUND PAGE
    This class manages the not_found page when the page requested is not there 
    on the path

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerErrorNotFound extends Controller {  
/*
FUNCTION NAME     - index
DESCRIPTION       - Loads when the requested page is not there on the asked path. 
INPUT PARAMETER   - void
OUTPUT PARAMETER  - Rendering of the not_found page
*/  
	public function index() { 
    	$this->language->load('error/not_found');
 
    	$this->document->setTitle($this->language->get('heading_title'));

    	$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_not_found'] = $this->language->get('text_not_found');

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('error/not_found', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

		$this->template = 'error/not_found.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());	
  	}
}
?>