<?php 
 /*
@File box_reset.php(Controller)
ADMIN BoxReset PAGE
    This class manages the all the BoxReset  status.
    

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ControllerCommandsSpecialCommands extends Controller {
	private $error = array();

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
public function index() {
		$this->language->load('commands/special_commands');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/special_commands');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the transaction list.
*/
public function getList() {	
	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['target_level'])) {
			$target_level = $this->request->get['target_level'];
		} else {
			$target_level = '';
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
		} else {
			$filter_value = '';
		}
				
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/special_commands', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['target_level'])) {
			$url .= '&target_level=' . $this->request->get['target_level'];
		}
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

    	if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
  			
		
   		
		$this->data['insert'] = $this->url->link('commands/special_commands/insert', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['special_commands'] = array();
		$data = array(
			'target_level'	  => $target_level,
			'filter_value'	  => $filter_value,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->post['target_level'])) {
			$this->data['target_level'] = $this->request->post['target_level'];
		} else if (isset($this->request->get['target_level'])) {
			$this->data['target_level'] = $this->request->get['target_level'];
			$this->session->data['target_level']=$this->data['target_level'];
		}else {
			$this->data['target_level'] =-1;
		}

		// if(isset($this->session->data['target_level']))
			// $this->data['target_level']=$this->session->data['target_level'];
		
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
			$data['target_level']=$this->data['target_level'];
		} else if (isset($this->request->post['filter_value'])) {
			$this->data['filter_value'] = $this->request->post['filter_value'];
		} else{
			$this->data['filter_value'] = '';
			
		}
		$total=0;
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['target_level']))||(isset($data['target_level']) && $data['target_level']!=-1))
		{
		$total = $this->model_commands_special_commands->getTotalboxReset($data);

		$results = $this->model_commands_special_commands->getBoxReset($data);

		foreach ($results as $result) 
		{	
			$resend = $this->url->link('commands/special_commands/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');

				if($result['cmd_type']==0)
				{
				$cmd_type = 'Box Reboot';
				}
				elseif ($result['cmd_type']==1) 
		        {
				  $cmd_type='Msg_Id_Reset';
			    }
			    elseif($result['cmd_type']==2)
				{
				$cmd_type = 'PinReset';
				}
				elseif($result['cmd_type']==3)
				{
				$cmd_type='Black List';
				}
				elseif($result['cmd_type']==4)
				{
				$cmd_type='OSD Disable';
				}
				elseif($result['cmd_type']==5)
				{
				$cmd_type='Factory Reset';
				}
				elseif($result['cmd_type']==6)
				{
				$cmd_type='Network ID Reset';
				}
				else
				{
				$cmd_type='Unknown Special Command';	
				}
				// var_dump($cmd_type);exit();
			$this->data['special_commands'][] = array(
				'id'  		 	 => $result['id'],
				'tx_id'  		 => $result['tx_id'],
				'trigger_on'     => $result['modify_date'],
				'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
				'type'         	 => (($result['cmd_id']==16)?'Activation' :'DeActivation'),
				'cmd_id'         => $result['cmd_id'],
				'stb_no'         => $result['user_id'],
				'cmd_type'       => $cmd_type,
				'resend'         => $resend,
				// 'de_activation'  => $de_activation,
				'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);	
		}
	}
		$this->data['targets']=array(
			'-1' => 'Please select',
			'1'  => 'Individual',
			'4'  => 'Group',
			'3'  => 'Region',
			'2'  => 'Global'
			);

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_cmd_type'] = $this->language->get('column_cmd_type');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['target_level'])) {
			$this->data['error_target_level'] = $this->error['target_level'];
		}else{
			$this->data['error_target_level'] ='';
		}

		if (isset($this->error['user_data'])) {
			$this->data['error_user_data'] = $this->error['user_data'];
		}else{
			$this->data['error_user_data'] ='';
		}
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/special_commands', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/special_commands.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}
	  	/*
	FUNCTION NAME 		-	insert
	DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
							details of the new review. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
	*/  
	public function save() {

				$this->language->load('commands/special_commands');
				$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('commands/special_commands');
				$this->load->model('commands/bmail');
				if ($this->request->server['REQUEST_METHOD'] == 'POST') {
					if($this->validateForm($this->request->post)) {

						//---------
						$target_level=$this->request->post['target_level'];
		  		$target="";
		  		$log_target="";
		  		switch ($target_level) {
		  			case 1:
		  				$log_target_level = "Individual";
		  				$log_target_level_numeric = 1;
		  				$log_target = $this->request->post['target'];
		  				
		  				$customer_id =$this->model_commands_bmail->getCustomerId($this->request->post['target']);
		 	  			$target=(int)$customer_id["api_user_id"];
		 	  			$local_target=(int)$customer_id["customer_id"];
		 	  			$operator_id=(int)$customer_id["operator_id"];
		  			break;	
		  			case 2:
		  				$log_target_level = "Global";
		  				$log_target_level_numeric = 2;
		  				$log_target = "NA";

		  				$target=0;
		  				$local_target=0;
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			case 3:
		  				$log_target_level = "Regional";
		  				$log_target_level_numeric = 3;
		  				$log_target = $this->request->post['target'];

		  				$target=$this->request->post['target'];
		  				$local_target=$this->request->post['target'];
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			case 4:
		  				$log_target_level = "Group";
		  				$log_target_level_numeric = 4;
		  				$log_target = $this->request->post['target'];

		  				$group_ids=$this->model_commands_bmail->getGroupIdByname($this->request->post['target']);
		  				$target= $group_ids['kms_group_id'];
		  				$local_target=$group_ids['sms_group_id'];
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			default:
		  				break;
		  		}
						//---------
				 	$cmd_type= $this->request->post['cmd_type'];
					$obj = new restapi();
					$data="target_level=".$target_level."&target=".$target."&cmd_type=".$cmd_type;
					$method ="POST";
					$url="".KMS_API."/SpecialCommands";
				    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				    
				    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
					   //Process API response and add to db
				    $response=json_decode($apiresult);
		    		$apimessage='';
		    		$errorMsg='';
					$apimessage ="";
					$curlresponse="";
					foreach ($response as $key => $value) {
						switch ($key) {
				    		case 'error':
				    			$error=$value;	
				    		break;
				    		case 'id':
				    			$id=$value;	
				    		break;
				    		case 'message':
				    			$apimessage=$value;	
				    		break;
				    		case 'mq_response':
				    			$curlresponse=$value;	
				    		break;
				    		default:
				    			$errorMsg=$errorMsg." ".$key.":".$value;		
				    		break;
				    	}
					}
					// var_dump($apiresult);die;
					$ack_is=-1;$nack_is=-1;
					if(!$error)
					{
					$resend_status = 0;
					$commandid = 16;
					switch ($cmd_type) {
						case 0:	$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Box Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
								break;
						case 1: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Msg Id Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
								break;
						case 2: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Pin Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
								break;
						case 3: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Black List",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
								break;
						case 4: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Disable OSD",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
								break;
						case 5: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Factory Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
								break;
						case 6: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Network ID Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
								break;
									
						default:
								break;
					}
					
					
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
						if($ack=='ACK')
						{
							$ack_is=1;
						}elseif($ack=='NACK'){
							$nack_is=-1;
						}
						if(((int)$cmd_type)==3)
						{
						$this->load->model('inventry/stb');
						$temp=$this->model_inventry_stb->blacklistSTB($log_target);
					
						}
						$payload=$cmd_type;
						// $target1=(int)$customer_id["customer_id"];
						$this->model_commands_special_commands->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id,$cmd_type);
						$this->session->data['success'] = $apimessage;
						$url = '';
						$this->redirect($this->url->link('commands/special_commands', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['target'], 'SSL'));
	
					}else{
						$errorMsg=$errorMsg." ".$apimessage;
						$this->session->data['warning']="In CAS :".$apimessage;//$errorMsg;
						$url = '';
						$this->redirect($this->url->link('commands/special_commands', 'token=' . $this->session->data['token'] . $url, 'SSL'));
						
					}
				}
				else{
				$this->data['special_command_target']=array('target_level' =>$this->request->post['target_level'],
											'target'         =>$this->request->post["target"]);
				}
			}
			$this->getForm();
		}
		  	/*
		FUNCTION NAME 		-	insert
		DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
								details of the new review. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
		*/ 
		public function insert() {
			$obj = new restapi();
			$this->language->load('commands/special_commands');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('commands/special_commands');
			if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validateInsertForm($this->request->post))) {

				$this->data['special_command_target']=array('target_level' =>$this->request->post['target_level'],
													'target'         =>$this->request->post['filter_value']);
				$this->getForm();
			}else{
				$this->getList();
			}
		} 




 	/*
FUNCTION NAME 		-	validateInsertForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateInsertForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/special_commands')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/special_commands');
		switch ($this->request->post['target_level']) {
			case 1:
				if($this->request->post['filter_value']=='')
				{
					$this->error['user_data']='Please enter STB no ';	
				}else if(strlen($this->request->post['filter_value'])!=14){
					$this->error['user_data']='STB no should be 14 digit ';	
				}elseif($this->model_commands_special_commands->isSTBBlackListed($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is Blacklisted.";
	    		}elseif($this->user->isStbSuspend($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is suspended, Please resume first.!";
	    		}else{
					$stb=$this->model_commands_special_commands->isStbExistedAndPaired($this->request->post['filter_value']);
					if(!isset($stb['customer_id']))
					{
						$this->error['user_data']='Invalid STB no';
					}else if (isset($stb['customer_id'])) {
						if(!$stb['customer_id']>0)
							$this->error['user_data']='STB no is not paired with user';
					}

					$lcoId  = $this->user->getOperatorIdFromStbno($this->request->post['filter_value']);
			 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
			 		if($is_lco_suspend==1){
			 			$this->error['user_data'] = $this->language->get('STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
			 		}

			 		$is_RMA = $this->user->isStbRMA($this->request->post['filter_value']);
			 		if($is_RMA==1){
			 			$this->error['user_data'] = $this->language->get('STB in RMA state.!');		
			 		}
				}
				break;
			case 2:
				
				break;
			case 3:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter pin code ';
				else if(strlen($this->request->post['filter_value'])!=6)
					$this->error['user_data']='Pin code must be 6 digits';
				else{
					$pin=$this->model_commands_special_commands->checkPinExist($this->request->post['filter_value']);
					if(!$pin)
						$this->error['user_data']='Invalid PIN code';
				}
				break;
			case 4:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter group name';
				else {
					$group=$this->model_commands_special_commands->checkGroupExists($this->request->post['filter_value']);
					if(!$group)
						$this->error['user_data']='Invalid group name';	
				}
				break;    			
			default:
				$this->error['target_level']='Please select target ';
				break;
		}

		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	}  


 /*
FUNCTION NAME 		-	resend
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function resend() {

		$this->language->load('commands/special_commands');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/special_commands');
  		$this->load->model('commands/special_commands');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{
     		$transaction_details=$this->model_commands_special_commands->getTransactionDetails($this->request->get['id']);
     		// var_dump($transaction_details);exit();
     		//-----
     		$customer_id=$transaction_details['user_id'];
    		$target_lvl=$transaction_details['target_level'];
    		$trans_id=$transaction_details['tx_id']; 
    		$cmd_id=$transaction_details['cmd_id'];
    		$operator_id=$transaction_details['operator_id'];

    		switch ($target_lvl) {
    			case 1:
    					$target=$this->model_commands_special_commands->getKMSUserId($transaction_details['user_id']);
    					$targ_value=$this->model_commands_special_commands->getSTBno($transaction_details['user_id']);

    					$log_target_level = "Individual";
    					$log_target_level_numeric = 1;
    					$log_target = $targ_value["STBNO"];

    			break;
    			case 2:
    					$target=0;
    					$targ_value=0;
    					$log_target_level = "Global";
    					$log_target_level_numeric = 2;
    					$log_target = "NA";
    			break;
    			case 3:
    					$transaction_details=$this->model_commands_special_commands->getTransactionDetailsRegion($this->request->get['id']);
    					$target=$transaction_details['user_id'];
    					$targ_value=$target;
    					$log_target_level = "Regional";
    					$log_target_level_numeric = 3;
    					$log_target = $targ_value;
    			break;
    			case 4:
    					$transaction_details=$this->model_commands_special_commands->getTransactionDetailsGroup($this->request->get['id']);
    					$target=$this->model_commands_special_commands->getKMSGroupId($transaction_details['user_id']);
    					$targ_value=$this->model_commands_special_commands->getGroupNameById($transaction_details['user_id']);

    					$log_target_level = "Group";
    					$log_target_level_numeric = 4;
    					$log_target = $targ_value;
    			break;
    		}

     		//------
     	// 	$customer_id=$transaction_details['user_id'];
    		// $user_id=$transaction_details['api_user_id'];
    		// $operator_id=isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
    		// $target_lvl=1;
    		// $trans_id=$transaction_details['tx_id']; 
    		// $cmd_id=$transaction_details['cmd_id'];
    		$cmd_type=$transaction_details['cmd_type'];
    		
		  	// $data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$target."&target_level=".$target_lvl;
		  	$method ="POST";
			$uri=KMS_API."/Resend";	
			
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
			// var_dump($apiresult);exit();
		    //Process API response and add to db 
		    $response=json_decode($apiresult);	

		    $error=true;
		    $errorMsg='';
		    $apimessage="";
		    $curlresponse="";
		    foreach ($response as $key => $value) {
		    	switch ($key) {
		    		case 'error':
		    			$error=$value;	
		    		break;
		    		case 'id':
		    			$id=$value;	
		    		break;
		    		case 'message':
		    			$apimessage=$value;	
		    		break;
		    		case 'mq_response':
		    			$curlresponse=$value;	
		    		break;
		    		default:
		    			$errorMsg=$errorMsg." ".$key.":".$value;		
		    		break;
		    	}
			}
			// $log_target_level="Individual";
			// $log_target = $this->model_commands_special_commands->getSTBno($transaction_details['user_id']);
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{
			$resend_status = 1;
			$commandid = 16;
			switch ($cmd_type) {
				case 0:	$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND Box Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
						break;
				case 1: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND Msg Id Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
						break;
				case 2: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND Pin Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
						break;
				case 3: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND Black List",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
						break;
				case 4: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND OSD Disable",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
						break;
				case 5: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND Factory Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
						break;	
			    case 6: $this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND Network ID Reset",$resend_status,$commandid,$log_target_level_numeric,$cmd_type);
						break;				
				default:
						break;
			}
			
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$payload=$user_id."#".$cmd_id."#".$trans_id;
				$target=1;
				$targetdata=0;
				$results = $this->model_commands_special_commands->addToCasOpTransanction($target_lvl,$customer_id,$id,$payload,$ack_is,$nack_is,$operator_id,$cmd_type);

				
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
		}
		$this->session->data['warning'] = $this->error['warning'];
     	$this->redirect($this->url->link('commands/special_commands', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  	}  


/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
 	
		$this->data['button_save'] = $this->language->get('button_send');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
    	$this->data['column_cmd_type'] = $this->language->get('column_cmd_type');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/special_commands', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/special_commands/save', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/special_commands/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/special_commands/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	// $this->data['stbs']=array();
	    	// $stb_info = $this->model_inventry_box_activation->getSTBs();
	    	// foreach ($stb_info as $stb) {
	    	// 	$this->data['stbs'][] = array('stb_id' => $stb['id'],
	    	// 								  'stb_no' => $stb['stb_no'],
	    	// 								  'customer_id' => $stb['customer_id'],
	    	// 								  'name' => $stb['name']);
	    	// }
    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'commands/special_commands_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/bmail')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/bmail');
		if($this->request->post['target_level']==1)
    	{
	    	$stb_no=$this->request->post['target'];
	    	if($stb_no){
	    		$isActive = $this->model_commands_special_commands->isSTBActivated($stb_no);
	    		$result = $this->model_commands_bmail->isSTBPaired($stb_no);
		    	if ((strlen($stb_no)!=14)){
		            $this->error['stb_no'] = $this->language->get('error_length');
		       	}
		        elseif($result["customer_id"]==0)
		    	{
		    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
		    	}elseif($isActive==1&& ($this->request->post['cmd_type']==3)){ 
    				$this->error['stb_no'] = "Please deactivate the STB before blacklisting!";
    				// return false;
    			}
	      	}
			else
			{
				$this->error['stb_no']="STB Field empty!";
			}
		}

		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	}  		 
 

  	/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/special_commands')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

    	// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		$stb_no = $this->model_commands_special_commands->getStbNoFromId($this->request->get['id']);
		
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_special_commands->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
	 		}

			$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}

	 		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB in RMA state.!');		
	 		}	 		
	 	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/special_commands');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_special_commands->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function decTohexAndMsb($target,$no_ofbits)
		{
		$target=dechex($target);
		$target=str_pad($target, $no_ofbits, '0', STR_PAD_LEFT);
    	$msblsb='';
    	for ($k=strlen($target); $k >0 ; $k-=2) { 
    		$msblsb.=substr($target,$k-2,2);
    	}
    	return $msblsb;
		}

	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id,$log_target_level_numeric,$cmd_type){		
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	// var_dump($log_target_level);exit();
    	$log_target = (strlen($log_target)<22)?str_pad($log_target,24," "):substr($log_target, 0,22).".";
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").$log_target.$command);
        fclose($log_file);


        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level_numeric,$log_target,$command_id,$resend_status,$cmd_type);
    }


 }
?> 