<?php 
 /*
@File parental_rating.php(Controller)
ADMIN Parental Rating PAGE
    This class manages the all the Parental Rating list and status.
    

@Author Ravi Ranjan 
@date 20 Jun. 2016
*/
class ControllerCommandsParentalRating extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
	public function index() {
		$this->language->load('commands/parental_rating');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/parental_rating');
    	$this->getList();
  		}


		/*
		FUNCTION NAME 		-	getList
		DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
								database and make a list for it.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Renders the transaction list.
		*/
		public function getList() {	
			
				if (isset($this->request->get['page'])) {
					$page = $this->request->get['page'];
				} else {
					$page = 1;
				}
						
				$url = '';
				if (isset($this->request->get['filter_value'])) {
					$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
				}
		  		$this->data['breadcrumbs'] = array();
		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
		      		'separator' => false
		   		);

		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('heading_title'),
					'href'      => $this->url->link('commands/parental_rating', 'token=' . $this->session->data['token'] . $url, 'SSL'),
		      		'separator' => ' :: '
		   		);

				
		   		$this->data['insert'] = $this->url->link('commands/parental_rating/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
				$this->data['button_insert'] = $this->language->get('button_insert');
		    	$this->data['button_delete'] = $this->language->get('button_delete');
		    	$this->data['button_filter'] = $this->language->get('button_filter');

				$this->data['bmails'] = array();
				$data = array(
					'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
					'limit'           => $this->config->get('config_admin_limit')
				);
			
				$total=0;
				if (($this->request->server['REQUEST_METHOD'] == 'GET'))
				{
					$total = $this->model_commands_parental_rating->getTotalParentalRating($data);

					$results = $this->model_commands_parental_rating->getParentalRatting($data);

					foreach ($results as $result) 
					{	
						$resend = $this->url->link('commands/parental_rating/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');

						$de_activation = $this->url->link('commands/parental_rating/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
						
						$this->data['ratings'][] = array(
							'id'  		 	 => $result['id'],
							'tx_id'  		 => $result['tx_id'],
							'trigger_on'     => $result['modify_date'],
							'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
							'cmd_id'         => $result['cmd_id'],
							'resend'         => $resend,
							'de_activation'  => $de_activation,
							'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
						);	
					}
				}

				$this->data['heading_title'] = $this->language->get('heading_title');
				$this->data['entry_stb'] = $this->language->get('entry_stb');
				$this->data['column_stb'] = $this->language->get('column_stb');
				$this->data['column_name'] = $this->language->get('column_name');
				$this->data['column_tx_id'] = $this->language->get('column_tx_id');
				$this->data['column_trigger'] = $this->language->get('column_trigger');
				$this->data['column_resp'] = $this->language->get('column_resp');
				$this->data['column_type'] = $this->language->get('column_type');

				$this->data['text_no_results'] = $this->language->get('text_no_results');
				$this->data['token'] = $this->session->data['token'];

				if (isset($this->error['warning'])) {
					$this->data['error_warning'] = $this->error['warning'];
				}else if (isset($this->session->data['warning'])) {
					$this->data['error_warning'] = $this->session->data['warning'];
				
					unset($this->session->data['warning']);
				} else {
					$this->data['error_warning'] = '';
				}

				if (isset($this->error['target_level'])) {
					$this->data['error_target_level'] = $this->error['target_level'];
				}else{
					$this->data['error_target_level'] ='';
				}
				if (isset($this->error['user_data'])) {
					$this->data['error_user_data'] = $this->error['user_data'];
				}else{
					$this->data['error_user_data'] ='';
				}

				if (isset($this->session->data['success'])) {
					$this->data['success'] = $this->session->data['success'];
				
					unset($this->session->data['success']);
				} else {
					$this->data['success'] = '';
				}
				$pagination = new Pagination();
				$pagination->total = $total;
				$pagination->page = $page;
				$pagination->limit = $this->config->get('config_admin_limit');
				$pagination->text = $this->language->get('text_pagination');
				$pagination->url = $this->url->link('commands/parental_rating', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
					
				$this->data['pagination'] = $pagination->render();
				
				$url = '';
			
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}


				$this->template = 'commands/parental_rating.tpl';
				$this->children = array(
					'common/header',
					'common/footer'
				);
						
				$this->response->setOutput($this->render());

		  	}


		  	/*
		FUNCTION NAME 		-	insert
		DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
								details of the new review. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
		*/  
		  	public function save() {
		  		
				$this->language->load('commands/parental_rating');
		    	$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('commands/parental_rating');

				if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validateForm($this->request->post))) {
				 		$service_id=$this->request->post["service_id"];
				 		$age=$this->request->post["age"];
						$obj = new restapi();
						$data="age=".$age."&service_id=".$service_id;
						$method ="POST";
					    $url="".KMS_API."/ParentalLock";
					    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
						$apiresult=$obj->callAPI($method,$hdr,$url,$data);
						$response=json_decode($apiresult);
						// var_dump($apiresult);exit();
			    		$apimessage='';
			    		$errorMsg='';
						$apimessage ="Failed to Update OTA";
						foreach ($response as $key => $value) {
							switch ($key) {
								case 'error':
									$error=false;
								break;
								case 'id':
									$id=$value;
								break;
								case 'mq_response':
									$curlresponse=$value;
								break;
								case 'message':
									$apimessage=$value;
								break;
								default:
									$errorMsg=$errorMsg." ".$key. ": ".$value;				
								break;
							}
						}
						$log_target_level="Service ID";
						$log_target = $this->request->post["service_id"];
						$this->WriteMessageLog($curlresponse,$log_target_level,$log_target,"SEND PARENTAL LOCK");
					$ack_is=-1;$nack_is=-1;
					if(!$error)
					{
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
						if($ack=='ACK')
						{
							$ack_is=1;
						}elseif($ack=='NACK'){
							$nack_is=-1;
						}
						$payload =$service_id."#".$age;
						$this->model_commands_parental_rating->addToCasOpTransanction($id,$payload,$ack_is,$nack_is,$operator_id);
						$this->session->data['success'] = $apimessage;
						$url = '';
						$this->redirect($this->url->link('commands/parental_rating', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['target'], 'SSL'));
					}else{
						$errorMsg=$errorMsg." ".$apimessage;
						$this->session->data['warning']=$errorMsg;
						
					 }
			}
			$this->getForm();
		}

			


			public function insert() {
				$obj = new restapi();
				$this->language->load('commands/parental_rating');
				$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('commands/parental_rating');
				if ($this->request->server['REQUEST_METHOD'] == 'POST') {
					$this->getForm();
				}else
				$this->getList();
			}
  
 

		  	/*
		FUNCTION NAME 		-	getForm
		DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
		*/  
		  	protected function getForm() {
		    	$this->data['heading_title'] = $this->language->get('heading_title');
		 		
		    	$this->data['entry_stb']		    = $this->language->get('entry_stb');
		 		$this->data['entry_channel']  		 = $this->language->get('entry_channel');
		 		$this->data['entry_subject'] 		= $this->language->get('entry_subject');
		 		$this->data['entry_message'] 		= $this->language->get('entry_message');
		 		$this->data['text_age_rating'] 		= $this->language->get('text_age_rating');
		 		
				$this->data['button_save'] = $this->language->get('button_save');
		    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		 		if (isset($this->error['warning'])) {
					$this->data['error_warning'] = $this->error['warning'];
				} else {
					$this->data['error_warning'] = '';
				}
				

				$this->data['channel_lists'] = $this->model_commands_parental_rating->getChanelList();
		    	
		    	if (isset($this->request->post['service_id'])) {
		      		$this->data['service_id'] = $this->request->post['service_id'];
		    	 }else {
		      		$this->data['service_id'] = $this->config->get('config_service_id');
		    	}
				if (isset($this->error['age'])) {
					$this->data['error_age'] = $this->error['age'];
				} else {
					$this->data['error_age'] = '';
				}
		    	if (isset($this->request->post['age'])) {
		      		$this->data['age'] = $this->request->post['age'];
				}else {
		      		$this->data['age'] = '';
		    	}

				$url = '';
				
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}
								
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				
		  		$this->data['breadcrumbs'] = array();

		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
		      		'separator' => false
		   		);

		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('heading_title'),
					'href'      => $this->url->link('commands/parental_rating', 'token=' . $this->session->data['token'] . $url, 'SSL'),
		      		'separator' => ' :: '
		   		);

				if (!isset($this->request->get['stb_no'])) {
					$this->data['action'] = $this->url->link('commands/parental_rating/save', 'token=' . $this->session->data['token'] . $url, 'SSL');
				} else {
					$this->data['action'] = $this->url->link('commands/parental_rating/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
				}
				  
		    	$this->data['cancel'] = $this->url->link('commands/parental_rating/', 'token=' . $this->session->data['token'] . $url, 'SSL');


		    	$this->data['token'] = $this->session->data['token'];
			
				$this->template = 'commands/parental_rating_form.tpl';
				$this->children = array(
					'common/header',
					'common/footer'
				);
						
				$this->response->setOutput($this->render());
			}
		/*
		FUNCTION NAME 		-	validateForm
		DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
		*/
			 
  		protected function validateForm($post) {
  			// var_dump($post);exit();
		    	if (!$this->user->hasPermission('modify', 'commands/parental_rating')) {
		      		$this->error['warning'] = $this->language->get('error_permission');
		    	}
				$this->load->model('commands/parental_rating');
		   //  	if($this->request->post['target_level']==1)
		   //  	{
			  //   	$stb_no=$this->request->post['target'];
			  //   	if($stb_no){
			  //   		$result = $this->model_commands_parental_rating->isSTBPaired($stb_no);
				 //    	if ((strlen($stb_no)!=14)){
				 //            $this->error['stb_no'] = $this->language->get('error_length');
				 //       	}
				 //        elseif($result["customer_id"]==0)
				 //    	{
				 //    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
				 //    	}
			  //     	}
					// else
					// {
					// 	$this->error['stb_no'] = $this->language->get('error_stb');
					// }
				// }
				if($this->request->post['age']==-1){
					$this->error['age'] = $this->language->get('error_age');
				}


				if (!$this->error) {
			  		return true;
				 } else {
			 		return false;
				 }
  			}  

 

		  	/*
		FUNCTION NAME 		-	autocomplete
		DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
								the form. These auto-fill values are retrieved from the database
								and shown as a drop down list.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Renders the list.
		*/
			
			public function autocomplete() {
				$json = array();
				
				if (isset($this->request->get['filter_no'])) {
					$this->load->model('commands/parental_rating');
					
					$data = array(
						'filter_no' => $this->request->get['filter_no'],
						'start'       => 0,
						'limit'       => 20
					);
					
					$results = $this->model_commands_parental_rating->getSTBs($data);
						
					foreach ($results as $result) {
						$json[] = array(
							'stb_id' 	=> $result['id'], 
							'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
						);
					}		
				}

				$sort_order = array();
			  
				foreach ($json as $key => $value) {
					$sort_order[$key] = $value['stb_no'];
				}
				array_multisort($sort_order, SORT_ASC, $json);

				$this->response->setOutput(json_encode($json));
			}

	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
        fclose($log_file);
    }

}
?> 