<?php 

class ControllerCommandsOsd extends Controller {
	private $error = array();


public function index() {
		$this->language->load('commands/osd');		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/osd');
    	$this->getList();
  	}

public function getList() {	
	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['target_level'])) {
			$target_level = $this->request->get['target_level'];
		} else {
			$target_level = '';
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
		} else {
			$filter_value = '';
		}
				
		$url = '';

  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/osd', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['target_level'])) {
			$url .= '&target_level=' . $this->request->get['target_level'];
		}
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
		
   		$this->data['insert'] = $this->url->link('commands/osd/insert', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['osds'] = array();
		$data = array(
			'target_level'	  => $target_level,
			'filter_value'	  => $filter_value,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->post['target_level'])) {
			$this->data['target_level'] = $this->request->post['target_level'];
		} else if (isset($this->request->get['target_level'])) {
			$this->data['target_level'] = $this->request->get['target_level'];
			$this->session->data['target_level']=$this->data['target_level'];
		} else {
			$this->data['target_level'] =-1;
		}

		// if(isset($this->session->data['target_level']))
			// $this->data['target_level']=$this->session->data['target_level'];
		
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
			$data['target_level']=$this->data['target_level'];
		} else if (isset($this->request->post['filter_value'])) {
			$this->data['filter_value'] = $this->request->post['filter_value'];
		} else{
			$this->data['filter_value'] = '';
			
		}

		$this->data['targets']=array(
			'-1' => 'Please select',
			'1'  => 'Individual',
			'2'  => 'Global',
			'3'  => 'Region',
			'4'  => 'Group',
			'5'  => 'Operator');

		$this->data['operators'] = array();
		$operators = $this->model_commands_osd->getAllOperators();
		foreach ($operators as $operator) {
			$this->data['operators'][] = array(
				'user_id'  	=> $operator['user_id'],
				'username' 	=> $operator['username']
			);
		}

		$total=0;

		if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['target_level']))||(isset($data['target_level']) && $data['target_level']!=-1))
		{
			$total = $this->model_commands_osd->getTotalOsd($data);
			$results = $this->model_commands_osd->getOSD($data);
			foreach ($results as $result) {	
				$resend = $this->url->link('commands/osd/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
				$de_activation = $this->url->link('commands/osd/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
				
				$this->data['osds'][] = array(
					'id'  		 	 => $result['id'],
					'tx_id'  		 => $result['tx_id'],
					'trigger_on'    => $result['modify_date'],
					'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
					'cmd_id'         => $result['cmd_id'],
					'stb_no'         => ($data['target_level']==1)?$result['STBNO']:
							(($data['target_level']==2)?'Global':
								(($data['target_level']==3)?$result['region_name']:
									(($data['target_level']==5)?$result['username']:$result['name']))),
					'resend'         => $resend,
					'de_activation'  => $de_activation,
					'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
				);	
			}
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['target_level'])) {
			$this->data['error_target_level'] = $this->error['target_level'];
		}else{
			$this->data['error_target_level'] ='';
		}
		if (isset($this->error['user_data'])) {
			$this->data['error_user_data'] = $this->error['user_data'];
		}else{
			$this->data['error_user_data'] ='';
		}

		if (isset($this->error['filter_lco'])) {
			$this->data['error_filter_lco'] = $this->error['filter_lco'];
		}else{
			$this->data['error_filter_lco'] ='';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/osd', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/osd.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}

  	public function save() {
		$this->language->load('commands/osd');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/osd');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if($this->validateForm($this->request->post)) {
				
				$target_level=$this->request->post['target_level'];
				$target="";
		  		switch ($target_level) {
		  			case 1:
		  				$customer_id =$this->model_commands_osd->getCustomerId($this->request->post['target']);
				 	  	$local_target = (int)$customer_id["customer_id"];
				 	  	$target 	  = (int)$customer_id["api_user_id"];
				 	  	$operator_id  = (int)$customer_id["operator_id"];
				 	  	$log_target_level="Individual";
				 	  	$log_target_level_numeric = 1;
				 	  	$log_target = $this->request->post['target'];
		  				break;
		  			case 2:
		  				$target=0;
		  				$local_target=0;
		  				$operator_id=$this->session->data['user_id'];
		  				$log_target_level="Global";
		  				$log_target_level_numeric = 2;
				 	  	$log_target = "n/a";
		  				break;
		  			case 3:
		  				$target=$this->request->post['target'];
		  				$local_target=$this->request->post['target'];
		  				$operator_id=$this->session->data['user_id'];
		  				$log_target_level="Regional";
		  				$log_target_level_numeric = 3;
				 	  	$log_target = $this->request->post['target'];
		  				break;
		  			case 4:
		  				$this->load->model('commands/ota_download');
		  				$group_ids=$this->model_commands_ota_download->getGroupIdByname($this->request->post['target']);
		  				$target= $group_ids['kms_group_id'];
		  				$local_target=$group_ids['sms_group_id'];
		  				$operator_id=$this->session->data['user_id'];

		  				$log_target_level="Group";
		  				$log_target_level_numeric = 4;
				 	  	$log_target = $this->request->post['target'];
		  				break;	
		  			case 5: 
		  				$target=trim($this->request->post['target']);
		  				$local_target=$this->request->post['target'];
		  				$operator_id=$this->session->data['user_id'];
		  				$log_target_level="Operator";
		  				$log_target_level_numeric = 5;
				 	  	$log_target = $this->request->post['target'];
		  				break;	  			
		  			default:
		  				break;
		  		}		 		 	 	
				//----------------------------------------------
				$language 		= $this->request->post["language"];
				$message 		= $this->request->post["message"];
				$transparency 	= $this->request->post["transparency"];
				$bg_color 		= $this->request->post["backgrd_color"];
				$fore_color 	= $this->request->post["foregrd_color"];
				$scrolling 	    = $this->request->post["scrolling"];
				// $display_type 	= $this->request->post["display_type"];
				$display_type 	= 0;
				// $expiry 		= $this->request->post["expiry"];
				$content_identifier = $this->request->post["osd_content_identifier"];

				$datetime = new DateTime($this->request->post['expiry'], new DateTimeZone('Asia/Calcutta'));
				$expiry = $datetime->getTimestamp();
				$startTimeObj = new DateTime($this->request->post['start_time'], new DateTimeZone('Asia/Calcutta'));
				$startTime = $startTimeObj->getTimestamp();
				if($scrolling==1){
					$polarization = $this->request->post['polarization'];
					if($polarization==0 || $polarization==1){
						$marque = $this->request->post['HorizontalMarque'];
					}else {
						$marque = $this->request->post['VerticalMarque'];
					}
					$width 	= $this->request->post['width'];
				}else{
					$polarization = 0;
					$marque = 0;
					$width = 0;
				}	
				$forced = $this->request->post["forced"];
				if ($scrolling == "1"){
					$forced = "1";
				}
				//---------------------------------------------
				//Call of API
				$obj = new restapi();
			    $method ="POST";
				$data="target_level=".trim($target_level)."&target=".$target."&language=".$language."&message=".$message."&transparency=".$transparency."&bg_color=".$bg_color."&fore_color=".$fore_color."&display_type=".$display_type."&expiry=".$expiry."&forced=".$forced."&scrolling=".$scrolling."&start_time=".$startTime."&polarization=".$polarization."&marque=".$marque."&width=".$width."&content_identifier=".$content_identifier;
				// var_dump($data); die;
			    $url="".KMS_API."/enableOSD";
			    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
			    //Process API response and add to db
			    $response=json_decode($apiresult);
			    $error=true;

			    $errorMsg='';
			    $apimessage="KMS API Failed";
			    foreach ($response as $key => $value) {
			    	switch ($key) {
			    		case 'error':
			    			$error=$value;
			    		break;
			    		case 'id':
			    			$id=$value;
			    		break;
			    		case 'message':
			    			$apimessage=$value;
			    		break;
			    		case 'mq_response':
			    			$curlresponse=$value;
			    		break;
			    		default:
			    			$errorMsg=$errorMsg." ".$key. ": ".$value;
			    		break;
			    	}
				}
				// if (!isset($curlresponse)) {
				// 	$curlresponse = $apimessage;
				// }
    			
				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{	
					$resend_status = 0;
					$commandid = 3;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"OSD",$resend_status,$commandid,$log_target_level_numeric);
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));					
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					$payload = $target."#".$language."#".$message."#".$transparency."#".$bg_color."#".$display_type."#".$expiry."#".$forced."#".$start_time."#".$polarization."#".$marque."#".$width."#".$content_identifier;
					
					$this->model_commands_osd->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id);
					$this->session->data['success'] = $apimessage;
					$url = '';
					$this->redirect($this->url->link('commands/osd', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['target'], 'SSL'));
					}else{
						$errorMsg=$errorMsg." ".$apimessage;
						$this->session->data['warning']="In CAS :".$apimessage;//$errorMsg;	
						$url = '';
						$this->redirect($this->url->link('commands/osd', 'token=' . $this->session->data['token'] . $url, 'SSL'));					
					}
				}else{
					$this->data['osd']=array('target_level' =>trim($this->request->post['target_level']),'target'       =>trim($this->request->post['target']));
				}
			}
			$this->getForm();
}

public function resend() {

		$this->language->load('commands/osd');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/osd');
		$this->load->model('commands/osd');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{
     		$transaction_details = $this->model_commands_osd->getTransactionDetails($this->request->get['id']);         		 		
     		$customer_id=$transaction_details['user_id'];
     		$target_lvl=$transaction_details['target_level'];
    		$trans_id=$transaction_details['tx_id']; 
    		$cmd_id=$transaction_details['cmd_id'];
    		$operator_id=$transaction_details['operator_id'];

    		switch ($target_lvl) {
    			case 1:
					$target=$this->model_commands_osd->getKMSUserId($transaction_details['user_id']);
					$targ_value=$this->model_commands_osd->getSTBno($transaction_details['user_id']);					
					$log_target_level="Individual";
					$log_target_level_numeric = 1;
					$log_target = $targ_value;
					break;
    			case 2:
					$target=0;
					$targ_value=0;
					$log_target_level="Global";
					$log_target_level_numeric = 2;
					$log_target = "n/a";
    			break;
    			case 3:
					$target=$transaction_details['user_id'];
					$targ_value=$target;
					$log_target_level="Regional";
					$log_target_level_numeric = 3;
					$log_target = $targ_value;
    			break;
    			case 4:
					$target=$this->model_commands_osd->getKMSGroupId($transaction_details['user_id']);
					$targ_value=$this->model_commands_osd->getGroupNameById($transaction_details['user_id']);
					$log_target_level="Group";
					$log_target_level_numeric = 4;
					$log_target = $targ_value;
    				break;
    			case 5: 
    				$target=$transaction_details['user_id'];
					$targ_value=$transaction_details['user_id'];
					$log_target_level="Operator";
					$log_target_level_numeric = 5;
					$log_target = $targ_value;
    				break;
    		}
    		
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$target."&target_level=".$target_lvl;
		  	// var_dump($data);exit();
		  	$method ="POST";
			$uri=KMS_API."/Resend";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);		
		    $error=true;
		    $errorMsg='';
		    $apimessage=" Kms fail to enable STB";

		    foreach ($response as $key => $value) {
				switch ($key) {
					case 'error':
						$error=$value;
					break;
					case 'id':
						$id=$value;
					break;
					case 'mq_response':
						$curlresponse=$value;
					break;
					case 'message':
						$apimessage=$value;			
					break;
					default:
						$errorMsg=$errorMsg." ".$key.":".$value;	
						break;
				}
			}
			
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{	
				$resend_status = 1;
				$commandid = 3;
				$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND OSD",$resend_status,$commandid,$log_target_level_numeric);
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$payload=$trans_id."#".$cmd_id."#".$target;
				$target=1;
				$targetdata=0;
				$results = $this->model_commands_osd->addToCasOpTransanction($target_lvl,$transaction_details['user_id'],$id,$payload,$ack_is,$nack_is,$operator_id);
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
		}
		$this->session->data['warning'] = $this->error['warning'];
     	$this->redirect($this->url->link('commands/osd', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_lvl.'&filter_value='.$targ_value, 'SSL'));
  	}

  	protected function getForm() {

    	$this->data['heading_title'] 			= $this->language->get('heading_title'); 		
    	$this->data['entry_stb']	   			= $this->language->get('entry_stb');
 		$this->data['entry_lang']   			= $this->language->get('entry_lang');
 		$this->data['entry_message'] 			= $this->language->get('entry_message');
 		$this->data['entry_expiry'] 			= $this->language->get('entry_expiry');
 		$this->data['entry_transparency'] 		= $this->language->get('entry_transparency'); 		
 		$this->data['entry_display_type'] 		= $this->language->get('entry_display_type');
 		$this->data['entry_forced'] 			= $this->language->get('entry_forced'); 		
 		$this->data['entry_scrolling'] 			= $this->language->get('entry_scrolling'); 	
 		$this->data['entry_backgrd_color'] 		= $this->language->get('entry_backgrd_color');
 		$this->data['entry_foregrd_color'] 		= $this->language->get('entry_foregrd_color');
 		$this->data['entry_start_time']			= $this->language->get('entry_start_time');
 		$this->data['entry_polarization']		= $this->language->get('entry_polarization');
 		$this->data['entry_marque']				= $this->language->get('entry_marque');
 		$this->data['entry_width']				= $this->language->get('entry_width');
 		$this->data['button_save'] 				= $this->language->get('button_send');
    	$this->data['button_cancel'] 			= $this->language->get('button_cancel');
    	$this->data['entry_content_identifier'] = $this->language->get('entry_content_identifier');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['expiry'])) {
			$this->data['error_expiry'] = $this->error['expiry'];
		} else {
			$this->data['error_expiry'] = '';
		}

		if (isset($this->error['message'])) {
				$this->data['error_message'] = $this->error['message'];
			} else {
				$this->data['error_message'] = '';
		}

		if (isset($this->error['transparency'])) {
				$this->data['error_transparency'] = $this->error['transparency'];
			} else {
				$this->data['error_transparency'] = '';
		}

		// if (isset($this->error['display_duration'])) {
		// 	$this->data['error_duration'] = $this->error['display_duration'];
		// } else {
		// 	$this->data['error_duration'] = '';
		// }

		if (isset($this->error['fore_color'])) {
			$this->data['error_fore_color'] = $this->error['fore_color'];
		} else {
			$this->data['error_fore_color'] = '';
		}
	
		if (isset($this->request->get['backgrd_color'])) {
			$url .= '&backgrd_color=' . $this->request->get['backgrd_color'];
		}
	
		if (isset($this->request->post['language'])) {
      		$this->data['language'] = $this->request->post['language'];
		}else {
      		$this->data['language'] = '';
    	}

    	if (isset($this->request->post['osd_content_identifier'])) {
      		$this->data['osd_content_identifier'] = $this->request->post['osd_content_identifier'];
		}else {
      		$this->data['osd_content_identifier'] = '';
    	}

    	if (isset($this->request->post['message'])) {
      		$this->data['message'] = $this->request->post['message'];
		}else {
      		$this->data['message'] = '';
    	}

    	if (isset($this->request->post['transparency'])) {
      		$this->data['transparency'] = $this->request->post['transparency'];
		}else {
      		$this->data['transparency'] = '';
    	}

    	if (isset($this->request->post['display_type'])) {
      		$this->data['display_type'] = $this->request->post['display_type'];
		}else {
      		$this->data['display_type'] = '';
    	}
    
    	if (isset($this->request->post['backgrd_color'])) {
      		$this->data['backgrd_color'] = $this->request->post['backgrd_color'];
		}else {
      		$this->data['backgrd_color'] = '';
    	}

    	if (isset($this->error['start_time'])) {
			$this->data['error_start_time'] = $this->error['start_time'];
		} else {
			$this->data['error_start_time'] = '';
		}

		if (isset($this->error['width'])) {
			$this->data['error_width'] = $this->error['width'];
		} else {
			$this->data['error_width'] = '';
		}

		if (isset($this->error['polarization'])) {
			$this->data['error_polarization'] = $this->error['polarization'];
		} else {
			$this->data['error_polarization'] = '';
		}
    	    	
    	if (isset($this->request->post['expiry'])) {
      		$this->data['expiry'] = $this->request->post['expiry'];
		}else {
      		$this->data['expiry'] = '';
    	}

    	if (isset($this->request->post['forced'])) {
      		$this->data['forced'] = $this->request->post['forced'];
		}else {
      		$this->data['forced'] = '';
    	}
  
    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}

    	if (isset($this->request->post['scrolling'])) {
      		$this->data['scrolling'] = $this->request->post['scrolling'];
		}else {
      		$this->data['scrolling'] = '';
    	}

    	if (isset($this->request->post['polarization'])) {
      		$this->data['polarization'] = $this->request->post['polarization'];
		}else {
      		$this->data['polarization'] = '-1';
    	}

    	if (isset($this->request->post['start_time'])) {
      		$this->data['start_time'] = $this->request->post['start_time'];
		}else {
      		$this->data['start_time'] = '';
    	}

    	if (isset($this->request->post['width'])) {
      		$this->data['width'] = $this->request->post['width'];
		}else {
      		$this->data['width'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['backgrd_colors']=array( '000000' => 'Black' ,
											 'FFFFFF' => 'White' ,			        						 
			        						 '0000FF' => 'Blue' ,
			        						 'FFFF00' => 'Yellow' ,
			        						 'FF0000' => 'Red' ,
			        						 '008000' => 'Green' ,
			        						 '808000' => 'Olive' ,
			        						 'FF8000' => 'Orange' ,
			        						 '804000' => 'Brown');

		$this->data['foregrd_colors']=array( 'FFFFFF' => 'White' ,
			        						 '000000' => 'Black' ,
			        						 '0000FF' => 'Blue' ,
			        						 'FFFF00' => 'Yellow' ,
			        						 'FF0000' => 'Red' ,
			        						 '008000' => 'Green' ,
			        						 '808000' => 'Olive' ,
			        						 'FF8000' => 'Orange' ,
			        						 '804000' => 'Brown');

		$this->data['scrollings']=array('0'=>'NO', '1'=>'YES');

		$this->data['polarizations'] = array("-1"=>"Select Polarization",
											"0"=>"Horizontal Bottom",
											"1"=>"Horizontal Top",
											// "2"=>"Vertical Left",
											// "3"=>"Vertical Right",
											);

		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/osd', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/osd/save', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/osd/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/osd/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	   
    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'commands/osd_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	public function insert() {		  		
		
		$this->language->load('commands/osd');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/osd');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if($this->validateInsertForm($this->request->post)) {
				if(trim($this->request->post['target_level'])==5){
					$this->data['osd']=array('target_level' =>trim($this->request->post['target_level']),'target'       =>trim($this->request->post['filter_lco']));
				}else{
					$this->data['osd']=array('target_level' =>trim($this->request->post['target_level']),'target'       =>trim($this->request->post['filter_value']));
				}

				$this->getForm();
			}else{
				$this->getList();
			}
		}else
			$this->getList();
	}

			 
  	protected function validateForm($post) {
  		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('Y-m-d H:i:s');	
  			
    	if (!$this->user->hasPermission('modify', 'commands/osd')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
    	
		$this->load->model('commands/osd');
		if($this->request->post['target_level']==1)	{
	    	$stb_no=$this->request->post['target'];
	    	if($stb_no){
	    		$result = $this->model_commands_osd->isSTBPaired($stb_no);
		    	if ((strlen($stb_no)!=14)){
		            $this->error['stb_no'] = $this->language->get('error_length');
		       	}
		        elseif($result["customer_id"]==0)
		    	{
		    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
		    	}
	      	}
			else
			{
				$this->error['stb_no']="Stb field is empty!";
			}
		}
		
		if(!strcmp($post["backgrd_color"],$post["foregrd_color"])) {
			$this->error['fore_color'] = $this->language->get('error_fore_color');
		}

		if ($this->request->post['message']=="") {
			$this->error['message'] ='Please fill the message!';
		}

		if (strlen($this->request->post['message']) > 255) {
			$this->error['message'] ='Message length too Long!!';
		}
		// elseif(!preg_match("#^[a-zA-Z0-9 ]+$#", $this->request->post['message']))	{
		// 	$this->error['message']="Special Characters not allowed!";
		// }

		if((int)($this->request->post['transparency'])<20 ||(int)($this->request->post['transparency'])>80){
				$this->error['transparency'] = "Transparency must be less than 80 and greater than 20!";

		}

		if(!$this->request->post['start_time']){
			$this->error['start_time'] = $this->language->get('error_start_time');
		}elseif ($this->request->post['start_time'] < $current_date) {
			$this->error['start_time'] = "Start time must be greater than current time!";
		}

		if ($this->request->post['expiry']=="") {
			$this->error['expiry'] ='Please select the expiry!';
		}elseif ($this->request->post['expiry'] < $current_date) {
			$this->error['expiry'] = "Expiry time must be greater than current time!";
		}elseif (($this->request->post['expiry'] < $this->request->post['start_time']) || ($this->request->post['expiry'] == $this->request->post['start_time'])) {
			$this->error['expiry'] = "Expiry time must be greater than start time..!";
		}

		if(isset($this->request->post['scrolling']) && $this->request->post['scrolling']==1){ 
			if (($this->request->post['scrolling']==1) && $this->request->post['polarization']=='-1') {
				$this->error['polarization'] ='Please select the polarization to set the marque position and width!';
			}

			if (($this->request->post['scrolling']==1) && $this->request->post['width']=="") {
				$this->error['width'] ='Please enter the width!';
			}else if(!preg_match('/^[1-9][0-9]*$/', $this->request->post['width'])){
				$this->error['width'] = 'Accepts only integer value for width.!';
			}else if ((int)$this->request->post['width'] < 10 || (int)$this->request->post['width'] >100) {
				$this->error['width'] = 'Width must be between (10-100%)';
			}
		}


		if (!$this->error) {
	  		return true;
		} else {
	 		return false;
		}
  	}  

	/*
FUNCTION NAME 		-	validateInsertForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateInsertForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/osd')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/ota_download');
		$this->load->model('commands/osd');

		switch ($this->request->post['target_level']) {
			case 1:
				$lcoId  = $this->user->getOperatorIdFromStbno($this->request->post['filter_value']);
				if($this->request->post['filter_value']=='')
				{
					$this->error['user_data']='Please enter STB no ';	
				}else if(strlen($this->request->post['filter_value'])!=14)
				{
					$this->error['user_data']='STB no should be 14 digit ';	
				}elseif($this->user->isStbSuspend($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is suspended, Please resume first.!";
	    		}elseif($this->user->isLcoSuspend($lcoId)){
	    			$this->error['user_data'] = $this->language->get('STB Belongs To LCO Is Suspended, Please Resume LCO First.!');
	    		}elseif($this->user->isStbRMA($this->request->post['filter_value'])){
	    			$this->error['user_data'] = $this->language->get('STB in RMA state.!');	
	    		}else{
					$stb=$this->model_commands_ota_download->isStbExistedAndPaired($this->request->post['filter_value']);
					if(!isset($stb['customer_id']))
					{
						$this->error['user_data']='Invalid STB no';
					}else if (isset($stb['customer_id'])) {
						if(!$stb['customer_id']>0)
							$this->error['user_data']='STB no is not paired with user';
					}
				}
				// -------------------CHECK IF BOX IS BLACKLISTED-------------------------

		 		$is_blacklist = $this->model_commands_osd->isBlacklist($this->request->post['filter_value']);
		 		if($is_blacklist==1){
		 			$this->error['user_data'] = 'STB Blacklisted!!!';			 			
		 		}
		 	// -----------------------------------------------------------------------------
				break;
			case 2:				
				break;
			case 3:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter pin code ';
				else if(strlen($this->request->post['filter_value'])!=6)
					$this->error['user_data']='Pin code must be 6 digits';
				else{
					$pin=$this->model_commands_ota_download->checkPinExist($this->request->post['filter_value']);
					if(!$pin)
						$this->error['user_data']='Invalid PIN code';
				}
				break;
			case 4:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter group name';
				else {
					$group=$this->model_commands_ota_download->checkGroupExists($this->request->post['filter_value']);
					if(!$group)
						$this->error['user_data']='Invalid group name';	
				}
				break; 
			case 5:
			    	$filterlco=$this->request->post['filter_lco'];
			    	if($filterlco=='-1'){
			    		$this->error['filter_lco']="Please select LCO.!";
			    	}
			    	$is_lco_suspend = $this->user->isLcoSuspend($filterlco);
			    	if($is_lco_suspend!=0){
			    		$this->error['filter_lco']="Operator is in Suspend Mode!";
			    	}
			    	break;
			default:
				$this->error['target_level']='Please select target ';
				break;
		}

		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	} 
  	/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/osd')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		$stb_no = $this->model_commands_osd->getStbNoFromId($this->request->get['id']);
		
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_osd->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
	 		}

			$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}

	 		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB in RMA state.!');		
	 		}		 		
	 	}
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/osd');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_osd->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function decTohexAndMsb($target,$no_ofbits)
		{
		$target=dechex($target);
		$target=str_pad($target, $no_ofbits, '0', STR_PAD_LEFT);
    	$msblsb='';
    	for ($k=strlen($target); $k >0 ; $k-=2) { 
    		$msblsb.=substr($target,$k-2,2);
    	}
    	return $msblsb;
		}

	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id,$log_target_level_numeric){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	$log_target = (strlen($log_target)<22)?str_pad($log_target,24," "):substr($log_target, 0,22).".";
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").$log_target.$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level_numeric,$log_target,$command_id,$resend_status,'-1');
    }


 }
?> 