<?php 
 /*
@File force_nit_tunning.php(Controller)
ADMIN FORCE NIT TUNNING PAGE
    This class manages the all the OtaDownload list and status.
    

@Author Ravi Ranjan 
@date 13 Dec. 2016
*/
class ControllerCommandsForceNitTunning extends Controller {
	private $error = array();

	/*
	FUNCTION NAME 		-	index
	DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
							It get all the stb number list and displays it here.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
	*/
public function index() {
		$this->language->load('commands/force_nit_tunning');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/force_nit_tunning');
    	$this->getList();
  	}


		/*
		FUNCTION NAME 		-	getList
		DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
								database and make a list for it.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Renders the transaction list.
		*/
		public function getList() {	
			
				if (isset($this->request->get['page'])) {
					$page = $this->request->get['page'];
				} else {
					$page = 1;
				}
						
				$url = '';
		  		$this->data['breadcrumbs'] = array();
		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
		      		'separator' => false
		   		);

		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('heading_title'),
					'href'      => $this->url->link('commands/force_nit_tunning', 'token=' . $this->session->data['token'] . $url, 'SSL'),
		      		'separator' => ' :: '
		   		);

				if (isset($this->request->get['filter_value'])) {
					$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
				}	
				
		   		$this->data['insert'] = $this->url->link('commands/force_nit_tunning/insert', 'token=' . $this->session->data['token'], 'SSL');
				$this->data['button_insert'] = $this->language->get('button_insert');
		    	$this->data['button_delete'] = $this->language->get('button_delete');
		    	$this->data['button_filter'] = $this->language->get('button_filter');

				$this->data['ota_updates'] = array();
				$data = array(
					'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
					'limit'           => $this->config->get('config_admin_limit')
				);
				
				if (isset($this->request->get['filter_value'])) {
					$this->data['filter_value'] = $this->request->get['filter_value'];
					$data['filter_value']=$this->request->get['filter_value'];
					$data['target_level']=$this->request->get['target_level'];
				} else if (isset($this->request->post['filter_value'])) {
					$this->data['filter_value'] = $this->request->post['filter_value'];
				} else{
					$this->data['filter_value'] ='';
				}

				if (isset($this->request->post['target_level'])) {
					$this->data['target_level'] = $this->request->post['target_level'];
				} else if (isset($this->request->get['target_level'])) {
					$this->data['target_level'] = $this->request->get['target_level'];
				}else {
					$this->data['target_level'] =-1;
				}

				$total=0;
				if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['target_level'])))
				{	
					$total = $this->model_commands_force_nit_tunning->getTotalotaUpdate($data);
					$results = $this->model_commands_force_nit_tunning->getOtadownload($data);
					foreach ($results as $result) 
					{	
						$resend = $this->url->link('commands/force_nit_tunning/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
						$de_activation = $this->url->link('commands/force_nit_tunning/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
						
						$this->data['ota_updates'][] = array(
							'id'  		 	 => $result['id'],
							'tx_id'  		 => $result['tx_id'],
							'trigger_on'     => $result['modify_date'],
							'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
							'cmd_id'         => $result['cmd_id'],
							'stb_no'         => ($data['target_level']==1)?$result['STBNO']:(($data['target_level']==2)?'Global':(($data['target_level']==3)?$result['region_name']:$result['name'])),
							// 'resend'         => $resend,
							// 'de_activation'  => $de_activation,
							'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
						);	
					}			
				}
				$this->data['targets']=array(
					'-1' => 'Please select',
					'1'  => 'Individual',
					'2'  => 'Global',
					'3'  => 'Region',
					'4'  => 'Group');
				$this->data['heading_title'] = $this->language->get('heading_title');
				
				$this->data['entry_stb'] = $this->language->get('entry_stb');
				$this->data['column_stb'] = $this->language->get('column_stb');
				$this->data['column_name'] = $this->language->get('column_name');
				$this->data['column_tx_id'] = $this->language->get('column_tx_id');
				$this->data['column_trigger'] = $this->language->get('column_trigger');
				$this->data['column_resp'] = $this->language->get('column_resp');
				$this->data['column_type'] = $this->language->get('column_type');

				$this->data['text_no_results'] = $this->language->get('text_no_results');
				$this->data['token'] = $this->session->data['token'];

				if (isset($this->error['warning'])) {
					$this->data['error_warning'] = $this->error['warning'];
				}else if (isset($this->session->data['warning'])) {
					$this->data['error_warning'] = $this->session->data['warning'];
				
					unset($this->session->data['warning']);
				} else {
					$this->data['error_warning'] = '';
				}
				if (isset($this->error['target_level'])) {
					$this->data['error_target_level'] = $this->error['target_level'];
				}else{
					$this->data['error_target_level'] ='';
				}
				if (isset($this->error['user_data'])) {
					$this->data['error_user_data'] = $this->error['user_data'];
				}else{
					$this->data['error_user_data'] ='';
				}
				
				if (isset($this->session->data['success'])) {
					$this->data['success'] = $this->session->data['success'];
				
					unset($this->session->data['success']);
				} else {
					$this->data['success'] = '';
				}
				$pagination = new Pagination();
				$pagination->total = $total;
				$pagination->page = $page;
				$pagination->limit = $this->config->get('config_admin_limit');
				$pagination->text = $this->language->get('text_pagination');
				$pagination->url = $this->url->link('commands/force_nit_tunning', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
					
				$this->data['pagination'] = $pagination->render();
				
				$url = '';
			
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}


				$this->template = 'commands/force_nit_tunning.tpl';
				$this->children = array(
					'common/header',
					'common/footer'
				);
						
				$this->response->setOutput($this->render());

		  	}


		  	/*
		FUNCTION NAME 		-	save
		DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
								details of the new review. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
		*/  
		 public function save() {
		  		
				$obj = new restapi();
				$this->language->load('commands/force_nit_tunning');
		    	$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('commands/force_nit_tunning');

				if ($this->request->server['REQUEST_METHOD'] == 'POST' ) {
					
					if($this->validateForm($this->request->post)) {
						
						$transport_stream =$this->decTohexAndMsb($this->request->post["transport_stream_id"],4);
						$orginal_network =$this->decTohexAndMsb($this->request->post['original_network_id'],4);

						$oad_frequency =$this->decTohexAndMsb($this->request->post['oad_frequency'],4);
						$oad_symbal_rate =$this->decTohexAndMsb($this->request->post['oda_symbol_rate'],4);
						$oad_modulation =$this->request->post['oad_modulation'];

						$payload=$transport_stream.$orginal_network.$oad_frequency.$oad_modulation.$oad_symbal_rate;
						$target_level=$this->request->post['target_level'];
				  		switch ($target_level) {
				  			case 1:
				  				$customer_id =$this->model_commands_force_nit_tunning->getCustomerId($this->request->post['target']);	
				  				$target=(int)$customer_id["api_user_id"];
				  				$local_target=(int)$customer_id["customer_id"];	
				  				$operator_id=(int)$customer_id["operator_id"];

				  				$log_target_level = "Individual";
				  				$log_target_level_numeric = 1;
				  				$log_target=$this->request->post['target'];
				  				break;
				  			case 2:
				  				$target=0;
				  				$local_target=0;
				  				$operator_id=$this->session->data['user_id'];

				  				$log_target_level = "Global";
				  				$log_target_level_numeric = 2;
				  				$log_target="n/a";
				  				break;
				  			case 3:
				  				$target=$this->request->post['target'];
				  				$local_target=$this->request->post['target'];
				  				$operator_id=$this->session->data['user_id'];

				  				$log_target_level = "Regional";
				  				$log_target_level_numeric = 3;
				  				$log_target=$this->request->post['target'];
				  				break;
				  			case 4:
				  				$group_ids=$this->model_commands_force_nit_tunning->getGroupIdByname($this->request->post['target']);
				  				$target= $group_ids['kms_group_id'];
				  				$local_target=$group_ids['sms_group_id'];
				  				$operator_id=$this->session->data['user_id'];

				  				$log_target_level = "Group";
				  				$log_target_level_numeric = 4;
				  				$log_target=$this->request->post['target'];
				  				break;		  			
				  			default:
				  				break;
				  		}
						$data="target_level=".$target_level."&target=".$target."&uri=".$payload;
					    $method ="POST";
					    $url="".KMS_API."/forceNITTunning";
					    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
					   //Process API response and add to db
					    $response=json_decode($apiresult);

			    		$apimessage='';
			    		$errorMsg='';
						$apimessage ="";
						foreach ($response as $key => $value) {
							switch ($key) {
								case 'error':
									$error=$value;
									break;
								case 'id':
									$id=$value;
									break;
								case 'mq_response':
									$curlresponse=$value;
									break;
								case 'message':
									$apimessage=$value;
									break;
								default:
									$errorMsg=$errorMsg.' '.$apimessage;
									break;
							}
						}
						
						$ack_is=-1;$nack_is=-1;
						if(!$error)
						{	
							$resend_status = 0;
							$commandid = 17;
							$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"FORCE NIT TUNNING",$resend_status,$commandid,$log_target_level_numeric);
							$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
							if($ack=='ACK')
							{
								$ack_is=1;
							}elseif($ack=='NACK'){
								$nack_is=-1;
							}
							
							$payload=$target_level."#".$id."#".$payload."#".$ack_is."#".$nack_is."#".$target;
							
							$this->model_commands_force_nit_tunning->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id);
							$this->session->data['success'] = $apimessage;
							$url = '';
							$this->redirect($this->url->link('commands/force_nit_tunning', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['target'], 'SSL'));
						}else{
							$errorMsg=$errorMsg." ".$apimessage;
							$this->session->data['warning']="In CAS :".$apimessage;//$errorMsg;
							$url = '';
							$this->redirect($this->url->link('commands/force_nit_tunning', 'token=' . $this->session->data['token'] . $url, 'SSL'));
						}
					}else{
						// var_dump($this->error)  			;exit();
							$this->data['ota_target']=array('target_level' =>$this->request->post['target_level'],
														'target'       =>$this->request->post['target']);
					}
			}
			$this->getForm();
		}


		public function insert() {
		  		
			$obj = new restapi();
			$this->language->load('commands/force_nit_tunning');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('commands/force_nit_tunning');

			if ($this->request->server['REQUEST_METHOD'] == 'POST') {
				if($this->validateInsertForm($this->request->post)) {
					
					$this->data['ota_target']=array('target_level' =>$this->request->post['target_level'],
													'target'       =>$this->request->post['filter_value']);
					$this->getForm();
				}else{
					$this->getList();
				}
			}else
				$this->getList();
		}

		 /*
		FUNCTION NAME 		-	resend
		DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
								added/uploaded earlier. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
		*/
 
			public function resend() {

				$this->language->load('commands/force_nit_tunning');
		    	$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('commands/ota_download');
		  		$obj = new restapi();
		  		
		    	if($this->validate())
		    	{
		     		$transaction_details=$this->model_commands_force_nit_tunning->getTransactionDetails($this->request->get['id']);
		     		$customer_id=$transaction_details['user_id'];
		    		$target_lvl=$transaction_details['target_level'];
		    		$trans_id=$transaction_details['tx_id']; 
		    		$cmd_id=$transaction_details['cmd_id'];
		    		$operator_id=isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
		    		switch ($target_lvl) {
		    			case 1:
		    					$target=$this->model_commands_ota_download->getKMSUserId($transaction_details['user_id']);
		    					$targ_value=$this->model_commands_ota_download->getSTBno($transaction_details['user_id']);

		    					$log_target_level = "Individual";
		    					$log_target_level_numeric = 1;
		    					$log_target = $this->model_commands_ota_download->getStbNo($transaction_details['user_id']);
		    			break;
		    			case 2:
		    					$target=0;
		    					$targ_value=0;

		    					$log_target_level = "Global";
		    					$log_target_level_numeric = 2;
		    					$log_target="n/a";
		    			break;
		    			case 3:
		    					$target=$transaction_details['user_id'];
		    					$targ_value=$target;

		    					$log_target_level = "Regional";
		    					$log_target_level_numeric = 3;
		    					$log_target = $transaction_details['user_id'];
		    			break;
		    			case 4:
		    					$target=$this->model_commands_force_nit_tunning->getKMSGroupId($transaction_details['user_id']);
		    					$targ_value=$this->model_commands_force_nit_tunning->getGroupNameById($transaction_details['user_id']);

		    					$log_target_level = "Group";
		    					$log_target_level_numeric = 4;
		    					$log_target = $this->model_commands_force_nit_tunning->getGroupNameById($transaction_details['user_id']);
		    			break;
		    		}
		    		
				  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$target."&target_level=".$target_lvl;
				  	$method ="POST";
					$uri=KMS_API."/Resend";		
					$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
				    //Process API response and add to db 
				    $response=json_decode($apiresult);		
				    $error=true;
				    $errorMsg='';
				    $apimessage=" Kms fail to enable STB";

				    foreach ($response as $key => $value) {
						switch ($key) {
							case 'error':
								$error=$value;
							break;
							case 'id':
								$id=$value;
							break;
							case 'mq_response':
								$curlresponse=$value;
							break;
							case 'message':
								$apimessage=$value;			
							break;
							default:
								$errorMsg=$errorMsg." ".$key.":".$value;	
								break;
						}
					}

					
					$ack_is=-1;$nack_is=-1;
					if(!$error)
					{	
						$resend_status = 1;
						$commandid = 17;
						$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND FORCE NIT TUNNING",$resend_status,$commandid,$log_target_level_numeric);
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
						if($ack=='ACK')
						{
							$ack_is=1;
						}elseif($ack=='NACK'){
							$nack_is=-1;
						}
						$resp=split('`', $curlresponse);
						$payload=$user_id."#".$cmd_id."#".$trans_id;
						$target=1;
						$targetdata=0;
						$results = $this->model_commands_force_nit_tunning->addToCasOpTransanction($target_lvl,$transaction_details['user_id'],$id,$payload,$ack_is,$nack_is,$operator_id);
						$this->session->data['success']=$apimessage;
					}else{
						$errorMsg=$errorMsg."  ".$apimessage;
						$this->session->data['warning']=$errorMsg;
					}
				}
		     	$this->redirect($this->url->link('commands/force_nit_tunning', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_lvl.'&filter_value='.$targ_value, 'SSL'));
		  	}  

/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_chip_no'] = $this->language->get('entry_chip_no');
    	$this->data['entry_confirm_chip_no'] = $this->language->get('entry_confirm_chip_no');

    	$this->data['entry_transport_stream_id'] = $this->language->get('entry_transport_stream_id');
    	$this->data['entry_linkage_type'] = $this->language->get('entry_linkage_type');
    	$this->data['entry_oui_id'] = $this->language->get('entry_oui_id');
    	$this->data['entry_oda_symbol_rate'] = $this->language->get('entry_oda_symbol_rate');
    	$this->data['entry_chip_id'] = $this->language->get('entry_chip_id');
    	$this->data['entry_oui_id'] = $this->language->get('entry_oui_id');

    	$this->data['entry_original_network_id'] = $this->language->get('entry_original_network_id');
    	$this->data['entry_oui_id_length'] = $this->language->get('entry_oui_id_length');
    	$this->data['entry_oad_frequency'] = $this->language->get('entry_oad_frequency');
    	$this->data['entry_oad_modulation'] = $this->language->get('entry_oad_modulation');


 	
		$this->data['button_save'] = $this->language->get('button_send');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}
		if (isset($this->error['transport_stream_id'])) {
			$this->data['error_transport_stream_id'] = $this->error['transport_stream_id'];
		} else {
			$this->data['error_transport_stream_id'] = '';
		}
		if (isset($this->error['original_network_id'])) {
			$this->data['error_original_network_id'] = $this->error['original_network_id'];
		} else {
			$this->data['error_original_network_id'] = '';
		}
		
		if (isset($this->error['oui_id'])) {
			$this->data['error_oui_id'] = $this->error['oui_id'];
		} else {
			$this->data['error_oui_id'] = '';
		}

		if (isset($this->error['oda_symbol_rate'])) {
			$this->data['error_oda_symbol_rate'] = $this->error['oda_symbol_rate'];
		} else {
			$this->data['error_oda_symbol_rate'] = '';
		}
		if (isset($this->error['oad_frequency'])) {
			$this->data['error_oad_frequency'] = $this->error['oad_frequency'];
		} else {
			$this->data['error_oad_frequency'] = '';
		}
		
		if (isset($this->error['oad_modulation'])) {
			$this->data['error_oad_modulation'] = $this->error['oad_modulation'];
		} else {
			$this->data['error_oad_modulation'] = '';
		}
	
		if (isset($this->error['target_ota'])) {
			$this->data['error_target_ota'] = $this->error['target_ota'];
		} else {
			$this->data['error_target_ota'] = '';
		}
		if (isset($this->error['force_ota'])) {
			$this->data['error_force_ota'] = $this->error['force_ota'];
		} else {
			$this->data['error_force_ota'] = '';
		}
		if (isset($this->error['oad_pid'])) {
			$this->data['error_oad_pid'] = $this->error['oad_pid'];
		} else {
			$this->data['error_oad_pid'] = '';
		}
		



		if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}
		if (isset($this->request->post['transport_stream_id'])) {
      		$this->data['transport_stream_id'] = $this->request->post['transport_stream_id'];
		}else {
      		$this->data['transport_stream_id'] = '1002';
    	}

    	if (isset($this->request->post['original_network_id'])) {
      		$this->data['original_network_id'] = $this->request->post['original_network_id'];
		}else {
      		$this->data['original_network_id'] = '0001';
    	}

    	
    	if (isset($this->request->post['oui_id_length'])) {
      		$this->data['oui_id_length'] = $this->request->post['oui_id_length'];
		}else {
      		$this->data['oui_id_length'] = '03';
    	}

    	if (isset($this->request->post['oui_id'])) {
      		$this->data['oui_id'] = $this->request->post['oui_id'];
		}else {
      		$this->data['oui_id'] = '037094';
    	}

    	if (isset($this->request->post['oad_frequency'])) {
      		$this->data['oad_frequency'] = $this->request->post['oad_frequency'];
		}else {
      		$this->data['oad_frequency'] = '0754';
    	}

    	if (isset($this->request->post['oda_symbol_rate'])) {
      		$this->data['oda_symbol_rate'] = $this->request->post['oda_symbol_rate'];
		}else {
      		$this->data['oda_symbol_rate'] = '6875';
    	}

    	if (isset($this->request->post['oad_modulation'])) {
      		$this->data['oad_modulation'] = $this->request->post['oad_modulation'];
		}else {
      		$this->data['oad_modulation'] = '00';
    	}

    	if (isset($this->request->post['chip_id'])) {
      		$this->data['chip_id'] = $this->request->post['chip_id'];
		}else {
      		$this->data['chip_id'] = '00';
    	}
    
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/force_nit_tunning', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/force_nit_tunning/save', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/force_nit_tunning/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/force_nit_tunning/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	// $this->data['stbs']=array();
	    	// $stb_info = $this->model_inventry_box_activation->getSTBs();
	    	// foreach ($stb_info as $stb) {
	    	// 	$this->data['stbs'][] = array('stb_id' => $stb['id'],
	    	// 								  'stb_no' => $stb['stb_no'],
	    	// 								  'customer_id' => $stb['customer_id'],
	    	// 								  'name' => $stb['name']);
	    	// }
    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'commands/force_nit_tunning_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm($post) {
    	if (!$this->user->hasPermission('modify', 'commands/force_nit_tunning')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
			$this->load->model('commands/force_nit_tunning');
  //   	if($this->request->post['target_level']==1)
  //   	{
	 //    	$stb_no=$this->request->post['target'];
	 //    	if($stb_no){
		//     	$result = $this->model_commands_ota_download->isSTBPaired($stb_no);
		//     	if ((strlen($stb_no)!=14)){
		//             $this->error['stb_no'] = $this->language->get('error_length');
		//        	}
		//         elseif($result["customer_id"]==0)
		//     	{
		//     		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
		//     	}
	 //      	}
		// 	else
		// 		{
		// 		$this->error['stb_no']="STB Field empty!";
		// 	}
		// }
	
		if(!is_numeric($this->request->post['transport_stream_id'])){
      		$this->error['transport_stream_id'] = "Accepts only digits!";
    	}else if ((utf8_strlen($this->request->post['transport_stream_id']) < 1) || (utf8_strlen($this->request->post['transport_stream_id']) > 4)) {
    		$this->error['transport_stream_id'] = "Length should be 1-4 digits";
    	}
    	// if(!is_numeric($this->request->post['original_network_id'])){
    	// 	$this->error['original_network_id'] = "Accepts only digits!";
    	// }elseif ((utf8_strlen($this->request->post['original_network_id']) < 1) || (utf8_strlen($this->request->post['original_network_id']) > 4)) {
     //  		$this->error['original_network_id'] = "Length should be 1-4 digits";
    	// }

    	if(!is_numeric($this->request->post['original_network_id'])){
    		$this->error['original_network_id'] = "Accepts only digits!";
    	}elseif ((utf8_strlen($this->request->post['original_network_id']) < 1) || (utf8_strlen($this->request->post['original_network_id']) > 5)) {
      		$this->error['original_network_id'] = "Length should be 1-5 digits";
    	}elseif($this->request->post['original_network_id'] > 65535){
    		$this->error['original_network_id'] = "Max limit is 65535";
    	} 
    	
    	if(!is_numeric($this->request->post['oad_frequency'])){
    		$this->error['oad_frequency'] = "Accepts only digits!";
    	}elseif ((utf8_strlen($this->request->post['oad_frequency']) < 1) || (utf8_strlen($this->request->post['oad_frequency']) > 4)) {
      		$this->error['oad_frequency'] = "Length should be 1-4 digits";
    	}
		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	}  

  	/*
FUNCTION NAME 		-	validateInsertForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateInsertForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/force_nit_tunning')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/force_nit_tunning');
		switch ($this->request->post['target_level']) {
			case 1:
				$lcoId  = $this->user->getOperatorIdFromStbno($this->request->post['filter_value']);
				if($this->request->post['filter_value']=='')
				{
					$this->error['user_data']='Please enter STB no ';	
				}else if(strlen($this->request->post['filter_value'])!=14)
				{
					$this->error['user_data']='STB no should be 14 digit ';	
				}elseif($this->model_commands_force_nit_tunning->isSTBBlackListed($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is Blacklisted.";
	    		}elseif($this->user->isStbSuspend($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is suspended, Please resume first.!";
	    		}elseif($this->user->isLcoSuspend($lcoId)){
	    			$this->error['user_data'] = $this->language->get('STB Belongs To LCO Is Suspended, Please Resume LCO First.!');
	    		}elseif($this->user->isStbRMA($this->request->post['filter_value'])){
	    			$this->error['user_data'] = $this->language->get('STB in RMA state.!');	
	    		}else{
					$stb=$this->model_commands_force_nit_tunning->isStbExistedAndPaired($this->request->post['filter_value']);
					if(!isset($stb['customer_id']))
					{
						$this->error['user_data']='Invalid STB no';
					}else if (isset($stb['customer_id'])) {
						if(!$stb['customer_id']>0)
							$this->error['user_data']='STB no is not paired with user';
					}
				}
				break;
			case 2:
				
				break;
			case 3:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter pin code ';
				else if(strlen($this->request->post['filter_value'])!=6)
					$this->error['user_data']='Pin code must be 6 digits';
				else{
					$pin=$this->model_commands_force_nit_tunning->checkPinExist($this->request->post['filter_value']);
					if(!$pin)
						$this->error['user_data']='Invalid PIN code';
				}
				break;
			case 4:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter group name';
				else {
					$group=$this->model_commands_force_nit_tunning->checkGroupExists($this->request->post['filter_value']);
					if(!$group)
						$this->error['user_data']='Invalid group name';	
				}
				break;    			
			default:
				$this->error['target_level']='Please select target ';
				break;
		}

		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	}  

  	/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/force_nit_tunning')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/force_nit_tunning');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_force_nit_tunning->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function decTohexAndMsb($target,$no_ofbits)
		{
		$target=dechex($target);
		$target=str_pad($target, $no_ofbits, '0', STR_PAD_LEFT);
    	$msblsb='';
    	for ($k=strlen($target); $k >0 ; $k-=2) { 
    		$msblsb.=substr($target,$k-2,2);
    	}
    	return $msblsb;
		}

	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id,$log_target_level_numeric){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	$log_target = (strlen($log_target)<22)?str_pad($log_target,24," "):substr($log_target, 0,22).".";
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").$log_target.$command);
        fclose($log_file);


        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level_numeric,$log_target,$command_id,$resend_status,'-1');
    }


 }
?> 