<?php 
 /*
@File emm_fingerprint.php(Controller)
ADMIN Emm Finger Print PAGE
    This class manages the all the EmmFingerprint  status.
    

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ControllerCommandsEmmFingerprint extends Controller {
	private $error = array();

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
public function index() {
		$this->language->load('commands/emm_fingerprint');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/emm_fingerprint');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the transaction list.
*/
public function getList() {	
	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['target_level'])) {
			$target_level = $this->request->get['target_level'];
		} else {
			$target_level = '';
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
		} else {
			$filter_value = '';
		}
				
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['target_level'])) {
			$url .= '&target_level=' . $this->request->get['target_level'];
		}
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
  			
		
   		$this->data['insert'] = $this->url->link('commands/emm_fingerprint/insert', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['bmails'] = array();
		$data = array(
			'target_level'	  => $target_level,
			'filter_value'	  => $filter_value,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->post['target_level'])) {
			$this->data['target_level'] = $this->request->post['target_level'];
		} else if (isset($this->request->get['target_level'])) {
			$this->data['target_level'] = $this->request->get['target_level'];
			$this->session->data['target_level']=$this->data['target_level'];
		}else {
			$this->data['target_level'] =-1;
		}

		// if(isset($this->session->data['target_level']))
		// 	$this->data['target_level']=$this->session->data['target_level'];
		
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
			$data['target_level']=$this->data['target_level'];
		} else if (isset($this->request->post['filter_value'])) {
			$this->data['filter_value'] = $this->request->post['filter_value'];
		} else{
			$this->data['filter_value'] = '';
			
		}

		$this->data['targets']=array(
			'-1' => 'Please select',
			'1'  => 'Individual',
			'2'  => 'Global',
			'3'  => 'Region',
			'4'  => 'Group');
		$total=0;
		/*if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['target_level']))||(isset($data['target_level']) && $data['target_level']!=-1))
		{*/
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['target_level'])))
		{	
			$total = $this->model_commands_emm_fingerprint->getTotalEmmFingeprint($data);

			$results = $this->model_commands_emm_fingerprint->getEmmFingerprint($data);
			foreach ($results as $result) 
			{	
				$resend = $this->url->link('commands/emm_fingerprint/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
				$de_activation = $this->url->link('commands/emm_fingerprint/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
				
				$this->data['bmails'][] = array(
					'id'  		 	 => $result['id'],
					'tx_id'  		 => $result['tx_id'],
					'trigger_on'    => $result['modify_date'],
					'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
					'cmd_id'         => $result['cmd_id'],
					'stb_no'         => ($data['target_level']==1)?$result['STBNO']:(($data['target_level']==2)?'Global':(($data['target_level']==3)?$result['region_name']:$result['name'])),
					'resend'         => $resend,
					'de_activation'  => $de_activation,
					'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
				);	
			}
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['target_level'])) {
			$this->data['error_target_level'] = $this->error['target_level'];
		}else{
			$this->data['error_target_level'] ='';
		}
		if (isset($this->error['user_data'])) {
			$this->data['error_user_data'] = $this->error['user_data'];
		}else{
			$this->data['error_user_data'] ='';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/emm_fingerprint.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function save() {
  // echo "<pre>";  print_r($this->request->post); die;
		$this->language->load('commands/emm_fingerprint');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/emm_fingerprint');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			// var_dump($this->request->post);exit();
			if($this->validateForm($this->request->post)) {


		  		$target_level=$this->request->post['target_level'];
		  		switch ($target_level) {
		  			case 1:
		  				$customer_id =$this->model_commands_emm_fingerprint->getCustomerId($this->request->post['target']);
				 	  	$local_target = (int)$customer_id["customer_id"];
				 	  	$target = (int)$customer_id["api_user_id"];
				 	  	$operator_id = (int)$customer_id["operator_id"];

				 	  	$log_target_level="Individual";
				 	  	$log_target_level_numeric = 1;
				 	  	$log_target = $this->request->post['target'];
		  				break;
		  			case 2:
		  				$target=0;
		  				$local_target=0;
		  				$operator_id=$this->session->data['user_id'];

		  				$log_target_level="Global";
		  				$log_target_level_numeric = 2;
				 	  	$log_target = "n/a";
		  				break;
		  			case 3:
		  				$target=$this->request->post['target'];
		  				$local_target=$this->request->post['target'];
		  				$operator_id=$this->session->data['user_id'];

		  				$log_target_level="Regional";
		  				$log_target_level_numeric = 3;
				 	  	$log_target = $this->request->post['target'];
		  				break;
		  			case 4:
		  				$this->load->model('commands/ota_download');
		  				$group_ids=$this->model_commands_ota_download->getGroupIdByname($this->request->post['target']);
		  				$target= $group_ids['kms_group_id'];
		  				$local_target=$group_ids['sms_group_id'];
		  				$operator_id=$this->session->data['user_id'];

		  				$log_target_level="Group";
		  				$log_target_level_numeric = 4;
				 	  	$log_target = $this->request->post['target'];
		  				break;		  			
		  			default:
		  				break;
		  		}
		  		$datetime = new DateTime($this->request->post['expiry'], new DateTimeZone('Asia/Calcutta'));
				$expiry = $datetime->getTimestamp();
				$is_covert = $this->request->post["mode_fp"];
				if($this->request->post["mode_fp"]==0){
			 	 	$location = ($this->request->post["location"]);
			 	 	$display_duration = $this->request->post["display_duration"];		 	 	
			 	 	$background_color = $this->request->post["backgrd_color"];
			 	 	$font_size = $this->request->post["front_size"];
			 	 	$font_style = $this->request->post["front_style"];
			 	 	$content_identifier = $this->request->post["emmfp_content_identifier"];
			 	 	$height = $this->request->post['location_pixel_x'];
					$width  = $this->request->post['location_pixel_y'];
			 	 	// $is_covert = $this->request->post["mode_fp"];
					$text_color = $this->request->post["fore_color"];
					$covert_pattern =0;
				}else{
					$location = 0;
					$display_duration = 0;	
					$background_color = 0;
					$font_size = 18;
					$font_style = 0;
					$content_identifier = 8;
					$height = 0;
					$width  = 0;					
					$text_color = 0;
					$covert_pattern = $this->request->post["emmfp_covert_pattern"];
					// $is_covert = $this->request->post["mode_fp"];
				}
		 	 	
				//Call of API
				$obj = new restapi();
			    $method ="POST";
				$data="target_level=".$target_level."&target=".$target."&is_random=".$location."&is_covert=".$is_covert."&display_duration=".$display_duration."&expiry=".$expiry.
				"&location_x=".$height."&location_y=".$width."&font_style=".$font_style."&font_size=".$font_size."&text_color=".$text_color."&background_color=".$background_color."&content_identifier=".$content_identifier."&covert_pattern=".$covert_pattern;
				// var_dump($data);die;
			    $url="".KMS_API."/EMMFingerPrint";
			    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
			   
			    //Process API response and add to db
			    $response=json_decode($apiresult);

			     $error=true;
			     $errorMsg='';
			     $apimessage="KMS API Failed";
			    foreach ($response as $key => $value) {
			    	switch ($key) {
			    		case 'error':
			    			$error=$value;
			    		break;
			    		case 'id':
			    			$id=$value;
			    		break;
			    		case 'message':
			    			$apimessage=$value;
			    		break;
			    		case 'mq_response':
			    			$curlresponse=$value;
			    		break;
			    		default:
			    			$errorMsg=$errorMsg." ".$key. ": ".$value;
			    		break;
			    	}
				}

				

				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{	
					$resend_status = 0;
					$commandid = 4;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"EMM FINGERPRINT",$resend_status,$commandid,$log_target_level_numeric);
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					$payload = $target."#".$is_covert."#".$display_duration."#".$location."#".$height."#".$width."#".$background_color."#".$font_style."#".$font_size."#".$text_color."#".$content_identifier."#".$covert_pattern."#".$res;
						$this->model_commands_emm_fingerprint->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id);
						$this->session->data['success'] = $apimessage;
						$url = '';
						$this->redirect($this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['target'], 'SSL'));
					}else{
						$errorMsg=$errorMsg." ".$apimessage;
						$this->session->data['warning']="In CAS :".$apimessage;//$errorMsg;
						$url = '';
						$this->redirect($this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'] . $url, 'SSL'));
						
					 }
				}else{
					$this->data['emm_target']=array('target_level' =>$this->request->post['target_level'],
												'target'       =>$this->request->post['target']);
				}
			}
	$this->getForm();
}

		  	/*
			FUNCTION NAME 		-	insert
			DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
									details of the new review. 
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
			*/ 
		public function insert() {
		  		
			$obj = new restapi();
			$this->language->load('commands/emm_fingerprint');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('commands/emm_fingerprint');

			if ($this->request->server['REQUEST_METHOD'] == 'POST') {
				if($this->validateInsertForm($this->request->post)) {
					
					$this->data['emm_target']=array('target_level' =>$this->request->post['target_level'],
													'target'       =>$this->request->post['filter_value']);
					$this->getForm();
				}else{
					$this->getList();
				}
			}else
				$this->getList();
		}
 /*
FUNCTION NAME 		-	resend
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
   public function resend() {

		$this->language->load('commands/emm_fingerprint');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/bmail');
		$this->load->model('commands/emm_fingerprint');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{
     		$transaction_details=$this->model_commands_bmail->getTransactionDetails($this->request->get['id']);
     		
     		$customer_id=$transaction_details['user_id'];
    		$target_lvl=$transaction_details['target_level'];
    		$trans_id=$transaction_details['tx_id']; 
    		$cmd_id=$transaction_details['cmd_id'];
    		$operator_id=$transaction_details['operator_id'];
    		switch ($target_lvl) {
    			case 1:
    					$target=$this->model_commands_bmail->getKMSUserId($transaction_details['user_id']);
    					$targ_value=$this->model_commands_bmail->getSTBno($transaction_details['user_id']);

    					$log_target_level="Individual";
    					$log_target_level_numeric = 1;
    					$log_target = $targ_value;
    			break;
    			case 2:
    					$target=0;
    					$targ_value=0;

    					$log_target_level="Global";
    					$log_target_level_numeric = 2;
    					$log_target = "n/a";
    			break;
    			case 3:
    					$target=$transaction_details['user_id'];
    					$targ_value=$target;

    					$log_target_level="Regional";
    					$log_target_level_numeric = 3;
    					$log_target = $targ_value;
    			break;
    			case 4:
    					$target=$this->model_commands_bmail->getKMSGroupId($transaction_details['user_id']);
    					$targ_value=$this->model_commands_bmail->getGroupNameById($transaction_details['user_id']);

    					$log_target_level="Group";
    					$log_target_level_numeric = 4;
    					$log_target = $targ_value;
    			break;
    		}
    		
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$target."&target_level=".$target_lvl;
		  	$method ="POST";
			$uri=KMS_API."/Resend";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);		
		    $error=true;
		    $errorMsg='';
		    $apimessage=" Kms fail to enable STB";

		    foreach ($response as $key => $value) {
				switch ($key) {
					case 'error':
						$error=$value;
					break;
					case 'id':
						$id=$value;
					break;
					case 'mq_response':
						$curlresponse=$value;
					break;
					case 'message':
						$apimessage=$value;			
					break;
					default:
						$errorMsg=$errorMsg." ".$key.":".$value;	
						break;
				}
			}

			
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{	
				$resend_status = 1;
				$commandid = 4;
				$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND EMM FINGERPRINT",$resend_status,$commandid,$log_target_level_numeric);
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$payload=$trans_id."#".$cmd_id."#".$target;
				$target=1;
				$targetdata=0;
				$results = $this->model_commands_emm_fingerprint->addToCasOpTransanction($target_lvl,$transaction_details['user_id'],$id,$payload,$ack_is,$nack_is,$operator_id);
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
		}
		$this->session->data['warning'] = $this->error['warning'];
     	$this->redirect($this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_lvl.'&filter_value='.$targ_value, 'SSL'));
  	}

/*
FUNCTION NAME 		-	deActivation
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  // 	public function deActivation() {
		// $this->language->load('commands/emm_fingerprint');
  //   	$this->document->setTitle($this->language->get('heading_title'));
		// $this->load->model('commands/emm_fingerprint');
  // 		$obj = new restapi();
  		
  //   	if($this->validate())
  //   	{
    		
  //    		$transaction_details=$this->model_commands_emm_fingerprint->getTransactionDetails($this->request->get['id']);
  //    		$customer_id=$transaction_details['user_id'];
  //   		$user_id=$transaction_details['api_user_id'];
  //   		$operator_id=$transaction_details['operator_id'];
  //   		$target_lvl=1;
  //   		$trans_id=$transaction_details['tx_id'];
  //   		$cmd_id=$transaction_details['cmd_id'];
    		
		//   	$data="transaction_id=".$trans_id."&command_id=".$cmd_id."&target=".$customer_id."&target_level=".$target_lvl;
		  	
		//   	$method ="POST";
		// 	$uri=KMS_API."/Disable";		
		// 	$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
		// 	$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
		//     //Process API response and add to db 
		//     $response=json_decode($apiresult);			
		//     var_dump($response);exit();
		//     $error=true;
		//     $errorMsg='';
		//     $apimessage=" Kms fail to enable STB";

		//     foreach ($response as $key => $value) {
		// 		if($key=='error'&&$value==false)
		// 		{
		// 			$error=false;
		// 		}if($key=='error'&&$value==true)
		// 		{
		// 			$error=true;	
		// 		}
		// 		if($key=='id')
		// 		{
		// 			$id=$value;
		// 		}
		// 		if($key=='mq_response')
		// 		{
		// 			$curlresponse=$value;
		// 		}if($key=='message')
		// 		{
		// 			$apimessage=$value;			
		// 		}if($key=='disble_command_id')
		// 		{
		// 			$cmd_id=$value;			
		// 		}if($key!='id' && $key!='error' && $key!='message')
		// 		{
		// 			$errorMsg=$errorMsg." ".$key.":".$value;
		// 		}
		// 	}
		// 	$ack_is=-1;$nack_is=-1;
		// 	if(!$error)
		// 	{
		// 		$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
		// 		if($ack=='ACK')
		// 		{
		// 			$ack_is=1;
		// 		}elseif($ack=='NACK'){
		// 			$nack_is=-1;
		// 		}
		// 		$resp=split('`', $curlresponse);
		// 		$payload=$user_id."#".$cmd_id."#".$trans_id;
		// 		$target=1;
		// 		$targetdata=0;
		// 		$results = $this->model_commands_emm_fingerprint->addToCasOpTransanction($customer_id,$cmd_id,$id,$payload,$ack_is,$nack_is,$operator_id);
		// 		$this->session->data['success']=$apimessage;
		// 	}else{
		// 		$errorMsg=$errorMsg."  ".$apimessage;
		// 		$this->session->data['warning']=$errorMsg;
		// 	}
		// }
  //    	$this->redirect($this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  // 	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb']		    = $this->language->get('entry_stb');
 		$this->data['entry_mode_fp']   = $this->language->get('entry_mode_fp');
 		$this->data['entry_display_duration'] 		= $this->language->get('entry_display_duration');
 		$this->data['entry_expiry'] 		= $this->language->get('entry_expiry');
 		$this->data['entry_message'] 		= $this->language->get('entry_message');
 		$this->data['entry_location'] 		= $this->language->get('entry_location');
 		$this->data['entry_location_pixel'] 		= $this->language->get('entry_location_pixel');
 		// $this->data['entry_location_pixel'] 		= $this->language->get('entry_location_pixel');
 		$this->data['entry_backgrd_color'] 		= $this->language->get('entry_backgrd_color');
 		$this->data['entry_front_style'] 		= $this->language->get('entry_front_style');
 		$this->data['entry_front_size'] 		= $this->language->get('entry_front_size');
		 		
		$this->data['entry_fore_color'] 		= $this->language->get('entry_fore_color');
		$this->data['entry_content_identifier'] 		= $this->language->get('entry_content_identifier');
 		// entry_location
 		
 		
		$this->data['button_save'] = $this->language->get('button_send');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['display_duration'])) {
			$this->data['error_duration'] = $this->error['display_duration'];
		} else {
			$this->data['error_duration'] = '';
		}

		if (isset($this->error['expiry'])) {
			$this->data['error_expiry'] = $this->error['expiry'];
		} else {
			$this->data['error_expiry'] = '';
		}
		//-----------
		if (isset($this->request->get['fore_color'])) {
			$url .= '&fore_color=' . $this->request->get['fore_color'];
		}
		if (isset($this->request->get['backgrd_color'])) {
			$url .= '&backgrd_color=' . $this->request->get['backgrd_color'];
		}

		//----------
		if (isset($this->error['location_pixel_x'])) {
			$this->data['error_x_loc'] = $this->error['location_pixel_x'];
		} else {
			$this->data['error_x_loc'] = '';
		}
		if (isset($this->error['location_pixel_y'])) {
			$this->data['error_y_loc'] = $this->error['location_pixel_y'];
		} else {
			$this->data['error_y_loc'] = '';
		}


		if (isset($this->request->post['en_loc'])) {
      		$this->data['en_loc'] = $this->request->post['en_loc'];
		}else {
      		$this->data['en_loc'] = '';
    	}
    	if (isset($this->request->post['emmfp_content_identifier'])) {
      		$this->data['emmfp_content_identifier'] = $this->request->post['emmfp_content_identifier'];
		}else {
      		$this->data['emmfp_content_identifier'] = '';
    	}
    	if (isset($this->request->post['emmfp_covert_pattern'])) {
      		$this->data['emmfp_covert_pattern'] = $this->request->post['emmfp_covert_pattern'];
		}else {
      		$this->data['emmfp_covert_pattern'] = '';
    	}
    	if (isset($this->request->post['fore_color'])) {
      		$this->data['fore_color'] = $this->request->post['fore_color'];
		}
		else {
      		$this->data['fore_color'] = '';
    	}
    	
    	if (isset($this->error['fore_color'])) {
			$this->data['error_fore_color'] = $this->error['fore_color'];
		} else {
			$this->data['error_fore_color'] = '';
		}
    	
    	if (isset($this->request->post['front_size'])) {
      		$this->data['front_size'] = $this->request->post['front_size'];
		}else {
      		$this->data['front_size'] = '';
    	}
    	if (isset($this->request->post['front_style'])) {
      		$this->data['front_style'] = $this->request->post['front_style'];
		}else {
      		$this->data['front_style'] = '';
    	}
    	if (isset($this->request->post['backgrd_color'])) {
      		$this->data['backgrd_color'] = $this->request->post['backgrd_color'];
		}else {
      		$this->data['backgrd_color'] = '';
    	}
    	
    	if (isset($this->request->post['location_pixel_x'])) {
      		$this->data['location_pixel_x'] = $this->request->post['location_pixel_x'];
		}else {
      		$this->data['location_pixel_x'] = '';
    	}

		if (isset($this->request->post['location_pixel_y'])) {
      		$this->data['location_pixel_y'] = $this->request->post['location_pixel_y'];
		}else {
      		$this->data['location_pixel_y'] = '';
    	}



    	if (isset($this->request->post['en_loc'])) {
      		$this->data['en_loc'] = $this->request->post['en_loc'];
		}else {
      		$this->data['en_loc'] = '';
    	}
    	if (isset($this->request->post['display_duration'])) {
      		$this->data['display_duration'] = $this->request->post['display_duration'];
		}else {
      		$this->data['display_duration'] = '';
    	}


    	if (isset($this->request->post['display_duration'])) {
      		$this->data['display_duration'] = $this->request->post['display_duration'];
		}else {
      		$this->data['display_duration'] = '';
    	}
    	if (isset($this->request->post['mode_fp'])) {
      		$this->data['mode_fp'] = $this->request->post['mode_fp'];
		}else {
      		$this->data['mode_fp'] = '';
    	}
    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/emm_fingerprint/save', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/emm_fingerprint/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/emm_fingerprint/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	// $this->data['stbs']=array();
	    	// $stb_info = $this->model_inventry_box_activation->getSTBs();
	    	// foreach ($stb_info as $stb) {
	    	// 	$this->data['stbs'][] = array('stb_id' => $stb['id'],
	    	// 								  'stb_no' => $stb['stb_no'],
	    	// 								  'customer_id' => $stb['customer_id'],
	    	// 								  'name' => $stb['name']);
	    	// }
    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'commands/emm_fingerprint_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm($post) {
  		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('Y-m-d H:i:s');
  			
    	if (!$this->user->hasPermission('modify', 'commands/emm_fingerprint')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/emm_fingerprint');
		// var_dump($post["backgrd_color"]);
		// var_dump($post["fore_color"]);
		// exit();
		if($this->request->post['target_level']==1)
		{
	    	$stb_no=$this->request->post['target'];
	    	if($stb_no){
	    		$result = $this->model_commands_emm_fingerprint->isSTBPaired($stb_no);
		    	if ((strlen($stb_no)!=14)){
		            $this->error['stb_no'] = $this->language->get('error_length');
		       	}
		        elseif($result["customer_id"]==0)
		    	{
		    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
		    	}
	      	}
			else
			{
				$this->error['stb_no']="Stb field is empty!";
			}
		}
		
		if($this->request->post["expiry"]==""){
			$this->error['expiry'] = "Expiry Required!";
		}elseif ($this->request->post['expiry'] < $current_date) {
			$this->error['expiry'] = "Expiry time must be greater than current time!";
		}

		if($this->request->post['mode_fp']==0){
			if (!$this->request->post['display_duration']) {
				$this->error['display_duration'] = $this->language->get('error_duration');
			}elseif(!preg_match("#^[a-zA-Z0-9. ]+$#", $this->request->post['display_duration'])){
				$this->error['display_duration']="Special Characters not allowed!";
			}elseif((int)($this->request->post['display_duration'])<10 ||(int)($this->request->post['display_duration'])>120){
					$this->error['display_duration'] = "Display duration must be less than 120 and greater than 10!";
			}

			if (!preg_match('/^[0-9]+$/', $this->request->post['display_duration'])) {
			  $this->error['display_duration']="Only numeric is allowed";
			} 
			
			if($this->request->post['location']==0)
			{
			if (!$this->request->post['location_pixel_x']) {
				$this->error['location_pixel_x'] = $this->language->get('error_x_loc');
			}
			elseif(!is_numeric($this->request->post['location_pixel_x'])){
				$this->error['location_pixel_x'] = $this->language->get('error_x_loc_interger');	
			}
			elseif(((int)($this->request->post['location_pixel_x'])<50)||((int)($this->request->post['location_pixel_x'])>650)){
				$this->error['location_pixel_x'] = $this->language->get('error_x_loc_range');	
			}
			if (!$this->request->post['location_pixel_y']) {
				$this->error['location_pixel_y'] = $this->language->get('error_y_loc');
			}
			elseif(!is_numeric($this->request->post['location_pixel_y'])){
				$this->error['location_pixel_y'] = $this->language->get('error_y_loc_interger');	
			}
			elseif(((int)($this->request->post['location_pixel_y'])<50)||((int)($this->request->post['location_pixel_y'])>650)){
				$this->error['location_pixel_y'] = $this->language->get('error_y_loc_range');	
			}
			}
			if(!strcmp($post["backgrd_color"],$post["fore_color"])) {
				$this->error['fore_color'] = $this->language->get('error_fore_color');
			}
		}

		if (!$this->error) {
	  		return true;
		} else {
	 		return false;
		}
  	}  

	/*
FUNCTION NAME 		-	validateInsertForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateInsertForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/emm_fingerprint')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/ota_download');
		$this->load->model('commands/osd');
		$this->load->model('commands/emm_fingerprint');
		switch ($this->request->post['target_level']) {
			case 1:
				$lcoId  = $this->user->getOperatorIdFromStbno($this->request->post['filter_value']);
				if($this->request->post['filter_value']=='')
				{
					$this->error['user_data']='Please enter STB no ';	
				}else if(strlen($this->request->post['filter_value'])!=14){
					$this->error['user_data']='STB no should be 14 digit ';	
				}elseif($this->model_commands_emm_fingerprint->isSTBBlackListed($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is Blacklisted.";
	    		}elseif($this->user->isStbSuspend($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is suspended, Please resume first.!";
	    		}elseif($this->user->isLcoSuspend($lcoId)){
	    			$this->error['user_data'] = $this->language->get('STB Belongs To LCO Is Suspended, Please Resume LCO First.!');
	    		}elseif($this->user->isStbRMA($this->request->post['filter_value'])){
	    			$this->error['user_data'] = $this->language->get('STB in RMA state.!');	
	    		}else{
					$stb=$this->model_commands_ota_download->isStbExistedAndPaired($this->request->post['filter_value']);
					if(!isset($stb['customer_id']))
					{
						$this->error['user_data']='Invalid STB no';
					}else if (isset($stb['customer_id'])) {
						if(!$stb['customer_id']>0)
							$this->error['user_data']='STB no is not paired with user';
					}
					// -------------------CHECK IF BOX IS BLACKLISTED-------------------------
				 		$is_blacklist = $this->model_commands_osd->isBlacklist($this->request->post['filter_value']);
				 		if($is_blacklist==1){
				 			$this->error['user_data'] = 'STB Blacklisted!!!';			 			
				 		}
				 	// -----------------------------------------------------------------------------
				}
				break;
			case 2:
				
				break;
			case 3:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter pin code ';
				else if(strlen($this->request->post['filter_value'])!=6)
					$this->error['user_data']='Pin code must be 6 digits';
				else{
					$pin=$this->model_commands_ota_download->checkPinExist($this->request->post['filter_value']);
					if(!$pin)
						$this->error['user_data']='Invalid PIN code';
				}
				break;
			case 4:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter group name';
				else {
					$group=$this->model_commands_ota_download->checkGroupExists($this->request->post['filter_value']);
					if(!$group)
						$this->error['user_data']='Invalid group name';	
				}
				break;    			
			default:
				$this->error['target_level']='Please select target ';
				break;
		}

		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	} 
  	/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/emm_fingerprint')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
    	// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		$stb_no = $this->model_commands_emm_fingerprint->getStbNoFromId($this->request->get['id']);
		
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_emm_fingerprint->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
	 		}

			$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}	

	 		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB in RMA state.!');		
	 		} 		
	 	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/emm_fingerprint');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_emm_fingerprint->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function decTohexAndMsb($target,$no_ofbits)
		{
		$target=dechex($target);
		$target=str_pad($target, $no_ofbits, '0', STR_PAD_LEFT);
    	$msblsb='';
    	for ($k=strlen($target); $k >0 ; $k-=2) { 
    		$msblsb.=substr($target,$k-2,2);
    	}
    	return $msblsb;
		}

	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id,$log_target_level_numeric){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	$log_target = (strlen($log_target)<22)?str_pad($log_target,24," "):substr($log_target, 0,22).".";
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").$log_target.$command);
        fclose($log_file);


        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level_numeric,$log_target,$command_id,$resend_status,'-1');
    }


 }
?> 