<?php 
 /*
@File box_activation.php(Controller)
ADMIN BoxActivation PAGE
    This class manages the all the BoxActivation  status.
    

@Author Mahesh Yallure 
@date 19 Jan. 2016
*/
class ControllerCommandsBoxActivation extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
	public function index() {
		$this->language->load('commands/box_activation');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('commands/box_activation');
    	$this->getList();
  	}


	/*
	FUNCTION NAME 		-	getList
	DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
							database and make a list for it.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Renders the transaction list.
	*/
	public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
		
		
   		$this->data['insert'] = $this->url->link('commands/box_activation/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['stb_activations'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		$total = $this->model_commands_box_activation->getTotalStbActivations($data);

		$results = $this->model_commands_box_activation->getActivationTransactions($data);
		// echo "<pre>"; print_r($results); die;
		foreach ($results as $result) 
		{	
			$resend = $this->url->link('commands/box_activation/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
			$de_activation = $this->url->link('commands/box_activation/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
			
			$this->data['stb_activations'][] = array(
				'id'  		 	 => $result['id'],
				'tx_id'  		 => $result['tx_id'],
				'stb_no'    	 => $result['STBNO'],
				'trigger'	     => $result['modify_date'],
				'expiry'	     => ($result['exp_date'])?$result['exp_date']:'N/A',
				'name'           => $result['name'],
				'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
				'type'         	 => (($result['cmd_id']==0)?'Activation' :'De-Activation'),
				'cmd_id'         => $result['cmd_id'],
				'resend'         => $resend,
				'de_activation'  => $de_activation,
				'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_expiry'] = $this->language->get('column_expiry');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/box_activation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/box_activation.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


	  	/*
	FUNCTION NAME 		-	insert
	DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
							details of the new review. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
	*/  
  	public function insert() {
  		
		$obj = new restapi();
		$this->language->load('commands/box_activation');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_activation');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if($this->validateForm($this->request->post)) {

				// switch ($this->request->post["expiry_time"]) {
				// 	case 'month':
				// 		$expiry_time=strtotime("+1 month",time());
				// 		break;
				// 	case 'day':
				// 		$expiry_time=strtotime("+1 day",time());
				// 		break;	
				// 	case 'hour':
				// 		$expiry_time=strtotime("+1 hour",time());
				// 		break;
				// 	case 'min':
				// 		$expiry_time=strtotime("+1 mins",time());
				// 		break;	
				// 	default:
				// 		$expiry_time=strtotime("+1 year",time());// +31536000;
				// 		break;
				// }
				$expiry_time=strtotime("+10 year",time());
				$expiry_time=$expiry_time+19800;
				$expiry_time=date('Y-m-d H:i:s',$expiry_time);
				$kms_expiry=strtotime($expiry_time);
				// 

		  		$customer_id = $this->model_commands_box_activation->getCustomerId($this->request->post['stb_no']);
			    $operator_id=$customer_id['operator_id'];
			    //$data="stb_no=".$this->request->post['stb_no']."&chipno=".$this->request->post['chip_no'];
			    // $data="stb_no=".$this->request->post['stb_no']."&chipno=".$this->request->post['chip_no']."&expiry=".$kms_expiry;
				if(strcmp($this->request->post['chip_no'],"")==0){
					$data="stb_no=".$this->request->post['stb_no']."&expiry=".$kms_expiry;
				}else{
					$data="stb_no=".$this->request->post['stb_no']."&chip_no=".$this->request->post['chip_no']."&expiry=".$kms_expiry;
				}
		 		$method ="POST";
		 		$url=KMS_API."/enableSTBActivation";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);

	    		$response=json_decode($apiresult);
	    		$apimessage='';
	    		$errorMsg='';
	    		$error=true;	
	    		$cmd_id=0;
				foreach ($response as $key => $value) {
					switch ($key) {
					case 'error':
						$error=$value;
						break;
					case 'id':
						$id=$value;
						break;
					case 'mq_response':
						$curlresponse=$value;
						break;
					case 'message':
						$apimessage=$value;
						break;
					default:
						$errorMsg=$key.':'.$value;
						break;
					}
				}
				$log_target_level = "Individual";
				$log_target = $this->request->post['stb_no'];
				
				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{
					$resend_status = 0;
					$commandid = 0;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"BOX ACTIVATION",$resend_status,$commandid);
					$cust_id=$customer_id['customer_id'];
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
						$this->model_commands_box_activation->setSTBActiveDeactive(1,$cust_id,1);	
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					$resp=split('`', $curlresponse);
					$payload=$this->request->post['stb_no']."#".$this->request->post['chip_no'];
					$target=1;
					
					$results = $this->model_commands_box_activation->addToCasOpTransanction($cust_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$expiry_time,$operator_id,$this->request->post['stb_no']);
					$this->model_commands_box_activation->addPasscode($this->request->post['stb_no'],$this->request->post['chip_no']);
					/*=======================================================*/
						if($ack_is==1){
							$this->model_commands_box_activation->addToActivationDeactivation($cust_id,$cmd_id,$id,$ack_is,$expiry_time,$operator_id,$this->request->post['stb_no']);
						}
					/*=======================================================*/

					$this->session->data['success']=$apimessage;
					$url = '';
									
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}

					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}

					if (isset($this->request->get['page'])) {
						$url .= '&page=' . $this->request->get['page'];
					}
					$this->redirect($this->url->link('commands/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'));
				}else{
					$this->error['warning']=$errorMsg." ".$apimessage;
			 		$this->getForm();
				}
			}
		}
    	
    	$this->getForm();
  	} 

		 /*
		FUNCTION NAME 		-	resend
		DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
								added/uploaded earlier. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
		*/
   
  	public function resend() {

		$this->language->load('commands/box_activation');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_activation');
  		$obj = new restapi();
  		
    	if($this->validate()){
     		$transaction_details= $this->model_commands_box_activation->getTransactionDetails($this->request->get['id']);
     		$customer_id 	= $transaction_details['user_id'];
    		$user_id 		= $transaction_details['api_user_id'];
    		$operator_id 	= $transaction_details['operator_id'];
    		$target_lvl 	= 1;
    		$trans_id 		= $transaction_details['tx_id'];
    		$cmd_id 		= $transaction_details['cmd_id'];
		  	$data 			= "transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;		  	
		  	$method 		= "POST";
			$uri 			= KMS_API."/Resend";		
			$hdr 			= array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			
			$apiresult 		= $obj->callAPI($method,$hdr,$uri,$data);

		    //Process API response and add to db 
		    $response = json_decode($apiresult);	
		    
		    $error = true;
		    $errorMsg = '';
		    $apimessage = " Kms fail to enable STB";

		    foreach ($response as $key => $value) {
		    	switch ($key) {
		    		case 'error':
		    			$error = $value;	
		    		break;
		    		case 'id':
		    			$id = $value;	
		    		break;
		    		case 'message':
		    			$apimessage = $value;	
		    		break;
		    		case 'mq_response':
		    			$curlresponse = $value;	
		    		break;
		    		default:
		    			$errorMsg = $errorMsg." ".$key.":".$value;
		    			break;
		    	}
			}
			
			$ack_is = -1;$nack_is = -1;
			if(!$error)
			{	
				$resend_status = 1;
				$commandid = 0;
				$log_target_level = "Individual";
				$log_target = $this->model_commands_box_activation->getStbNo($customer_id);;
				$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND BOX ACTIVATION",$resend_status,$commandid);
				$ack = ((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
					$this->model_commands_box_activation->setSTBActiveDeactive(1,$customer_id,2);	
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp = split('`', $curlresponse);
				$payload = $trans_id."#".$cmd_id."#".$user_id;
				$target = 1;
				$targetdata = 0;

				$results = $this->model_commands_box_activation->addToCasOpTransanction($customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$transaction_details['exp_date'],$operator_id,$log_target);
				$this->session->data['success'] = $apimessage;
			}else{
				$errorMsg = $errorMsg."  ".$apimessage;
				$this->session->data['warning'] = $errorMsg;
			}
			$this->redirect($this->url->link('commands/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}else{
			
			$this->session->data['warning'] = $this->error['warning'];
			$this->redirect($this->url->link('commands/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
     	
  	}  

		/*
		FUNCTION NAME 		-	deActivation
		DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
								added/uploaded earlier. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
		*/
   
    public function deActivation() {
		$this->language->load('commands/box_activation');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_activation');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{    	
    		$transaction_details= $this->model_commands_box_activation->getTransactionDetails($this->request->get['id']);
     		$customer_id = $transaction_details['user_id'];
     		if ($this->validateDeactivate($customer_id)) {
        		$user_id=$transaction_details['api_user_id'];
	    		$operator_id=isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
	    		$target_lvl=1;
	    		// $trans_id=$transaction_details['tx_id'];
	    		$stb_no = $this->model_commands_box_activation->getStbNo($customer_id);
	    		$cmd_id=$transaction_details['cmd_id'];
			  	$data="stb_no=". $stb_no."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;

			  	$stbStatus = $this->model_commands_box_activation->getStbNoStatus($customer_id);
			  	if($stbStatus=='0'){
			  		$this->session->data['warning'] = "Customer is disabled, Can't process it..!!";
			  	}else{
				  	
				  	$method ="POST";
					$uri=KMS_API."/Disable";		
					$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					
					$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
				    //Process API response and add to db 
				    $response=json_decode($apiresult);
				    $error=true;
				    $errorMsg='';
				    $apimessage='';
				    $cas_dashboard_response='';

				    foreach ($response as $key => $value) {
				    	switch ($key) {
				    		case 'error':
				    			$error=$value;	
				    		break;
				    		case 'id':
				    			$id=$value;	
				    		break;
				    		case 'disble_command_id':
				    			$cmd_id=$value;	
				    		break;
				    		case 'message':
				    			$apimessage=$value;	
				    		break;
				    		case 'mq_response':
				    			$curlresponse=$value;	
				    		break;
				    		case 'cas_dashboard_response':
				    			$cas_dashboard_response=$value;	
				    		break;
				    		default:
				    			$errorMsg=$errorMsg." ".$key.":".$value;		
				    		break;
				    	}

						/*if($key=='error'&&$value==false)
						{
							$error=false;
						}if($key=='error'&&$value==true)
						{
							$error=true;	
						}
						if($key=='id')
						{
							$id=$value;
						}
						if($key=='mq_response')
						{
							$curlresponse=$value;
						}if($key=='message')
						{
							$apimessage=$value;			
						}if($key=='disble_command_id')
						{
							$cmd_id=$value;			
						}if($key!='id' && $key!='error' && $key!='message')
						{
							$errorMsg=$errorMsg." ".$key.":".$value;
						}*/
					}
					
					$ack_is=-1;$nack_is=-1;
					if(!$error)
					{	
						$resend_status = 0;
						$commandid = 1;
						$log_target_level = "Individual";
						$log_target = $this->model_commands_box_activation->getStbNo($customer_id);
						$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"BOX De-ACTIVATION",$resend_status,$commandid);
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
						if($ack=='ACK')
						{
							$ack_is=1;
							// $this->model_commands_box_activation->setSTBActiveDeactive(0,$customer_id,3);	
							$this->model_commands_box_activation->setSTBActiveDeactiveOnlyForDeactivation(0,$customer_id,3);	
						}elseif($ack=='NACK'){
							$nack_is=-1;
						}
						$resp=explode('`', $curlresponse);
						$payload=$stb_no."#".$cmd_id."#".$user_id;
						$target=1;
						$targetdata=0;

						/*=======================================================*/
						if($ack_is==1){
							$this->model_commands_box_activation->getIdsForExpiryUpdate($transaction_details["user_id"],$this->request->get['id']);	
							if(!$this->model_commands_box_activation->isDeactivated($customer_id,$stb_no)){
								$this->model_commands_box_activation->InsertUpdateActivationExpiryForDeactivation($customer_id,$cmd_id,$id,$ack_is,$operator_id,$stb_no);
							}
						}
						$results = $this->model_commands_box_activation->addToCasOpTransanction($customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,NULL,$operator_id,$stb_no);
						/*=======================================================*/

						$this->session->data['success']=$apimessage;
					}else{
						$errorMsg=$errorMsg."  ".$apimessage;
						$this->session->data['warning']=$errorMsg;
					}
				}
		}else{			
			$errorMsg = 'Warning: User subscribed to services, please send Product/Package desubscription first!!';
			$this->session->data['warning']=$errorMsg;
		}

		}
		/*if(isset($this->error['warning'])){
			$errorMsg = 'Warning: STB Blacklisted!!';
			$this->session->data['warning']=$errorMsg;	
		}*/
		if(isset($this->error['warning'])){
			$this->session->data['warning'] = $errorMsg." ".$this->error['warning'];
		}
     	$this->redirect($this->url->link('commands/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  	}   
		/*
		FUNCTION NAME 		-	delete
		DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
								checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
								after clicking the delete button. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
		*/
  		public function delete() {
  		
  			}  

		  	/*
		FUNCTION NAME 		-	getForm
		DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
		*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_chip_no'] = $this->language->get('entry_chip_no');
    	$this->data['entry_confirm_chip_no'] = $this->language->get('entry_confirm_chip_no');
    	$this->data['entry_expiry'] = $this->language->get('entry_expiry');
 	
		$this->data['button_save'] = $this->language->get('button_send');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['chip_no'])) {
			$this->data['error_chip_no'] = $this->error['chip_no'];
		} else {
			$this->data['error_chip_no'] = '';
		}

		if (isset($this->request->post['chip_no'])) {
      		$this->data['chip_no'] = $this->request->post['chip_no'];
		}else {
      		$this->data['chip_no'] = '';
    	}

    	if (isset($this->request->post['confirm_chip_no'])) {
      		$this->data['confirm_chip_no'] = $this->request->post['confirm_chip_no'];
		}else {
      		$this->data['confirm_chip_no'] = '';
    	}

    	if (isset($this->request->post['expiry_time'])) {
      		$this->data['expiry_time'] = $this->request->post['expiry_time'];
		}else {
      		$this->data['expiry_time'] = '';
    	}

    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => "Box Activation",//$this->language->get('heading_title'),
			'href'      => $this->url->link('commands/box_activation', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/box_activation/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/box_activation/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/box_activation/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	// $this->data['stbs']=array();
	    	// $stb_info = $this->model_inventry_box_activation->getSTBs();
	    	// foreach ($stb_info as $stb) {
	    	// 	$this->data['stbs'][] = array('stb_id' => $stb['id'],
	    	// 								  'stb_no' => $stb['stb_no'],
	    	// 								  'customer_id' => $stb['customer_id'],
	    	// 								  'name' => $stb['name']);
	    	// }
    	$this->data['token'] = $this->session->data['token'];

		$this->template = 'commands/box_activation_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	/*
	FUNCTION NAME 		-	validateForm
	DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
	*/
			 
  	protected function validateForm($post) {
    	if (!$this->user->hasPermission('modify', 'commands/box_activation')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/box_activation');
    	$stb_no=$this->request->post['stb_no'];
    	if(preg_match("#^[a-zA-Z0-9 ]+$#", $stb_no)){
    		$result = $this->model_commands_box_activation->isSTBPaired($stb_no);
	    	
	    	if ((strlen($stb_no)!=14)){
	            $this->error['stb_no'] = $this->language->get('error_length');
	       	}
	        elseif(!$result)
	    	{
	    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
	    	}
	    	 // -------------------CHECK IF BOX IS ALREADY ACTIVATED----------------------
		 		$is_active = $this->model_commands_box_activation->isActive($stb_no);
		 		if($is_active==1){
		 			$this->error['warning'] = $this->language->get('error_stb_active');		
		 		}
		 	// ---------------------------------------------------------------------------
		 	// -------------------CHECK IF BOX IS BLACKLISTED-------------------------
		 		$is_blacklist = $this->model_commands_box_activation->isBlacklist($stb_no);
		 		if($is_blacklist==1){
		 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
		 		}

		 		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
		 		$is_suspend = $this->user->isStbSuspend($stb_no);
		 		if($is_suspend==1){
		 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
		 		}

		 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
		 		if($is_lco_suspend==1){
		 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
		 		}
		 	// ----------------- CHECK IF BOX IS RMA -----------------------------
		 		$is_RMA = $this->user->isStbRMA($stb_no);
		 		if($is_RMA==1){
		 			$this->error['warning'] = $this->language->get('error_stb_RMA');		
		 		}
    


			$result = $this->model_commands_box_activation->isSTBPairedValid($stb_no);
			if ($result=='') {
	    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
	    	}
			elseif($result>0){
				$result_enabled = $this->model_commands_box_activation->isCustomerEnabled($stb_no);
				if($result_enabled==0){
					$this->error['stb_no']="Customer paired with STB is not enabled!";		
				}
			}elseif($result==0){
				$this->error['stb_no']="Customer is not paied with STB!";		
			}
		     	} else
			{
			 $this->error['stb_no'] = "Invalide STB number !";
			}	
		
		 // if(strcmp($post['chip_no'], $post['confirm_chip_no'])!==0)
		 // {
		 // 	$this->error['chip_no'] = $this->language->get('error_chip_no');
		 // }
		 if(strcmp($post['chip_no'],"")==0){
		 	// $this->error['chip_no']="Chip no is empty!";	
		 }elseif(strlen($post['chip_no'])!=16){
		 	$this->error['chip_no'] = 'Chip no should be 16 charecters';//$this->language->get('error_chip_no');
		 }else if(preg_match("/[^A-F0-9]/",strtoupper($post['chip_no']))){
		 	$this->error['chip_no'] = 'Accepts hexadecimal values';		
		 }
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

	  	/*
	FUNCTION NAME 		-	validate
	DESCRIPTION 		-	Validates the details of the transaction content . 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
	*/
	
  	protected function validate() {
  		
    	if (!$this->user->hasPermission('modify', 'commands/box_activation')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

		$command_type = explode("/",$this->request->get["route"]);

		$result = 1;
		if(strcmp("deActivation", $command_type[2])){
			$result = $this->model_commands_box_activation->canResend($this->request->get['id']);
			
			if($result==0){
				$this->error['warning'] = "Warning: Can't Resend! Box in Deactive state.";
			}
		}

		// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		
		$stb_no = $this->model_commands_box_activation->getStbNoFromId($this->request->get['id']);
		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_box_activation->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = "Warning: STB in RMA state.!";		
	 		}

			$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}

	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}	 		
	 	}
		
		// ---------------------------------------------------------------------------------

		if (!$this->error && $result) {			
	  		return true;
		} else {			
	  		return false;
		}
  	}  

  	protected function validateDeactivate($user_id){
		$result = $this->model_commands_box_activation->canSendDeactivation($user_id);

		// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		$stb_no = $this->model_commands_box_activation->getStbNoFromId($this->request->get['id']);
		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_box_activation->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = "Warning: STB in RMA state.!";		
	 		}

			$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}	 

	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}		
	 	}
		// ---------------------------------------------------------------------------------

		if ($result>0) {
	  		return false;
		} else {
	  		return true;
		}
  	}

	/*
	FUNCTION NAME 		-	autocomplete
	DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
							the form. These auto-fill values are retrieved from the database
							and shown as a drop down list.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Renders the list.
	*/
		
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/box_activation');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_box_activation->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
        // ------------------------------only for stb activation------------------------------------
        $log_file = fopen(DIR_LOGS."sms_stb_activation.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target,24," ").$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$command_id,$resend_status);

        // -----------------------------------------------------------------------------------------
    }
 }
?> 