<?php 
 /*
@File bmail.php(Controller)
ADMIN Bmail PAGE
    This class manages the all the Bmail  status.
    

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ControllerCommandsBmail extends Controller {
	private $error = array();
	

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
public function index() {
		$this->language->load('commands/bmail');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/bmail');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the transaction list.
*/
public function getList() {	
	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['target_level'])) {
			$target_level = $this->request->get['target_level'];
		} else {
			$target_level = '';
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
		} else {
			$filter_value = '';
		}
				
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['target_level'])) {
			$url .= '&target_level=' . $this->request->get['target_level'];
		}
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

    	if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
  			
		
   		$this->data['insert'] = $this->url->link('commands/bmail/insert', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['bmails'] = array();
		$data = array(
			'target_level'	  => $target_level,
			'filter_value'	  => $filter_value,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		if (isset($this->request->post['target_level'])) {
			$this->data['target_level'] = $this->request->post['target_level'];
		} else if (isset($this->request->get['target_level'])) {
			$this->data['target_level'] = $this->request->get['target_level'];
			$this->session->data['target_level']=$this->data['target_level'];
		}else {
			$this->data['target_level'] =-1;
		}

		// if(isset($this->session->data['target_level']))
			// $this->data['target_level']=$this->session->data['target_level'];
		
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
			$data['target_level']=$this->request->get['target_level'];
		} else if (isset($this->request->post['filter_value'])) {
			$this->data['filter_value'] = $this->request->post['filter_value'];
		} else{
			$this->data['filter_value'] = '';
			
		}

		$total=0;
		/*if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['target_level']))||(isset($data['target_level']) && $data['target_level']!=-1))
		{*/
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['target_level'])))
		{	
			$total = $this->model_commands_bmail->getTotalBamil($data);
			$results = $this->model_commands_bmail->getBmail($data);
			// echo "<pre>"; print_r($results); die;
			foreach ($results as $result) 
			{	
				// $result['name']='';
				$resend = $this->url->link('commands/bmail/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
				$de_activation = $this->url->link('commands/bmail/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
				
				$this->data['bmails'][] = array(
					'id'  		 	 => $result['id'],
					'tx_id'  		 => $result['tx_id'],
					'trigger_on'     => $result['modify_date'],
					'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
					'cmd_id'         => $result['cmd_id'],
					'stb_no'         => ($data['target_level']==1)?$result['STBNO']:(($data['target_level']==2)?'Global':(($data['target_level']==3)?$result['region_name']:$result['name'])),
					'resend'         => $resend,
					'de_activation'  => $de_activation,
					'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
				);	
			}
		}

		$this->data['targets']=array(
			'-1' => 'Please select',
			'1'  => 'Individual',
			'2'  => 'Global',
			'3'  => 'Region',
			'4'  => 'Group');
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['target_level'])) {
			$this->data['error_target_level'] = $this->error['target_level'];
		}else{
			$this->data['error_target_level'] ='';
		}
		
		if (isset($this->error['user_data'])) {
			$this->data['error_user_data'] = $this->error['user_data'];
		}else{
			$this->data['error_user_data'] ='';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/bmail', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/bmail.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function save() {
  		
		$this->language->load('commands/bmail');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/bmail');

		if ($this->request->server['REQUEST_METHOD'] == 'POST' ) {
			if($this->validateForm($this->request->post)) {
		  		$target_level=$this->request->post['target_level'];
		  		$target="";
		  		switch ($target_level) {
		  			case 1:
		  				$log_target_level = "Individual";
		  				$log_target_level_numeric = 1;
		  				$log_target = $this->request->post['target'];
		  				
		  				$customer_id =$this->model_commands_bmail->getCustomerId($this->request->post['target']);
		 	  			$target=(int)$customer_id["api_user_id"];
		 	  			$local_target=(int)$customer_id["customer_id"];
		 	  			$operator_id=(int)$customer_id["operator_id"];
		  			break;	
		  			case 2:
		  				$log_target_level = "Global";
		  				$log_target_level_numeric = 2;
		  				$log_target = "NA";

		  				$target=0;
		  				$local_target=0;
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			case 3:
		  				$log_target_level = "Regional";
		  				$log_target_level_numeric = 3;
		  				$log_target = $this->request->post['target'];

		  				$target=$this->request->post['target'];
		  				$local_target=$this->request->post['target'];
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			case 4:
		  				$log_target_level = "Group";
		  				$log_target_level_numeric = 4;
		  				$log_target = $this->request->post['target'];

		  				$group_ids=$this->model_commands_bmail->getGroupIdByname($this->request->post['target']);
		  				$target= $group_ids['kms_group_id'];
		  				$local_target=$group_ids['sms_group_id'];
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			default:
		  				break;
		  		}
		  		
		 		$option=($this->request->post["display_type"]);
		 		$subject=($this->request->post["subject"]);
		 		$message=($this->request->post["message"]);
				$obj = new restapi();
				$data="target_level=".$target_level."&target=".$target."&display_type=".$option."&subject=".$subject."&message=".$message;
				
				$method ="POST";
			    $url="".KMS_API."/BMail";
			    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
			    //Process API response and add to db
			    $response=json_decode($apiresult);
	    		$apimessage='';
	    		$errorMsg='';
				$apimessage ="";
				$curlresponse = "";

			foreach ($response as $key => $value) {
				switch ($key) {
					case 'error':
						$error=$value;
						break;
					case 'id':
						$id=$value;
						break;
					case 'mq_response':
						$curlresponse=$value;
						break;
					case 'message':
						$apimessage=$value;
						break;
					default:
						$errorMsg=$errorMsg.' '.$apimessage;
						break;
				}
			}
			
			
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{	
				$resend_status = 0;
				$commandid = 5;
				$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"BMAIL",$resend_status,$commandid,$log_target_level_numeric);
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				
				$payload=$target_level."#".$target."#".$option."#".$subject."#".$message;
				
				$this->model_commands_bmail->addToCasOpTransanction($target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id);
				$this->session->data['success'] = $apimessage;
				$url = '';
				$this->redirect($this->url->link('commands/bmail', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['target'], 'SSL'));
			}else{

				$errorMsg=$errorMsg." ".$apimessage;
				$this->session->data['warning']="In CAS :".$apimessage;//$errorMsg;
				$url = '';
				$this->redirect($this->url->link('commands/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			 }
		}
		else{
				$this->data['bmail_target']=array('target_level' =>$this->request->post['target_level'],
											'target'         =>$this->request->post["target"]);
			}
	}
	$this->getForm();
}

public function insert() {
  		
	$obj = new restapi();
	$this->language->load('commands/bmail');
	$this->document->setTitle($this->language->get('heading_title'));
	$this->load->model('commands/bmail');

	if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validateInsertForm($this->request->post))) {
	
		$this->data['bmail_target']=array('target_level' =>$this->request->post['target_level'],
											'target'         =>$this->request->post['filter_value']);
		$this->getForm();
	}else{
		$this->getList();
	}
}
 /*
FUNCTION NAME 		-	resend
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function resend() {

		$this->language->load('commands/bmail');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/bmail');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{
     		$transaction_details=$this->model_commands_bmail->getTransactionDetails($this->request->get['id']);
//var_dump($transaction_details)     		;exit();
     		$customer_id=$transaction_details['user_id'];
    		$target_lvl=$transaction_details['target_level'];
    		$trans_id=$transaction_details['tx_id']; 
    		$cmd_id=$transaction_details['cmd_id'];
    		$operator_id=$transaction_details['operator_id'];
    		switch ($target_lvl) {
    			case 1:
    					$target=$this->model_commands_bmail->getKMSUserId($transaction_details['user_id']);
    					$targ_value=$this->model_commands_bmail->getSTBno($transaction_details['user_id']);

    					$log_target_level = "Individual";
    					$log_target_level_numeric = 1;
    					$log_target = $targ_value;
    			break;
    			case 2:
    					$target=0;
    					$targ_value=0;

    					$log_target_level = "Global";
    					$log_target_level_numeric = 2;
    					$log_target = "NA";
    			break;
    			case 3:
    					$target=$transaction_details['user_id'];
    					$targ_value=$target;

    					$log_target_level = "Regional";
    					$log_target_level_numeric = 3;
    					$log_target = $targ_value;
    			break;
    			case 4:
    					$target=$this->model_commands_bmail->getKMSGroupId($transaction_details['user_id']);
    					$targ_value=$this->model_commands_bmail->getGroupNameById($transaction_details['user_id']);

    					$log_target_level = "Group";
    					$log_target_level_numeric = 4;
    					$log_target = $targ_value;
    			break;
    		}
    		
		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$target."&target_level=".$target_lvl;
		  	$method ="POST";
			$uri=KMS_API."/Resend";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);		
		    $error=true;
		    $errorMsg='';
		    $apimessage=" Kms fail to enable STB";
		    $curlresponse="";
		    foreach ($response as $key => $value) {
				switch ($key) {
					case 'error':
						$error=$value;
					break;
					case 'id':
						$id=$value;
					break;
					case 'mq_response':
						$curlresponse=$value;
					break;
					case 'message':
						$apimessage=$value;			
					break;
					default:
						$errorMsg=$errorMsg." ".$key.":".$value;	
						break;
				}
			}

					
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{	
				$resend_status = 1;
				$commandid = 5;
				$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND BMAIL",$resend_status,$commandid,$log_target_level_numeric);	
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$payload=$user_id."#".$cmd_id."#".$trans_id;
				$target=1;
				$targetdata=0;
				$results = $this->model_commands_bmail->addToCasOpTransanction($target_lvl,$transaction_details['user_id'],$id,$payload,$ack_is,$nack_is,$operator_id);
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
		}
		$this->session->data['warning'] = $this->error['warning'];
     	$this->redirect($this->url->link('commands/bmail', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_lvl.'&filter_value='.$targ_value, 'SSL'));
  	}  

/*
FUNCTION NAME 		-	deActivation
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function deActivation() {
		$this->language->load('commands/bmail');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/bmail');
  		$obj = new restapi();
  		
    	if($this->validate())
    	{
    		
     		$transaction_details=$this->model_commands_bmail->getTransactionDetails($this->request->get['id']);
     		
     		$customer_id=$transaction_details['user_id'];
    		$user_id=$transaction_details['api_user_id'];
    		$target_lvl=1;
    		$trans_id=$transaction_details['tx_id'];
    		$cmd_id=$transaction_details['cmd_id'];
    		$operator_id=$transaction_details['operator_id'];

		  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;
		  	$method ="POST";
			$uri=KMS_API."/Disable";		
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
		    //Process API response and add to db 
		    $response=json_decode($apiresult);			
		    $error=true;
		    $errorMsg='';
		    $apimessage=" Kms fail to enable STB";

		    foreach ($response as $key => $value) {
				if($key=='error'&&$value==false)
				{
					$error=false;
				}if($key=='error'&&$value==true)
				{
					$error=true;	
				}
				if($key=='id')
				{
					$id=$value;
				}
				if($key=='mq_response')
				{
					$curlresponse=$value;
				}if($key=='message')
				{
					$apimessage=$value;			
				}if($key=='disble_command_id')
				{
					$cmd_id=$value;			
				}if($key!='id' && $key!='error' && $key!='message')
				{
					$errorMsg=$errorMsg." ".$key.":".$value;
				}
			}
			$ack_is=-1;$nack_is=-1;
			if(!$error)
			{
				$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
				if($ack=='ACK')
				{
					$ack_is=1;
				}elseif($ack=='NACK'){
					$nack_is=-1;
				}
				$resp=split('`', $curlresponse);
				$payload=$user_id."#".$cmd_id."#".$trans_id;
				$target=1;
				$targetdata=0;
				$results = $this->model_commands_bmail->addToCasOpTransanction($customer_id,$cmd_id,$id,$payload,$ack_is,$nack_is,$operator_id);
				$this->session->data['success']=$apimessage;
			}else{
				$errorMsg=$errorMsg."  ".$apimessage;
				$this->session->data['warning']=$errorMsg;
			}
		}
     	$this->redirect($this->url->link('commands/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb']		    = $this->language->get('entry_stb');
 		$this->data['entry_display_type']   = $this->language->get('entry_display_type');
 		$this->data['entry_subject'] 		= $this->language->get('entry_subject');
 		$this->data['entry_message'] 		= $this->language->get('entry_message');
 	
		$this->data['button_save'] = $this->language->get('button_send');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['subject'])) {
			$this->data['error_sub'] = $this->error['subject'];
		} else {
			$this->data['error_sub'] = '';
		}

		if (isset($this->error['message'])) {
			$this->data['error_message'] = $this->error['message'];
		} else {
			$this->data['error_message'] = '';
		}


		if (isset($this->request->post['display_type'])) {
      		$this->data['display_type'] = $this->request->post['display_type'];
		}else {
      		$this->data['display_type'] = '';
    	}
    	if (isset($this->request->post['subject'])) {
      		$this->data['subject'] = $this->request->post['subject'];
		}else {
      		$this->data['subject'] = '';
    	}
    	if (isset($this->request->post['message'])) {
      		$this->data['message'] = $this->request->post['message'];
		}else {
      		$this->data['message'] = 'testing';
    	}
    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/bmail', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/bmail/save', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/bmail/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/bmail/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	// $this->data['stbs']=array();
	    	// $stb_info = $this->model_inventry_box_activation->getSTBs();
	    	// foreach ($stb_info as $stb) {
	    	// 	$this->data['stbs'][] = array('stb_id' => $stb['id'],
	    	// 								  'stb_no' => $stb['stb_no'],
	    	// 								  'customer_id' => $stb['customer_id'],
	    	// 								  'name' => $stb['name']);
	    	// }
    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'commands/bmail_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/bmail')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/bmail');
		if($this->request->post['target_level']==1)
    	{
	    	$stb_no=$this->request->post['target'];
	    	if($stb_no){
	    		$result = $this->model_commands_bmail->isSTBPaired($stb_no);
		    	if ((strlen($stb_no)!=14)){
		            $this->error['stb_no'] = $this->language->get('error_length');
		       	}
		        elseif($result["customer_id"]==0)
		    	{
		    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
		    	}
	      	}
			else
			{
				$this->error['stb_no']="STB Field empty!";
			}
		}
// || streln($this->request->post["subject"]) > 64 || streln($this->request->post["subject"])<3)		
		if(!$this->request->post["subject"] || (strlen($this->request->post['subject']) > 64) || (strlen($this->request->post['subject']) < 3)){
			$this->error['subject']=$this->language->get('error_subject');
		}elseif(!preg_match("#^[a-zA-Z0-9. ]+$#", $this->request->post['subject']))	{
			$this->error['subject']="Special Characters not allowed!";
		}elseif (strlen(trim($this->request->post['subject'] ))==0){
			$this->error['subject'] = "Only Spaces not allowed!";
		}

		// elseif ( preg_match('/\s/',$this->request->post['subject']) ){
		// 	$this->error['subject'] = "Space not allowed!";
		// }


		if(!$this->request->post["message"] || (strlen($this->request->post['message']) > 256) || (strlen($this->request->post['message']) < 3)){
			$this->error['message']=$this->language->get('error_message');
		}elseif (strlen(trim($this->request->post['message'] ))==0){
			$this->error['message'] = "Only Spaces not allowed!";
		}

		// elseif(!preg_match("#^[a-zA-Z0-9. ]+$#", $this->request->post['message']))	{
		// 	$this->error['message']="Special Characters not allowed!";
		// }

// var_dump(strlen($this->request->post['subject']));exit();
		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	}  

 	/*
FUNCTION NAME 		-	validateInsertForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateInsertForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/bmail')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/bmail');
		switch ($this->request->post['target_level']) {
			case 1:
				$lcoId  = $this->user->getOperatorIdFromStbno($this->request->post['filter_value']);
				if($this->request->post['filter_value']=='')
				{
					$this->error['user_data']='Please enter STB no ';	
				}else if(strlen($this->request->post['filter_value'])!=14)
				{
					$this->error['user_data']='STB no should be 14 digit ';	
				}elseif($this->model_commands_bmail->isSTBBlackListed($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is Blacklisted.";
	    		}elseif($this->user->isStbSuspend($this->request->post['filter_value'])){
	    			$this->error['user_data'] = "STB is suspended, Please resume first.!";
	    		}elseif($this->user->isLcoSuspend($lcoId)){
	    			$this->error['user_data'] = $this->language->get('STB Belongs To LCO Is Suspended, Please Resume LCO First.!');
	    		}elseif($this->user->isStbRMA($this->request->post['filter_value'])){
	    			$this->error['user_data'] = $this->language->get('STB in RMA state.!');	
	    		}else{
					$stb=$this->model_commands_bmail->isStbExistedAndPaired($this->request->post['filter_value']);
					if(!isset($stb['customer_id']))
					{
						$this->error['user_data']='Invalid STB no';
					}else if (isset($stb['customer_id'])) {
						if(!$stb['customer_id']>0)
							$this->error['user_data']='STB no is not paired with user';
					}
				}
				break;
			case 2:
				
				break;
			case 3:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter pin code ';
				else if(strlen($this->request->post['filter_value'])!=6)
					$this->error['user_data']='Pin code must be 6 digits';
				else{
					$pin=$this->model_commands_bmail->checkPinExist($this->request->post['filter_value']);
					if(!$pin)
						$this->error['user_data']='Invalid PIN code';
				}
				break;
			case 4:
				if($this->request->post['filter_value']=='')
					$this->error['user_data']='Please enter group name';
				else {
					$group=$this->model_commands_bmail->checkGroupExists($this->request->post['filter_value']);
					if(!$group)
						$this->error['user_data']='Invalid group name';	
				}
				break;    			
			default:
				$this->error['target_level']='Please select target ';
				break;
		}

		if (!$this->error) {
	  		return true;
		 } else {
	 		return false;
		 }
  	}  
  	/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/bmail')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		
		// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		$stb_no = $this->model_commands_bmail->getStbNoFromId($this->request->get['id']);
		
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_bmail->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
	 		}

			$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}	 

	 		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB in RMA state.!');		
	 		}		
	 	}
	 	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/bmail');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_bmail->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function decTohexAndMsb($target,$no_ofbits)
		{
		$target=dechex($target);
		$target=str_pad($target, $no_ofbits, '0', STR_PAD_LEFT);
    	$msblsb='';
    	for ($k=strlen($target); $k >0 ; $k-=2) { 
    		$msblsb.=substr($target,$k-2,2);
    	}
    	return $msblsb;
		}

	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id,$log_target_level_numeric){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	$log_target = (strlen($log_target)<22)?str_pad($log_target,24," "):substr($log_target, 0,22).".";
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").$log_target.$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level_numeric,$log_target,$command_id,$resend_status,'-1');
    }


 }
?> 