<?php 
 /*
@File account_info.php(Controller)
ADMIN Account Information PAGE
    This class manages the all the BoxActivation  status.
    

@Author Ravi Ranjan 
@date 21 Nov. 2016
*/
class ControllerCommandsAccountInfo extends Controller {
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
	public function index() {
		$this->language->load('commands/account_info');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('commands/account_info');
    	$this->getList();
  	}


	/*
	FUNCTION NAME 		-	getList
	DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
							database and make a list for it.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Renders the transaction list.
	*/
	public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$this->data['bulk_account_info'] = $this->url->link('commands/account_info/bulk_account_info', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		$this->data['insert'] = $this->url->link('commands/account_info/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['stb_activations'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		$total = $this->model_commands_account_info->getTotalStbActivations($data);

		$results = $this->model_commands_account_info->getActivationTransactions($data);
		foreach ($results as $result) 
		{	
			
			$this->data['stb_activations'][] = array(
				'name'           => $result['firstname']." ".$result['lastname'],
				'stb_no'    	 => $result['STBNO'],
				'telephone'  	 => $result['telephone'],
				'trigger'	     => $result['modify_date'],
				'region'	     => $result['postcode'],
				'group'	     	 => $result['name'],
				'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
				'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_mobile'] = $this->language->get('column_mobile');
		$this->data['column_region'] = $this->language->get('column_region');
		$this->data['column_group'] = $this->language->get('column_group');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/account_info.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


	  	/*
	FUNCTION NAME 		-	insert
	DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
							details of the new review. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
	*/  
  	public function insert() {
  		
		$obj = new restapi();
		$this->language->load('commands/account_info');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/account_info');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if($this->validateForm($this->request->post)) {

		  		$customer_details = $this->model_commands_account_info->getCustomerId($this->request->post['stb_no']);
		  		$customer_id=$customer_details['customer_id'];

		  		$operator_id=$this->session->data['user_id'];
		  		// var_dump($operator_id);exit();
			    $customer_name=$this->request->post['customer_name'];
			    $target=$this->request->post['stb_no'];
			    $telephone=$this->request->post['telephone'];
			    $postcode=$this->request->post['postcode'];
			    $customer_group=$this->request->post['customer_group'];
			    $region = $this->model_commands_account_info->getRegion($postcode);
			    $group = $this->model_commands_account_info->getCustomergroup($customer_group);

			    $kms_group_id = $this->model_commands_account_info->getKmsGroupid($group["customer_group_id"]);
			    // var_dump($kms_group_id);exit();
			    $name=explode(" ", $customer_name);

				$data="stb_no=".$target."&first_name=".$name[0]."&last_name=".$name[1]."&region_pin=".$postcode."&group_id=".$kms_group_id["kms_group_id"]."&telephone=".$telephone;
				$method ="POST";
			    $url="".KMS_API."/accountInformation";
			    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
			    //Process API response and add to db
			    $response=json_decode($apiresult);
			    $error=true;
			    $errorMsg='';
			    $apimessage="";

			    foreach ($response as $key => $value) {
			    	switch ($key) {
			    		case 'error':
			    			$error=$value;	
			    		break;
			    		case 'id':
			    			$id=$value;	
			    		break;
			    		case 'message':
			    			$apimessage=$value;	
			    		break;
			    		case 'mq_response':
			    			$curlresponse=$value;	
			    		break;
			    		default:
			    			$errorMsg=$errorMsg." ".$key.":".$value;		
			    		break;
			    	}
				}
				$ack_is=-1;$nack_is=-1;$target_level=1;
				if(!$error)
				{
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=1;
					}
					$expiry=strtotime("+1 year",time());
        			$expiry+=19800; 
					$payload = $kms_group_id["kms_group_id"]."~".$postcode."~".$telephone."~".$target."~".$expiry;

					$results = $this->model_commands_account_info->updateCustomer($customer_name,$telephone,$postcode,$group["customer_group_id"],$operator_id,$target,$region,$customer_id);
					
					// var_dump($customer_id);
					// var_dump($id);
					$results = $this->model_commands_account_info->addToCasOpTransanction($customer_id,$id,$payload,$ack_is,$nack_is,$operator_id);
					$this->session->data['success']=$apimessage;
					$url = '';
									
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}

					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}

					if (isset($this->request->get['page'])) {
						$url .= '&page=' . $this->request->get['page'];
					}
					$this->redirect($this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'));
				}else{
					$this->error['warning']=$errorMsg;
			 		$this->getForm();
				}
			}
		}
    	
    	$this->getForm();
  	} 

	



		  	/*
		FUNCTION NAME 		-	getForm
		DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
		*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_name'] = $this->language->get('entry_name');
    	$this->data['entry_mobile'] = $this->language->get('entry_mobile');
    	$this->data['entry_region'] = $this->language->get('entry_region');
    	$this->data['entry_group'] = $this->language->get('entry_group');

    	$this->data['entry_expiry'] = $this->language->get('entry_expiry');
 	
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}
		if (isset($this->error['postcode'])) {
			$this->data['error_postcode'] = $this->error['postcode'];
		} else {
			$this->data['error_postcode'] = '';
		}
		if (isset($this->error['customer_group'])) {
			$this->data['error_customer_group'] = $this->error['customer_group'];
		} else {
			$this->data['error_customer_group'] = '';
		}

		if (isset($this->error['telephone'])) {
			$this->data['error_telephone'] = $this->error['telephone'];
		} else {
			$this->data['error_telephone'] = '';
		}

    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}

    	if (isset($this->request->post['customer_name'])) {
      		$this->data['customer_name'] = $this->request->post['customer_name'];
		}else {
      		$this->data['customer_name'] = '';
    	}

    	if (isset($this->request->post['telephone'])) {
      		$this->data['telephone'] = $this->request->post['telephone'];
		}else {
      		$this->data['telephone'] = '';
    	}
    	if (isset($this->request->post['customer_region_id'])) {
      		$this->data['customer_region_id'] = $this->request->post['customer_region_id'];
		}else {
      		$this->data['customer_region_id'] = '';
    	}

    	$customer_group = $this->model_commands_account_info->getCustomerGroups();

    	if (isset($this->request->post['customer_group'])) {
      		$this->data['customer_group'] = $this->request->post['customer_group'];
		}else {
      		$this->data['customer_group'] = '';
    	}
    	if (isset($this->request->post['postcode'])) {
      		$this->data['postcode'] = $this->request->post['postcode'];
		}else {
      		$this->data['postcode'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/account_info/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/account_info/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/account_info/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	
    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'commands/account_info_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	/*
	FUNCTION NAME 		-	validateForm
	DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
	*/
			 
    	protected function validateForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/account_info')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
			$this->load->model('commands/account_info');
			$this->load->model('sale/customer');
    	$stb_no=$this->request->post['stb_no'];
    	
    	if($stb_no){
    		$result = $this->model_commands_account_info->isSTBPaired($stb_no);

	    	if ((strlen($stb_no)!=14)){
	            $this->error['stb_no'] = $this->language->get('error_length');
	       	}
	        elseif(!$result)
	    	{
	    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
	    	}
      	}
		else
		{
			$this->error['stb_no']="STB Field is empty!";
		}
		if ((utf8_strlen($this->request->post['telephone']) < 10) || (utf8_strlen($this->request->post['telephone']) > 10)) {
      			$this->error['telephone'] = $this->language->get('error_telephone');
    	}
    	elseif(!is_numeric($this->request->post['telephone'])){
    			$this->error['telephone'] = $this->language->get('error_telephone_digits');
    	}
    
  //   	$customer_tel = $this->model_sale_customer->getCustomerByMobile($this->request->post['telephone']);
  //   	if (!isset($this->request->get['customer_id'])) {
		// 	if ($customer_tel) {
		// 		$this->error['warning'] = $this->language->get('error_exist'); 
		// 	}
		// } else {
		// 	if ($customer_tel && ($this->request->get['customer_id'] != $customer_tel['customer_id'])) {
		// 		$this->error['telephone'] = "telephone number is exit";//$this->language->get('error_exists');
		// 	}
		// }
		$group_id = $this->model_commands_account_info->isValidGroup($this->request->post["customer_group"]);
		if(!$group_id)
		{
			$this->error['customer_group'] =$this->language->get('error_invalid_group');
		}
		$postcode = $this->model_commands_account_info->isValidRegion($this->request->post["postcode"]);
		if(!$postcode)
		{
			$this->error['postcode'] =$this->language->get('error_invalid_postcode');
		}
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  
	  	/*
	FUNCTION NAME 		-	validate
	DESCRIPTION 		-	Validates the details of the transaction content . 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
	*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/account_info')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

	

	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
        fclose($log_file);
    }

    //-------
    /*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	The filter anme is auto filled as the user type 
						few of the starting letters.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Shows the pattern search list as a drop down.
*/
	

	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/account_info');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_account_info->getSTBdetails($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'name' 	=> $result['name'],
					'telephone' => $result['telephone'],
					'postcode' 	=> $result['postcode'],
					'group' 	=> $result['group_name'], 
					'stb_no'=> strip_tags(html_entity_decode($result['STBNO'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		// $sort_order = array();
	  
		// foreach ($json as $key => $value) {
		// 	$sort_order[$key] = $value['stb_no'];
		// }
		// array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function exportFormat(){  
    	/*********************** Export Bulk Account Info CSV Format *****************************/
    	$results = array( "SDA40000000001", "first", "customer", "Friends", "560100", "9999999999");
    	if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=bulk_account_info.csv');
			$output = fopen('php://output', 'w');
			fputcsv($output, array('STBNO', 'FIRST NAME', 'LAST NAME', 'GROUP NAME', 'REGION PIN', 'MOBILE'));
			fputcsv($output, $results);
		}
    }

	  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer form page where the admin can give the
						details of the new customer. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer form page.
*/  
  	public function bulk_account_info() {
  		 $this->load->model('commands/account_info');
    	$obj = new restapi();
  			
		$this->language->load('commands/account_info');

    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/account_info');
		$this->load->model('commands/account_info');
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {
			 // if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
			  	$ext = pathinfo(DIR_BULK_ACCOUNT_INFO.$_FILES['filename']['name'], PATHINFO_EXTENSION);
			  	
			  	if($ext=='csv'){
			  		$handle = fopen(DIR_BULK_ACCOUNT_INFO.$_FILES['filename']['name'], "r");
				    $i=0;
				    $customer=array();
				    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				    		if($i>0){
				    		$customers[$i-1]['STBNO']=$data[0];
				    		$customers[$i-1]['firstname']=$data[1];
				    		$customers[$i-1]['lastname']=$data[2];
				    		$customers[$i-1]['group_name']=$data[3];
				    		$customers[$i-1]['region_pin']=$data[4];
				    		$customers[$i-1]['telephone']=$data[5];


				    	}
				    	$i++; 
				    }
				    $warnings=array(array());
				    $j=0;
				    $err_encounter=0;
			    	$log_separator = "-------------------------------------\n";
					$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
					$current_date = $currDate->format('d-m-Y H:i:s');	
					file_put_contents(DIR_BULK_CUSTOMER_LOGS.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);	

				    foreach ($customers as $row) {

			    		if ((utf8_strlen($row['firstname']) < 1) || (utf8_strlen($row['firstname']) > 32)) {
				      		$warnings[$j]['firstname'] = $this->language->get('error_firstname');
				      		$err_encounter=1;
				    	}else{
				    		$customer['firstname'] = $row['firstname'];
				    	}

				    	if ((utf8_strlen($row['lastname']) < 1) || (utf8_strlen($row['lastname']) > 32)) {
				      		$warnings[$j]['lastname'] = $this->language->get('error_lastname');
				      		$err_encounter=1;
				    	}else{
				    		$customer['lastname'] = $row['lastname'];
				    	}

				    	if ((strlen(trim($row['STBNO']))<14)||(strlen(trim($row['STBNO']))>14)){

				            $warnings[$j]['STBNO'] = $this->language->get('error_STBNO');
				            $err_encounter=1;
				        }
				        else{
				        	$customer['STBNO'] = $row['STBNO'];
						        $stb_exist = $this->model_commands_account_info->getSTBExist($row['STBNO']);
					        if($stb_exist){
						        $customer_info = $this->model_commands_account_info->getCustomerBySTBNO($row['STBNO']);
								$stb_blackList = $this->model_commands_account_info->getSTBblackList($row['STBNO']);
								if ((int)$stb_blackList["is_black_list"]) {
					        		$warnings[$j]['STBNO'] = 'STBNO is Black listed!';
					        		$err_encounter=1;
					        	}
					
							}else{
								$warnings[$j]['STB NO'] = 'Warning: STB No. does not exist!';
							}
						}
				    	if ((utf8_strlen($row['telephone']) < 10) || (utf8_strlen($row['telephone']) > 10)) {
				      			$warnings[$j]['telephone'] = $this->language->get('error_telephone');
				      			$err_encounter=1;
				    	}
				    	elseif(!is_numeric($row['telephone'])){
				    			$warnings[$j]['telephone'] = $this->language->get('error_telephone_digits');
				    			$err_encounter=1;
				    	}else{
				    		$customer['telephone'] = $row['telephone'];
				    	}
				    
				    	if ($row['group_name']== '') {
				      		$warnings[$j]['group'] = "Please give group";
				      		$err_encounter=1;
				    	}else{
				    		$customer_group = $this->model_commands_account_info->getGroupIdByName($row['group_name']);
				    		if(!isset($customer_group['customer_group_id']))
				    		{
				    			$warnings[$j]['group_id'] = "Group '".$row['group_name']."' is not exist !";	
				    			$err_encounter=1;
				    		}else{
				    			$customer['customer_group_id'] = $customer_group['customer_group_id'];
				    		}
				    	}

				    	if ($row['region_pin']==''){
				      		$warnings[$j]['region_pin'] = "Please give region";
				      		$err_encounter=1;
				    	}else{
				    		
				    		$customer_region = $this->model_commands_account_info->isRegionpinExist($row['region_pin']);
				    		if(!$customer_region)
				    		{
				    			$warnings[$j]['region_pin'] = "Region '".$row['region_pin']."' is not exist !";	
				    			$err_encounter=1;
				    		}
				    	}
				    	
						if(!$err_encounter)
				    	{
				    	$customer_details = $this->model_commands_account_info->getCustomerId($row['STBNO']);
				    		if (!empty($customer_details)) {
				    		$customer_id=$customer_details['customer_id'];
				  			$cust_groupid=$this->model_commands_account_info->getApigroupid((int)$customer['customer_group_id']);
							$data="stb_no=".$row['STBNO']."&first_name=".$customer['firstname']."&last_name=".$customer['lastname']."&region_pin=".$row['region_pin']."&group_id=".$cust_groupid['kms_group_id']."&telephone=".$customer['telephone'];				
							$method ="POST";
						    $url="".KMS_API."/accountInformation";
						    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
						    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
						    //Process API response and add to db
						    $response=json_decode($apiresult);
							//--------
							$errorMsg="";
							foreach ($response as $key => $value) {
								switch ($key) {
				    				case 'error':
				    					$error=	$value;
				    					break;
				    				case 'message':
				    					$apimessage=$value;				
				    					break;
				    				case 'id':
				    					$api_user_id=$value;	
				    					break;
				    				case 'mq_response':
										$curlresponse=$value;	
				    				default:
				    					$errorMsg=$errorMsg." ".$key.":".$value;	
				    					break;
				    			}
							}
							$log_target_level = "Individual";
							$log_target = $row['STBNO'];
							$this->WriteMessageLog($curlresponse,$log_target_level,$log_target,"SEND STB ACTIVATION");
							$ack_is=-1;$nack_is=-1;
							if(!$error){
								$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));

								$region = $this->model_commands_account_info->getRegion($row['region_pin']);
								$customer_name=$customer['firstname']." ".$customer['lastname'];
								$operator_id=$this->session->data['user_id'];
								$results = $this->model_commands_account_info->updateCustomer($customer_name,$customer['telephone'],$row['region_pin'],$customer['customer_group_id'],$operator_id,$row['STBNO'],$region,$customer_id);
								if($ack=='ACK')
								{
								$ack_is=1;	
								}elseif($ack=='NACK'){
										$nack_is=-1;
								}
								$results = $this->model_commands_account_info->addToCasOpTransanction($customer_id,$api_user_id,$row['STBNO'],$ack_is,$nack_is,$operator_id);

								$this->session->data['success']=$apimessage;
								if($ack=='ACK')
									$this->status_array[$row['STBNO']] = "SUCCESS";
								else if($ack=='NACK')
								$this->status_array[$row['STBNO']] = "FAILED: NACK RECEIVED!";

							}else{
							$this->error['warning']=$errorMsg.$apimessage;
							$this->status_array[$row['STBNO']] = "FAIL";
							}
						}else{
							$this->status_array[$row['STBNO']] = "Not Exist this details!";	
						}
				    	}else{
				    		$this->status_array[$row['STBNO']] = "STB details are not valid!";
				    		$warnings[$j]['error'] = 1;
				    	}
				    	$err_encounter=0;
				    	
			    		$j++;
			    	}

				}else{
					$this->error['warning']= "Warning: INVALID FILE FORMAT";
					unlink(DIR_BULK_ACCOUNT_INFO.$_FILES['filename']['name']);
				}
			// }else{

			// }
		}
    
      $this->getUploadForm();
  	}

  	public function validateFile(){
  	
  		$newloc = DIR_BULK_ACCOUNT_INFO.$_FILES['filename']['name'];
  		move_uploaded_file($_FILES['filename']['tmp_name'], $newloc);
  		$lines = count(file($newloc)); 
  		
  		$ext = pathinfo(DIR_BULK_CUSTOMER_LOGS.$_FILES['filename']['name'], PATHINFO_EXTENSION);
  		if($ext!='csv'){
  			$this->error['warning'] = "Warning: Invalid file format, Only .CSV files are accepted!";
  			return false;
  		}

  		if( $lines > 1001){
			$this->error['warning'] = "Can't process csv, records count is more than 1000.!";
			unlink(DIR_BULK_ACCOUNT_INFO.$_FILES['filename']['name']); 
			return false;
		}else {
				if($lines){
					// $this->session->data['success'] = "File upload successfully.!!";
					return true;
				}else {
					$this->error['warning']	= "Please select .csv file of customer registration.!";
				}
			}
  	} 


  	protected function getUploadForm() {
  		$this->language->load('commands/account_info');
    	$this->data['heading_title_bulk'] = $this->language->get('heading_title_bulk');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title_bulk'),
			'href'      => $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$this->data['bulk_account_info'] = $this->url->link('commands/account_info/bulk_account_info', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if(isset($this->status_array)){
			
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;
		}else{
			$this->data['status_array'] = array();
		}
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 
		
    	$this->data['cancel'] = $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL');		

		$this->template = 'commands/bulk_account_info.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}


 }
?> 