<?php 
/*
@File product.php(Controller)
ADMIN PRODUCT PAGE
    This class manages the channel in the store. Creating/ updating/ deleting of channels 
    can be done with the notification of success or failure.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCatalogProduct extends Controller {
	private $error = array(); 
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the channel option in the dopdown list.
						It get all the channel list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin channel page.
*/
     
  	public function index() {
		$this->language->load('catalog/product');
		$this->document->setTitle($this->language->get('heading_title')); 
		$this->load->model('catalog/product');
		$this->getList();
  	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert channel form page where the admin can give the
						details of the new channel which can be inserted.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin channel form page.
*/
 	public function printPdf() {
 		$this->pdf->AddPage();
	    $this->load->model('catalog/product');
	    $this->pdf->SetFillColor(232,232,232);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(25);
		$this->pdf->SetX(10);
		$this->pdf->Ln();
		

		$this->pdf->Cell(175,6,'-: Channels Details :-',1,0,'C',1);
		

		$this->pdf->SetY(35);
	    $w = array(10,25,95,125,155);
	    $c = array(15,70,30,30,30);	
	    
	    $header =  array('Sl No.','Channel Name','Product ID','Channel No.','Service ID.');
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
	    }
	    $count=1;
		$this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	    
	    $results = $this->model_catalog_product->getChannelsDetails();
		foreach($results as $result){		    	
			$this->pdf->SetX(10);
			$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
			$this->pdf->Cell($c[1],6,$result["name"],1,0,'L',0);
			$this->pdf->Cell($c[2],6,$result["product_id"],1,0,'L',0);
			$this->pdf->Cell($c[3],6,$result["model"],1,0,'L',0);
			$this->pdf->Cell($c[4],6,$result["service_id"],1,0,'L',0);
			$this->pdf->Ln();
			$count++;
		}
              
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);ob_clean();
	    $this->pdf->Output();
  	}

  	public function insert() {
// var_dump($this->request->post);exit(); 		
  		$obj = new restapi();
    	$this->language->load('catalog/product');

    	$this->document->setTitle($this->language->get('heading_title')); 
		
		$this->load->model('catalog/product');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm() && $this->validateProductCount()) {

    		// var_dump($this->request->post);exit();

			if($this->request->post['broadcaster_id'] == '-1')
			{
				$productName = $this->request->post['broadcaster_channel_name'];
			}else{
				$productName = $this->request->post['channel_name'];
			}
			$productName = trim(preg_replace('!\s+!', ' ', $productName),' ');
			$x=$this->request->post["product_description"];
			// var_dump(sizeof($this->request->post["product_category"]));exit();		
			// $data="product_name=".$x[1]["name"]."&is_enabled=".(int)$this->request->post['status']."&service_id=".$this->request->post['service_id']."&product_number=".(int)$this->request->post['model'];
			$data="product_name=".urlencode(trim($productName))."&is_enabled=".(int)$this->request->post['status']."&service_id=".$this->request->post['service_id']."&product_number=".$this->request->post['model']."&access_criteria=".$this->request->post['access_criteria']."&lcn=".$this->request->post['lcn'];

			$prd_log_detail = "(".$productName."~".$this->request->post['service_id']."~".$this->request->post['access_criteria'].")";

	 		$method ="POST";
	 		$url=KMS_API."/enableProduct";	
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
// var_dump($apiresult)       	 	;exit();
       	 	$response=json_decode($apiresult);
    		$error=true;
    		$respId="";
    		$apimessage="";
    		$errorMsg="";
    		foreach ($response as $key => $value) {
    			switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$respId=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			if($respId!="")
        	{
        		$product_id = $this->model_catalog_product->addProduct($this->request->post);
        		$this->model_catalog_product->addProductModificationLog($this->request->post,$productName,'ADD');
        		// $result=$this->model_catalog_product->getProductIdByName($this->request->post['channel_name']);
	        	// $product_id=$result[0]["product_id"];
        		$this->model_catalog_product->addApiResponceId($respId,$product_id);
        		$this->session->data['success'] = $apimessage;	
		  		$url = '';
				
				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
			
				if (isset($this->request->get['filter_model'])) {
					$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
				}
				if (isset($this->request->get['filter_service_id'])) {
					$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_price'])) {
					$url .= '&filter_price=' . $this->request->get['filter_price'];
				}
				
				if (isset($this->request->get['filter_quantity'])) {
					$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
				}
				
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
						
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				

				$this->load->model('json/feed');
				$this->model_json_feed->CreateChannelFeed();
				// $this->model_json_feed->CreatePackageFeed();
				// $this->model_json_feed->CreatePackChannelFeed();
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("SUCCESS:","NA",$this->request->post['model'],"addprd",$prd_log_detail);
				// ----------------------------------------------------------------------------	
				$this->redirect($this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				$this->error['warning'] =$errorMsg.' '.$apimessage;
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("ERROR:","NA",$this->request->post['model'],"addprd",$prd_log_detail);
				// ----------------------------------------------------------------------------
				$this->getForm();
			}		

    	}
	
    	$this->getForm();
  	}
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the product/channel details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/


  	public function update() {
    	$this->language->load('catalog/product');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/product');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
    		$x=$this->request->post["product_description"];
    		$errorMsg="";
			$obj = new restapi();
			if($this->request->post['broadcaster_id'] == '-1')
			{
				$productName = $this->request->post['broadcaster_channel_name'];
			}else{
				$productName = $this->request->post['channel_name'];
			}
			
			$productName = trim(preg_replace('!\s+!', ' ', $productName),' ');

			$api_prod_id=$this->model_catalog_product->getApiResponceId($this->request->get['product_id']);
			// var_dump($api_prod_id);exit();
			$data="product_name=".urlencode(trim($productName))."&is_enabled=".(int)$this->request->post['status']."&service_id=".$this->request->post['service_id']."&product_number=".$this->request->post['model']."&access_criteria=".$this->request->post['access_criteria']."&lcn=".$this->request->post['lcn']."&update_id=".$api_prod_id['api_product_id'];

			$prd_log_detail = "(".$productName."~".$this->request->post['service_id']."~".$this->request->post['access_criteria'].")";
			
			$method ="POST";
			$uri=KMS_API."/enableProduct";
			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			
			$res=$obj->callAPI($method,$hdr,$uri,$data);
			$response=json_decode($res);
			$error=true;
			$apimessage='';
			foreach ($response as $key=>$value) 
			{
				switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$respId=$value;	
    					break;
    				default:
						$errorMsg=$errorMsg." ".$key.":".$value;	
						break;
				}
			}
    		if(!$error)
    		{
	    		$this->model_catalog_product->editProduct($this->request->get['product_id'], $this->request->post);
	    		$this->model_catalog_product->addProductModificationLog($this->request->post,$productName,'MODIFY');
    			$this->session->data['success'] = $apimessage;
	    	
				$url = '';
				
				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
			
				if (isset($this->request->get['filter_model'])) {
					$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
				}

				if (isset($this->request->get['filter_service_id'])) {
					$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_price'])) {
					$url .= '&filter_price=' . $this->request->get['filter_price'];
				}
				
				if (isset($this->request->get['filter_quantity'])) {
					$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
				}	
			
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
						
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}	
			
				$this->load->model('json/feed');
				//$this->model_json_feed->CreatePackageFeed();
				//$this->model_json_feed->CreateChannelFeed();
				// $this->model_json_feed->CreatePackChannelFeed();
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("SUCCESS:","NA",$this->request->post['model'],"modifyprd",$prd_log_detail);
				// ----------------------------------------------------------------------------	
				$this->redirect($this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				// ----------------------------------------------------------------------------
					$this->WriteMessageLog("ERROR:","NA",$this->request->post['model'],"modifyprd",$prd_log_detail);
				// ----------------------------------------------------------------------------	
				$this->error['warning'] = $errorMsg;
    			$this->getForm();
	    	}
		}

    	$this->getForm();
  	}
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected product/channel listed on the page. Admin selects the 
						checkbox against the product/channel in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the product/channel list page after deleting the product/channel from the list.
*/

  	public function delete() {
  		$obj = new restapi();
    	$this->language->load('catalog/product');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/product');
		$flag=false;
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
				$error_encounter=0;
				$errorMsg="";
			foreach ($this->request->post['selected'] as $product_id) {
				$data= $this->model_catalog_product->getApiResponceId($product_id);
				$apimessage="";
					
	      		$data="product_id=".$data['api_product_id'];	
		 		$method ="POST";
		 		$url=KMS_API."/disableProduct";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
	        	$response=json_decode($apiresult);
	        	$error=true;
	        	foreach ($response as $key => $value) {
	        		switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$respId=$value;	
    					break;
    				default:
						$errorMsg=$errorMsg." ".$key.":".$value;	
						break;
				}
				}
				$ppvMapWithProductName = $this->model_catalog_product->getPpvMapWithProductName($product_id);
				$ppvMapWithProduct = $this->model_catalog_product->checkPpvMapWithProduct($ppvMapWithProductName);
	  			

    			    			if($error){
    				$error_encounter=1;
    				$errorMsg=$errorMsg." :".$apimessage;
    			}else if ($ppvMapWithProduct!=NULL) 
				{
					$this->error['warning']=$this->language->get('text_warning_ppv_map');
				}else{
    				$flag=true;
    				$this->model_catalog_product->deleteProduct($product_id);
    				$this->session->data['success'] = $this->language->get('text_success_delete');
    			}
	  		}
	  		if($error_encounter)
	  		{
	  			if($flag)
	  				$this->session->data['warning'] =$this->language->get('text_warning_partial_delete').' ('.$errorMsg.')';
		  		else
		  			$this->session->data['warning'] =$errorMsg;
		  		$this->redirect($this->url->link('catalog/product', 'token=' . $this->session->data['token'], 'SSL'));
	  		}else{

			// $this->session->data['success'] = $this->language->get('text_success_delete');
			
			$url = '';
			
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
		
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_service_id'])) {
				$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . $this->request->get['filter_price'];
			}
			
			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}	
		
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
					
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			// $this->load->model('json/feed');
			// $this->model_json_feed->CreateChannelFeed();
			// $this->model_json_feed->CreatePackageFeed();
			// $this->model_json_feed->CreatePackChannelFeed();
	
			}
		}else{
			$this->error['warning'] =$this->language->get('text_warning_delete1');
		}
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	copy
DESCRIPTION 		-	Loads when the admin wants to copy a product/channel. 
						This function copies all the details of the selected product/channel and 
						gives a notification on success.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the product/channel template file.
*/

  	public function copy() {
    	$this->language->load('catalog/product');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/product');
		
		if (isset($this->request->post['selected']) && $this->validateCopy()) {
			foreach ($this->request->post['selected'] as $product_id) {
				$this->model_catalog_product->copyProduct($product_id);
	  		}

			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';
			
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
		  
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_service_id'])) {
				$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . $this->request->get['filter_price'];
			}
			
			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}	
		
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
					
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

    	$this->getList();
  	}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the product/channel added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the product/channel list.
*/
	
  	protected function getList() {				
		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if (isset($this->request->get['filter_product_id'])) {
			$filter_product_id = $this->request->get['filter_product_id'];
		} else {
			$filter_product_id = null;
		}

		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = null;
		}

		if (isset($this->request->get['filter_service_id'])) {
			$filter_service_id = $this->request->get['filter_service_id'];
		} else {
			$filter_service_id = null;
		}
		
		if (isset($this->request->get['filter_price'])) {
			$filter_price = $this->request->get['filter_price'];
		} else {
			$filter_price = null;
		}

		if (isset($this->request->get['filter_quantity'])) {
			$filter_quantity = $this->request->get['filter_quantity'];
		} else {
			$filter_quantity = null;
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pd.name';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';	
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
						
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . urlencode(html_entity_decode($this->request->get['filter_product_id'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}		

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
						
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		if(isset($this->request->get['filter_name']) ||isset($this->request->get['filter_product_id']) ||isset($this->request->get['filter_model'])||isset($this->request->get['filter_service_id'])||isset($this->request->get['filter_name'])||isset($this->request->get['filter_price'])||isset($this->request->get['filter_quantity'])||isset($this->request->get['filter_status'])){
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('catalog/product', 'token=' . $this->session->data['token'], 'SSL'),
	      		'separator' => ' :: '
	   		);
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_filter'),
				'href'      => $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);
   		}
   		else{
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, 'SSL'),       		
	      		'separator' => ' :: '
	   		);
	   	}
		
		$this->data['printPdf'] = $this->url->link('catalog/product/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['insert'] = $this->url->link('catalog/product/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['copy'] = $this->url->link('catalog/product/copy', 'token=' . $this->session->data['token'] . $url, 'SSL');	
		$this->data['delete'] = $this->url->link('catalog/product/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
    	
		$this->data['products'] = array();

		$data = array(
			'filter_name'	  => $filter_name, 
			'filter_product_id'	  => $filter_product_id, 
			'filter_model'	  => $filter_model,
			'filter_service_id'	  => $filter_service_id,
			'filter_price'	  => $filter_price,
			'filter_quantity' => $filter_quantity,
			'filter_status'   => $filter_status,
			'sort'            => $sort,
			'order'           => $order,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		$this->load->model('tool/image');
		
		$product_total = $this->model_catalog_product->getTotalProducts($data);
			
		$results = $this->model_catalog_product->getProducts($data);
				    	
		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('catalog/product/update', 'token=' . $this->session->data['token'] . '&product_id=' . $result['product_id'] . $url, 'SSL')
			);
			
			if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.jpg', 40, 40);
			}
		
			$special = false;
			
			$product_specials = $this->model_catalog_product->getProductSpecials($result['product_id']);
			
			foreach ($product_specials  as $product_special) {
				if (($product_special['date_start'] == '0000-00-00' || $product_special['date_start'] < date('Y-m-d')) && ($product_special['date_end'] == '0000-00-00' || $product_special['date_end'] > date('Y-m-d'))) {
					$special = $product_special['price'];
			
					break;
				}					
			}
	
      		$this->data['products'][] = array(
				'product_id' => $result['product_id'],
				'name'       => $result['name'],
				'model'      => $result['model'],
				'service_id'      => $result['service_id'],
				'price'      => number_format($result['price'],2,'.',''),
				'special'    => $special,
				'image'      => $image,
				'quantity'   => $result['quantity'],
				'status'     => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'selected'   => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				'action'     => $action
			);
    	}
		
		$this->data['heading_title'] = $this->language->get('heading_title');		
				
		$this->data['text_enabled'] = $this->language->get('text_enabled');		
		$this->data['text_disabled'] = $this->language->get('text_disabled');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');		
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');		
		$this->data['column_no'] = $this->language->get('column_no');	
		$this->data['column_image'] = $this->language->get('column_image');		
		$this->data['column_name'] = $this->language->get('column_name');	
		$this->data['column_product_id'] = $this->language->get('column_product_id');		
		$this->data['column_model'] = $this->language->get('column_model');
		$this->data['column_service_id'] = $this->language->get('column_service_id');		
		$this->data['column_price'] = $this->language->get('column_price');		
		$this->data['column_quantity'] = $this->language->get('column_quantity');		
		$this->data['column_status'] = $this->language->get('column_status');		
		$this->data['column_action'] = $this->language->get('column_action');		
				
		$this->data['button_copy'] = $this->language->get('button_copy');		
		$this->data['button_insert'] = $this->language->get('button_insert');		
		$this->data['button_delete'] = $this->language->get('button_delete');		
		$this->data['button_filter'] = $this->language->get('button_filter');
		 
 		$this->data['token'] = $this->session->data['token'];
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		}else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . urlencode(html_entity_decode($this->request->get['filter_product_id'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}
		
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
								
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
					
		$this->data['sort_name'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=pd.name' . $url, 'SSL');
		$this->data['sort_product_id'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=pd.product_id' . $url, 'SSL');
		$this->data['sort_model'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=p.model' . $url, 'SSL');
		$this->data['sort_service_id'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=p.service_id' . $url, 'SSL');
		$this->data['sort_price'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=p.price' . $url, 'SSL');
		$this->data['sort_quantity'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=p.quantity' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=p.status' . $url, 'SSL');
		$this->data['sort_order'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&sort=p.sort_order' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . urlencode(html_entity_decode($this->request->get['filter_product_id'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
		$this->data['filter_name'] = $filter_name;
		$this->data['filter_product_id'] = $filter_product_id;
		$this->data['filter_model'] = $filter_model;
		$this->data['filter_service_id'] = $filter_service_id;
		$this->data['filter_price'] = $filter_price;
		$this->data['filter_quantity'] = $filter_quantity;
		$this->data['filter_status'] = $filter_status;
		
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'catalog/product_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the product/channel content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the product/channel form page.
*/


  	protected function getForm() {
  		$this->language->load('catalog/product');
    	$this->data['heading_title'] = $this->language->get('heading_title');
 
    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
    	$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_yes'] = $this->language->get('text_yes');
    	$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_plus'] = $this->language->get('text_plus');
		$this->data['text_minus'] = $this->language->get('text_minus');
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		$this->data['text_option'] = $this->language->get('text_option');
		$this->data['text_option_value'] = $this->language->get('text_option_value');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_percent'] = $this->language->get('text_percent');
		$this->data['text_amount'] = $this->language->get('text_amount');
		$this->data['text_amount'] = $this->language->get('text_amount');
		$this->data['text_paid'] = $this->language->get('text_paid');
		$this->data['text_fd'] = $this->language->get('text_fd');

		$this->data['entry_type'] = $this->language->get('entry_type');

		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_service_id'] = $this->language->get('entry_service_id');
		$this->data['entry_meta_description'] = $this->language->get('entry_meta_description');
		$this->data['entry_meta_keyword'] = $this->language->get('entry_meta_keyword');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_store'] = $this->language->get('entry_store');
		$this->data['entry_keyword'] = $this->language->get('entry_keyword');
    	$this->data['entry_model'] = $this->language->get('entry_model');

    	$this->data['entry_lcn'] = $this->language->get('entry_lcn');
		$this->data['entry_sku'] = $this->language->get('entry_sku');
		$this->data['entry_upc'] = $this->language->get('entry_upc');
		$this->data['entry_ean'] = $this->language->get('entry_ean');
		$this->data['entry_jan'] = $this->language->get('entry_jan');
		$this->data['entry_isbn'] = $this->language->get('entry_isbn');
		$this->data['entry_mpn'] = $this->language->get('entry_mpn');
		$this->data['entry_location'] = $this->language->get('entry_location');
		$this->data['entry_minimum'] = $this->language->get('entry_minimum');
		$this->data['entry_manufacturer'] = $this->language->get('entry_manufacturer');
		$this->data['entry_broadcaster'] = $this->language->get('entry_broadcaster');
    	$this->data['entry_shipping'] = $this->language->get('entry_shipping');
    	$this->data['entry_date_available'] = $this->language->get('entry_date_available');
    	$this->data['entry_quantity'] = $this->language->get('entry_quantity');
		$this->data['entry_stock_status'] = $this->language->get('entry_stock_status');
    	$this->data['entry_price'] = $this->language->get('entry_price');
		$this->data['entry_tax_class'] = $this->language->get('entry_tax_class');
		$this->data['entry_points'] = $this->language->get('entry_points');
		$this->data['entry_option_points'] = $this->language->get('entry_option_points');
		$this->data['entry_subtract'] = $this->language->get('entry_subtract');
    	$this->data['entry_weight_class'] = $this->language->get('entry_weight_class');
    	$this->data['entry_weight'] = $this->language->get('entry_weight');
		$this->data['entry_dimension'] = $this->language->get('entry_dimension');
		$this->data['entry_length'] = $this->language->get('entry_length');
    	$this->data['entry_image'] = $this->language->get('entry_image');
    	$this->data['entry_download'] = $this->language->get('entry_download');
    	$this->data['entry_category'] = $this->language->get('entry_category');
		$this->data['entry_filter'] = $this->language->get('entry_filter');
		$this->data['entry_related'] = $this->language->get('entry_related');
		$this->data['entry_attribute'] = $this->language->get('entry_attribute');
		$this->data['entry_text'] = $this->language->get('entry_text');
		$this->data['entry_option'] = $this->language->get('entry_option');
		$this->data['entry_option_value'] = $this->language->get('entry_option_value');
		$this->data['entry_required'] = $this->language->get('entry_required');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$this->data['entry_date_start'] = $this->language->get('entry_date_start');
		$this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['entry_priority'] = $this->language->get('entry_priority');
		$this->data['entry_tag'] = $this->language->get('entry_tag');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$this->data['entry_reward'] = $this->language->get('entry_reward');
		$this->data['entry_layout'] = $this->language->get('entry_layout');
		$this->data['entry_access_criteria'] = $this->language->get('entry_access_criteria');
				
    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_attribute'] = $this->language->get('button_add_attribute');
		$this->data['button_add_option'] = $this->language->get('button_add_option');
		$this->data['button_add_option_value'] = $this->language->get('button_add_option_value');
		$this->data['button_add_discount'] = $this->language->get('button_add_discount');
		$this->data['button_add_special'] = $this->language->get('button_add_special');
		$this->data['button_add_image'] = $this->language->get('button_add_image');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
    	$this->data['tab_general'] = $this->language->get('tab_general');
    	$this->data['tab_data'] = $this->language->get('tab_data');
		$this->data['tab_attribute'] = $this->language->get('tab_attribute');
		$this->data['tab_option'] = $this->language->get('tab_option');		
		$this->data['tab_discount'] = $this->language->get('tab_discount');
		$this->data['tab_special'] = $this->language->get('tab_special');
    	$this->data['tab_image'] = $this->language->get('tab_image');		
		$this->data['tab_links'] = $this->language->get('tab_links');
		$this->data['tab_reward'] = $this->language->get('tab_reward');
		$this->data['tab_design'] = $this->language->get('tab_design');
		 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = array();
		}

		if (isset($this->error['channel_name'])) {
			$this->data['error_name'] = $this->error['channel_name'];
		} else {
			$this->data['error_name'] = array();
		}

		if (isset($this->error['subscription_price'])) {
			$this->data['error_subscription_price'] = $this->error['subscription_price'];
		} else {
			$this->data['error_subscription_price'] = '';
		}

		if (isset($this->error['subscription_option'])) {
			$this->data['error_subscription_option'] = $this->error['subscription_option'];
		} else {
			$this->data['error_subscription_option'] = '';
		}		

		if (isset($this->error['category'])) {
			$this->data['error_category'] = $this->error['category'];
		} else {
			$this->data['error_category'] = '';
		}

		if (isset($this->error['option'])) {
			$this->data['error_option'] = $this->error['option'];
		} else {
			$this->data['error_option'] = '';
		}

 		if (isset($this->error['meta_description'])) {
			$this->data['error_meta_description'] = $this->error['meta_description'];
		} else {
			$this->data['error_meta_description'] = array();
		}		
   
   		if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = array();
		}	

		if (isset($this->error['lcn'])) {
			$this->data['error_lcn'] = $this->error['lcn'];
		} else {
			$this->data['error_lcn'] = '';
		}
		
   		if (isset($this->error['model'])) {
			$this->data['error_model'] = $this->error['model'];
		} else {
			$this->data['error_model'] = '';
		}

		if (isset($this->error['access_criteria'])) {
			$this->data['error_access_criteria'] = $this->error['access_criteria'];
		} else {
			$this->data['error_access_criteria'] = '';
		}	

		if (isset($this->error['service_id'])) {
			$this->data['error_service_id'] = $this->error['service_id'];
		} else {
			$this->data['error_service_id'] = '';
		}	
     	
		if (isset($this->error['date_available'])) {
			$this->data['error_date_available'] = $this->error['date_available'];
		} else {
			$this->data['error_date_available'] = '';
		}	

		if (isset($this->error['price'])) {
			$this->data['error_price'] = $this->error['price'];
		} else {
			$this->data['error_price'] = '';
		}	
		if(isset($this->error['product_details']))
		{
			$this->data['error_product_details']=$this->error['product_details'];
		}else{
			$this->data['error_product_details'] = array();
		}	


		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}
		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}	
		
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
								
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
									
		if (!isset($this->request->get['product_id'])) {
			$this->data['action'] = $this->url->link('catalog/product/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('catalog/product/update', 'token=' . $this->session->data['token'] . '&product_id=' . $this->request->get['product_id'] . $url, 'SSL');
		}
		
		$this->data['cancel'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['product_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);
    	}

    	$this->data['broadcaster_info'] = $this->model_catalog_product->getBroadcasterList();
		
		$this->load->model('catalog/broadcastergroup');
		 if (isset($this->request->post['broadcaster_id'])) {
    		if($this->request->post['broadcaster_id']!=-1)
    		{
    			$this->data['broadcaster_id'] = $this->request->post['broadcaster_id'];
      			$this->data['channels'] = $this->model_catalog_product->getBroadcasterChannel($this->request->post['broadcaster_id']);
    		}else $this->data['channels'] = array();
      		
		}else
			$this->data['channels'] = array();


  //   	if (isset($this->request->post['broadcaster_id'])) {
  //     		$this->data['broadcaster_id'] = $this->request->post['broadcaster_id'];
  //     		$this->data['channels'] = $this->model_catalog_product->getBroadcasterChannel($this->request->post['broadcaster_id']);
  //     		// var_dump($this->data['channels']);exit();
		// }
		if (!empty($product_info)) {
			$this->data['broadcaster_info'] = $this->model_catalog_product->getBroadcasterInfo($product_info["broadcaster_id"]);
			$this->data['channels'] = $this->model_catalog_product->getBroadcasterChannel($product_info["broadcaster_id"]);
		} 
		else {
      		$this->data['broadcaster_id'] = 0;
      		// $this->data['channels'] =null;
    	} 		
    	

		if (isset($this->request->post['channel_name'])) {
      		$this->data['channel_name'] = trim(preg_replace('!\s+!', ' ', $this->request->post['channel_name']),' ');      		
    	} elseif (!empty($product_info)) {
			$this->data['channel_name'] = $product_info['name'];
		} else {
      		$this->data['channel_name'] = '';
    	}		

    	if (isset($this->request->post['broadcaster_channel_name'])) { 
      		$this->data['broadcaster_channel_name'] = trim(preg_replace('!\s+!', ' ', $this->request->post['broadcaster_channel_name']),' ');
    	} elseif (!empty($product_info)) { 
			$this->data['broadcaster_channel_name'] = $product_info['name'];
		} else {
      		$this->data['broadcaster_channel_name'] = '';
    	}

    	if (isset($this->request->post['broadcaster_id'])) {
      		$this->data['broadcaster_id'] = $this->request->post['broadcaster_id'];
    	} elseif (!empty($product_info)) {
			$this->data['broadcaster_id'] = $product_info['broadcaster_id'];
		} else {
      		$this->data['broadcaster_id'] = '';
    	}
    	
		$this->data['token'] = $this->session->data['token'];
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['product_description'])) {
			$this->data['product_description'] = $this->request->post['product_description'];			
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_description'] = $this->model_catalog_product->getProductDescriptions($this->request->get['product_id']);
		} else {
			$this->data['product_description'] = array();
		}
		
		if (isset($this->request->post['model'])) {
      		$this->data['model'] = $this->request->post['model'];
    	} elseif (!empty($product_info)) {
			$this->data['model'] = $product_info['model'];
		} else {
      		$this->data['model'] = '';
    	}

    	if (isset($this->request->post['service_id'])) {
      		$this->data['service_id'] = $this->request->post['service_id'];
    	} elseif (!empty($product_info)) {
			$this->data['service_id'] = $product_info['service_id'];
		} else {
      		$this->data['service_id'] = '';
    	}

		if (isset($this->request->post['sku'])) {
      		$this->data['sku'] = $this->request->post['sku'];
    	} elseif (!empty($product_info)) {
			$this->data['sku'] = $product_info['sku'];
		} else {
      		$this->data['sku'] = '';
    	}
		
		if (isset($this->request->post['upc'])) {
      		$this->data['upc'] = $this->request->post['upc'];
    	} elseif (!empty($product_info)) {
			$this->data['upc'] = $product_info['upc'];
		} else {
      		$this->data['upc'] = '';
    	}
		
		if (isset($this->request->post['ean'])) {
      		$this->data['ean'] = $this->request->post['ean'];
    	} elseif (!empty($product_info)) {
			$this->data['ean'] = $product_info['ean'];
		} else {
      		$this->data['ean'] = '';
    	}
		
		if (isset($this->request->post['jan'])) {
      		$this->data['jan'] = $this->request->post['jan'];
    	} elseif (!empty($product_info)) {
			$this->data['jan'] = $product_info['jan'];
		} else {
      		$this->data['jan'] = '';
    	}
		
		if (isset($this->request->post['isbn'])) {
      		$this->data['isbn'] = $this->request->post['isbn'];
    	} elseif (!empty($product_info)) {
			$this->data['isbn'] = $product_info['isbn'];
		} else {
      		$this->data['isbn'] = '';
    	}
		
		if (isset($this->request->post['mpn'])) {
      		$this->data['mpn'] = $this->request->post['mpn'];
    	} elseif (!empty($product_info)) {
			$this->data['mpn'] = $product_info['mpn'];
		} else {
      		$this->data['mpn'] = '';
    	}								
				
		if (isset($this->request->post['location'])) {
      		$this->data['location'] = $this->request->post['location'];
    	} elseif (!empty($product_info)) {
			$this->data['location'] = $product_info['location'];
		} else {
      		$this->data['location'] = '';
    	}

		$this->load->model('setting/store');
		
		$this->data['stores'] = $this->model_setting_store->getStores();
		
		if (isset($this->request->post['product_store'])) {
			$this->data['product_store'] = $this->request->post['product_store'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_store'] = $this->model_catalog_product->getProductStores($this->request->get['product_id']);
		} else {
			$this->data['product_store'] = array(0);
		}	
		
		if (isset($this->request->post['keyword'])) {
			$this->data['keyword'] = $this->request->post['keyword'];
		} elseif (!empty($product_info)) {
			$this->data['keyword'] = $product_info['keyword'];
		} else {
			$this->data['keyword'] = '';
		}
		
		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (!empty($product_info)) {
			$this->data['image'] = $product_info['image'];
		} else {
			$this->data['image'] = '';
		}
		
		$this->load->model('tool/image');
		
		if (isset($this->request->post['image']) && file_exists(DIR_IMAGE . $this->request->post['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($product_info) && $product_info['image'] && file_exists(DIR_IMAGE . $product_info['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($product_info['image'], 100, 100);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}

  //   	if (isset($this->request->post['shipping'])) {
  //     		$this->data['shipping'] = $this->request->post['shipping'];
  //   	} elseif (!empty($product_info)) {
  //     		$this->data['shipping'] = $product_info['shipping'];
  //   	} else {
		// 	$this->data['shipping'] = 1;
		// }

		if (isset($this->request->post['price'])){
			if(!is_numeric($this->request->post['price'])){
				// var_dump($this->request->post['price']);
				$this->data['price'] = '';
			}else{
				$this->data['price'] = number_format($this->request->post['price'],2,'.','');
			}
		}else{
	    	if (isset($this->request->post['price']) && $this->request->post['price']!='') {
	      		$this->data['price'] = number_format($this->request->post['price'],2,'.','');
	    	} elseif (!empty($product_info)) {
				$this->data['price'] = number_format($product_info['price'],2,'.','');
			} else {
	      		$this->data['price'] = '';
	    	}
		}

		$this->load->model('localisation/tax_class');
		
		$this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();
    	
		if (isset($this->request->post['tax_class_id'])) {
      		$this->data['tax_class_id'] = $this->request->post['tax_class_id'];
    	} elseif (!empty($product_info)) {
			$this->data['tax_class_id'] = $product_info['tax_class_id'];
		} else {
      		$this->data['tax_class_id'] = 0;
    	}
		      	
		if (isset($this->request->post['date_available'])) {
       		$this->data['date_available'] = $this->request->post['date_available'];
		} elseif (!empty($product_info)) {
			$this->data['date_available'] = date('Y-m-d', strtotime($product_info['date_available']));
		} else {
			$this->data['date_available'] = date('Y-m-d', time() );
			// $this->data['date_available'] = date('Y-m-d', time() - 86400);
		}
											
		if (isset($this->request->post['sort_order'])) {
      		$this->data['sort_order'] = $this->request->post['sort_order'];
    	} elseif (!empty($product_info)) {
      		$this->data['sort_order'] = $product_info['sort_order'];
    	} else {
			$this->data['sort_order'] = 1;
		}

		if (isset($this->request->post['access_criteria'])) {
      		$this->data['access_criteria'] = $this->request->post['access_criteria'];
    	} elseif (!empty($product_info)) {
			$this->data['access_criteria'] = $product_info["access_criteria"];
		} else {
      		$this->data['access_criteria'] = '';
    	}

    	if (isset($this->request->post['lcn'])) {
      		$this->data['lcn'] = $this->request->post['lcn'];
    	} elseif (!empty($product_info)) {
			$this->data['lcn'] = $product_info["lcn"];
		} else {
      		$this->data['lcn'] = '';
    	}

		if (isset($this->request->post['type'])) {
      		$this->data['type'] = $this->request->post['type'];
    	} elseif (!empty($product_info)) {
			$this->data['type'] = $product_info["product_type"];
		} else {
      		$this->data['type'] = 1;
    	}

		$this->load->model('localisation/stock_status');
		
		$this->data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();
    	
		// if (isset($this->request->post['stock_status_id'])) {
  //     		$this->data['stock_status_id'] = $this->request->post['stock_status_id'];
  //   	} elseif (!empty($product_info)) {
  //     		$this->data['stock_status_id'] = $product_info['stock_status_id'];
  //   	} else {
		// 	$this->data['stock_status_id'] = $this->config->get('config_stock_status_id');
		// }
				
    	if (isset($this->request->post['status'])) {
      		$this->data['status'] = $this->request->post['status'];
    	} elseif (!empty($product_info)) {
			$this->data['status'] = $product_info['status'];
		} else {
      		$this->data['status'] = 1;
    	}


		// $this->load->model('catalog/broadcastergroup');
		
  //   	if (isset($this->request->post['broadcaster_id'])) {
  //     		$this->data['broadcaster_id'] = $this->request->post['broadcaster_id'];
		// } elseif (!empty($product_info)) {
		// 	$this->data['broadcaster_id'] = $product_info['broadcaster_id'];
		// } else {
  //     		$this->data['broadcaster_id'] = 0;
  //   	} 		
			
  //   	if (isset($this->request->post['broadcaster'])) {
  //     		$this->data['broadcaster'] = $this->request->post['broadcaster'];
		// } elseif (!empty($product_info)) {
		// 	$broadcaster_info = $this->model_catalog_broadcastergroup->getBroadcaster($product_info['broadcaster_id']);
			
		// 	if ($broadcaster_info) {		
		// 		$this->data['broadcaster'] = $broadcaster_info['name'];
		// 	} else {
		// 		$this->data['broadcaster'] = '';
		// 	}	
		// } else {
  //     		$this->data['broadcaster'] = '';
  //   	} 
		
		// Categories
		$this->load->model('catalog/category');
		
		if (isset($this->request->post['product_category'])) {
			$categories = $this->request->post['product_category'];
		} elseif (isset($this->request->get['product_id'])) {		
			$categories = $this->model_catalog_product->getProductCategories($this->request->get['product_id']);
		} else {
			$categories = array();
		}
	
		$this->data['product_categories'] = array();
		
		foreach ($categories as $category_id) {
			$category_info = $this->model_catalog_category->getCategory($category_id);
			
			if ($category_info) {
				$this->data['product_categories'][] = array(
					'category_id' => $category_info['category_id'],
					'name'        => ($category_info['path'] ? $category_info['path'] . ' &gt; ' : '') . $category_info['name']
				);
			}
		}
		
		// Filters
		$this->load->model('catalog/filter');
		
		if (isset($this->request->post['product_filter'])) {
			$filters = $this->request->post['product_filter'];
		} elseif (isset($this->request->get['product_id'])) {
			$filters = $this->model_catalog_product->getProductFilters($this->request->get['product_id']);
		} else {
			$filters = array();
		}
		
		$this->data['product_filters'] = array();
		
		foreach ($filters as $filter_id) {
			$filter_info = $this->model_catalog_filter->getFilter($filter_id);
			
			if ($filter_info) {
				$this->data['product_filters'][] = array(
					'filter_id' => $filter_info['filter_id'],
					'name'      => $filter_info['group'] . ' &gt; ' . $filter_info['name']
				);
			}
		}		
		
		// Attributes
		$this->load->model('catalog/attribute');
		
		if (isset($this->request->post['product_attribute'])) {
			$product_attributes = $this->request->post['product_attribute'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_attributes = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);
		} else {
			$product_attributes = array();
		}
		
		$this->data['product_attributes'] = array();
		
		foreach ($product_attributes as $product_attribute) {
			$attribute_info = $this->model_catalog_attribute->getAttribute($product_attribute['attribute_id']);
			
			if ($attribute_info) {
				$this->data['product_attributes'][] = array(
					'attribute_id'                  => $product_attribute['attribute_id'],
					'name'                          => $attribute_info['name'],
					'product_attribute_description' => $product_attribute['product_attribute_description']
				);
			}
		}		
		
		// Options
		$this->load->model('catalog/option');
		
		if (isset($this->request->post['product_option'])) {
			$product_options = $this->request->post['product_option'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_options = $this->model_catalog_product->getProductOptions($this->request->get['product_id']);			
		} else {
			$product_options = array();
		}			
		
		$this->data['product_options'] = array();
			
		foreach ($product_options as $product_option) {
			$option_info = $this->model_catalog_option->getOption($product_option['option_id']);
			
			if ($option_info) {
				if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
					$product_option_value_data = array();
					if(isset($product_option['product_option_value']))
					{
						foreach ($product_option['product_option_value'] as $product_option_value) {
							$product_option_value_data[] = array(
								'product_option_value_id' => $product_option_value['product_option_value_id'],
								'option_value_id'         => $product_option_value['option_value_id'],
								'price'                   => $product_option_value['price'],
								'price_prefix'            => $product_option_value['price_prefix'],
								'points'                  => $product_option_value['points'],
								'points_prefix'           => $product_option_value['points_prefix'],						
							);
						}
					}					
					
					$this->data['product_options'][] = array(
						'product_option_id'    => $product_option['product_option_id'],
						'product_option_value' => $product_option_value_data,
						'option_id'            => $product_option['option_id'],
						'name'                 => $option_info['name'],
						'type'                 => $option_info['type'],
						//'required'             => $product_option['required']
					);				
				} else {
					$this->data['product_options'][] = array(
						'product_option_id' => $product_option['product_option_id'],
						'option_id'         => $product_option['option_id'],
						'name'              => $option_info['name'],
						'type'              => $option_info['type'],
						'option_value'      => $product_option['option_value'],
						//'required'          => $product_option['required']
					);				
				}
			}
		}
		
		$this->data['option_values'] = array();
		
		foreach ($this->data['product_options'] as $product_option) {
			if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
				if (!isset($this->data['option_values'][$product_option['option_id']])) {
					$this->data['option_values'][$product_option['option_id']] = $this->model_catalog_option->getOptionValues($product_option['option_id']);
				}
			}
		}
		
		$this->load->model('sale/customer_group');
		
		$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
		
		if (isset($this->request->post['product_discount'])) {
			$this->data['product_discounts'] = $this->request->post['product_discount'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_discounts'] = $this->model_catalog_product->getProductDiscounts($this->request->get['product_id']);
		} else {
			$this->data['product_discounts'] = array();
		}

		if (isset($this->request->post['product_special'])) {
			$this->data['product_specials'] = $this->request->post['product_special'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_specials'] = $this->model_catalog_product->getProductSpecials($this->request->get['product_id']);
		} else {
			$this->data['product_specials'] = array();
		}
		
		// Images
		if (isset($this->request->post['product_image'])) {
			$product_images = $this->request->post['product_image'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_images = $this->model_catalog_product->getProductImages($this->request->get['product_id']);
		} else {
			$product_images = array();
		}
		
		$this->data['product_images'] = array();
		
		foreach ($product_images as $product_image) {
			if ($product_image['image'] && file_exists(DIR_IMAGE . $product_image['image'])) {
				$image = $product_image['image'];
			} else {
				$image = 'no_image.jpg';
			}
			
			$this->data['product_images'][] = array(
				'image'      => $image,
				'thumb'      => $this->model_tool_image->resize($image, 100, 100),
				'sort_order' => $product_image['sort_order']
			);
		}

		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);

		// Downloads
		// $this->load->model('catalog/download');
		
		// if (isset($this->request->post['product_download'])) {
		// 	$product_downloads = $this->request->post['product_download'];
		// } elseif (isset($this->request->get['product_id'])) {
		// 	$product_downloads = $this->model_catalog_product->getProductDownloads($this->request->get['product_id']);
		// } else {
		// 	$product_downloads = array();
		// }
			
		// $this->data['product_downloads'] = array();
		
		// foreach ($product_downloads as $download_id) {
		// 	$download_info = $this->model_catalog_download->getDownload($download_id);
			
		// 	if ($download_info) {
		// 		$this->data['product_downloads'][] = array(
		// 			'download_id' => $download_info['download_id'],
		// 			'name'        => $download_info['name']
		// 		);
		// 	}
		// }
		
		if (isset($this->request->post['product_related'])) {
			$products = $this->request->post['product_related'];
		} elseif (isset($this->request->get['product_id'])) {		
			$products = $this->model_catalog_product->getProductRelated($this->request->get['product_id']);
		} else {
			$products = array();
		}
	
		$this->data['product_related'] = array();
		
		foreach ($products as $product_id) {
			$related_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($related_info) {
				$this->data['product_related'][] = array(
					'product_id' => $related_info['product_id'],
					'name'       => $related_info['name']
				);
			}
		}

    	if (isset($this->request->post['points'])) {
      		$this->data['points'] = $this->request->post['points'];
    	} elseif (!empty($product_info)) {
			$this->data['points'] = $product_info['points'];
		} else {
      		$this->data['points'] = '';
    	}
						
		if (isset($this->request->post['product_reward'])) {
			$this->data['product_reward'] = $this->request->post['product_reward'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_reward'] = $this->model_catalog_product->getProductRewards($this->request->get['product_id']);
		} else {
			$this->data['product_reward'] = array();
		}
		
		if (isset($this->request->post['product_layout'])) {
			$this->data['product_layout'] = $this->request->post['product_layout'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_layout'] = $this->model_catalog_product->getProductLayouts($this->request->get['product_id']);
		} else {
			$this->data['product_layout'] = array();
		}

		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();
										
		$this->template = 'catalog/product_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	} 

  	
  	protected function validateProductCount() { 
  		$channelCount = $this->model_catalog_product->CheckChannelCount();
  		if ($channelCount<550) {
			return true;
    	} else {
    		$this->error['warning'] = $this->language->get('Warning: Maximum Limit reached for adding Products/Channels!!');
      		return false;
    	}
  	}

/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the product/channel details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/

	
  	protected function validateForm() { 
  		if (!$this->user->hasPermission('modify', 'catalog/product')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
 
		if ($this->request->post["status"] == 0) {    			
    		if($this->request->post['broadcaster_id'] == '-1') {
				$productName = $this->request->post['broadcaster_channel_name'];
			} else {
				$productName = $this->request->post['channel_name'];
			}
			$productName = trim(preg_replace('!\s+!', ' ', $productName),' ');
    		$channels_in_packages = $this->model_catalog_product->getChannelsList();
    		
    		foreach ($channels_in_packages as $value) {
    			if (strpos($value, $productName) !== false) {
				    $this->error['warning'] = "Warning: Channel present in package can't disable!!";
				}
    		}
    	}
    	
    	/*foreach ($this->request->post['product_description'] as $language_id => $value) {
      		if ((utf8_strlen($value['name']) < 3) || (utf8_strlen($value['name']) > 100)) {
        		$this->error['name'][$language_id] = $this->language->get('error_name');
      		}
    	}*/
    	
    	if(isset($this->request->post['product_option'])){
    		foreach ($this->request->post['product_option'] as $product_option) {
    			if (isset($product_option['product_option_value']) && count($product_option['product_option_value']) > 0 ) {
						foreach ($product_option['product_option_value'] as $product_option_value) {
							if($product_option_value['price']=='' || !is_numeric($product_option_value['price'])){
								$this->error['subscription_price']=$this->language->get('error_price');
							}elseif ($product_option_value['price']<0) {
								$this->error['subscription_price']= "Price should be positive.!";
							}
						}
				}
    		}
    	}

		$unique_option_value = array();
		$count = 0;
		if(isset($this->request->post['product_option'])){
	    	 foreach ($this->request->post['product_option'] as $product_option) {
	    	  	if (isset($product_option['product_option_value']))	{
	    	    	foreach($product_option['product_option_value'] as $product_option_id)	{
	    	    	    $unique_option_value[$count++]  = 	$product_option_id['option_value_id'];
	    	    	}
	    	    }
	    	  }
    	}
    	if (count(array_unique(array_diff_assoc($unique_option_value,array_unique($unique_option_value))))>0){
           $this->error['subscription_option'] = $this->language->get('warning_duplicate_option');
    	}

    	if(isset($this->request->get['product_id'])){
			$yes = $this->model_catalog_product->getCategory($this->request->get['product_id']);
	    	if (!isset($this->request->post['product_category'])) {
				$this->error['category']= $this->language->get('error_category_mismatch');
			}
    	}else{
	    	if (!isset($this->request->post['product_category'])) {
				$this->error['category']= $this->language->get('error_category_mismatch');
			}
    	}

    	if(!isset($this->request->post['product_option'])){
    		$this->error['option']	="Choose subscription to add options!";
    	}else if(isset($this->request->post['product_option']))
    	{
    		foreach ($this->request->post['product_option'] as $product_option) {
    			if(!isset($product_option['product_option_value'])){
    				$this->error['option']	=$this->language->get('warning_add_option');	
    				break;
    			}
    		}
    	}

    	if(!is_numeric($this->request->post['price'])){
    		$this->error['price'] = $this->language->get('error_price');
    	}else if($this->request->post['price'] < 0){
    		$this->error['price'] = "Invalid price, price should be positive.!";
    	}

    	if ((utf8_strlen($this->request->post['model']) < 1) || (utf8_strlen($this->request->post['model']) > 7)) {
      		$this->error['model'] = 'Accepts integer of max length 7'; //$this->language->get('error_model');
    	}
    	else if(!is_numeric($this->request->post['model'])){
    		$this->error['model'] = 'Accepts only integers.'; //$this->language->get('error_model_digits');
    	}
    	else{
			$channel_check = $this->model_catalog_product->CheckChannelNo($this->request->post['model']);
			if (!isset($this->request->get['product_id'])) {
				if ($channel_check) {
					$this->error['model'] = $this->language->get('warning_duplicate_channel_no');
				}
			} else {
				if ($channel_check && ($this->request->get['product_id'] != $channel_check['product_id'])) {
					$this->error['model'] = $this->language->get('warning_duplicate_channel_no');
				}
			}
    	}
    	if ((utf8_strlen($this->request->post['service_id']) < 1) || (utf8_strlen($this->request->post['service_id']) > 5)) {
      		$this->error['service_id'] = $this->language->get('error_service_id');
    	}
    	else if(!is_numeric($this->request->post['service_id'])){
    		$this->error['service_id'] = $this->language->get('error_service_id_digits');
    	}
    	else{
			$service_id_check = $this->model_catalog_product->CheckServiceId($this->request->post['service_id']);
			if (!isset($this->request->get['product_id'])) {
				if ($service_id_check) {
					$this->error['service_id'] = $this->language->get('warning_duplicate_service_id');
				}
			} else {
				if ($service_id_check && ($this->request->get['product_id'] != $service_id_check['product_id'])) {
					$this->error['service_id'] =$this->language->get('warning_duplicate_service_id');
				}
			}
    	}

    	if ((utf8_strlen($this->request->post['access_criteria']) < 1) || (utf8_strlen($this->request->post['access_criteria']) > 4)) {
      		$this->error['access_criteria'] = $this->language->get('error_access_criteria');
    	}
    	else if(!is_numeric($this->request->post['access_criteria'])){
    		$this->error['access_criteria'] = $this->language->get('error_access_digits');
    	}
    	else{
			$access_check = $this->model_catalog_product->CheckAccessCriteria($this->request->post['access_criteria']);
			if (!isset($this->request->get['product_id'])) {
				if ($access_check) {
					$this->error['access_criteria'] = $this->language->get('warning_duplicate_access_criteria');
				}
			} else {
				if ($access_check && ($this->request->get['product_id'] != $access_check['product_id'])) {
					$this->error['access_criteria'] = $this->language->get('warning_duplicate_access_criteria');
				}
			}
    	}
		
    	if ((utf8_strlen($this->request->post['lcn']) < 1) || (utf8_strlen($this->request->post['lcn']) > 4)) {
      		$this->error['lcn'] = $this->language->get('error_lcn');
    	}
    	else if(!is_numeric($this->request->post['lcn'])){
    		$this->error['lcn'] = $this->language->get('error_lcn_digits');
    	}
    	else{
			$lcn_check = $this->model_catalog_product->CheckLCN($this->request->post['lcn']);
			if (!isset($this->request->get['product_id'])) {
				if ($lcn_check) {
					$this->error['lcn'] = $this->language->get('warning_duplicate_lcn');
				}
			} else {
				if ($lcn_check && ($this->request->get['product_id'] != $lcn_check['product_id'])) {
					$this->error['lcn'] = $this->language->get('warning_duplicate_lcn');
				}
			}
    	}
		
		/********************************** Duplicate Product ******************************/
		if($this->request->post['broadcaster_id'] == '-1'){
			// $productName = $this->request->post['broadcaster_channel_name'];
			$productName = trim(preg_replace('!\s+!', ' ', $this->request->post['broadcaster_channel_name']));
			
		}else{
			// $productName = $this->request->post['channel_name'];
			if(isset($this->request->post['channel_name'])){
				$productName = trim(preg_replace('!\s+!', ' ', $this->request->post['channel_name']));
			}else{
				$productName = '';
			}
		}

		if ((strlen($productName) < 3) || (utf8_strlen($productName) >64 )){
    		$this->error['product_details']="Length should be between 3-64 characters!";
    	}
    	elseif(!preg_match("#^[a-zA-Z0-9 -]+$#", $productName))	{
    	// elseif(!preg_match("#^[a-zA-Z0-9_\/ ,-]+$#", $productName))	{
			$this->error['product_details']="Special Characters not allowed!";
		}

		if(!isset($this->request->get['product_id'])){
  			if($this->model_catalog_product->CheckProductDuplication($productName))
    	   		$this->error['product_details']=$this->language->get('error_name_duplicate');
    	}

    	if(isset($this->request->get["product_id"])){ 
    		$prodName = $this->model_catalog_product->getProductName($this->request->get["product_id"]);
    		if($prodName!=$productName){
    			if(isset($this->request->post)){	    		
						if($this->model_catalog_product->CheckProductDuplication($productName))
					   		$this->error['product_details']=$this->language->get('error_name_duplicate');	
					}
    		}			
    	}/*elseif(preg_match('/[^a-z0-9 _]+/i', trim($productName))) {
    		$this->error['product_details']='Special Characters not allowed in Channel Name.';	
    	}*/

    	/********************************** Duplicate Product ******************************/
    	if(isset($this->request->post['product_option'])){
	    	foreach ($this->request->post['product_option'] as $product_option) {
	    	  	if (isset($product_option['product_option_value']))	{
    	  			foreach($product_option['product_option_value'] as $product_option_id)	{
    	  				$option_val_name = $this->model_catalog_product->getSubscriptionDurationName($product_option_id["option_value_id"]);	    	  				
    	    	    	if(stristr($option_val_name, '1 day')=='1 day' || stristr($option_val_name, '1day')=='1day'){
    	    	    		$this->error['subscription_option'] = "Warning: Please do not select 1 day subscription value for Channel!!"; 
    	    	    	}	    	    	    	
    	    		}
	    	  		
	    	    }
	    	}
    	}    	

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
				
    	if (!$this->error) {
			return true;
    	} else {
      		return false;
    	}
  	}
  	// private function CheckDuplication()
  	// {
  	// 	if($this->request->post['broadcaster_id'] == '-1')
			// {
			// 	$productName = $this->request->post['broadcaster_channel_name'];
			// }else{
			// 	$productName = $this->request->post['channel_name'];
			// }
  	// 	// $is_product_exist = $this->model_catalog_product->CheckProductDuplication($this->request->post['product_description']['1']['name']);
  	// 	$is_product_exist = $this->model_catalog_product->CheckProductDuplication($productName);
   //  	if($is_product_exist)
   //  	{
   //  		$this->error['warning']="Duplicate Product!";
   //  		return false;
   //  	}else{
   //  		return true;
   //  	}
  	// }
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the product/channel content when deleted. 
						Checks if the deteled product/channel is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'catalog/product')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}
	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

/*
FUNCTION NAME 		-	validateCopy
DESCRIPTION 		-	Validates the permisssion of modifying the product/channel or not.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	
  	protected function validateCopy() {
    	if (!$this->user->hasPermission('modify', 'catalog/product')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
		
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_service_id']) || isset($this->request->get['filter_model']) || isset($this->request->get['filter_category_id'])) {
			$this->load->model('catalog/product');
			$this->load->model('catalog/option');
			
			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
			}
			
			if (isset($this->request->get['filter_model'])) {
				$filter_model = $this->request->get['filter_model'];
			} else {
				$filter_model = '';
			}

			if (isset($this->request->get['filter_service_id'])) {
				$filter_service_id = $this->request->get['filter_service_id'];
			} else {
				$filter_service_id = '';
			}
			
			if (isset($this->request->get['limit'])) {
				$limit = $this->request->get['limit'];	
			} else {
				$limit = 20;	
			}			
						
			$data = array(
				'filter_name'  => $filter_name,
				'filter_model' => $filter_model,
				'filter_service_id' => $filter_service_id,
				'start'        => 0,
				'limit'        => $limit
			);
			
			$results = $this->model_catalog_product->getProductAndPackages($data);
			
			foreach ($results as $result) {
				$option_data = array();
				
				$product_options = $this->model_catalog_product->getProductOptions($result['product_id']);	
				
				foreach ($product_options as $product_option) {
					$option_info = $this->model_catalog_option->getOption($product_option['option_id']);
					
					if ($option_info) {				
						if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
							$option_value_data = array();
							
							foreach ($product_option['product_option_value'] as $product_option_value) {
								$option_value_info = $this->model_catalog_option->getOptionValue($product_option_value['option_value_id']);
						
								if ($option_value_info) {
									$option_value_data[] = array(
										'product_option_value_id' => $product_option_value['product_option_value_id'],
										'option_value_id'         => $product_option_value['option_value_id'],
										'name'                    => $option_value_info['name'],
										'price'                   => (float)$product_option_value['price'] ? $this->currency->format($product_option_value['price'], $this->config->get('config_currency')) : false,
										'price_prefix'            => $product_option_value['price_prefix']
									);
								}
							}
						
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $option_value_data,
								'required'          => $product_option['required']
							);	
						} else {
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $product_option['option_value'],
								'required'          => $product_option['required']
							);				
						}
					}
				}
					
				$json[] = array(
					'product_id' => $result['product_id'],
					'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),	
					'model'      => $result['model'],
					'service_id'      => $result['service_id'],
					'option'     => $option_data,
					'price'      => $result['price'],
					'is_package' => $result['is_package']
				);	
			}

		}

		$this->response->setOutput(json_encode($json));
	}

		/*
FUNCTION NAME 		-	autocompleteOrder
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
		
	public function autocompleteOrder() {
		$json = array();
		
		if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_service_id']) || isset($this->request->get['filter_model']) || isset($this->request->get['filter_category_id'])) {
			$this->load->model('catalog/product');
			$this->load->model('catalog/option');
			
			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
			}
			
			if (isset($this->request->get['filter_model'])) {
				$filter_model = $this->request->get['filter_model'];
			} else {
				$filter_model = '';
			}

			if (isset($this->request->get['filter_service_id'])) {
				$filter_service_id = $this->request->get['filter_service_id'];
			} else {
				$filter_service_id = '';
			}
			
			if (isset($this->request->get['limit'])) {
				$limit = $this->request->get['limit'];	
			} else {
				$limit = 20;	
			}			
						
			$data = array(
				'filter_name'  => $filter_name,
				'filter_model' => $filter_model,
				'filter_service_id' => $filter_service_id,
				'start'        => 0,
				'limit'        => $limit
			);
			
			$results = $this->model_catalog_product->getProductAndPackagesFromOrder($data);
			
			foreach ($results as $result) {
				$option_data = array();
				
				$product_options = $this->model_catalog_product->getProductOptions($result['product_id']);	
				
				foreach ($product_options as $product_option) {
					$option_info = $this->model_catalog_option->getOption($product_option['option_id']);
					
					if ($option_info) {				
						if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
							$option_value_data = array();
							
							foreach ($product_option['product_option_value'] as $product_option_value) {
								$option_value_info = $this->model_catalog_option->getOptionValue($product_option_value['option_value_id']);
						
								if ($option_value_info) {
									$option_value_data[] = array(
										'product_option_value_id' => $product_option_value['product_option_value_id'],
										'option_value_id'         => $product_option_value['option_value_id'],
										'name'                    => $option_value_info['name'],
										'price'                   => (float)$product_option_value['price'] ? $this->currency->format($product_option_value['price'], $this->config->get('config_currency')) : false,
										'price_prefix'            => $product_option_value['price_prefix']
									);
								}
							}
						
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $option_value_data,
								'required'          => $product_option['required']
							);	
						} else {
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $product_option['option_value'],
								'required'          => $product_option['required']
							);				
						}
					}
				}
					
				$json[] = array(
					'product_id' => $result['product_id'],
					'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),	
					'model'      => $result['model'],
					'service_id'      => $result['service_id'],
					'option'     => $option_data,
					'price'      => $result['price'],
					'is_package' => $result['is_package'],
					'is_ppv' => $result['is_ppv']
				);	
			}

		}

		$this->response->setOutput(json_encode($json));
	}



	private function getProductIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);
		foreach ($res as $value) 
			 {
			 	if($value['error']==false)
				return $value;
			 }
			 return;
	}

	/*
	FUNCTION NAME 		-	getDuplicateChannelsFromPackage
	DESCRIPTION 		-	This function gives the list of channels are added in perticular channel wise. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Renders the list.
	*/

	 public function getDuplicateChannelsFromPackage() {
		$json = array();
		$arrayList=array();
		$list_cart=array();
		if (isset($this->request->get['product_id']) && isset($this->request->get['customer_id'])&& isset($this->request->get['cart_list'])) {
			$this->load->model('catalog/product');
			$this->load->model('catalog/option');
				
			$product_ids=$this->request->get['cart_list'];		
			$data = array(
				'product_id'  => $this->request->get['product_id'],
				'customer_id' => $this->request->get['customer_id']
			);
			$channels = $this->model_catalog_product->getChannelListFromPackage($data['product_id']);
			
			$text='';
			if($product_ids!='')
			{
				$list_cart=explode(',', $product_ids);
				foreach ($list_cart as $value) {
					$cart_channels = $this->model_catalog_product->getChannelListFromPackage($value);
					$current_channel_list=explode(',',trim($channels['channel_list'],','));
					$tempList=explode(',', trim($cart_channels['channel_list'],','));
					$duplicateList=array_intersect($current_channel_list,$tempList);
					if($duplicateList)
					{
						$text=$cart_channels['name']."{ ".implode(',',$duplicateList)."}";
						array_push($arrayList, $text);
					}
				}
			}
			$channelList = $this->model_catalog_product->checkPackageSubs($data);
			// var_dump($channelList);
			if($channelList)
			{
				$list=explode(',',trim($channels['channel_list'],','));
				foreach ($channelList as $value) {
					if(!in_array($value['product_id'], $list_cart))
					{
						$tempList=explode(',', trim($value['channel_list'],','));
						$duplicateList=array_intersect($list,$tempList);
						if($duplicateList)
						{	$expireDate = $value['expire_date'];
							$is_cancel = $value['is_cancel'];
							$text .=', '.$value['name']."{ ".implode(',',$duplicateList)."}";
							array_push($arrayList, $text);
						}
					}
				}

			}
			if($arrayList){
				// Below if else codition is introduced in verion 2.5.16 for package alert
				if(isset($is_cancel)){
					$json = array(
						'is_cancel'   => $is_cancel,
						'expire_date' => $expireDate,
						'isDuplicate' => 1,
						'list' => $text//$list_ch
					);
				}else{

					  $json = array(
						'isDuplicate' => 1,
						'list' => $text//$list_ch
						);
				}
			}else{
				$json = array(
						'isDuplicate' => 0,
						'list' => ''
					);
			}
			
		}else{
			$json = array(
						'isDuplicate' => 0,
						'list' => ''
					);
		}
		$this->response->setOutput(json_encode($json));
	 }

	//  public function broadcaster_wise_channels() {
	// 	$json = array();
		
	// 	$this->load->model('catalog/product');

 //    	$broadcaster_info = $this->model_catalog_product->getBroadcasterChannel($this->request->get['broadcaster_id']);
	// 	if ($broadcaster_info) {
	// 				$this->load->model('catalog/product');
	// 		$json = array(
	// 			'broadcaster_id'     => $broadcaster_info['broadcaster_id'],
	// 			'name'               => $broadcaster_info['name'],
	// 			'broadcaster_channel'            => $this->model_catalog_product->getChannelByBroadcasterId($this->request->get['broadcaster_id'])
	// 		);
	// 	}
		
	// 	$this->response->setOutput(json_encode($json));
	// }

	public function broadcaster_channels(){
		$json = array();
		$this->load->model('catalog/product');
		$broadcaster_info = $this->model_catalog_product->getBroadcasterChannel($this->request->get['broadcaster_id']);

		if($broadcaster_info){
			foreach ($broadcaster_info as $value) {
				array_push($json, $value['channel_name']);
			}	
		}
		$this->response->setOutput(json_encode($json));
	}

	/*
	FUNCTION NAME 		-	getDuplicateChannelsFromPackage
	DESCRIPTION 		-	This function gives the list of channels are added in perticular channel wise. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Renders the list.
	*/

	 public function getBoughtPPV() {
		$json = array();
		if (isset($this->request->get['product_id']) && isset($this->request->get['customer_id'])) {
			$this->load->model('catalog/product');
			$this->load->model('catalog/option');
				
			$data = array(
				'product_id'  => $this->request->get['product_id'],
				'customer_id' => $this->request->get['customer_id']
			);
			
			$text='';
			
			$channelList = $this->model_catalog_product->checkPPVSubs($data);
		
			if($channelList)
			{
				
				$json = array(
						'isBought' => 1,
					);
			}
	
		$this->response->setOutput(json_encode($json));
	 }
	}

	public function WriteMessageLog($status,$log_target_level,$log_target,$command,$prd_log_detail){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command.$prd_log_detail);
        fclose($log_file);
    }

}
?>
