<?php 
/*
@File package.php(Controller)
ADMIN PACKAGE PAGE
    This class manages the packages in the store. Creating/ updating/ deleting of packages 
    can be done with the notification of success or failure.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCatalogPackage extends Controller {
	private $error = array(); 
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the package option in the dopdown list.
						It get all the package list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin package page.
*/
     
  	public function index() {
		$this->language->load('catalog/package');
    	
		$this->document->setTitle($this->language->get('heading_title')); 
		
		$this->load->model('catalog/package');
		
		$this->getList();
  	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert package form page where the admin can give the
						details of the new package.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin package form page.
*/
  
  	public function insert() {  	 		
  		$obj = new restapi();
    	$this->language->load('catalog/package');

    	$this->document->setTitle($this->language->get('heading_title')); 
		
		$this->load->model('catalog/package');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm() ) {

    		//------added after build 22-----------------------------
    		foreach ($this->request->post["product_description"] as $key => $value) {
				$this->request->post["product_description"][$key]['name'] = preg_replace('!\s+!', ' ', trim($value['name']));
			}
			//--------------------------------------------------------
			// ------------------------------------------------------------------------------------------

				$strings=$this->request->post['destchannels'];
				$channel_list = "'".implode("','",$strings)."'";
				$ids=$this->model_catalog_package->getChanneIdlList($channel_list);
				$count = 0;
				$list = "";
				foreach ($values as $key => $value) {
					if ($count==0) {
						$list = $value["api_product_id"];
					}else{
						$list = $list.",".$value["api_product_id"];
					}
				 	$count++;		 	
				}

				$product_no = $this->model_catalog_package->getProductNos($ids);
           	 	$count_product_nums = 0;
				$list_product_nums = "";
				foreach ($product_no as $key => $value) {
					if ($count_product_nums==0) {
						$list_product_nums = $value["model"]." - ".$value["name"];
					}else{
						$list_product_nums = $list_product_nums.", ".$value["model"]." - ".$value["name"];
					}
				 	$count_product_nums++;		 	
				}

			// ------------------------------------------------------------------------------------------
	  		$x=$this->request->post["product_description"];
			$data="package_name=".$x[1]["name"]."&is_enabled=".(int)$this->request->post['status']."&package_number=".(int)$this->request->post["model"]."&product_numbers=".$list_product_nums;
	 		$method ="POST";
	 		$url=KMS_API."/enablePackage";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
        	$response=json_decode($apiresult);
        	// var_dump($response);exit();
        	$respId="";
        	$error=true;
        	$apimessage="";
        	$errorMsg="KMS Failed! ";
	   		foreach ($response as $key => $value) {
	   			switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$respId=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			if(!$error)
			{
				$this->model_catalog_package->addProduct($this->request->post);
			#---------- ---- Add Product to Package --------------------------------#
				$result=$this->model_catalog_package->getProductIdByName($x[1]["name"]);
	        	$product_id=$result[0]["product_id"];
	      	 	$channel_list="";
	        	$package_id="";       						
	        	if (sizeof($result)) {
	        	 	foreach ($result as $row) {
	        	 		$package_id=$row['product_id'];
	        	 	}
	        	 		        		
	        		$this->model_catalog_package->addApiResponceId($respId,$package_id);
	        	 	//$strings = explode(",",$channel_list);
	        	 	$strings=$this->request->post['destchannels'];
					$channel_list = "'".implode("','",$strings)."'";
	        	 	$url=KMS_API."/addProductToPackage";
	        		$ids=array();
	        		$new_arr="";
	        		foreach ($strings as $value) {
							$new_arr.="'".trim($value)."'".',';
						}
					$str=trim($new_arr, ",");
					$ids=$this->model_catalog_package->getChanneIdlList($channel_list);
	        		$resp_ids=array();
	        		$i=0;
	        	 	foreach ($ids as $channel)
	        	 	{  
	        	 		$data="product_id=".$channel['api_product_id']."&package_id=".$respId;
	        	 		$resp_ids=$obj->callAPI($method,$hdr,$url,$data);
	        	 		$prod_pack_res=json_decode($resp_ids);	
	        	 		$is_error=true;
					    $apimessage=" Kms fail to enable STB";
					    $errorMsg="KMS Failed!";
					    foreach ($prod_pack_res as $key => $value) {
					    	switch ($key) {
			    				case 'error':
			    					$is_error=	$value;
			    					break;
			    				case 'message':
			    					$apimessage=$value;				
			    					break;
			    				case 'id':
			    					$respId1=$value;	
			    					break;
			    				default:
			    					$errorMsg=$errorMsg." ".$key.":".$value;	
			    					break;
			    			}
						}
						if(!$is_error)
						{
							$this->model_catalog_package->addchannelToPackage($strings[$i],$product_id);
							$this->model_catalog_package->addProdToPkgApiResponceId($channel['api_product_id'],$respId,$respId1);
							//var_dump($i."==>".$strings[$i]." =====>>".$product_id);		
							$this->session->data['success'] =$apimessage;	  
						}else{
							$this->session->data['warning'] =$errorMsg; //$this->language->get('text_warning_delete');
							$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'], 'SSL'));	
						}
					$i=$i+1;
	           	 	}
					// -----------------------------------------------------------------------------------
		           	 		 	           	 	
		           	 	$this->WritePackageLog($this->request->post["model"],$list_product_nums);
					// -----------------------------------------------------------------------------------
					$data="target_level=2&package_id=".$respId."&end_time=2524608000";
					$method ="POST";
					$url=KMS_API."/enableMassPackageEntitlement";
					$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					$apiresult = $obj->callAPI($method,$hdr,$url,$data);
					$response=json_decode($apiresult);
					//---------------- added after 2.5.22 build for empty package ie with no channels --------
					//---------------- Success msg will come on empty package creation -----------------------
					if(empty($ids)){
						
						$errorMsg="KMS Failed!";
						foreach ($response as $key => $value) {
						    	switch ($key) {
				    				case 'error':
				    					$is_error=	$value;
				    					break;
				    				case 'message':
				    					$apimessage=$value;				
				    					break;
				    				case 'id':
				    					$respId1=$value;	
				    					break;
				    				default:
				    					$errorMsg=$errorMsg." ".$key.":".$value;	
				    					break;
				    			}
						}
						if(!$is_error)
						{
							$this->session->data['success'] = 'Success: Package added successfully!!';	  
						}else{
							$this->session->data['warning'] =$errorMsg; 
							$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'], 'SSL'));	
						}
					}
					//----------------------------------------------------------------------------------------

	        	}
				$url = '';
				
				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
			
				if (isset($this->request->get['filter_model'])) {
					$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_price'])) {
					$url .= '&filter_price=' . $this->request->get['filter_price'];
				}
				
				if (isset($this->request->get['filter_quantity'])) {
					$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
				}
				
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
						
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}


				$this->load->model('json/feed');
				$this->model_json_feed->CreateChannelFeed();
				//$this->model_json_feed->CreatePackageFeed();
				//$this->model_json_feed->CreatePackChannelFeed();
				$this->WriteMessageLog("SUCCESS:","NA",$this->request->post["model"],"addPkg");
				$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				// $this->session->data['warning'] = $response['message'];//$this->language->get('text_warning_delete');
				$this->WriteMessageLog("ERROR:","NA",$this->request->post["model"],"addPkg");
				$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'], 'SSL'));
			}
    	}
	
    	$this->getForm();
  	}
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the package details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/

  	public function update() {
  		$obj = new restapi();
  		$edit=true;
  		$callMassPkg=0;
    	$this->language->load('catalog/package');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/package');
					
    	// $channels=$this->model_catalog_package->getPrevChannels($this->request->get['product_id']);	
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
    			// var_dump($this->request->post["destchannels"]);exit();
    			// -------------------------------------------------------------------------------------------
    			$pids = $this->model_catalog_package->getProductIDS($this->request->post["destchannels"]);	
    			$product_no = $this->model_catalog_package->getProductNosduringUpdate($pids);
	       	 	$count = 0;
				$list_log = "";
				foreach ($product_no as $key => $value) {
					if ($count==0) {
						$list_log = $value["model"]." - ".$value["name"];
					}else{
						$list_log = $list_log.", ".$value["model"]." - ".$value["name"];
					}
				 	$count++;		 	
				}	 
				// ---------------------------------------------------------------------------------------------

				$this->load->model('catalog/package');
				//Package Enable/Disable 
				$x=$this->request->post["product_description"];
				$api_prod_id=$this->model_catalog_package->getApiResponceId($this->request->get['product_id']);				
				$method ="POST";
				$data="package_name=".$x[1]["name"]."&is_enabled=".(int)$this->request->post['status']."&package_number=".(int)$this->request->post["model"]."&update_id=".$api_prod_id['api_product_id']."&product_numbers=".$list_log;
				$uri=KMS_API."/enablePackage";
				$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				$apiresp=$obj->callAPI($method,$hdr,$uri,$data);
				$response=json_decode($apiresp);
				$error=true;
				$errorMsg="";
				$apimessage="";
				foreach ($response as $key => $value) 
				{
					switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
	    			}
		    	}
		    	if(!$error)
		    	{
		    		$this->model_catalog_package->setPackageStatus((int)$this->request->post['status'],$this->request->get['product_id']);
		    		$this->session->data['success'] = $this->language->get('text_success');
		    	}else{
		    		$edit=false;
	    			$this->session->data['warning'] = $errorMsg;
					$this->redirect($this->url->link('catalog/package/insert', 'token=' . $this->session->data['token'], 'SSL'));
		    	}
				//Product to Package API Calls (Adding/ting)
				$channel_list1= $this->model_catalog_package->getPreChannelList($this->request->get['product_id']);
				$list = explode(',',$channel_list1['channel_list']);	
				
				$deletedlist=array();
				$addedList=array();
				if(sizeof($this->request->post ["destchannels"])>0)
					$deletedlist=$this->getChannelListDiff($list,$this->request->post ["destchannels"],0);
				else {
					$deletedlist=$list;
				}
				$pkg =$this->request->post ["product_description"];
				
				foreach ($deletedlist as $value) {
					$va=trim($value);
					$result=$this->model_catalog_package->getProductIdByName($va,0);
					
					if (sizeof($result)) {
			        	foreach ($result as $row) {
			        	 		$package_id=$row['product_id'];
		        		}
		    	 		$resultp=$this->model_catalog_package->getProductIdByName($pkg[1]["name"]);
		    	  		$resultId=$this->model_catalog_package->getApiResponceId($resultp[0]['product_id']);
						$result1=$this->model_catalog_package->getApiResponceId($package_id);
						$p_id=$result1["api_product_id"];
						
						$data="product_id=".$p_id."&package_id=".$resultId["api_product_id"];
						$method ="POST";
				 		$url=KMS_API."/deleteProductFromPackage";
				 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			        	$apiresult=$obj->callAPI($method,$hdr,$url,$data); 
			        	$response1=json_decode($apiresult); 
			        	$error1=true;
						$flag=true;
						
						foreach ($response as $key => $value) 
						{
							switch ($key) {
			    				case 'error':
			    					$error1=	$value;
			    					break;
			    				default:
			    					$errorMsg=$errorMsg." ".$key.":".$value;	
			    					break;
			    			}
		    			}
			    		if(!$error1)
			    		{
			    			$this->model_catalog_package->deleteProductToPackage($p_id,$resultId["api_product_id"]);
			    			$this->session->data['success'] = $this->language->get('text_success');
			    			$callMassPkg=1;
			    		}else{
			    			$edit=false;
			    			$this->session->data['success']='';
			    			$this->session->data['warning'] = $errorMsg;
			    			$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'], 'SSL'));
			    		}
	           	 	}
        	 	
			 }

			if(sizeof($this->request->post ["destchannels"])!=0)
			{
	        	if(sizeof($list)==0)
					$addedList=$this->request->post ["destchannels"];			
				else {
					$addedList=$this->getChannelListDiff($this->request->post ["destchannels"],$list,1);;
				}
	        	foreach ($addedList as $value) {
				 	$va=trim($value);
				 	$result=$this->model_catalog_package->getProductIdByName($va,0);
				 	 
				 	if (sizeof($result)) {
		        	 	foreach ($result as $row) {
		        	 		$package_id=$row['product_id'];
		        	 	}
	        	 		$resultp=$this->model_catalog_package->getProductIdByName($pkg[1]["name"]);
	        	  		$resultId=$this->model_catalog_package->getApiResponceId($resultp[0]['product_id']);
						$result1=$this->model_catalog_package->getApiResponceId($package_id);
						$data="product_id=".$result1["api_product_id"]."&package_id=".$resultId["api_product_id"];
						$method ="POST";
				 		$url=KMS_API."/addProductToPackage";
				 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        			$apiresult=$obj->callAPI($method,$hdr,$url,$data);
	        			$prod_pack_res=json_decode($apiresult);	
	        	 		$respId1="";
		    	 		$is_error=true;
		    	 		$errorMsg="";
	        	 		foreach ($prod_pack_res as $key => $value) {
	        	 			switch ($key) {
			    				case 'error':
			    					$is_error=	$value;
			    					break;
			    				case 'message':
			    					$apimessage=$value;				
			    					break;
			    				case 'id':
			    					$respId1=$value;	
			    					break;
			    				default:
			    					$errorMsg=$errorMsg." ".$key.":".$value;	
			    					break;
			    			}
			    		}
						if(!$is_error)
						{
							
							$this->model_catalog_package->addProdToPkgApiResponceId($result1["api_product_id"],$resultId["api_product_id"],$respId1);
							$this->session->data['success'] = $this->language->get('text_success');
							$callMassPkg=1;

						}else{
							$edit=false;
							$this->session->data['success']='';
							$this->session->data['warning'] = $errorMsg;
							$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'], 'SSL'));
						}
        	 		}

			 	}

			}
			// ----------------------------------------------------------------------------------
			
       	 	$this->WritePackageLog($this->request->post["model"],$list_log);
			// ----------------------------------------------------------------------------------
			if($edit)
			{
				$this->model_catalog_package->editProduct($this->request->get['product_id'], $this->request->post);
				if($callMassPkg==1){
					$api_prod_id=$this->model_catalog_package->getApiResponceId($this->request->get['product_id']);
					$data="target_level=2&package_id=".$api_prod_id['api_product_id']."&end_time=2524608000";
					$method ="POST";
					$url=KMS_API."/enableMassPackageEntitlement";
					$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					$apiresult = $obj->callAPI($method,$hdr,$url,$data);
					$response=json_decode($apiresult);
				}
			}
		
			$url = '';
			
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
		
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . $this->request->get['filter_price'];
			}
			
			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}	
		
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
					
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->load->model('json/feed');
			//$this->model_json_feed->CreateChannelFeed();
			//$this->model_json_feed->CreatePackageFeed();
			//$this->model_json_feed->CreatePackChannelFeed();
			$this->WriteMessageLog("SUCCESS:","NA",$this->request->post["model"],"modifyPkg");
			$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

    	$this->getForm();
  	}
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected package listed on the page. Admin selects the 
						checkbox against the package in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the package list page after deleting the package file from the list.
*/

  	public function delete() {
  		$obj = new restapi();
    	$this->language->load('catalog/package');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/package');
		$notDeleted="";
		$msg="";
		$flag=false;
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			$error_encounter=0;
			foreach ($this->request->post['selected'] as $product_id) {
				$data = $this->model_catalog_package->getApiResponceId($product_id);
				$method ="POST";
				$data = "package_id=".$data['api_product_id'];	
				$url=KMS_API."/disablePackage";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
	        	$error=true;
				$response=json_decode($apiresult);
				foreach ($response as $key=>$value) 
				{
					if($key=='error')
					{	
						$error=$value;
	  					break;
	  				}
    			}
    			if($error){
    				$error_encounter=1;
    			}else{
    				$flag=true;
    				$this->model_catalog_package->deleteProduct($product_id);
    			}
	  		}	
	  		if($error_encounter)
	  		{
	  			
	  			if($flag)
	  				$this->session->data['warning'] =$this->language->get('text_warning_partial_delete').' ('.$this->language->get('text_warning_delete').')';
		  		else
		  			$this->session->data['warning'] =$this->language->get('text_warning_delete');
		  		$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'], 'SSL'));
	  		}else{
				$url = '';
				$this->session->data['success'] = $this->language->get('text_delete_success');

				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
			
				if (isset($this->request->get['filter_model'])) {
					$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_price'])) {
					$url .= '&filter_price=' . $this->request->get['filter_price'];
				}
				
				if (isset($this->request->get['filter_quantity'])) {
					$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
				}	
			
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
						
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}

				$this->load->model('json/feed');
				$this->model_json_feed->CreateChannelFeed();
				// $this->model_json_feed->CreatePackageFeed();
				// $this->model_json_feed->CreatePackChannelFeed();
				$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}

		}
		if(!isset($this->request->post['selected'])){
			$this->error['warning'] =$this->language->get('Warning: Select the Package(s) for deletion!');
		}else{
			$this->error['warning'] =$this->language->get('text_warning_delete');
		}
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	copy
DESCRIPTION 		-	Loads when the admin wants to copy a package. 
						This function copies all the details of the selected package and 
						gives a notification on success.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the package list page after successfull coping.
*/

  	public function copy() {
    	$this->language->load('catalog/package');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/package');
		
		if (isset($this->request->post['selected']) && $this->validateCopy()) {
			foreach ($this->request->post['selected'] as $product_id) {
				$this->model_catalog_package->copyProduct($product_id);
	  		}

			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';
			
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
		  
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . $this->request->get['filter_price'];
			}
			
			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}	
		
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
					
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

    	$this->getList();
  	}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the packages added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the packages list.
*/
	
  	protected function getList() {	

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if (isset($this->request->get['filter_product_id'])) {
			$filter_product_id = $this->request->get['filter_product_id'];
		} else {
			$filter_product_id = null;
		}

		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = null;
		}
		
		if (isset($this->request->get['filter_price'])) {
			$filter_price = $this->request->get['filter_price'];
		} else {
			$filter_price = null;
		}

		if (isset($this->request->get['filter_quantity'])) {
			$filter_quantity = $this->request->get['filter_quantity'];
		} else {
			$filter_quantity = null;
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pd.name';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
						
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . urlencode(html_entity_decode($this->request->get['filter_product_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}		

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
						
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url, 'SSL'),       		
      		'separator' => ' :: '
   		);
		
		$this->data['insert'] = $this->url->link('catalog/package/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['copy'] = $this->url->link('catalog/package/copy', 'token=' . $this->session->data['token'] . $url, 'SSL');	
		$this->data['delete'] = $this->url->link('catalog/package/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
    	
		$this->data['products'] = array();

		$data = array(
			'filter_name'	  => $filter_name, 
			'filter_product_id'	  => $filter_product_id,
			'filter_model'	  => $filter_model,
			'filter_price'	  => $filter_price,
			'filter_quantity' => $filter_quantity,
			'filter_status'   => $filter_status,
			'sort'            => $sort,
			'order'           => $order,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		$this->load->model('tool/image');
		
		$product_total = $this->model_catalog_package->getTotalProducts($data);
			
		$results = $this->model_catalog_package->getPackages($data);
		// $this->session->data['success']=$results;
		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('catalog/package/update', 'token=' . $this->session->data['token'] . '&product_id=' . $result['product_id'] . $url, 'SSL')
			);
			
			if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.jpg', 40, 40);
			}
	
			$special = false;
			
			$product_specials = $this->model_catalog_package->getProductSpecials($result['product_id']);
			
			foreach ($product_specials  as $product_special) {
				if (($product_special['date_start'] == '0000-00-00' || $product_special['date_start'] < date('Y-m-d')) && ($product_special['date_end'] == '0000-00-00' || $product_special['date_end'] > date('Y-m-d'))) {
					$special = $product_special['price'];
			
					break;
				}					
			}
	
      		$this->data['products'][] = array(
				'product_id' => $result['product_id'],
				'name'       => $result['name'],
				'model'      => $result['model'],
				'price'      => number_format($result['price'],2,'.',''),
				'special'    => $special,
				'image'      => $image,
				'quantity'   => $result['quantity'],
				'status'     => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'ispackage'  => $result['is_package'],
				'channel'    => $result['channel_list'],
				'selected'   => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				'action'     => $action
			);
    	}
		
		$this->data['heading_title'] = $this->language->get('heading_title');		
				
		$this->data['text_enabled'] = $this->language->get('text_enabled');		
		$this->data['text_disabled'] = $this->language->get('text_disabled');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');		
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');		
			
		$this->data['column_image'] = $this->language->get('column_image');		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_product_id'] = $this->language->get('column_product_id');			
		$this->data['column_model'] = $this->language->get('column_model');		
		$this->data['column_price'] = $this->language->get('column_price');		
		$this->data['column_quantity'] = $this->language->get('column_quantity');		
		$this->data['column_status'] = $this->language->get('column_status');		
		$this->data['column_action'] = $this->language->get('column_action');		
				
		$this->data['button_copy'] = $this->language->get('button_copy');		
		$this->data['button_insert'] = $this->language->get('button_insert');		
		$this->data['button_delete'] = $this->language->get('button_delete');		
		$this->data['button_filter'] = $this->language->get('button_filter');
		 
 		$this->data['token'] = $this->session->data['token'];
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} elseif(isset($this->session->data['warning'])){
			$this->data['error_warning'] = $this->session->data['warning'];
			unset($this->session->data['warning']);
		}else {
			$this->data['error_warning'] = '';
		}


		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';


		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . urlencode(html_entity_decode($this->request->get['filter_product_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}
		
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
								
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
					
		$this->data['sort_name'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . '&sort=pd.name' . $url, 'SSL');
		$this->data['sort_product_id'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . '&sort=pd.product_id' . $url, 'SSL');
		$this->data['sort_model'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . '&sort=p.model' . $url, 'SSL');
		$this->data['sort_price'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . '&sort=p.price' . $url, 'SSL');
		$this->data['sort_quantity'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . '&sort=p.quantity' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . '&sort=p.status' . $url, 'SSL');
		$this->data['sort_order'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . '&sort=p.sort_order' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . urlencode(html_entity_decode($this->request->get['filter_product_id'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
		$this->data['filter_name'] = $filter_name;
		$this->data['filter_product_id'] = $filter_product_id;
		$this->data['filter_model'] = $filter_model;
		$this->data['filter_price'] = $filter_price;
		$this->data['filter_quantity'] = $filter_quantity;
		$this->data['filter_status'] = $filter_status;
		
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'catalog/package_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the packages content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the packages form page.
*/


  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 
    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
    	$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_yes'] = $this->language->get('text_yes');
    	$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_plus'] = $this->language->get('text_plus');
		$this->data['text_minus'] = $this->language->get('text_minus');
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		$this->data['text_option'] = $this->language->get('text_option');
		$this->data['text_option_value'] = $this->language->get('text_option_value');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_percent'] = $this->language->get('text_percent');
		$this->data['text_amount'] = $this->language->get('text_amount');

		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_meta_description'] = $this->language->get('entry_meta_description');
		$this->data['entry_meta_keyword'] = $this->language->get('entry_meta_keyword');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_store'] = $this->language->get('entry_store');
		$this->data['entry_keyword'] = $this->language->get('entry_keyword');
    	$this->data['entry_model'] = $this->language->get('entry_model');
		$this->data['entry_sku'] = $this->language->get('entry_sku');
		$this->data['entry_upc'] = $this->language->get('entry_upc');
		$this->data['entry_ean'] = $this->language->get('entry_ean');
		$this->data['entry_jan'] = $this->language->get('entry_jan');
		$this->data['entry_isbn'] = $this->language->get('entry_isbn');
		$this->data['entry_mpn'] = $this->language->get('entry_mpn');
		$this->data['entry_location'] = $this->language->get('entry_location');
		$this->data['entry_minimum'] = $this->language->get('entry_minimum');
		$this->data['entry_manufacturer'] = $this->language->get('entry_manufacturer');
    	$this->data['entry_shipping'] = $this->language->get('entry_shipping');
    	$this->data['entry_date_available'] = $this->language->get('entry_date_available');
    	$this->data['entry_quantity'] = $this->language->get('entry_quantity');
		$this->data['entry_stock_status'] = $this->language->get('entry_stock_status');
    	$this->data['entry_price'] = $this->language->get('entry_price');
		$this->data['entry_tax_class'] = $this->language->get('entry_tax_class');
		$this->data['entry_points'] = $this->language->get('entry_points');
		$this->data['entry_option_points'] = $this->language->get('entry_option_points');
		$this->data['entry_subtract'] = $this->language->get('entry_subtract');
    	$this->data['entry_weight_class'] = $this->language->get('entry_weight_class');
    	$this->data['entry_weight'] = $this->language->get('entry_weight');
		$this->data['entry_dimension'] = $this->language->get('entry_dimension');
		$this->data['entry_length'] = $this->language->get('entry_length');
    	$this->data['entry_image'] = $this->language->get('entry_image');
    	$this->data['entry_download'] = $this->language->get('entry_download');
    	$this->data['entry_category'] = $this->language->get('entry_category');
		$this->data['entry_filter'] = $this->language->get('entry_filter');
		$this->data['entry_related'] = $this->language->get('entry_related');
		$this->data['entry_attribute'] = $this->language->get('entry_attribute');
		$this->data['entry_text'] = $this->language->get('entry_text');
		$this->data['entry_option'] = $this->language->get('entry_option');

		$this->data['entry_option_value'] = $this->language->get('entry_option_value');
		$this->data['entry_required'] = $this->language->get('entry_required');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$this->data['entry_date_start'] = $this->language->get('entry_date_start');
		$this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['entry_priority'] = $this->language->get('entry_priority');
		$this->data['entry_tag'] = $this->language->get('entry_tag');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$this->data['entry_reward'] = $this->language->get('entry_reward');
		$this->data['entry_layout'] = $this->language->get('entry_layout');
				
    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_attribute'] = $this->language->get('button_add_attribute');
		$this->data['button_add_option'] = $this->language->get('button_add_option');
		$this->data['button_add_option_value'] = $this->language->get('button_add_option_value');
		$this->data['button_add_discount'] = $this->language->get('button_add_discount');
		$this->data['button_add_special'] = $this->language->get('button_add_special');
		$this->data['button_add_image'] = $this->language->get('button_add_image');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
    	$this->data['tab_general'] = $this->language->get('tab_general');
    	$this->data['tab_data'] = $this->language->get('tab_data');
		$this->data['tab_attribute'] = $this->language->get('tab_attribute');
		$this->data['tab_option'] = $this->language->get('tab_option');		
		$this->data['tab_discount'] = $this->language->get('tab_discount');
		$this->data['tab_special'] = $this->language->get('tab_special');
    	$this->data['tab_image'] = $this->language->get('tab_image');		
		$this->data['tab_links'] = $this->language->get('tab_links');
		$this->data['tab_reward'] = $this->language->get('tab_reward');
		$this->data['tab_design'] = $this->language->get('tab_design');
		 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['subscription_price'])) {
			$this->data['error_subscription_price'] = $this->error['subscription_price'];
		} else {
			$this->data['error_subscription_price'] = '';
		}
		//-------------
		if (isset($this->error['subscription_option'])) {
			$this->data['error_subscription_option'] = $this->error['subscription_option'];
		} else {
			$this->data['error_subscription_option'] = '';
		}		
		
		//-------------

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = array();
		}

		if (isset($this->error['price'])) {
			$this->data['error_price'] = $this->error['price'];
		} else {
			$this->data['error_price'] = '';
		}

 		if (isset($this->error['meta_description'])) {
			$this->data['error_meta_description'] = $this->error['meta_description'];
		} else {
			$this->data['error_meta_description'] = array();
		}		
   
		if (isset($this->error['option'])) {
			$this->data['error_option'] = $this->error['option'];
		} else {
			$this->data['error_option'] = '';
		}

		if (isset($this->error['category'])) {
			$this->data['error_category'] = $this->error['category'];
		} else {
			$this->data['error_category'] = '';
		}
   		
   		if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = array();
		}	
		
   		if (isset($this->error['model'])) {
			$this->data['error_model'] = $this->error['model'];
		} else {
			$this->data['error_model'] = '';
		}		
     	
		if (isset($this->error['date_available'])) {
			$this->data['error_date_available'] = $this->error['date_available'];
		} else {
			$this->data['error_date_available'] = '';
		}	

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}	
		
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
								
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
									
		if (!isset($this->request->get['product_id'])) {
			$this->data['action'] = $this->url->link('catalog/package/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('catalog/package/update', 'token=' . $this->session->data['token'] . '&product_id=' . $this->request->get['product_id'] . $url, 'SSL');
		}
		
		$this->data['cancel'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['product_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$product_info = $this->model_catalog_package->getProduct($this->request->get['product_id']);
    	}

		$this->data['token'] = $this->session->data['token'];
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['product_description'])) {
			$this->data['product_description'] = $this->request->post['product_description'];
			//------added after build 22---------------------
			foreach ($this->data['product_description'] as $key => $value) {
				$this->data['product_description'][$key]['name'] = preg_replace('!\s+!', ' ', trim($value['name']));
			}
			// --------------------------------------------------
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_description'] = $this->model_catalog_package->getProductDescriptions($this->request->get['product_id']);
		} else {
			$this->data['product_description'] = array();
		}
		
		if (isset($this->request->post['model'])) {
      		$this->data['model'] = $this->request->post['model'];
    	} elseif (!empty($product_info)) {
			$this->data['model'] = $product_info['model'];
		} else {
      		$this->data['model'] = '';
    	}

		// if (isset($this->request->post['sku'])) {
  //     		$this->data['sku'] = $this->request->post['sku'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['sku'] = $product_info['sku'];
		// } else {
  //     		$this->data['sku'] = '';
  //   	}
		
		// if (isset($this->request->post['upc'])) {
  //     		$this->data['upc'] = $this->request->post['upc'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['upc'] = $product_info['upc'];
		// } else {
  //     		$this->data['upc'] = '';
  //   	}
		
		// if (isset($this->request->post['ean'])) {
  //     		$this->data['ean'] = $this->request->post['ean'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['ean'] = $product_info['ean'];
		// } else {
  //     		$this->data['ean'] = '';
  //   	}
		
		// if (isset($this->request->post['jan'])) {
  //     		$this->data['jan'] = $this->request->post['jan'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['jan'] = $product_info['jan'];
		// } else {
  //     		$this->data['jan'] = '';
  //   	}
		
		// if (isset($this->request->post['isbn'])) {
  //     		$this->data['isbn'] = $this->request->post['isbn'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['isbn'] = $product_info['isbn'];
		// } else {
  //     		$this->data['isbn'] = '';
  //   	}
		
		// if (isset($this->request->post['mpn'])) {
  //     		$this->data['mpn'] = $this->request->post['mpn'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['mpn'] = $product_info['mpn'];
		// } else {
  //     		$this->data['mpn'] = '';
  //   	}								
				
		// if (isset($this->request->post['location'])) {
  //     		$this->data['location'] = $this->request->post['location'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['location'] = $product_info['location'];
		// } else {
  //     		$this->data['location'] = '';
  //   	}

		$this->load->model('setting/store');
		
		$this->data['stores'] = $this->model_setting_store->getStores();
		
		if (isset($this->request->post['product_store'])) {
			$this->data['product_store'] = $this->request->post['product_store'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_store'] = $this->model_catalog_package->getProductStores($this->request->get['product_id']);
		} else {
			$this->data['product_store'] = array(0);
		}	
		
		if (isset($this->request->post['keyword'])) {
			$this->data['keyword'] = $this->request->post['keyword'];
		} elseif (!empty($product_info)) {
			$this->data['keyword'] = $product_info['keyword'];
		} else {
			$this->data['keyword'] = '';
		}
		
		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (!empty($product_info)) {
			$this->data['image'] = $product_info['image'];
		} else {
			$this->data['image'] = '';
		}
		
		$this->load->model('tool/image');
		
		if (isset($this->request->post['image']) && file_exists(DIR_IMAGE . $this->request->post['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($product_info) && $product_info['image'] && file_exists(DIR_IMAGE . $product_info['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($product_info['image'], 100, 100);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}
		
  //   	if (isset($this->request->post['shipping'])) {
  //     		$this->data['shipping'] = $this->request->post['shipping'];
  //   	} elseif (!empty($product_info)) {
  //     		$this->data['shipping'] = $product_info['shipping'];
  //   	} else {
		// 	$this->data['shipping'] = 1;
		// }
		
    	if (isset($this->request->post['price'])) {
      		$this->data['price'] = $this->request->post['price'];
    	} elseif (!empty($product_info)) {
			$this->data['price'] = $product_info['price'];
		} else {
      		$this->data['price'] = '';
    	}

    	if (isset($this->request->post['channel_list'])) {
      		$this->data['channel_list'] = $this->request->post['channel_list'];
    	} elseif (!empty($product_info)) {
			$this->data['channel_list'] = $product_info['channel_list'];
		} else {
      		$this->data['channel_list'] = '';
    	}
		
		// $this->load->model('localisation/tax_class');
		
		// $this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();
    	
		// if (isset($this->request->post['tax_class_id'])) {
  //     		$this->data['tax_class_id'] = $this->request->post['tax_class_id'];
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['tax_class_id'] = $product_info['tax_class_id'];
		// } else {
  //     		$this->data['tax_class_id'] = 0;
  //   	}
		      	
		if (isset($this->request->post['date_available'])) {
       		$this->data['date_available'] = $this->request->post['date_available'];
		} elseif (!empty($product_info)) {
			// $this->data['date_available'] = date('Y-m-d', strtotime($product_info['date_available']));
			$this->data['date_available'] = date('Y-m-d', strtotime($product_info['date_available']));
		} else {
			// $this->data['date_available'] = date('Y-m-d', time() - 86400);
			$this->data['date_available'] = date('Y-m-d', time() );
		}
		
		$this->data['quantity'] = 1;

		
		$this->data['minimum'] = 1;
		
		
        

        if (isset($this->request->post['channel'])) {
      		$this->data['channel'] = $this->request->post['channel'];
    	} else {
			$this->data['channel'] = 1;
		}
        
		
		$this->data['subtract'] = 0;
		
		if (isset($this->request->post['sort_order'])) {
      		$this->data['sort_order'] = $this->request->post['sort_order'];
    	} elseif (!empty($product_info)) {
      		$this->data['sort_order'] = $product_info['sort_order'];
    	} else {
			$this->data['sort_order'] = 1;
		}

		// $this->load->model('localisation/stock_status');
		
		// $this->data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();
    	
		// if (isset($this->request->post['stock_status_id'])) {
  //     		$this->data['stock_status_id'] = $this->request->post['stock_status_id'];
  //   	} elseif (!empty($product_info)) {
  //     		$this->data['stock_status_id'] = $product_info['stock_status_id'];
  //   	} else {
		// 	$this->data['stock_status_id'] = $this->config->get('config_stock_status_id');
		// }
				
    	if (isset($this->request->post['status'])) {
      		$this->data['status'] = $this->request->post['status'];
    	} elseif (!empty($product_info)) {
			$this->data['status'] = $product_info['status'];
		} else {
      		$this->data['status'] = 1;
    	}

    	if (isset($this->request->post['weight'])) {
      		$this->data['weight'] = $this->request->post['weight'];
		} elseif (!empty($product_info)) {
			$this->data['weight'] = $product_info['weight'];
    	} else {
      		$this->data['weight'] = '';
    	} 
		
		$this->load->model('localisation/weight_class');
		
		$this->data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();
    	
		if (isset($this->request->post['weight_class_id'])) {
      		$this->data['weight_class_id'] = $this->request->post['weight_class_id'];
    	} elseif (!empty($product_info)) {
      		$this->data['weight_class_id'] = $product_info['weight_class_id'];
		} else {
      		$this->data['weight_class_id'] = $this->config->get('config_weight_class_id');
    	}
		
		if (isset($this->request->post['length'])) {
      		$this->data['length'] = $this->request->post['length'];
    	} elseif (!empty($product_info)) {
			$this->data['length'] = $product_info['length'];
		} else {
      		$this->data['length'] = '';
    	}
		
		if (isset($this->request->post['width'])) {
      		$this->data['width'] = $this->request->post['width'];
		} elseif (!empty($product_info)) {	
			$this->data['width'] = $product_info['width'];
    	} else {
      		$this->data['width'] = '';
    	}
		
		if (isset($this->request->post['height'])) {
      		$this->data['height'] = $this->request->post['height'];
		} elseif (!empty($product_info)) {
			$this->data['height'] = $product_info['height'];
    	} else {
      		$this->data['height'] = '';
    	}

		$this->load->model('localisation/length_class');
		
		$this->data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();
    	
		if (isset($this->request->post['length_class_id'])) {
      		$this->data['length_class_id'] = $this->request->post['length_class_id'];
    	} elseif (!empty($product_info)) {
      		$this->data['length_class_id'] = $product_info['length_class_id'];
    	} else {
      		$this->data['length_class_id'] = $this->config->get('config_length_class_id');
		}

		$this->load->model('catalog/manufacturer');
		
    	if (isset($this->request->post['manufacturer_id'])) {
      		$this->data['manufacturer_id'] = $this->request->post['manufacturer_id'];
		} elseif (!empty($product_info)) {
			$this->data['manufacturer_id'] = $product_info['broadcaster_id'];
		} else {
      		$this->data['manufacturer_id'] = 0;
    	} 		
		
    	if (isset($this->request->post['manufacturer'])) {
      		$this->data['manufacturer'] = $this->request->post['manufacturer'];
		} elseif (!empty($product_info)) {
			$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product_info['broadcaster_id']);
			
			if ($manufacturer_info) {		
				$this->data['manufacturer'] = $manufacturer_info['name'];
			} else {
				$this->data['manufacturer'] = '';
			}	
		} else {
      		$this->data['manufacturer'] = '';
    	} 
		
		// Categories

		$this->load->model('catalog/category');
		
		if (isset($this->request->post['product_category'])) {
			$categories = $this->request->post['product_category'];
		} elseif (isset($this->request->get['product_id'])) {		
			$categories = $this->model_catalog_package->getProductCategories($this->request->get['product_id']);
		} else {
			$categories = array();
		}
	
		$this->data['product_categories'] = array();
		
		foreach ($categories as $category_id) {
			$category_info = $this->model_catalog_category->getCategory($category_id);
			
			if ($category_info) {
				$this->data['product_categories'][] = array(
					'category_id' => $category_info['category_id'],
					'name'        => ($category_info['path'] ? $category_info['path'] . ' &gt; ' : '') . $category_info['name']
				);
			}
		}



		
		// Filters
		$this->load->model('catalog/filter');
		
		if (isset($this->request->post['product_filter'])) {
			$filters = $this->request->post['product_filter'];
		} elseif (isset($this->request->get['product_id'])) {
			$filters = $this->model_catalog_package->getProductFilters($this->request->get['product_id']);
		} else {
			$filters = array();
		}
		
		$this->data['product_filters'] = array();
		
		foreach ($filters as $filter_id) {
			$filter_info = $this->model_catalog_filter->getFilter($filter_id);
			
			if ($filter_info) {
				$this->data['product_filters'][] = array(
					'filter_id' => $filter_info['filter_id'],
					'name'      => $filter_info['group'] . ' &gt; ' . $filter_info['name']
				);
			}
		}		
		
		// Attributes
		$this->load->model('catalog/attribute');
		
		if (isset($this->request->post['product_attribute'])) {
			$product_attributes = $this->request->post['product_attribute'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_attributes = $this->model_catalog_package->getProductAttributes($this->request->get['product_id']);
		} else {
			$product_attributes = array();
		}
		
		$this->data['product_attributes'] = array();
		
		foreach ($product_attributes as $product_attribute) {
			$attribute_info = $this->model_catalog_attribute->getAttribute($product_attribute['attribute_id']);
			
			if ($attribute_info) {
				$this->data['product_attributes'][] = array(
					'attribute_id'                  => $product_attribute['attribute_id'],
					'name'                          => $attribute_info['name'],
					'product_attribute_description' => $product_attribute['product_attribute_description']
				);
			}
		}		
//******************************************



// Channels
$this->data['channels'] = array();

$this->load->model('catalog/package');
$this->load->model('catalog/category');
$genres = $this->model_catalog_category->getAllCategories();
foreach ($genres as $genre) {
$channels = $this->model_catalog_package->getProductsByCategoryId($genre['category_id']);
// var_dump($channels);exit();
	foreach ($channels as $channel) {
      $this->data['channels'][] = array(
      'parent_id' => $genre['category_id'],
      'name'      => $channel['name'],
      'id'        => $channel['product_id'],
);
}
}
//var_dump($this->data['channels']);exit(0);

$data='';
//Packages
$this->data['packages'] = array();

$this->load->model('catalog/package');
$results = $this->model_catalog_package->getPackages($data);

foreach($results as $result)
{
	
	$this->data['packages'][] = array(
          'name' => $result['name'],
          'id'   => $result['product_id'],
		);
}

// Genres
$this->data['genres'] = array();
$this->load->model('catalog/category');
$results = $this->model_catalog_category->getAllCategories();

foreach ($results as $result) {
$this->data['genres'][] = array(
'name' => $result['name'],
'id' => $result['category_id'],
);
}


//channel List

if(isset($this->request->get['product_id'])){
	$this->load->model('catalog/package');
	$channel_list= $this->model_catalog_package->getChannelList($this->request->get['product_id']);

	$list = explode(',',trim($channel_list[0]['channel_list'], ', '));

	$this->data['destchannellist'] = array();
	if(!($list[0]==' ' || $list[0]=='  '))
	{

	foreach ($list as $l)
	{
	$this->data['destchannellist'][] =  array('name' => trim($l));

	}
	
	}

}


//*********************************************

 
		// Options
		$this->load->model('catalog/option');
		
		if (isset($this->request->post['product_option'])) {
			$product_options = $this->request->post['product_option'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_options = $this->model_catalog_package->getProductOptions($this->request->get['product_id']);			
		} else {
			$product_options = array();
		}			
		
		$this->data['product_options'] = array();
			
		foreach ($product_options as $product_option) {
			$option_info = $this->model_catalog_option->getOption($product_option['option_id']);
			
			if ($option_info) {
				if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
					$product_option_value_data = array();
					if(isset($product_option['product_option_value']))
					{
						foreach ($product_option['product_option_value'] as $product_option_value) {

							$product_option_value_data[] = array(
								'product_option_value_id' => $product_option_value['product_option_value_id'],
								'option_value_id'         => $product_option_value['option_value_id'],
								'price'                   => $product_option_value['price'],
								'price_prefix'            => $product_option_value['price_prefix'],
								'points'                  => $product_option_value['points'],
								'points_prefix'           => $product_option_value['points_prefix'],						
							);
						}
					}					
					$this->data['product_options'][] = array(
						'product_option_id'    => $product_option['product_option_id'],
						'product_option_value' => $product_option_value_data,
						'option_id'            => $product_option['option_id'],
						'name'                 => $option_info['name'],
						'type'                 => $option_info['type']
						// 'required'             => $product_option['required']
					);				
				} else {
					$this->data['product_options'][] = array(
						'product_option_id' => $product_option['product_option_id'],
						'option_id'         => $product_option['option_id'],
						'name'              => $option_info['name'],
						'type'              => $option_info['type'],
						'option_value'      => $product_option['option_value']
						// 'required'          => $product_option['required']
					);				
				}
			}
		}
		
		$this->data['option_values'] = array();
		
		foreach ($this->data['product_options'] as $product_option) {
			if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
				if (!isset($this->data['option_values'][$product_option['option_id']])) {
					$this->data['option_values'][$product_option['option_id']] = $this->model_catalog_option->getOptionValues($product_option['option_id']);
				}
			}
		}
		
		$this->load->model('sale/customer_group');
		
		$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
		
		if (isset($this->request->post['product_discount'])) {
			$this->data['product_discounts'] = $this->request->post['product_discount'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_discounts'] = $this->model_catalog_package->getProductDiscounts($this->request->get['product_id']);
		} else {
			$this->data['product_discounts'] = array();
		}

		if (isset($this->request->post['product_special'])) {
			$this->data['product_specials'] = $this->request->post['product_special'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_specials'] = $this->model_catalog_package->getProductSpecials($this->request->get['product_id']);
		} else {
			$this->data['product_specials'] = array();
		}
		
		// Images
		if (isset($this->request->post['product_image'])) {
			$product_images = $this->request->post['product_image'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_images = $this->model_catalog_package->getProductImages($this->request->get['product_id']);
		} else {
			$product_images = array();
		}
		
		$this->data['product_images'] = array();
		
		foreach ($product_images as $product_image) {
			if ($product_image['image'] && file_exists(DIR_IMAGE . $product_image['image'])) {
				$image = $product_image['image'];
			} else {
				$image = 'no_image.jpg';
			}
			
			$this->data['product_images'][] = array(
				'image'      => $image,
				'thumb'      => $this->model_tool_image->resize($image, 100, 100),
				'sort_order' => $product_image['sort_order']
			);
		}

		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);

		// Downloads
		// $this->load->model('catalog/download');
		
		// if (isset($this->request->post['product_download'])) {
		// 	$product_downloads = $this->request->post['product_download'];
		// } elseif (isset($this->request->get['product_id'])) {
		// 	$product_downloads = $this->model_catalog_package->getProductDownloads($this->request->get['product_id']);
		// } else {
		// 	$product_downloads = array();
		// }
			
		// $this->data['product_downloads'] = array();
		
		// foreach ($product_downloads as $download_id) {
		// 	$download_info = $this->model_catalog_download->getDownload($download_id);
			
		// 	if ($download_info) {
		// 		$this->data['product_downloads'][] = array(
		// 			'download_id' => $download_info['download_id'],
		// 			'name'        => $download_info['name']
		// 		);
		// 	}
		// }
		
		if (isset($this->request->post['product_related'])) {
			$products = $this->request->post['product_related'];
		} elseif (isset($this->request->get['product_id'])) {		
			$products = $this->model_catalog_package->getProductRelated($this->request->get['product_id']);
		} else {
			$products = array();
		}
	
		$this->data['product_related'] = array();
		
		foreach ($products as $product_id) {
			$related_info = $this->model_catalog_package->getProduct($product_id);
			
			if ($related_info) {
				$this->data['product_related'][] = array(
					'product_id' => $related_info['product_id'],
					'name'       => $related_info['name']
				);
			}
		}

    	if (isset($this->request->post['points'])) {
      		$this->data['points'] = $this->request->post['points'];
    	} elseif (!empty($product_info)) {
			$this->data['points'] = $product_info['points'];
		} else {
      		$this->data['points'] = '';
    	}
						
		if (isset($this->request->post['product_reward'])) {
			$this->data['product_reward'] = $this->request->post['product_reward'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_reward'] = $this->model_catalog_package->getProductRewards($this->request->get['product_id']);
		} else {
			$this->data['product_reward'] = array();
		}
		
		if (isset($this->request->post['product_layout'])) {
			$this->data['product_layout'] = $this->request->post['product_layout'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_layout'] = $this->model_catalog_package->getProductLayouts($this->request->get['product_id']);
		} else {
			$this->data['product_layout'] = array();
		}

		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();
										
		$this->template = 'catalog/package_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	} 
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the packages details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/

	
  	protected function validateForm() { 
    	if (!$this->user->hasPermission('modify', 'catalog/package')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
$this->load->model('catalog/package');
// var_dump($this->request->post);exit();

		if (!isset($this->request->post['product_category'])) {
			$this->error['category']= $this->language->get('Please Select Category!');
		}

    	foreach ($this->request->post['product_description'] as $language_id => $value) {
    		// ------added after build 22---------------------
    		$value['name'] = preg_replace('!\s+!', ' ', trim($value['name']));
    		//  ---------------------------------------------------
    		$name_store = $value['name'];
      		if ((utf8_strlen($value['name']) < 3) || (utf8_strlen($value['name']) > 64)) {
        		$this->error['name'][$language_id] = $this->language->get('error_name');
      		}
      		elseif(isset($this->request->get['product_id'])){
      			if($this->model_catalog_package->isPkgNameDuplicationFromId($value['name'],$this->request->get['product_id'])){
      				$this->error['name'][$language_id] = $this->language->get('error_name_duplicate');
      			}
      		}
      		elseif($this->model_catalog_package->isPkgNameDuplication(trim($value['name']))){
      			// var_dump("expression");exit();
      			$this->error['name'][$language_id] = $this->language->get('error_name_duplicate');
      		}
      		elseif(preg_match('/[^a-z0-9 _]+/i', trim($value['name']))) {
// preg_match will return true if it finds 
// a character *other than* a-z, 0-9, space and _
// *anywhere* inside the string
				$this->error['name'][$language_id] = 'Special Characters not allowed in package name!';
			}
    	}

///Start
    	//--------To put validation on price of subscription in option tab.
    	if(isset($this->request->post['product_option'])){
    		foreach ($this->request->post['product_option'] as $product_option) {
    			if (isset($product_option['product_option_value']) && count($product_option['product_option_value']) > 0 ) {
						foreach ($product_option['product_option_value'] as $product_option_value) {
							if($product_option_value['price']=='' || !is_numeric($product_option_value['price']))
								$this->error['subscription_price']=$this->language->get('error_price');
						}
				}
    		}
    	}

    	if(!isset($this->request->post['product_option'])){
    		$this->error['option']	="Choose subscription to add options!";
    	}else if(isset($this->request->post['product_option']))
    	{
    		foreach ($this->request->post['product_option'] as $product_option) {
    			if(!isset($product_option['product_option_value'])){
    				$this->error['option']	=$this->language->get('warning_add_option');		
    				break;
    			}
    		}
    	}

///End
    	// ***********************rr**********************************************************************
    
       $unique_option_value = array();
		$count = 0;
		if(isset($this->request->post['product_option'])){
	    	  foreach ($this->request->post['product_option'] as $product_option) {
	    	  	if (isset($product_option['product_option_value']))	{
	    	    	foreach($product_option['product_option_value'] as $product_option_id)	{
	    	    	    $unique_option_value[$count++]  = 	$product_option_id['option_value_id'];
	    	    	}
	    	    }
	    	  }
	    	}
	    	if (count(array_unique(array_diff_assoc($unique_option_value,array_unique($unique_option_value))))>0)
	    	{
           $this->error['subscription_option'] =$this->language->get('warning_duplicate_option'); 
	    	}
    	//-------rr--------
		
    	if ((utf8_strlen($this->request->post['model']) < 3) || (utf8_strlen($this->request->post['model']) > 64)) {
      		$this->error['model'] = $this->language->get('error_packageno');
    	}
    	elseif(isset($this->request->get['product_id'])){
  			if($this->model_catalog_package->isduplicatepackagenoFromId($this->request->post['model'],$this->request->get['product_id'])){
  				$this->error['model'] = $this->language->get('error_package_duplicate');
  			}
  		}
  		elseif($this->model_catalog_package->isduplicatepackageno($this->request->post['model'],$name_store)){
    		$this->error['model'] = $this->language->get('error_package_duplicate');
    	}

    	if (!is_numeric($this->request->post['price']) || $this->request->post['price']=='' ) {
      		$this->error['price'] = $this->language->get('error_price');
    	}

    	////////////////////////////////////////////////////////////////////////////////////////////////
    	if(isset($this->request->post['product_option'])){
	    	foreach ($this->request->post['product_option'] as $product_option) {
	    	  	if (isset($product_option['product_option_value']))	{
	    	  		
    	  			foreach($product_option['product_option_value'] as $product_option_id)	{
    	  				$option_val_name = $this->model_catalog_package->getSubscriptionDurationName($product_option_id["option_value_id"]);	    	  				
    	    	    	if(stristr($option_val_name, '1 day')=='1 day' || stristr($option_val_name, '1day')=='1day'){
    	    	    		$this->error['subscription_option'] = "Warning: Please do not select 1 day subscription value for Package!!"; 
    	    	    	}	    	    	    	
    	    		}
	    	  		
	    	    }
	    	}
    	}    	

    	if(!isset($this->request->post['destchannels'])){
    		$this->error['warning'] = 'Warning: Empty Package, Please add channels!';
    	}
    	////////////////////////////////////////////////////////////////////////////////////////////
		
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
					
    	if (!$this->error) {
			return true;
    	} else {
      		return false;
    	}
  	}

  	
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the packages content when deleted. 
						Checks if the deteled packages is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'catalog/package')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
/*
FUNCTION NAME 		-	validateCopy
DESCRIPTION 		-	Validates the permisssion of modifying the package or not.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/

  	
  	protected function validateCopy() {
    	if (!$this->user->hasPermission('modify', 'catalog/package')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
		
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_model']) || isset($this->request->get['filter_category_id'])) {
			$this->load->model('catalog/package');
			$this->load->model('catalog/option');
			
			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
			}
			
			if (isset($this->request->get['filter_model'])) {
				$filter_model = $this->request->get['filter_model'];
			} else {
				$filter_model = '';
			}
			
			if (isset($this->request->get['limit'])) {
				$limit = $this->request->get['limit'];	
			} else {
				$limit = 20;	
			}			
						
			$data = array(
				'filter_name'  => $filter_name,
				'filter_model' => $filter_model,
				'start'        => 0,
				'limit'        => $limit
			);
			
			$results = $this->model_catalog_package->getPackages($data);
			
			foreach ($results as $result) {
				$option_data = array();
				
				$product_options = $this->model_catalog_package->getProductOptions($result['product_id']);	
				
				foreach ($product_options as $product_option) {
					$option_info = $this->model_catalog_option->getOption($product_option['option_id']);
					
					if ($option_info) {				
						if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
							$option_value_data = array();
							
							foreach ($product_option['product_option_value'] as $product_option_value) {
								$option_value_info = $this->model_catalog_option->getOptionValue($product_option_value['option_value_id']);
						
								if ($option_value_info) {
									$option_value_data[] = array(
										'product_option_value_id' => $product_option_value['product_option_value_id'],
										'option_value_id'         => $product_option_value['option_value_id'],
										'name'                    => $option_value_info['name'],
										'price'                   => (float)$product_option_value['price'] ? $this->currency->format($product_option_value['price'], $this->config->get('config_currency')) : false,
										'price_prefix'            => $product_option_value['price_prefix']
									);
								}
							}
						
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $option_value_data,
								'required'          => $product_option['required']
							);	
						} else {
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $product_option['option_value'],
								'required'          => $product_option['required']
							);				
						}
					}
				}
					
				$json[] = array(
					'product_id' => $result['product_id'],
					'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),	
					'model'      => $result['model'],
					'option'     => $option_data,
					'price'      => $result['price']
				);	
			}
		}

		$this->response->setOutput(json_encode($json));
	}
	private function getProductIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);
		foreach ($res as $value) 
			 {
			 if($value['error']==false)
				return $value;
			 }
			 return;
	}

	private function getChannelListDiff($oldList,$newList,$flag){
		if($flag==0&&sizeof($newList)==0){
			return $oldList;
		}elseif ($flag==1&&sizeof($oldList)==0) {
			return $newList;
		}
		$list=array();
		foreach ($oldList as $value) {
			$item="";
			foreach ($newList as $valuen) {
				$v1=trim($valuen);
				$v2=trim($value);
				if(strcasecmp($v1,$v2)==0){
					$item=$valuen;
				}
				
				}
				if($item==""){
					array_push($list,$value);
					
				}
		}
		return $list;
	}
	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
    }
    public function WritePackageLog($package_no,$product_no_list){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."sms_package_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);    	    	
    	fwrite($log_file, "\n"."PACKAGE NO: ".str_pad($package_no,14," ")."\t\t".$today."\n".$product_no_list);
    	fwrite($log_file, "\n--------------------------------------------------------------------------------------------------------");
        fclose($log_file);
    }
}
?>