<?php    
/*
@File broadcastergroup.php(Controller)
ADMIN broadcastergroup PAGE
    This class manages the broadcastergroup details.
    New broadcastergroup can be inserted and deletion option is also there. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCatalogBroadcastergroup extends Controller { 
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the broadcastergroup option in the dopdown list.
						It get all the manufacuturer list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin broadcastergroup page showing all the broadcastergroup in a list.
*/
  
  	public function index() {
		$this->language->load('catalog/broadcastergroup');
		
		$this->document->setTitle($this->language->get('heading_title'));
		 
		$this->load->model('catalog/broadcastergroup');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert broadcastergroup form page where the admin can give the
						details of the new broadcastergroup.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin broadcastergroup form page.
*/
  
  	public function insert() {
		$this->language->load('catalog/broadcastergroup');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/broadcastergroup');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

			$this->model_catalog_broadcastergroup->addBroadcaster($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	} 
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the broadcastergroup details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
		$this->language->load('catalog/broadcastergroup');
// var_dump($this->request->post);exit();
    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/broadcastergroup');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_broadcastergroup->editBroadcaster($this->request->get['broadcaster_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_edit_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected broadcastergroup listed on the page. Admin selects the 
						checkbox against the broadcastergroup in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the broadcastergroup list page after deleting the selected broadcastergroup from the list.
*/

  	public function delete() {
		$this->language->load('catalog/broadcastergroup');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/broadcastergroup');
			
    	if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $broadcaster_id) {
				$this->model_catalog_broadcastergroup->deleteBroadcaster($broadcaster_id);
			}

			$this->session->data['success'] = $this->language->get('text_delete_success');
			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}else if(!isset($this->request->post['selected'])){
    		$this->session->data['error_warning'] = $this->language->get('error_broadcaster_del');
    		$this->redirect($this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url, 'SSL'));		
    	}
	
    	$this->getList();
  	}  
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the broadcastergroup added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the broadcastergroup list.
*/
    
  	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
				
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('catalog/broadcastergroup/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('catalog/broadcastergroup/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	

		$this->data['broadcasters'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$broadcaster_total = $this->model_catalog_broadcastergroup->getTotalBroadcasters();
	
		$results = $this->model_catalog_broadcastergroup->getBroadcasters($data);
 
    	foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('catalog/broadcastergroup/update', 'token=' . $this->session->data['token'] . '&broadcaster_id=' . $result['broadcaster_id'] . $url, 'SSL')
			);
						
			$count = $this->model_catalog_broadcastergroup->getChannelCount($result['broadcaster_id']);

			$this->data['broadcasters'][] = array(
				'broadcaster_id' => $result['broadcaster_id'],
				'name'            => $result['name'],
				'sort_order'      => ($count ? $count : '0'),
				'selected'        => isset($this->request->post['selected']) && in_array($result['broadcaster_id'], $this->request->post['selected']),
				'action'          => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_sort_order'] = $this->language->get('column_sort_order');
		$this->data['column_action'] = $this->language->get('column_action');		
		
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->session->data['error_warning'])) {
			$this->data['error_warning'] = $this->session->data['error_warning'];
		
			unset($this->session->data['error_warning']);
		}else
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$this->data['sort_name'] = $this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
		$this->data['sort_sort_order'] = $this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . '&sort=sort_order' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $broadcaster_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'catalog/broadcastergroup_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the broadcastergroup content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the broadcastergroup form page.
*/

  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
    	$this->data['text_select'] = $this->language->get('text_select');

    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_default'] = $this->language->get('text_default');
    	$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');			
		$this->data['text_percent'] = $this->language->get('text_percent');
		$this->data['text_amount'] = $this->language->get('text_amount');
		$this->data['entry_channel_name'] = $this->language->get('entry_channel_name');
		$this->data['entry_subscription'] = $this->language->get('entry_subscription');
		$this->data['entry_price'] = $this->language->get('entry_price');
				
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_store'] = $this->language->get('entry_store');
		$this->data['entry_keyword'] = $this->language->get('entry_keyword');
    	$this->data['entry_image'] = $this->language->get('entry_image');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
// 
		$this->data['entry_email'] = $this->language->get('entry_email');
    	$this->data['entry_telephone'] = $this->language->get('entry_telephone');
    	$this->data['entry_fax'] = $this->language->get('entry_fax');
    	$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
    	$this->data['entry_customer_region'] = $this->language->get('entry_customer_region');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_company'] = $this->language->get('entry_company');
		$this->data['entry_company_id'] = $this->language->get('entry_company_id');
		$this->data['entry_tax_id'] = $this->language->get('entry_tax_id');
		$this->data['entry_address_1'] = $this->language->get('entry_address_1');
		$this->data['entry_address_2'] = $this->language->get('entry_address_2');
		$this->data['entry_city'] = $this->language->get('entry_city');
		$this->data['entry_postcode'] = $this->language->get('entry_postcode');
		$this->data['entry_zone'] = $this->language->get('entry_zone');
		$this->data['entry_country'] = $this->language->get('entry_country');
		  // 
    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
    	$this->data['button_remove'] = $this->language->get('button_cancel');
		
		$this->data['tab_general'] = $this->language->get('tab_general');
			  
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = '';
		}
		if (isset($this->error['details'])) {
			$this->data['error_details'] = $this->error['details'];
		} else {
			$this->data['error_details'] = '';
		}
if (isset($this->error['email'])) {
	$this->data['error_email'] = $this->error['email'];
} else {
	$this->data['error_email'] = '';
}

	if (isset($this->error['telephone'])) {
	$this->data['error_telephone'] = $this->error['telephone'];
} else {
	$this->data['error_telephone'] = '';
}


if (isset($this->error['address_city'])) {
	$this->data['error_address_city'] = $this->error['address_city'];
} else {
	$this->data['error_address_city'] = '';
}

if (isset($this->error['address_postcode'])) {
	$this->data['error_address_postcode'] = $this->error['address_postcode'];
} else {
	$this->data['error_address_postcode'] = '';
}

if (isset($this->error['address_country'])) {
	$this->data['error_address_country'] = $this->error['address_country'];
} else {
	$this->data['error_address_country'] = '';
}

if (isset($this->error['address_zone'])) {
	$this->data['error_address_zone'] = $this->error['address_zone'];
} else {
	$this->data['error_address_zone'] = '';
}		    
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		if (!isset($this->request->get['broadcaster_id'])) {
			$this->data['action'] = $this->url->link('catalog/broadcastergroup/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('catalog/broadcastergroup/update', 'token=' . $this->session->data['token'] . '&broadcaster_id=' . $this->request->get['broadcaster_id'] . $url, 'SSL');
		}
		
		$this->data['cancel'] = $this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['broadcaster_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$broadcaster_info = $this->model_catalog_broadcastergroup->getBroadcaster($this->request->get['broadcaster_id']);
    		$broadcaster_details = $this->model_catalog_broadcastergroup->getBroadcasterInfo($this->request->get['broadcaster_id']);
    	}

		$this->data['token'] = $this->session->data['token'];

    	if (isset($this->request->post['name'])) {
      		$this->data['name'] = trim(preg_replace('!\s+!', ' ', $this->request->post['name']),' ');      		
    	} elseif (!empty($broadcaster_info)) {
			$this->data['name'] = $broadcaster_info['name'];
		} else {	
      		$this->data['name'] = '';
    	}
		
		$this->load->model('setting/store');
		
		$this->data['stores'] = $this->model_setting_store->getStores();
		
		if (isset($this->request->post['broadcaster_store'])) {
			$this->data['broadcaster_store'] = $this->request->post['broadcaster_store'];
		} elseif (isset($this->request->get['broadcaster_id'])) {
			$this->data['broadcaster_store'] = $this->model_catalog_broadcastergroup->getBroadcasterStores($this->request->get['broadcaster_id']);
		} else {
			$this->data['broadcaster_store'] = array(0);
		}
		//----------------------------
		if (isset($this->request->post['product_detail'])) {
			$product_info = $this->request->post['product_detail'];
		} 

		elseif (isset($this->request->get['broadcaster_id'])) {
			$product_info = $this->model_catalog_broadcastergroup->getChannel($this->request->get['broadcaster_id']);
			$this->data['is_edit']=0;
		} 
		else {
			$product_info = array();
		}

		
		$this->data['product_details'] = array();
		foreach ($product_info as $product_inf) {
		 	$this->data['product_details'][] = array(
				'name'       		           => trim(preg_replace('!\s+!', ' ', $product_inf['name']),' ')

			);
		}
		$this->data['is_edit']=1;

		 

// ----------
		$this->load->model('localisation/country');
		
		$this->data['countries'] = $this->model_localisation_country->getCountries();
		 	if (isset($this->request->post['email'])) {
      		$this->data['email'] = $this->request->post['email'];
    	} elseif (!empty($broadcaster_details)) { 
			$this->data['email'] = $broadcaster_details['broadcaster_email'];
		} else {
      		$this->data['email'] = '';
    	}

    	if (isset($this->request->post['telephone'])) {
      		$this->data['telephone'] = $this->request->post['telephone'];
    	} elseif (!empty($broadcaster_details)) { 
			$this->data['telephone'] = $broadcaster_details['broadcaster_mobile'];
		} else {
      		$this->data['telephone'] = '';
    	}


    	if (isset($this->request->post['city'])) { 
			$this->data['city'] = $this->request->post['city'];
		}elseif (!empty($broadcaster_details)) { 
			$this->data['city'] = $broadcaster_details['broadcaster_city'];
		} else {
			$this->data['city'] = '';
		}

		if (isset($this->request->post['country_id'])) { 
		$this->load->model('sale/customer');

			$this->data['country_id'] = $this->request->post['country_id'];
			$this->data['zones'] =$this->model_sale_customer->getZoneList($this->request->post['country_id']);
		}elseif (!empty($broadcaster_details)) {
			$this->load->model('sale/customer'); 
			$this->data['country_id'] = $broadcaster_details['country_id'];
			$this->data['zones'] =$this->model_sale_customer->getZoneList($broadcaster_details['country_id']);
		} else {
			$this->load->model('sale/customer');
			$this->data['zones'] =$this->model_sale_customer->getZoneList(99);
			$this->data['country_id'] = 99;
		}

		if (isset($this->request->post['zone_id'])) { 
			$this->data['zone_id'] = $this->request->post['zone_id'];
		}elseif (!empty($broadcaster_details)) { 
			$this->data['zone_id'] = $broadcaster_details['zone_id'];
		} else {
			$this->data['zone_id'] = '';
		}		

		if (isset($this->request->post['postcode'])) { 
			$this->data['postcode'] = $this->request->post['postcode'];
		}elseif (!empty($broadcaster_details)) { 
			$this->data['postcode'] = $broadcaster_details['broadcaster_pin'];
		} else {
			$this->data['postcode'] = '';
		}

		//------------------------------
		if (isset($this->request->post['keyword'])) {
			$this->data['keyword'] = $this->request->post['keyword'];
		} elseif (!empty($broadcaster_info)) {
			$this->data['keyword'] = $broadcaster_info['keyword'];
		} else {
			$this->data['keyword'] = '';
		}

		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (!empty($broadcaster_info)) {
			$this->data['image'] = $broadcaster_info['image'];
		} else {
			$this->data['image'] = '';
		}
		if(isset($this->error['product_details']))
		{
			$this->data['error_product_details']=$this->error['product_details'];
		}else{
			$this->data['error_product_details'] = array();
		}

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && file_exists(DIR_IMAGE . $this->request->post['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($broadcaster_info) && $broadcaster_info['image'] && file_exists(DIR_IMAGE . $broadcaster_info['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($broadcaster_info['image'], 100, 100);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}
		
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		
		if (isset($this->request->post['sort_order'])) {
      		$this->data['sort_order'] = $this->request->post['sort_order'];
    	} elseif (!empty($broadcaster_info)) {
			$this->data['sort_order'] = $broadcaster_info['sort_order'];
		} else {
      		$this->data['sort_order'] = '';
    	}
		
		$this->template = 'catalog/broadcastergroup_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}  
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the broadcastergroup details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	public function isValid($str) {
    	return preg_match('/[^A-Za-z0-9 ]/', $str);
	}
	 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'catalog/broadcastergroup')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

    	$broadcaster_id=isset($this->request->get['broadcaster_id'])?$this->request->get['broadcaster_id']:-1;
    	$isDuplicate = $this->model_catalog_broadcastergroup->checkDuplicateBroadcaster(trim(preg_replace('!\s+!', ' ', $this->request->post['name']),' '),$broadcaster_id);


    	if ( $this->isValid($this->request->post['name'])){
  			$this->error['name'] = $this->language->get('Special Characters not allowed!');
  		}

		if($this->request->post['name']==''){
    		$this->error['name'] = "Broadcaster name is mandatory!";
    	}elseif ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
      		$this->error['name'] = $this->language->get('error_name');
    	}elseif ( preg_match('/^\s/',$this->request->post['name']) ){
			$this->error['name'] = $this->language->get('Space not allowed!');
		}else if ($isDuplicate) {
      		$this->error['name'] = $this->language->get('error_broadcaster_name');
    	}

    	// if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
     //  		$this->error['email'] = $this->language->get('error_email');
    	// }

    	if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
      		$this->error['email'] = $this->language->get('error_email');
    	}
    	    	

    	$broadcaster_info = $this->model_catalog_broadcastergroup->getBroadcasterByEmail($this->request->post['email']);
		
		if (!isset($this->request->get['broadcaster_id'])) {
			if ($broadcaster_info) {
				$this->error['email'] = $this->language->get('Duplicate E-Mail address!');
			}
		} else {
			if ($broadcaster_info && ($this->request->get['broadcaster_id'] != $broadcaster_info['broadcaster_id'])) {
				$this->error['email'] = "Please input valid E-Mail address!";//$this->language->get('error_exists');
			}
		}

    	if ((utf8_strlen($this->request->post['telephone']) < 10) || (utf8_strlen($this->request->post['telephone']) > 10)) {
      			$this->error['telephone'] = $this->language->get('error_telephone');
    	}
    	elseif(!is_numeric($this->request->post['telephone'])){
    			$this->error['telephone'] = $this->language->get('error_telephone_digits');
    	}

    	$broadcaster_tel = $this->model_catalog_broadcastergroup->getBroadcasterByMobile($this->request->post['telephone']);
    	if (!isset($this->request->get['broadcaster_id'])) {
			if ($broadcaster_tel) {
				$this->error['telephone'] = $this->language->get('Duplicate Mobile Number'); 
			}
		} else {
			if ($broadcaster_tel && ($this->request->get['broadcaster_id'] != $broadcaster_tel['broadcaster_id'])) {
				$this->error['telephone'] = "Warning: Duplicate Mobile Number";//$this->language->get('error_exists');
			}
		}

		$phoneNumber = $this->request->post['telephone'];
		
		if(!empty($phoneNumber)){
		    if((int)$phoneNumber < 1000000000 || !preg_match('/^\d{10}$/',$phoneNumber)) {		      
		    	$this->error['telephone'] = "Please input valid Mobile number!!";		      
		    }		   
		}else {
		  $this->error['telephone'] = "Please input valid Mobile number!";
		}

    	if ((utf8_strlen($this->request->post['city']) < 3) || (utf8_strlen($this->request->post['city']) > 64)) {
			$this->error['address_city'] = $this->language->get('error_city');
		}
		if ( $this->isValid($this->request->post['city'])){
  			$this->error['address_city'] = $this->language->get('Special Characters not allowed!');
  		}

		if ( preg_match('/^\s/',$this->request->post['city']) ){
			$this->error['address_city'] = $this->language->get('Space not allowed!');
		} 
		if(is_numeric($this->request->post['city'])){
			$this->error['address_city'] = 'Only Numeric digits not allowed!';
		}

		$this->load->model('localisation/country');
		
		// $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);
				
		// if ($country_info) {
		// 	if ($country_info['postcode_required'] && (utf8_strlen($this->request->post['postcode']) < 6) || (utf8_strlen($this->request->post['postcode']) > 6)) {
		// 		$this->error['address_postcode'] = $this->language->get('error_postcode');
		// 	}
		// }
	
		/*if ((utf8_strlen($this->request->post['postcode']) < 6) || (utf8_strlen($this->request->post['postcode']) > 6)) {
			$this->error['address_postcode'] = $this->language->get('error_address_postcode');
		}*/

		if(!preg_match('/^[1-9][0-9]*$/', $this->request->post['postcode'])){
    		$this->error['address_postcode'] = "Postcode is mandatory!, Accepts only 0-9!";
    	}elseif ((utf8_strlen($this->request->post['postcode']) !=6)) {
      		$this->error['address_postcode'] = "Length should be 6!";
    	}

// =============================================
    	$test_zone_id = $this->model_catalog_broadcastergroup->getZoneId($this->request->post['postcode']);
    	if($test_zone_id!=0 && $test_zone_id!=$this->request->post['zone_id']){
    		$this->error['address_postcode'] = "Same postcode used in different state!";	
    	}
// ==============================================


		if ($this->request->post['country_id'] == '') {
			$this->error['address_country'] = $this->language->get('error_country');
		}
		
		if (!isset($this->request->post['zone_id']) || $this->request->post['zone_id'] == '') {
			$this->error['address_zone'] = $this->language->get('error_zone');
		}
		/**************************Duplicate Product****************************/
	    $dupName = array();
		if(isset($this->request->post['product_detail'])){
			$tempProductName ='';
			$z=0;
			foreach ($this->request->post['product_detail'] as $key => $value) {
				 $tempProductName = trim(preg_replace('!\s+!', ' ', $value['name']),' ');		 
				 if(strlen($tempProductName)<=1){
				 	$this->error['warning'] = 'Warning: Please check form carefully for errors';
				 	$this->error['product_details'][$z] = 'Its a blank channel! please insert name';
				 	// return false;
				 }else{
				 array_push($dupName, $tempProductName);
				}
				$z++;
			} 
			$counts = array_count_values($dupName);
			$i=0;
			foreach ($dupName as $val) {
				$is_product_exist = $this->model_catalog_broadcastergroup->CheckProductDuplication($val);
  				$is_product_existBroadCaster = $this->model_catalog_broadcastergroup->CheckProductDuplicationFromBroadCaster($val,$broadcaster_id); 

				if($counts[$val]>1){ //check same channel name in broadcaster channels and also space
					$this->error['warning'] = 'Warning: Please check form carefully for errors';
					$this->error['product_details'][$i]="Duplicate Product!";
				}
				// else if($is_product_exist){ // check channel name exist in oc_product table
		  //   		$this->error['product_details'][$i]="Duplicate Product!";
		  //   		return false;
		  //   	}
		    	else if($is_product_existBroadCaster!=NULL){ // check channel name exist in oc_broadcaster_channel
		    		$this->error['warning'] = 'Warning: Please check form carefully for errors';
		    		$this->error['product_details'][$i]="Duplicate Product!";
		    		return false;
		    	 }
		    	 else if($this->isValid($val)){
  					$this->error['product_details'][$i] = "Special Characters not allowed!";
  				 } 
				$i++;
			}

			}else{
    			$this->error['details']	="Add the channel!";
    	}
    	//-------
    	$tempProdName=array();
    	if(isset($this->request->post['product_detail'])){
	    	foreach ($this->request->post['product_detail'] as $key => $value) {
				 $tempProdName[] = trim(preg_replace('!\s+!', ' ', $value['name']),' ');
			}
    	}

    	$channel_list=array();
    	$result=array();	
    	if (isset($this->request->get['broadcaster_id'])) {
	    	$channel_list[] = $this->model_catalog_broadcastergroup->getChaneelByBroadcaster($this->request->get['broadcaster_id']);
	    	foreach ($channel_list as $key => $value) {
	    		for ($i=0; $i <sizeof($value) ; $i++) { 
	    			array_push($result,$value[$i]['channel_name']);
	    		}
	    		
	    	}
    	}
    	$temp=array_diff($result,$tempProdName);

    	if (isset($this->request->get['broadcaster_id'])) {
	    	foreach ($temp as  $value) {
	    		$channel_list = $this->model_catalog_broadcastergroup->getChanelFormProduct($value);
	    		if($channel_list)
	    		{
	    		$this->error['warning'] = "Warning: Channel available in channel list!";	
	    		}
	    	}
   		}

    	/**************************Duplicate Product****************************/

		// var_dump($this->request->post["product_detail"]);exit();

		/*if(!isset($this->request->post['product_detail'])){
    		$this->error['details']	="Add the channel!";
    	}
    	else if(isset($this->request->post['product_detail']))
    	{
    		foreach ($this->request->post['product_detail'] as $detail) {
    			// var_dump($detail["name"]=="");exit();
    			if(($detail["name"]=="") ){ //||($detail["subscription"]=="")||($detail["price"]=="")
    			
    				$this->error['details']	= 'Add atleast one channel Details!';   //$this->language->get('warning_add_option');	
    				break;
    			}
    		}

    	}*/

    	if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    

 	// private function CheckDuplication()
  // 	{   
  // 		$dupName = array();
		// foreach ($this->request->post['product_detail'] as $key => $value) {
		// 	 $productName = $value['name'];
		// 	 array_push($dupName, $value['name']);
		// } 
	
  // 		$is_product_exist = $this->model_catalog_broadcastergroup->CheckProductDuplication($productName);
  // 		$is_product_existBroadCaster = $this->model_catalog_broadcastergroup->CheckProductDuplicationFromBroadCaster($productName);
  //   	if(sizeof(array_unique($dupName)) < sizeof($dupName)){ //same channel name in broadcaster channels
  // 				$this->error['warning']="Duplicate Product!";
  //   		return false;
  //   	}
  //   	else if($is_product_exist){ // check channel name exist in oc_product table
  //   		$this->error['warning']="Duplicate Product!";
  //   		return false;
  //   	}
  //   	else if($is_product_existBroadCaster){ // check channel name exist in oc_broadcaster_channel
  //   		$this->error['warning']="Duplicate Product!";
  //   		return false;
  //   	}else{
  //   		return true;
  //   	}
  // 	}

/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the broadcastergroup content when deleted. 
						Checks if the deteled broadcastergroup is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/

  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'catalog/broadcastergroup')) {
			$this->error['warning'] = $this->language->get('error_permission');
    	}	
		
		$this->load->model('catalog/product');

		foreach ($this->request->post['selected'] as $broadcaster_id) {
  			$product_total = $this->model_catalog_product->getTotalProductsByBroadcasterId($broadcaster_id);
    
			if ($product_total) {
	  			$this->error['warning'] = sprintf($this->language->get('error_product'), $product_total);	
			}	
	  	} 
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	}
/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_name'])) {
			$this->load->model('catalog/broadcastergroup');
			
			$data = array(
				'filter_name' => $this->request->get['filter_name'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_catalog_broadcastergroup->getBroadcasters($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'broadcaster_id' => $result['broadcaster_id'], 
					'name'            => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function country() {
		$json = array();
		
		$this->load->model('localisation/country');

    	$country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);
		
		if ($country_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'country_id'        => $country_info['country_id'],
				'name'              => $country_info['name'],
				'iso_code_2'        => $country_info['iso_code_2'],
				'iso_code_3'        => $country_info['iso_code_3'],
				'address_format'    => $country_info['address_format'],
				'postcode_required' => $country_info['postcode_required'],
				'zone'              => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
				'status'            => $country_info['status']		
			);
		}
		
		$this->response->setOutput(json_encode($json));
	}
	
}
?>