<?php 
/*error_reporting(E_ALL);
ini_set("display_errors", 1);*/
 
class ControllerBulkSubsListReport extends Controller { 
	private $error = array();
  /*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the authorized subscriber details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  authorized subscriber page
*/
  	public function index() {
		$this->language->load('bulk/subslistreport');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/subslistreport');
		
    	$this->getList();
  	}

  	/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  
  	public function printPdf(){

	    if(isset($this->request->post['selected']))
	    {
	    	$this->pdf->AddPage('L');
		    $this->pdf->SetFillColor(232,232,232);
		   	$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(28);
			$this->pdf->SetX(10);

			$this->pdf->Cell(275,6,'-: All Subscriber List Report :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    $w = array(10,25,45,90,120,180,205,235,265);
		    $c = array(15,20,45,30,60,25,30,30,20);
		    $this->pdf->SetY(35);
		    $header =  array('#','Customer No','Customer Name','Customer Group','Address','STB No.','Prod/Pkg Id','Operator','STB Status');
			
			for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}		
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
	        $this->load->model('report/customer');
	        $this->load->model('bulk/subslistreport');
		        $results = $this->model_bulk_subslistreport->getCustomersForPrint($this->request->post);
			    foreach($results as $result){
			    	$type=($result['STBNO']?(is_null($result['livestatus'])?'De-Activated':'Activated'):"Unpaired");
			    	$c_height=6;	
			     	$this->pdf->SetX(10);
			    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
			    	$this->pdf->Cell($c[1],6,$result["customerNo"],1,0,'L',0);
			    	$x_axis=$this->pdf->getx();
			    	$this->pdf->vcell($c[2],$c_height,$x_axis,$result["name"],25);
			    	$this->pdf->Cell($c[3],6,$result["customer_group"],1,0,'L',0);
			    	$x_axis=$this->pdf->getx();
			    	$this->pdf->vcell($c[4],$c_height,$x_axis,$result["addr"],30);
			    	$this->pdf->Cell($c[5],6,($result['STBNO']?$result['STBNO']:"N/A"),1,0,'L',0);
			    	$x_axis=$this->pdf->getx();
			    	$this->pdf->vcell($c[6],$c_height,$x_axis,($result['prod_pkg_no']?$result['prod_pkg_no']:"N/A"),15);
			    	$x_axis=$this->pdf->getx();
			    	$this->pdf->vcell($c[7],$c_height,$x_axis,$result["operator"],15);
			    	$this->pdf->Cell($c[8],6,$type,1,0,'L',0);
			    	$this->pdf->Ln();
			 		$count++;
		        }
	        // }
	       	
		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		 
		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/subslistreport');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] ="Please Select item to print PDF";
	       	$this->getList();
		}
    }
   
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the authorized subscribers details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/    
  	protected function getList() {	

  		if (isset($this->request->get['filter_customer_unique_id'])) {
			$filter_customer_unique_id = $this->request->get['filter_customer_unique_id'];
		} else {
			$filter_customer_unique_id = null;
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if (isset($this->request->get['filter_stb'])) {
			$filter_stb = $this->request->get['filter_stb'];
		} else {
			$filter_stb = null;
		}

  		if (isset($this->request->get['filter_customer_group_id'])) {
			$filter_customer_group_id = $this->request->get['filter_customer_group_id'];
		} else {
			$filter_customer_group_id = null;
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}

		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
		} else {
			$filter_operator = null;
		}

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$url = '';
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/subslistreport', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		if (isset($this->request->get['filter_customer_unique_id'])) {
			$url .= '&filter_customer_unique_id=' . $this->request->get['filter_customer_unique_id'];
		}

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_stb'])) {
			$url .= '&filter_stb=' . urlencode(html_entity_decode($this->request->get['filter_stb'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_customer_group_id'])) {
			$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}
	
   		$this->load->model('sale/customer_group');
    	$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
   		
		$this->data['customers'] = array();
		$this->load->model('bulk/subslistreport');
		$data = array(
			'filter_customer_unique_id' => $filter_customer_unique_id,
			'filter_name'              => $filter_name, 
			'filter_stb'               => $filter_stb, 
			'filter_customer_group_id' => $filter_customer_group_id,
			'filter_status' 		   => $filter_status, 
			'filter_operator'          => $filter_operator,
			'start'           		   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           		   => $this->config->get('config_admin_limit')
		);
		$total = $this->model_bulk_subslistreport->getTotalAuthSubs($data);
		$results = $this->model_bulk_subslistreport->getCustomers($data);
		// echo "<pre>"; print_r($results); die;
 		$i=0;
    	foreach ($results as $result) {
    		// if($result['STBNO']=='')
    		// 	$result['STBNO']='NA';
    		$hw = $this->model_bulk_subslistreport->getStbHw($result['STBNO']);
			$i=$i+1;
			$this->data['customers'][] = array(
				'customer_id'    => $result['customer_id'],
				'customer_no'    => $result['customerNo'],//($page - 1) * $this->config->get('config_admin_limit')+$i,
				'custom'         => ($result['STBNO']?$result['STBNO']:"N/A"),
				'telephone'      => $result["telephone"],
				'name'           => $result['name'],
				'operator'       => isset($result['operator'])?$result['operator']:'',
				'prod_pkg_no'	 => ($result['prod_pkg_no']==null)?'N/A':$result['prod_pkg_no'],
				'customer_group' => $result['customer_group'],  
				'address'        => $result['addr'],
				'date_added'     => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'status'         => ($result['STBNO']?(is_null($result['livestatus'])?'De-Activated':'Activated'):"Unpaired"),
				'pay'            => 'paid',
				'balance'        => '-- --',
				'selected'       => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);
		}

		$resultOperators = $this->model_bulk_subslistreport->getOperators();

		foreach ($resultOperators as $operator) {
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}	
					
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');	
		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_default'] = $this->language->get('text_default');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_group'] = $this->language->get('column_group');
		$this->data['column_prod_pkg_no'] = $this->language->get('column_prod_pkg_no');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_status'] = "STB Status";//$this->language->get('column_status');
		$this->data['column_pay'] = $this->language->get('column_pay');
		$this->data['column_balance'] = $this->language->get('column_balance');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['text_active'] = $this->language->get('text_active');
		$this->data['text_not_active'] = $this->language->get('text_not_active');
		$this->data['text_unpaired'] = $this->language->get('text_unpaired');

		$this->data['printPdf'] = $this->url->link('bulk/subslistreport/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$url = '';

		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['filter_customer_unique_id'])) {
			$url .= '&filter_customer_unique_id=' . $this->request->get['filter_customer_unique_id'];
		}

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_stb'])) {
			$url .= '&filter_stb=' . urlencode(html_entity_decode($this->request->get['filter_stb'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_customer_group_id'])) {
			$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/subslistreport', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		$this->data['filter_operator'] = $filter_operator; 
		//---------------------------
		$this->data['filter_customer_group_id'] 	= $filter_customer_group_id;
		$this->data['filter_customer_unique_id'] 	= $filter_customer_unique_id;
		$this->data['filter_name'] 					= $filter_name;
		$this->data['filter_stb'] 					= $filter_stb;
		if (isset($this->request->get['filter_status'])) {
			if($this->request->get['filter_status']==2){
				$this->data['filter_status'] = 2;
			}else{
				$this->data['filter_status'] = $filter_status;
			}
		}


		$this->data['sort_name'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
	    $this->data['sort_stbno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=STBNO' . $url, 'SSL');
		$this->data['sort_casno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=CASNO' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['filter_customer_unique_id'])) {
			$url .= '&filter_customer_unique_id=' . $this->request->get['filter_customer_unique_id'];
		}

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_stb'])) {
			$url .= '&filter_stb=' . urlencode(html_entity_decode($this->request->get['filter_stb'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_customer_group_id'])) {
			$url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}
		
		$this->template = 'bulk/subslistreport.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
}
?>