<?php 
 /*
@File customer.php(Controller)
ADMIN CUSTOMER PAGE
    This class show total authorized subscribers in the store

@Author Ravi Ranjan 
@date 26th Nov. 2015
*/ 
class ControllerBulkSubsListOnnet extends Controller { 
	private $error = array();
  /*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the authorized subscriber details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  authorized subscriber page
*/
  	public function index() {
		$this->language->load('bulk/subslistonnet');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/subslistonnet');
		
    	$this->getList();
  	}

function vcell($c_width,$c_height,$x_axis,$text){
	$w_w=$c_height/4;
	$w_w_1=$w_w+2;
	$w_w1=$w_w+$w_w+3;
	$w_w2=$w_w+$w_w+$w_w+4;
	$w_w3=$w_w+$w_w+$w_w+$w_w+4;
	$w_w4=$w_w+$w_w+$w_w+$w_w+$w_w+5;
	$len=strlen($text);// check the length of the cell and splits the text into 7 character each and saves in a array 
	if($len>22){
		$w_text=str_split($text,22);		
		$this->pdf->SetX($x_axis);
		if(isset($w_text[0])){
			$this->pdf->Cell($c_width,$w_w_1,$w_text[0],'','','');
			$this->pdf->SetX($x_axis);
		}
		if(isset($w_text[1])){
			$this->pdf->Cell($c_width,$w_w1,$w_text[1],'','','');
			$this->pdf->SetX($x_axis);
		}
		if(isset($w_text[2])){
			$this->pdf->Cell($c_width,$w_w2,$w_text[2],'','','');
			$this->pdf->SetX($x_axis);
		}
		if(isset($w_text[3])){
			$this->pdf->Cell($c_width,$w_w3,$w_text[3],'','','');
			$this->pdf->SetX($x_axis);
		}
		if(isset($w_text[4])){
			$this->pdf->Cell($c_width,$w_w4,$w_text[4],'','','');
			$this->pdf->SetX($x_axis);
		}
		$this->pdf->Cell($c_width,$c_height,'','LTRB',0,'L',0);
	}
	else{
	   	 $this->pdf->SetX($x_axis);
	   	 $this->pdf->Cell($c_width,$c_height,$text,'LTRB',0,'L',0);
		}
}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  
  	public function printPdf(){
  		if(isset($this->request->post['selected']))
  		{	
		    $this->pdf->AddPage('P',array(250,250));
		    $this->pdf->SetFillColor(232,232,232);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(10);
			$this->pdf->Cell(225,6,'-: Active Subscriber List On Network :-',1,0,'C',1);
			$this->pdf->SetY(33);
		    $w = array(45,45,45,45,45); 
		    // $header =  array('Sl.No','Customer Name','Mobile','Activation Date','Operator ID.','STB No.','Status');
			// $header =  array('Sl.No','Customer Name','Activation Date','Operator ID.','STB No.','Status');
			$header =  array('Sl.No','Customer Name','STB No.','Activation Date','Operator ID.');
		    for($i = 0; $i < count($header); $i++) {
				$this->pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C');
			}
			$this->pdf->Ln();
	    	$this->pdf->SetFont('times','',7);
			
	        $this->load->model('bulk/subslistonnet');
		   	$i=0;
	        $count=0;
		    if (isset($this->request->post['selected']))
			{
		      foreach ($this->request->post['selected'] as $customer) {
		      	$customer_id=substr($customer,0,strpos($customer,'~'));
		      	$sl_no=substr($customer,strpos($customer,'~')+1);
		        $results = $this->model_bulk_subslistonnet->getCustomerpdf($customer_id);
			    foreach($results as $result){
			    	$i=$i+1;
			    	$date=date('d-m-Y H:i',strtotime($result['active_date']));
					// $data[] = array($sl_no,$result['name'],$date,$result['operator_id'],$result['STBNO'],($result['STBNO']?'Active':'DeActive'));
					$data[] = array($sl_no,$result['name'],$result['STBNO'],$date,$result['operator_id']);
			     $count++;
		        }
	         }
	       }

		    $column_width = $w[1];
	        for ($i=0; $i < $count ; $i++) {
			
				 if($data[$i][1]=="")
			 	       	$total_string_width=55;
			 	    else
			 	       $total_string_width = $this->pdf->GetStringWidth($data[$i][1]);
			 	       $number_of_lines = ceil( $total_string_width / ($column_width) );
			 	       $line_height = 6;
			 	       $yH = ceil( $number_of_lines * $line_height ); 
			 	     
			 	  for($j=0; $j < count($header) ; $j++){ 
			 	     $x_axis=$this->pdf->getx();
					 $c_width=45;// cell width 
					 $c_height=8;// cell height
					
					 $this->vcell($c_width,$c_height,$x_axis,$data[$i][$j]);
			 	  }
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		 
		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/subslistonnet');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the authorized subscribers details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/    
  	protected function getList() {	

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/subslistonnet', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		
		$this->data['customers'] = array();
		$this->load->model('bulk/subslistonnet');
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_bulk_subslistonnet->getTotalAuthSubs();
		$results = $this->model_bulk_subslistonnet->getCustomers($data);
 		// var_dump($results);exit();
 		$i=0;
    	foreach ($results as $result) {
    		// $hw = $this->model_bulk_subslistonnet->getStbHw($result['STBNO']);
			$i=$i+1;
			$this->data['customers'][] = array(
				'customer_id'    => $result['customer_id'],
				'customer_no'    =>($page - 1) * $this->config->get('config_admin_limit')+$i,
				'custom'	     => $result['SCNO'],
				'telephone'      => $result["telephone"],
				'name'           => $result['name'],
				'operator_id'    => $result['operator_id'],
				// 'address'        => $result['address_1'],
				'date_added'     => date('d-m-Y H:i',strtotime($result['active_date'])),
				'STBNO'          => $result['STBNO'],
				'status'         => ($result['STBNO']?'Active':'DeActive'),
				'pay'        	 => ' Paid ',
				'balance'        => ' -- -- ',
				'selected'       => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);
		}	
					
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_cas'] = $this->language->get('column_cas');
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');	
		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_default'] = $this->language->get('text_default');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_caf'] = $this->language->get('column_caf');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_operator_id'] = $this->language->get('column_operator_id');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_pay'] = $this->language->get('column_pay');
		$this->data['column_balance'] = $this->language->get('column_balance');
		$this->data['printPdf'] = $this->url->link('bulk/subslistonnet/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/subslistonnet', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
		
		$this->data['sort_name'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
	    $this->data['sort_stbno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=STBNO' . $url, 'SSL');
		$this->data['sort_casno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=CASNO' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';
		
		$this->template = 'bulk/subslistonnet.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
}
?>