<?php


  /**
  * Author Shiril Tripathi
  * 16-Jan-2019
  */
  class ControllerBulkStbBulkUnpair extends Controller
  {
     private $error = array();
	   private $status_array = array();

  /*
   FUNCTION NAME 	-	index
   DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
   INPUT PARAMETER 	-	void
   OUTPUT PARAMETER - 	Rendering of the customer page showing all the customer in a list.
  */  

     public function index(){

     	$this->language->load('bulk/stbBulkUnpair');

     	$this->document->setTitle($this->language->get('heading_title'));

      $this->load->model('bulk/stbBulkUnpair');
     	$this->getUploadForm();

     }


//============================ Export Sample Stb bulk file==============================================//

     public function exportFormat(){
       
       $results = array("STBBD100000005,(Note:- Add 1 To 500 STBNO Serialwise..!)");
       if ($results) {
         header('Content-Type: text/csv; charset=utf-8');
         header('Content-Disposition: attachment; filename=StbBulkUnparingSampleFormat.csv');
         $output= fopen('php://output','w');ob_clean();
         fputcsv($output, array("STBNO"));
         fputcsv($output, $results);
       }
     }

//============================ Upload Stb bulk file==============================================//

     public function stb_bulk_unpair(){
       $obj = new restapi();
       $this->language->load('bulk/stbBulkUnpair');
       $this->document->setTitle($this->language->get('heading_title'));
       $this->load->model('bulk/stbBulkUnpair');
       if (($this->request->server['REQUEST_METHOD'] == 'POST')  &&  $this->validate_csvfile()) {
          $filename = $_FILES['filename']['name'];
          $file     = $_FILES['filename']['tmp_name'];
          $tempname = $_FILES['filename']['tmp_name'] ."/". $filename;
          if(is_uploaded_file($file)){
            $ext = pathinfo($tempname,PATHINFO_EXTENSION);
            if(isset($filename) && $ext=='csv') {
              $rows = array_map('str_getcsv', file($file));
              $row_index=0;
              foreach ($rows as $row){
                if($row_index==0){
                  $row_index=1;
                  continue;
                }
              $unpair_stb_data[] = array(
                   'STBNO'=> $row[0]
                  );
              }
              // csv to xml
              $xml_obj             = new ArrayToXML();         
              $GeneralRootNodeName = "unpair_stb";   
              $general_st          = "<stb_data/>";      
              $csv_xml_data        = $xml_obj->toXml($unpair_stb_data, $GeneralRootNodeName, $general_st);
               // print_r (htmlentities($csv_xml_data));die;
              // Enable user error handling
              libxml_use_internal_errors(true); 
              $xml = new DOMDocument();
              $xml->loadXML($csv_xml_data);
              if (!$xml->schemaValidate('../system/library/stb_unpair.xsd')) {
                $warnings =  $this->libxml_display_errors();
                $error_data= array();
                if (isset($warnings)) {
                  foreach ($warnings as $key => $value) {
                    $line = ++$key . " : " .$value."\n";
                    array_push($error_data, $line);
                    file_put_contents(DIR_ADMIN_LOGS.'Bulk_UnpairStb_LogList/'."error_logs.txt",$error_data);
                  }
                  $this->error['warning'] = "Errors";
                }
              }
              else
              {
               $json_stb=json_encode($unpair_stb_data,JSON_FORCE_OBJECT);
               $data="stb_list=".$json_stb;
               $method ="POST";
               $url=KMS_API."/unpairBulkUser";
               $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
               $apiresult=$obj->callAPI($method,$hdr,$url,$data);
               $response=json_decode($apiresult,true);
               // print_r($json_stb);die;
               $error=true;
               $apimessage="";
               $errorMsg='';
                // Api response to xml
               $xml_obj       = new ArrayToXML();         
               $GeneralRootNodeName = "unpair_stb";   
               $general_st       = "<stb_data/>";      
               $kms_xml         = $xml_obj->toXml($response, $GeneralRootNodeName, $general_st);

                  // print_r (htmlentities($kms_xml));die;
               $unpair = $this->model_bulk_stbBulkUnpair->unpairstbProcedure($csv_xml_data,$kms_xml);
               $this->session->data['success'] = "Success:Please check details in logs given below!!";
              
              }
            }
          }
       }
       $this-> getUploadForm();
     }

//====================== Error Hanlding for XML file====================================
    public function libxml_display_errors(){
      $value= array();
      $errors = libxml_get_errors();
      foreach ($errors as $error) { 
        $value[]= $this->libxml_display_error($error); 
      } 
      libxml_clear_errors();
      return $value;  
    }

    public  function libxml_display_error($error) 
    { 
      $return = ""; 
      switch ($error->level) { 
        case LIBXML_ERR_WARNING: 
        $return .= "<b>Warning $error->code</b>: "; 
        break; 
        case LIBXML_ERR_ERROR: 
        $return .= "<b>Error $error->code</b>: "; 
        break; 
        case LIBXML_ERR_FATAL: 
        $return .= "<b>Fatal Error $error->code</b>: "; 
        break; 
      } 
      $return .= trim($error->message); 
      if ($error->file) { 
        //$return .= " in <b>$error->file</b>"; 
      } 
      $return .= " on line <b>$error->line</b>\n"; 
      return $return;
    } 
//============================ Error File Download===================================================//

    public function error_File(){
     $file_name = 'error_logs.txt';
     $file_url = DIR_ADMIN_LOGS.'Bulk_UnpairStb_LogList/'. $file_name;
     header('Content-Type: text/csv; charset=utf-8');
     header('Content-Type: application/octet-stream');
     header("Content-Transfer-Encoding: Binary");
     header('Content-Disposition: attachment; filename= error_logs.txt');ob_clean();
     readfile($file_url);
     exit;
   }
//============================ Get UI For Stb bulk file==============================================//

     protected function getUploadForm(){
      
       $this->language->load('bulk/stbBulkUnpair');
       $this->data['heading_title'] = $this->language->get('heading_title');
       $this->data['text_none'] = $this->language->get('text_none');
       $this->data['text_wait'] = $this->language->get('text_wait');
	     $this->data['text_no_results'] = $this->language->get('text_no_results');
	     $this->data['button_save'] = $this->language->get('button_save');
       $this->data['button_cancel'] = $this->language->get('button_cancel');
	     $this->data['token'] = $this->session->data['token'];
       $total="";
       $url="";

       if (isset($this->request->get['page'])) {
        $page = $this->request->get['page'];
       }else {
        $page = 1;
       }
       
       if (isset($this->request->get['filter_date_added'])) {
         $filter_date_added = $this->request->get['filter_date_added'];
       }else{
          $filter_date_added = null;
       }
        $this->data['filter_date_added']= $filter_date_added;

        if (isset($this->request->get['filter_date_added'])) {
          $url.=  '&filter_date_added='.$this->request->get['filter_date_added'];
        }

       $this->data['breadcrumbs'] = array(); 
       $this->data['breadcrumbs'][] =array(
	       	'text'      => $this->language->get('text_home'),
	       	'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
	       	'separator' => false
       	);
       

       if (isset($this->request->get['filter_date_added'])) {
       $this->data['breadcrumbs'][] = array(
          'text'      => $this->language->get('heading_title'),
	       	'href'      => $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token'], 'SSL'),
	       	'separator' => '::'
          );
          $this->data['breadcrumbs'][] = array(
          'text'      => $this->language->get('heading_filter'),
          'href'      => $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token']. $url, 'SSL'),
          'separator' => '::'
            );
       }else{
           $this->data['breadcrumbs'][] = array(
           'text'      => $this->language->get('heading_title'),
          'href'      => $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token']. $url, 'SSL'),
          'separator' => '::'
            );

       }

       $data = array(
        'filter_date_added'      => $filter_date_added,
        'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
        'limit'                  => $this->config->get('config_admin_limit')
        );
       
        $this->data['bulk_unpairstblog_list'] = array();
        $total = $this->model_bulk_stbBulkUnpair->getTotal($data);
        $results = $this->model_bulk_stbBulkUnpair->getBulkUnpairStbLoglist($data);
        if($results){
            foreach ($results as $result) {
             $this->data['bulk_unpairstblog_list'][] = array(
                    'name'         => $result['batchno'],
                    'date'         => $result['date_added'],
                    'download_url' =>  $this->url->link('bulk/stbBulkUnpair/batchwise_unpairstb_details', 'token=' . $this->session->data['token'] . '&batchno=' . $result['batchno'], 'SSL')
              );
          }
        }
        
        $this->data['stb_bulk_unpair'] = $this->url->link('bulk/stbBulkUnpair/stb_bulk_unpair', 'token='.$this->session->data['token']. $url, 'SSL');  	
         
       //===============================Error Handling=====================//

      if (isset($this->error['warning'])) {
         $this->data['error_warning'] = $this->error['warning'];
       } else {
         $this->data['error_warning'] = '';
       } 

       if (isset($this->session->data['success'])) {
         $this->data['success'] = $this->session->data['success'];
         unset($this->session->data['success']);
       } else {
         $this->data['success'] = '';
       }

       if (isset($this->error['error_log'])) {
         $this->data['error_log'] = $this->error['error_log'];
       } else {
         $this->data['error_log'] = '';
       } 

       // $this->data['cancel'] = $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token'] . $url, 'SSL');	
       // $url="";
       if (isset($this->request->get['filter_date_added'])) {
          $url.=  '&filter_date_added='.$this->request->get['filter_date_added'];
       }
       $pagination = new Pagination();
       $pagination->total = $total;
       $pagination->page = $page;
       $pagination->limit = $this->config->get('config_admin_limit');
       $pagination->text = $this->language->get('text_pagination');
       $pagination->url = $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
       $this->data['pagination'] = $pagination->render();
       $this->template = 'bulk/stbBulkUnpair.tpl';
       $this->children = array(
         'common/header',
         'common/footer'
         ); 
       $this->response->setOutput($this->render());
     }



//============================ Check file Validations==============================================//
     public function validate_csvfile(){

       if(!file_exists($_FILES['filename']['tmp_name']) || !is_uploaded_file($_FILES['filename']['tmp_name'])) {
         $this->error['warning']  = "Warning: Please select .csv file .!!";
         return false;
       }elseif(!empty($_FILES['filename']['tmp_name']) && pathinfo($_FILES['filename']['name'], PATHINFO_EXTENSION)!='csv') {
         $this->error['warning']  = "Warning: Please select .csv file .!!";
         return false;
      }elseif(count(file($_FILES['filename']['tmp_name'], FILE_SKIP_EMPTY_LINES)) > 1000){
           $this->error['warning']  = "Warning: File length is greater than 1000 lines!";
         return false;
      }
       else{
         $handle = fopen($_FILES['filename']['tmp_name'], "r");
         $data = fgetcsv($handle, 1000,",");
         if ((($data = fgetcsv($handle, 1000,",")) !== FALSE  &&  (count($data) >1 || count($data) <1) ) && ($data[0]!="STBNO") ) {
          $this->error['warning'] = "Warning: Invalid file(File columns is greater than or smaller than 1)";
          return false;
        }
        fclose($handle);
      }
      return true;

    }


//===================================batchwise_unpairstb_details error log=============================

/*
FUNCTION NAME     - batchwise_unpairstb_details
DESCRIPTION       - show the log details of batchwise_unpairstb_details 
INPUT PARAMETER   - void
OUTPUT PARAMETER  -   Returns true if no error else returns false.
*/  
   
   public function batchwise_unpairstb_details()
   {
     $this->language->load('bulk/stbBulkUnpair');
     
     $this->document->setTitle($this->language->get('heading_title'));

     $this->load->model('bulk/stbBulkUnpair');
     $this->data['button_cancel'] = $this->language->get('button_cancel');
     $this->data['heading_title'] = $this->language->get('heading_title');
     $this->data['button_filter'] = $this->language->get('button_filter');
     $this->data['token'] = $this->session->data['token'];
     $this->data['batchno'] = $this->request->get['batchno'];
     $this->data['text_bulk_success'] = $this->language->get('text_bulk_success');
     $this->data['text_fail'] = $this->language->get('text_fail');
     $total="";
     if (isset($this->request->get['page'])) {
      $page = $this->request->get['page'];
    } else {
      $page = 1;
    }
    $url="";

    
    if (isset($this->request->get['batchno'])) {
     $batchno= $this->request->get['batchno'];
    }else{
     $batchno= null;
    }


    if (isset($this->request->get['filter_status'])) {
     $filter_status= $this->request->get['filter_status'];
    }else{
     $filter_status= null;
    }

    if (isset($this->request->get['filter_value'])) {
    
     $filter_value= $this->request->get['filter_value'];
    }else{
    $filter_value= null;
    }
    

    if (isset($this->request->get['filter_status'])) {
      $url .= '&filter_status=' . $this->request->get['filter_status'];
    }
    if (isset($this->request->get['filter_value'])) {
      $url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
    }
    if (isset($this->request->get['batchno'])) {
      $url .= '&batchno=' . urlencode(html_entity_decode($this->request->get['batchno'], ENT_QUOTES, 'UTF-8'));
    }

    $this->data['breadcrumbs'] = array();
    $this->data['breadcrumbs'][] = array(
      'text'      => $this->language->get('text_home'),
      'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      'separator' => false
      ); 
    if (isset($this->request->get['filter_status']) || isset($this->request->get['filter_value'])) {
      $this->data['breadcrumbs'][] = array(
        'text'      => $this->language->get('heading_title'),
        'href'      => $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token'], 'SSL'),
        'separator' => '::'
        );


      $this->data['breadcrumbs'][] = array(
        'text'    => $this->language->get('heading_filter'),
        'href'      => $this->url->link('bulk/stbBulkUnpair/batchwise_unpairstb_details', 'token=' . $this->session->data['token'] . $url, 'SSL'),
        'separator' => ' :: ' 
        );
    }else{
       $this->data['breadcrumbs'][] = array(
        'text'    => $this->language->get('heading_title'),
        'href'      => $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token'] . $url, 'SSL'),
        'separator' => ' :: ' 
        );

     }
    
     $this->data['filter_value']  = $filter_value;
     $this->data['filter_status'] = $filter_status;
     $this->data['batchno']       = $batchno;

    $data = array(
      'filter_value'           => $filter_value,
      'filter_status'          => $filter_status,
      'batchno'                => $batchno,
      'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
      'limit'                  => $this->config->get('config_admin_limit')
    );
    
    $this->data['bulk_unpairstblogdetails_list'] = array();
    $total = $this->model_bulk_stbBulkUnpair->getTotalBatchStblogList($data);
    $results = $this->model_bulk_stbBulkUnpair->getBulkUnpairStbNoLoglist($data);
    if ($results) {
      foreach ($results as  $result) {
       $this->data['bulk_unpairstblogdetails_list'][] = array(

         'stbno'   => $result['stbno'],
         'errorid' => $result['errorid'] == 0 ? "SUCCESS" : "FAIL" ,
         'status'  => $result['status']
         );
     }
   }
    
    
    $this->data['cancel'] = $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token'] . $url, 'SSL');
     $url="";
     if (isset($this->request->get['filter_status'])) {
      $url .= '&filter_status=' . $this->request->get['filter_status'];
    }
    
    if (isset($this->request->get['filter_value'])) {
      $url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
    }
    if (isset($this->request->get['batchno'])) {
      $url .= '&batchno=' . urlencode(html_entity_decode($this->request->get['batchno'], ENT_QUOTES, 'UTF-8'));
    }

    $pagination = new Pagination();
    $pagination->total = $total;
    $pagination->page = $page;
    $pagination->limit = $this->config->get('config_admin_limit');
    $pagination->text = $this->language->get('text_pagination');
    $pagination->url = $this->url->link('bulk/stbBulkUnpair/batchwise_unpairstb_details', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
      
    $this->data['pagination'] = $pagination->render();
    $this->template = 'bulk/batchwise_unpairstb_details.tpl';
    $this->children = array(
      'common/header',
      'common/footer'
      );

    $this->response->setOutput($this->render());
 
   }
}



?>