<?php    

class ControllerBulkStbBulkSubscriptionResend extends Controller { 
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer page showing all the customer in a list.
*/  
  	public function index() {
		$this->language->load('bulk/stbBulkSubscriptionResend');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/stbBulkSubscriptionResend');

		$this->getUploadForm();
		
	}

	public function exportFormat(){
		/*********************** Export STB Inventory CSV Format *****************************/
		$results = array('SDA40000000001,'.'1,', 'SDA40000000002,'.'2,', 'SDA40000000003,'.'3,',
						 'SDA40000000004,'.'4,', 'SDA40000000005,'.'5');
		if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=stbBulkSubscriptionResendSampleFormat.csv');
			$output = fopen('php://output', 'w'); ob_clean();
			fputcsv($output, array('STB NO', 'Product/Package Id'));
			foreach ( $results as $line ) {
				$val = explode(",", $line);
				fputcsv($output, $val);
			}
		}
	}

	public function stb_bulk_subscription_resend(){ 
    	
		$obj = new restapi();
		$log_separator = "-------------------------------------\n";
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('d-m-Y H:i:s');	
		$this->language->load('bulk/stbBulkSubscriptionResend');
    	$this->load->model('bulk/stbBulkSubscriptionResend');  		
    	$this->document->setTitle($this->language->get('heading_title'));
	
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {
			if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
			    $handle = fopen($_FILES['filename']['tmp_name'], "r");
				file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);
			    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
			    	file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",$log_separator, FILE_APPEND);	
			    	if($data[0] != NULL && (sizeof($data)==2) || sizeof($data)==3) {
				    	if($data[0]!= 'STB NO' && $data[1]!='Product/Package Id'){
				    		$status = $this->model_bulk_stbBulkSubscriptionResend->validateSTB(trim($data[0]));	
				    		$is_box_blacklist = $this->model_bulk_stbBulkSubscriptionResend->isBlacklist(trim($data[0]));
				    		$product_status = $this->model_bulk_stbBulkSubscriptionResend->validateProductID(trim($data[1]));
				    		$is_nvod = $this->model_bulk_stbBulkSubscriptionResend->validateNvod(trim($data[1]));
				    		$is_RMA = $this->user->isStbRMA(trim($data[0]));
					 		$lcoId  = $this->user->getOperatorIdFromStbno(trim($data[0]));
					 		$is_suspend = $this->user->isStbSuspend(trim($data[0]));
					 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);	

				    		if($is_box_blacklist==0 && $status && !$is_nvod && $product_status && $is_RMA==0 && $is_suspend==0 && $is_lco_suspend==0){
				    			$custstatus = $this->model_bulk_stbBulkSubscriptionResend->isCustomerEnabled(trim($data[0]));
				    			$product_no = $this->model_bulk_stbBulkSubscriptionResend->getPNo(trim($data[1]));
				    			$product_id = trim($data[1]);
				    			$isPkg = $this->model_bulk_stbBulkSubscriptionResend->isPackage(trim($data[1]));
				    			$sms_casop_id = '';
				    			$sms_customer_id = '';
				    			$result = false;
				    			if($custstatus==1){
				    				$sms_customer_id = $this->model_bulk_stbBulkSubscriptionResend->getCustomerId(trim($data[0]));
				    				$subs_state = $this->model_bulk_stbBulkSubscriptionResend->isSubscriptionAvail($product_id,$sms_customer_id,$isPkg);
				    				if($subs_state==1){
				    					$sms_customer_id = $this->model_bulk_stbBulkSubscriptionResend->getCustomerId(trim($data[0]));
					    				$sms_casop_id = $this->model_bulk_stbBulkSubscriptionResend->getCasopId($sms_customer_id,$product_id,$isPkg);
				    					$result = $this->model_bulk_stbBulkSubscriptionResend->canResend($sms_casop_id);
				    				}
				    			} else {
				    				$subs_state = 0 ;
				    			}
					    		if($custstatus==1 && $subs_state==1 && $result){
					    			$transaction_details = $this->model_bulk_stbBulkSubscriptionResend->getTransactionDetails($sms_casop_id);
					    			$end_time 			 = $transaction_details["exp_date"];
	     							$product_id 		 = $transaction_details["product_id"];
					    			$operator_id 		 = isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
					    			$customer_id 		 = $transaction_details['user_id'];
	    							$user_id 			 = $transaction_details['api_user_id'];
					    			$target_lvl 		 = 1;
						    		$trans_id 			 = $transaction_details['tx_id'];
						    		$cmd_id  			 = $transaction_details['cmd_id'];
					    			$data_kms			 = "transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl."&product_no=".$product_no;
								  	$method 	= "POST";
									$uri 		= KMS_API."/Resend";
									$hdr 		= array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
									$apiresult  = $obj->callAPI($method,$hdr,$uri,$data_kms);	    
								    $response   = json_decode($apiresult);			
								    $error 		= true;
								    $errorMsg 	= '';
								    $apimessage = "";

								    foreach ($response as $key => $value) {
								    	switch ($key) {
								    		case 'error':
								    			$error=$value;	
								    		break;
								    		case 'id':
								    			$id=$value;	
								    		break;
								    		case 'message':
								    			$apimessage=$value;	
								    		break;
								    		case 'mq_response':
								    			$curlresponse=$value;	
								    		break;
								    		default:
								    			$errorMsg=$errorMsg." ".$key.":".$value;		
								    		break;
								    	}
									}
									$ack_is=-1;$nack_is=-1;

									if(!$error)	{
										$log_target_level = "Individual";
										$log_target = $data[0];
										$resend_status = 1;
										$commandid = $cmd_id;
										$getPkgName = $this->model_bulk_stbBulkSubscriptionResend->getProductsName($product_id);
										$log_package_name = $getPkgName['name'];
										if($isPkg){
											$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,trim($product_no),"RESEND PACKAGE SUBS.",$resend_status,$commandid,$product_no);
										}else{
											$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,trim($product_no),"RESEND PRODUCT SUBS.",$resend_status,$commandid,$product_no);
										}
										$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
										if($ack=='ACK')
										{
											$ack_is=1;
										}elseif($ack=='NACK'){
											$nack_is=-1;
										}
										$payload=$user_id."#".$cmd_id."#".$trans_id;
										$target=1;
										$targetdata=0;
										$results = $this->model_bulk_stbBulkSubscriptionResend->addToCasOpTransanction($sms_customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$product_id,$end_time,$transaction_details['order_id'],$operator_id,$data[0]);
										if($ack=='ACK'){											
											$msg = 'SUCCESS'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  $data[0]." : ".$msg, FILE_APPEND);
								      	}else if($ack=='NACK'){
											$msg = 'FAILED: NACK RECEIVED!'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  $data[0]." : ".$msg, FILE_APPEND);
										}
									} else {
										$errorMsg = $errorMsg."  ".$apimessage;
										$msg = $errorMsg;
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  $data[0]." : ".$msg, FILE_APPEND);
									}
								} elseif($subs_state==0) {
									$msg = 'FAILED: Package not subscribed/expired for particular STB!!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
								} elseif($result==false) {
									$msg = 'FAILED: Subscription Expired, can not resend!!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
								} else {
									$msg = 'FAILED: Customer Not Enabled!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
								}		    			
						    } else {	
				    			if($is_nvod){
				    					$msg = 'FAILED: NVOD Not Allowed!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
				    			}else if(!$product_status){
				    					$msg = 'FAILED: Invalid Product No / Product is disabled!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
				    			}else if($is_RMA==1){
				    					$msg = 'FAILED: STB in RMA state.!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
				    			}else if($is_suspend==1){
				    					$msg = 'FAILED: STB is suspended, Please resume first.!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
				    			}else if($is_lco_suspend==1){
				    					$msg = 'FAILED: STB Belongs To LCO Is Suspended, Please Resume LCO First.!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
				    			}else{
				    					$msg = 'FAILED: Invalid STB NO / Customer Unpaired / Box not Active / Box Blacklisted!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
				    			}
				    		}
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",$log_separator, FILE_APPEND);	
							$user_id = "_".$this->session->data['user_id'];
							$gzfile = DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.$user_id.".gz";
							$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
							gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
							gzclose($fp);
			    		} 
			    	}			    	
			    	if(sizeof($data)<2){
			    		$msg = 'FAILED: Invalid Record!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);						
					}
			    } // End while loop	
			   	$user_id = "_".$this->session->data['user_id'];
				$gzfile = DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.$user_id.".gz";
				$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
				gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
				gzclose($fp);
				unlink(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Subscription/'.$current_date.".txt");
				$this->session->data['success'] = "Success: Please check the log file for detail!";
			} 
		}
        $this->getUploadForm();
  	} 	

  	public function validateFile(){
  		if (!$this->user->hasPermission('modify', 'bulk/stbBulkSubscriptionResend')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('bulk/stbBulkSubscriptionResend');
		switch ($_FILES['filename']['error']) { 
			case UPLOAD_ERR_OK:
				$message = "";//"There is no error, the file uploaded with success";
				break;
            case UPLOAD_ERR_INI_SIZE: 
                $message = "The uploaded file exceeds the upload_max_filesize directive in php.ini"; 
                break; 
            case UPLOAD_ERR_FORM_SIZE: 
                $message = "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form"; 
                break; 
            case UPLOAD_ERR_PARTIAL: 
                $message = "The uploaded file was only partially uploaded"; 
                break; 
            case UPLOAD_ERR_NO_FILE: 
                $message = "No file was uploaded"; 
                break; 
            case UPLOAD_ERR_NO_TMP_DIR: 
                $message = "Missing a temporary folder"; 
                break; 
            case UPLOAD_ERR_CANT_WRITE: 
                $message = "Failed to write file to disk"; 
                break; 
            case UPLOAD_ERR_EXTENSION: 
                $message = "File upload stopped by extension"; 
                break; 
            default: 
                $message = "Unknown upload error"; 
                break; 
        }
        $mimes = array('text/csv','application/vnd.ms-excel');
		if(in_array($_FILES['filename']['type'],$mimes)){
			$lines = count(file($_FILES['filename']['tmp_name'])); 
			if( $lines > 1001)
				$message = "Can't process csv, records more than 1000!";
			elseif($_FILES['filename']['size']<2)
				$message = "Can't process csv, no records found!";
		}else{
			$message = "Accepts only .csv file!";
		}

		if(!empty($message))
			$this->error['warning'] = $message;
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

  	public function WriteMessageLog($tx_id,$status,$log_target_level,$log_target,$product_no,$command,$resend_status,$command_id,$p_no){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command."\t\t".$subscription_name);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command."-".$product_no);
        fclose($log_file);
         // ------------------------------only subscription log------------------------------------
        $log_file = fopen(DIR_LOGS."subscription_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
 		
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target,24," ").$command."-".$product_no);
        fclose($log_file);


        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($tx_id,$status,$log_target_level,$log_target,$command_id,$resend_status,$p_no);
        // -----------------------------------------------------------------------------------------
    }
  
  	protected function getUploadForm() {
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

				

  		$this->language->load('bulk/stbBulkSubscriptionResend');
    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbBulkSubscriptionResend', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['stb_bulk_subscription_resend'] = $this->url->link('bulk/stbBulkSubscriptionResend/stb_bulk_subscription_resend', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$data = array(
			'start'   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'   => $this->config->get('config_admin_limit')
		);	
		/*=============================== Log History ===============================*/
		$this->data['bulk_resend_stb_subscription_log_list'] = array();
   		$total = $this->model_bulk_stbBulkSubscriptionResend->getTotal();
		$results = $this->model_bulk_stbBulkSubscriptionResend->getBulkRegistrationLogList($data);

		$count =0;
		if($results)
			foreach ($results as $result) {		
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){
					$useridwithextension = explode("_",$result['name']); 
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_resend_stb_subscription_log_list'][] = array(
							'name'    => $result['name'],
							'date'         => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		// $total = $count;
		/*=============================== Log History ===============================*/
		if(isset($this->status_array)){	
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;			
		}else{
			$this->data['status_array'] = array();
		}
		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 

		if (isset($this->request->get['msg'])) {
			$this->data['success'] = "Success: File Processed, please check logs for details!!";
		} 
		
    	$this->data['cancel'] = $this->url->link('bulk/stbBulkSubscriptionResend', 'token=' . $this->session->data['token'] . $url, 'SSL');		
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbBulkSubscriptionResend', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'bulk/stbBulkSubscriptionResend.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				// var_dump($this->template);exit();	
		$this->response->setOutput($this->render());
	}



}
?>