<?php    

class ControllerBulkStbBulkSubscription extends Controller { 
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer page showing all the customer in a list.
*/  
  	public function index() {
		$this->language->load('bulk/stbBulkSubscription');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/stbBulkSubscription');

		$this->getUploadForm();
		
	}

	public function exportFormat(){  
		ob_clean();
		/*********************** Export STB Inventory CSV Format *****************************/
		$results = array('SDA40000000001,'.'1,'.'1 month,', 'SDA40000000002,'.'2,'.'3 months,', 'SDA40000000003,'.'3,'.'6 months,',
						 'SDA40000000004,'.'4,'.'9 months,', 'SDA40000000005,'.'5,'.'12 months,');
		if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=StbBulkSubscriptionSampleFormat.csv');
			$output = fopen('php://output', 'w'); ob_clean();
			fputcsv($output, array('STB NO', 'Product ID', 'Duration'));
			foreach ( $results as $line ) {
				$val = explode(",", $line);
				fputcsv($output, $val);
			}
		}
	}

	public function stb_bulk_subscription(){ 
    	
    	$log_separator = "-------------------------------------\n";
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('d-m-Y H:i:s');	
		$obj = new restapi();
		$this->language->load('bulk/stbBulkSubscription');
    	$this->load->model('bulk/stbBulkSubscription'); 
    	$this->load->model('sale/order'); 		
    	$this->document->setTitle($this->language->get('heading_title'));
	
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {
			if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
			    $handle = fopen($_FILES['filename']['tmp_name'], "r");
				file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);
			    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
			    	$stbno = trim($data[0]);
			    	file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",$log_separator, FILE_APPEND);	    	
			    	if($stbno != NULL && (sizeof($data)==3) || sizeof($data)==4) {
				    	if($stbno!= 'STB NO' && $data[1]!='Product ID' && $data[2]!='Duration'){
				    		$status = $this->model_bulk_stbBulkSubscription->validateSTB(trim($stbno));
				    		$box_status = $this->model_bulk_stbBulkSubscription->checkSTBStatus(trim($stbno));  
				    		$is_box_blacklist = $this->model_bulk_stbBulkSubscription->isBlacklist(trim($stbno));
				    		$product_status = $this->model_bulk_stbBulkSubscription->validateProductID(trim($data[1]));
				    		$is_nvod = $this->model_bulk_stbBulkSubscription->validateNvod(trim($data[1]));
				    		$subs_month_status = $this->model_bulk_stbBulkSubscription->getOptionDetails(trim($data[1]),trim($data[2]));

				    		$is_RMA = $this->user->isStbRMA(trim($stbno));
					 		$lcoId  = $this->user->getOperatorIdFromStbno(trim($stbno));
					 		$is_suspend = $this->user->isStbSuspend(trim($stbno));
					 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
				    		$custdetails = $this->model_bulk_stbBulkSubscription->getCustomerDetails(trim($stbno));
				    		$isBasePack = $this->model_sale_order->isBasicPackage($data[1]);
				    		$basicPackageExist = 201;
				    		if(isset($custdetails['customer_id']))
								$basicPackageExist = $this->model_bulk_stbBulkSubscription->isBasicPackageAvailable($custdetails['customer_id'],$data[1],$isBasePack);

				    		if($box_status && $is_box_blacklist==0 && $status && !$is_nvod && $product_status && $subs_month_status  && $custdetails['address_id'] != 0 && $is_RMA==0 && $is_suspend==0 && $is_lco_suspend==0 && $basicPackageExist==101){
				    			$custstatus = $this->model_bulk_stbBulkSubscription->isCustomerEnabled(trim($stbno));
				    			$product_no = $this->model_bulk_stbBulkSubscription->getPNo(trim($data[1]));
				    			$log_target = $stbno;
					    		if($custstatus==1){
					    			$custname = array(
														'store_id' => '0',
														'customer' => $custdetails['firstname'].' '.$custdetails['lastname'],
													);
									$paymentaddressdetails = $this->model_bulk_stbBulkSubscription->getAddressDetails($custdetails['address_id']);
									$productdetails = $this->model_bulk_stbBulkSubscription->getProductDetails(trim($data[1]));
									$productpricedetails = $this->model_bulk_stbBulkSubscription->getProductPriceDetails(trim($data[1]));

									//$optionvaluedetails = $subs_month_status;
									$flatshippingdetails = $this->model_bulk_stbBulkSubscription->getFlatShippingDetails();
									$productoptiondetails = $this->model_bulk_stbBulkSubscription->getProductOptionDetails(trim($data[1]),trim($data[2]));
									if(!$flatshippingdetails){
										$flatshippingdetails[0]['value']=0;
									}
									$price_text = $productpricedetails[0]['price']+$productoptiondetails[0]['price'];
									$total_price_text = $productpricedetails[0]['price']+$productoptiondetails[0]['price']+$flatshippingdetails[0]['value'];
									$shippingaddressdetails = array(
										'shipping_address' 		=> $paymentaddressdetails[0]['payment_address'],
										'shipping_firstname' 	=> $paymentaddressdetails[0]['payment_firstname'],
										'shipping_lastname' 	=> $paymentaddressdetails[0]['payment_lastname'],
										'shipping_company' 		=> $paymentaddressdetails[0]['payment_company'],
										'shipping_address_1' 	=> $paymentaddressdetails[0]['payment_address_1'],
										'shipping_address_2' 	=> $paymentaddressdetails[0]['payment_address_2'],
										'shipping_city' 		=> $paymentaddressdetails[0]['payment_city'],
										'shipping_postcode' 	=> $paymentaddressdetails[0]['payment_postcode'],
										'shipping_country_id' 	=> $paymentaddressdetails[0]['payment_country_id'],
										'shipping_zone_id' 		=> $paymentaddressdetails[0]['payment_zone_id']
									);
									$order_option = array('0' => array('order_option_id' => '', 
																		'product_option_id' => $productoptiondetails[0]['product_option_id'],
																		'product_option_value_id' => $productoptiondetails[0]['product_option_value_id'],
																		'name' => 'Subscription',
																		'value' => trim($data[2]),
																		'type' => 'select'
										));
									$taxDetails = $this->model_bulk_stbBulkSubscription->getTaxRate($custdetails['customer_id'],$price_text, $productpricedetails[0]['tax_class_id']);

									$order_total = array('0' => array('order_total_id' => '',
																		'code' => 'sub_total',
																		'title' => 'Sub-Total',
																		'text' => 'Rs '.$price_text,
																		'value'	=> $productpricedetails[0]['price']+$productoptiondetails[0]['price'],
																		'sort_order' => ''	
																	),
														 '1' => array('order_total_id' => '',
																		'code' => 'shipping',
																		'title' => 'Flat Shipping Rate',
																		'text' => 'Rs '.$flatshippingdetails[0]['value'],
																		'value'	=> $flatshippingdetails[0]['value'],
																		'sort_order' => '3'	
																	),
														
														);
									$total_tax=0;
									foreach ($taxDetails as $taxDetail) {
											array_push($order_total,array('order_total_id' => '',
												'code' => 'tax',
												'title' => $taxDetail['name'],
												'text' => 'Rs '.$taxDetail['amount'],
												'value'	=> $taxDetail['amount'],
												'sort_order' => '3'	
											));
											$total_tax = $total_tax + $taxDetail['amount'];
									}
									$total_price_text = $total_price_text+$total_tax;
									 array_push($order_total,array('order_total_id' => '',
																		'code' => 'total',
																		'title' => 'Total',
																		'text' => 'Rs '.$total_price_text,
																		'value'	=> $productpricedetails[0]['price']+$productoptiondetails[0]['price']+$flatshippingdetails[0]['value']+$total_tax,
																		'sort_order' => '9'	
																	));

									$order_product = array('order_product' => array(
															array('order_product_id' => '',
																	'product_id' => trim($data[1]),
																	'name' => $productdetails[0]['name'],
																	'order_option' => $order_option,
																	'model' => $productpricedetails[0]['model'],
																	'price' => $productpricedetails[0]['price']+$productoptiondetails[0]['price'],
																	'total' => $productpricedetails[0]['price']+$productoptiondetails[0]['price'],
																	'tax' => $total_tax,
																	'reward' => 0
																 )
															),
															'product' => '',
															'product_id' => '',
															'is_package' => $productpricedetails[0]['is_package'],
															'is_ppv' => $productpricedetails[0]['is_ppv'],
															'order_total' => $order_total
												);	
									$shipping_method = array(
															'shipping' => 'flat.flat',
															'shipping_method' => 'Flat Shipping Rate',
															'shipping_code' => 'flat.flat',
															'payment' => 'cod',
															'payment_method' => 'Cash On Delivery',
															'payment_code' => 'cod',
															'coupon' => '',
															'voucher' => '',
															'reward' => '',
															'order_status_id' => '5',
															'comment' => '',
															'affiliate' => '',
															'affiliate_id' => ''
															);
									$complete_order_details = array_merge($custname,$custdetails,$paymentaddressdetails[0],$shippingaddressdetails,$order_product,$shipping_method);							
									
									$this->request->post = $complete_order_details;
									//-------lco balance------
						    		$is_lco_balance = 0;
						    		if ($this->session->data['user_group_id'] !=1 && (LCO_PAYMENT == 1)) {
						    			$is_lco_balance = $this->model_bulk_stbBulkSubscription->isLCOBalance($data[1],$this->request->post,trim($stbno));
						    			if($is_lco_balance==1){
					    					$msg = 'FAILED: Insufficient balance!'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
						    				continue;
						    			}
						    		}
						    		//------------------------
									$operator_id = $this->model_sale_order->getOperatorID($this->request->post['customer_id']);
									$error_encounter=0;
									$errorMsg="";
									$flag=false;
									$apimessage='';
									$finalExpiryDate=null;
									$i=0;
									$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
									$currentDate =  $now_datetime->getTimestamp(); 		
									$arr = array();
									$casop_arr = array()	;
									if(isset($this->request->post['order_product'])){
										foreach ($this->request->post['order_product'] as $order_product) {
											if (isset($order_product['order_option'])) {
												foreach ($order_product['order_option'] as $order_option) {	
													$value=substr($order_option['value'], 2,strlen($order_option['value']));
													$digit=explode(" ", $order_option['value']);
													if($value==="hour")	{								
														$finalExpiryDate = strtotime("+".$digit[0]." hour",$currentDate);
													}elseif($value==="hours"){
														$finalExpiryDate = strtotime("+".$digit[0]." hours",$currentDate);
													}elseif($value==="month") {
														$finalExpiryDate = strtotime("+".$digit[0]." month",$currentDate);
													}elseif($value===" months" || $digit[0]==3 || $digit[0]==6 || $digit[0]==9){
														$finalExpiryDate = strtotime("+".$digit[0]." months",$currentDate);
													}elseif ($value==="year") {
														$finalExpiryDate = strtotime("+".$digit[0]." year",$currentDate);
													}elseif ($value==="years") {
														$finalExpiryDate = strtotime("+".$digit[0]." years",$currentDate);
													}
													$i++;
												}
											}
											$DB_subscriptionData = $this->model_sale_order->getDBSubscriptionData($order_product['product_id'], $this->request->post['customer_id']);
											if($DB_subscriptionData){
												$datetime = new DateTime($DB_subscriptionData['expire_date'], new DateTimeZone('Asia/Calcutta'));
												$DB_expiryDate  = $datetime->getTimestamp(); 						  
												if((int)$DB_subscriptionData['is_cancel']==0){							
													if($DB_expiryDate <= $currentDate){
														$finalExpiryDate =strtotime(" + ".$order_option['value'],$currentDate);
														$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$this->request->post['customer_id']);
													}
													elseif($DB_expiryDate > $currentDate){
														$finalExpiryDate =strtotime(" + ".$order_option['value'],$DB_expiryDate);							
														$this->model_sale_order->updateExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$this->request->post['customer_id']);
													}
												}else{
													$finalExpiryDate =strtotime(" + ".$order_option['value'],$currentDate);
													$this->model_sale_order->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$this->request->post['customer_id']);
												}
											}
											$customer=$this->model_sale_order->getCustomerKmsId($this->request->post['customer_id']);	
											$product=$this->model_sale_order->getProductKmsId($order_product['product_id']);
											$obj = new restapi();
											$method ="POST";			
											if($product['is_package']==0 && $product['is_ppv']==0)	{
												$cmd_id='10';
												$data="user_id=".$customer['api_user_id']."&product_id=".$product['api_product_id']."&start_time=".$currentDate."&end_time=".$finalExpiryDate;
												$uri=KMS_API."/enableProductSubscription";
											}elseif ($product['is_package']==0 && $product['is_ppv']==1) {				
												$duration=$this->model_sale_order->getOrderPPVDuration($order_product['product_id']);
												$ppv_datetime_start = new DateTime($duration[0]["date_added"], new DateTimeZone('Asia/Calcutta'));
												$ppv_starttime  = $ppv_datetime_start->getTimestamp(); 
												$ppv_datetime_expiry = new DateTime($duration[0]["date_modified"], new DateTimeZone('Asia/Calcutta'));
												$ppv_expirytime  = $ppv_datetime_expiry->getTimestamp();

												$cmd_id='18';
												$data="user_id=".$customer['api_user_id']."&ppv_id=".$product['api_product_id']."&start_time=".$ppv_starttime."&end_time=".$ppv_expirytime;
												$uri=KMS_API."/enablePPVSubscription";						
											}else {
												$cmd_id='6';
												$data="user_id=".$customer['api_user_id']."&package_id=".$product['api_product_id']."&start_time=".$currentDate."&end_time=".$finalExpiryDate;
												$uri=KMS_API."/enablePackageSubscription";	
											}
											$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
											$res=$obj->callAPI($method,$hdr,$uri,$data);
											$response = json_decode($res);
											$error = true;
											$apimessage = '';
											$errorMsg = '';
											foreach ($response as $key => $value) {
												switch ($key) {
								    				case 'error':
								    					$error=	$value;
								    					break;
								    				case 'message':
								    					$apimessage=$value;				
								    					break;
								    				case 'id':
								    					$product_subscription_id=$value;	
								    					break;
								    				case 'mq_response':
								    					$curlresponse=$value;	
								    					break;
								    				default:
								    					$errorMsg=$errorMsg." ".$key.":".$value;	
								    					break;
								    			}
						    				}
								    		if(!$error)	{
								    			// -----------------------------------
							    				$log_target_level = "Individual";
							    				$resend_status = 0;
												$commandid = $cmd_id;
																							
												$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"SUBSCRIPTION."." - ".$product_no,$resend_status,$commandid,$product_no);
							    				// -----------------------------------
												$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
												$nack_is=-1;
												$ack_is=-1;
												if($ack=='ACK') {
													$ack_is=1;
													if($ack_is==1){
														$this->model_sale_order->addToSubscriptionDesubscription($this->request->post['customer_id'],$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$order_product['product_id'],$operator_id,$stbno);
													}							     
													$msg = 'SUCCESS'."\n";
													file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  $stbno." : ".$msg, FILE_APPEND);
												}elseif($ack=='NACK') {
													$nack_is=0;
													$msg = 'FAILED: NACK RECEIVED!'."\n";
													file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  $stbno." : ".$msg, FILE_APPEND);
												}
												$flag=true;
												$data=$this->request->post;
												array_push($arr, $order_product);
												
												if($product['is_ppv']==1){
													$casop_id = $this->model_sale_order->addToTransanction($this->request->post['customer_id'],$cmd_id,$ppv_expirytime,$product_subscription_id,$ack_is,$nack_is,$order_product['product_id'],$product['is_package'],$this->request->post['customer_id'],$duration[0]["date_added"],$operator_id,$stbno);
													$this->model_sale_order->addToSubscription($this->request->post['customer_id'],$order_product['product_id'],$ppv_expirytime,$duration[0]["date_added"]);
												}else{
													$casop_id = $this->model_sale_order->addToTransanction($this->request->post['customer_id'],$cmd_id,$finalExpiryDate,$product_subscription_id,$ack_is,$nack_is,$order_product['product_id'],$product['is_package'],$this->request->post['customer_id'],0,$operator_id,$stbno);
													$this->model_sale_order->addToSubscription($this->request->post['customer_id'],$order_product['product_id'],$finalExpiryDate);
												}
												array_push($casop_arr,$casop_id);
											}else{
												$error_encounter=1;
												$errorMsg=$errorMsg." :".$apimessage;	
												$msg = $errorMsg."\n";
												file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  $stbno." : ".$msg, FILE_APPEND);
											}
										}
										$data=$this->request->post;
										$data['order_product']=$arr;
										if (sizeof($arr)>0) {
											$order_id = $this->model_sale_order->addOrder($data,$casop_arr);
											$this->model_sale_order->addLCOtransaction($data,$order_id);
										}
									}
									if($error_encounter) {
							  			if($flag)
							  				$this->session->data['warning'] =$this->language->get('text_warning_partial_subscription').' ('.$errorMsg.')';
								  		else
								  			$this->session->data['warning'] =$errorMsg;
							  		}else{
										$this->session->data['success'] = $apimessage;
							      	}		
							      	
								}else{
									$msg = 'FAILED: Customer Not Enabled!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
								}		    			
				    		} else {
								if(isset($custdetails['address_id'])){
				    				if($custdetails['address_id'] == 0 || $custdetails['address_id'] == ''){	
				    					$msg = 'FAILED: Address Id not avilable for the Customer!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
				    				}elseif(!$status){
										$msg = 'FAILED: Invalid STB.!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
									}elseif(!$box_status){
											$msg = 'FAILED: Box not Active / Box Blacklisted.!'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}else if($is_nvod){
										$msg = 'FAILED: NVOD Not Allowed!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}else if(!$product_status){
				    					$msg = 'FAILED: Invalid Product Id / Product is disabled!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}else if(!$subs_month_status){	
				    					$msg = 'FAILED: Invalid Subscription Month Value!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}elseif($is_RMA==1){
				    					$msg = 'FAILED: STB in RMA state.!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}elseif($is_suspend==1){
				    					$msg = 'FAILED: STB is suspended, Please resume first.!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}elseif($is_lco_suspend==1){
				    					$msg = 'FAILED: STB Belongs To LCO Is Suspended, Please Resume LCO First.!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}elseif($is_box_blacklist){
				    					$msg = 'FAILED: Invalid STB NO / Box not Active / Box Blacklisted!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}else if($basicPackageExist==401){
					    				$msg = 'FAILED: Basic Package Subscription not available for customer, atleast one basic package required.!'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}else if($basicPackageExist==301){
				    					$msg = 'FAILED: Basic Package Subscription already available, cannot subscribed another basic package.!'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}else if($basicPackageExist==201){
					    				$msg = 'FAILED: Multiple Base Package Subscription available, kindly de-subscribe other base packages.!'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					    			}
				    			}else{
				    					$msg = 'FAILED: Invalid STB NO / Customer Unpaired / Box not Active / Box Blacklisted!'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
				    			}
				    		}
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",$log_separator, FILE_APPEND);	
			    		}
			    	}
			    	if(sizeof($data)<3){
			    		$msg = 'FAILED: Invalid Record!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt",  trim($stbno)." : ".$msg, FILE_APPEND);
					}
			    } 
			    $user_id = "_".$this->session->data['user_id'];
				$gzfile = DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.$user_id.".gz";
				$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
				gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
				gzclose($fp);

				unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Subscription/'.$current_date.".txt");
				$this->session->data['success'] = "Success: Please check the log file for detail!";
			}	
		}
        $this->getUploadForm();
  	} 

  	public function validateFile(){
  		if (!$this->user->hasPermission('modify', 'bulk/stbBulkSubscription')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('bulk/stbBulkSubscription');
		switch ($_FILES['filename']['error']) { 
			case UPLOAD_ERR_OK:
				$message = "";//"There is no error, the file uploaded with success";
				break;
            case UPLOAD_ERR_INI_SIZE: 
                $message = "The uploaded file exceeds the upload_max_filesize directive in php.ini"; 
                break; 
            case UPLOAD_ERR_FORM_SIZE: 
                $message = "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form"; 
                break; 
            case UPLOAD_ERR_PARTIAL: 
                $message = "The uploaded file was only partially uploaded"; 
                break; 
            case UPLOAD_ERR_NO_FILE: 
                $message = "No file was uploaded"; 
                break; 
            case UPLOAD_ERR_NO_TMP_DIR: 
                $message = "Missing a temporary folder"; 
                break; 
            case UPLOAD_ERR_CANT_WRITE: 
                $message = "Failed to write file to disk"; 
                break; 
            case UPLOAD_ERR_EXTENSION: 
                $message = "File upload stopped by extension"; 
                break; 
            default: 
                $message = "Unknown upload error"; 
                break; 
        }
        $mimes = array('text/csv','application/vnd.ms-excel');
		if(in_array($_FILES['filename']['type'],$mimes)){
			$lines = count(file($_FILES['filename']['tmp_name'])); 
			if( $lines > 1001)
				$message = "Can't process csv, records more than 1000!";
			elseif($_FILES['filename']['size']<2)
				$message = "Can't process csv, no records found!";
		}else{
			$message = "Accepts only .csv file!";
		}

		if(!empty($message))
			$this->error['warning'] = $message;
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

  	public function WriteMessageLog($tx_id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id,$p_no){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
         // ---------------------------------------------------------------------------------------
        $log_file = fopen(DIR_LOGS."subscription_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($tx_id,$status,$log_target_level,$log_target,$command_id,$resend_status,$p_no);
        // ---------------------------------------------------------------------------------------
    }
  
  	protected function getUploadForm() {
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

				

  		$this->language->load('bulk/stbBulkSubscription');
    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbBulkSubscription', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['stb_bulk_subscription'] = $this->url->link('bulk/stbBulkSubscription/stb_bulk_subscription', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$data = array(
			'start'   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'   => $this->config->get('config_admin_limit')
		);	
		/*=============================== Log History ===============================*/
		$this->data['bulk_stb_subscription_log_list'] = array();
   		$total = $this->model_bulk_stbBulkSubscription->getTotal();
		$results = $this->model_bulk_stbBulkSubscription->getBulkRegistrationLogList($data);
		$count =0;
		if($results)
			foreach ($results as $result) {		
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){
					$useridwithextension = explode("_",$result['name']); 
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_stb_subscription_log_list'][] = array(
							'name'    => $result['name'],
							'date'         => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		// $total = $count;
		/*=============================== Log History ===============================*/
		if(isset($this->status_array)){	
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;			
		}else{
			$this->data['status_array'] = array();
		}
			// var_dump($this->data['status_array']);exit();		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 

		if (isset($this->request->get['msg'])) {
			$this->data['success'] = "Success: File Processed, please check logs for details!!";
		} 
		
    	$this->data['cancel'] = $this->url->link('bulk/stbBulkSubscription', 'token=' . $this->session->data['token'] . $url, 'SSL');		
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbBulkActivation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'bulk/stbBulkSubscription.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
	
		$this->response->setOutput($this->render());
	}



}
?>