<?php    

class ControllerBulkStbBulkDeactivation extends Controller { 
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer page showing all the customer in a list.
*/  
  	public function index() {
		$this->language->load('bulk/stbBulkDeactivation');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/stbBulkDeactivation');

		$this->getUploadForm();
		
		}

	public function exportFormat(){  
		ob_clean();
    	/*********************** Export STB Bulk De-Activation CSV Format *****************************/
    	$results = array('SDA40000000001,'."Note:- Add 1 To 1000 STBNO Serialwise..!");
    	if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=StbBulkDeActivationSampleFormat.csv');
			$output = fopen('php://output', 'w');
			foreach ( $results as $line ) {
    			$val = explode(",", $line);
    			fputcsv($output, $val);
			}
		}
    }	

	public function stb_bulk_deactivation(){ 
    	$this->load->model('bulk/stbBulkDeactivation');
    	$obj = new restapi();
		$this->language->load('bulk/stbBulkDeactivation');
		$log_separator = "-------------------------------------\n";
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('d-m-Y H:i:s');	
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_activation');
		$this->load->model('sale/customer');
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {
			if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
		  		$handle = fopen($_FILES['filename']['tmp_name'], "r");
				file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {  				    	
			    	$stbLen =  strlen(trim($data[0]));
		    		file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt",$log_separator, FILE_APPEND);
		    		$status = $this->model_bulk_stbBulkDeactivation->validateSTB(trim($data[0])); 
		    		$is_blacklist = $this->model_bulk_stbBulkDeactivation->isBlacklist(trim($data[0]));
		    		$is_RMA = $this->user->isStbRMA(trim($data[0]));
			 		$lcoId  = $this->user->getOperatorIdFromStbno(trim($data[0]));
			 		$is_suspend = $this->user->isStbSuspend(trim($data[0]));
			 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);

		    		$actvLastInstId = 1;
		    		if($status){
		    			$customer_id = $status[0]['customer_id'];
						$actvLastInstId = $this->model_bulk_stbBulkDeactivation->getActiveLastInsertID($customer_id);
						$customerStatus = $this->model_commands_box_activation->getStbNoStatus($customer_id);
		    		}
		    		if($status && $actvLastInstId!=NULL && ($is_RMA==0) && ($is_suspend==0) && ($is_lco_suspend==0)){
		    		   	if($is_blacklist==0) {	
			    			if($customerStatus!='0'){
					    		if ($this->validateDeactivate($status[0]['customer_id'])) {
									$customer_id = $status[0]['customer_id'];
									$actvLastInstId = $this->model_bulk_stbBulkDeactivation->getActiveLastInsertID($customer_id);
									$transaction_details= $this->model_commands_box_activation->getTransactionDetails($actvLastInstId);
									if($transaction_details){
							     		$customer_id=$transaction_details['user_id'];
							    		$user_id=$transaction_details['api_user_id'];
							    		$operator_id=isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
							    		$target_lvl=1;
							    		$stb_no = $this->model_commands_box_activation->getStbNo($customer_id);
							    		$cmd_id=$transaction_details['cmd_id'];
									  	$data="stb_no=". $stb_no."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;
									}
							 		$method ="POST";
							 		$url=KMS_API."/Disable";
							 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
						        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
								    $response=json_decode($apiresult);
								    $error=true;
								    $curlresponse='';
								    $errorMsg='';
								    $apimessage='';
								    foreach ($response as $key => $value) {
										if($key=='error'&&$value==false){
											$error=$value;
										}if($key=='error'&&$value==true){
											$error=$value;	
										}
										if($key=='id'){
											$id=$value;
										}
										if($key=='mq_response'){
											$curlresponse=$value;
										}if($key=='message')
										{
											$apimessage=$value;			
										}if($key=='disble_command_id')
										{
											$cmd_id=$value;			
										}if($key!='id' && $key!='error' && $key!='message')
										{
											$errorMsg=$errorMsg." ".$key.":".$value;
										}
									}
									
									$ack_is=-1;$nack_is=-1;
									if(!$error)
									{
										$cust_id=$status[0]['customer_id']; 
										$log_target_level = "Individual";
										$resend_status = 0;
										$commandid = 1;
										$log_target = $this->model_commands_box_activation->getStbNo($cust_id);
										$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"BOX De-ACTIVATION",$resend_status,$commandid);
									
										$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
										if($ack=='ACK'){
											$ack_is=1;
											$this->model_commands_box_activation->setSTBActiveDeactiveOnlyForDeactivation(0,$cust_id,3);	
											if($ack_is==1){
												if(!$this->model_commands_box_activation->isDeactivated($cust_id,$status[0]['STBNO'])){
													$this->model_commands_box_activation->InsertUpdateActivationExpiryForDeactivation($cust_id,$cmd_id,$id,$ack_is,$operator_id,$status[0]['STBNO']);
												}
											}					
										}elseif($ack=='NACK'){
											$nack_is=-1;
										}
										$payload=$stb_no."#".$cmd_id."#".$user_id;
										$target=1;
										$targetdata=0;
										$this->model_commands_box_activation->getIdsForExpiryUpdate($transaction_details["user_id"],$actvLastInstId);	
										$results = $this->model_commands_box_activation->addToCasOpTransanction($cust_id,$cmd_id,$id,$ack_is,$nack_is,$payload,0,$operator_id,$status[0]['STBNO']);
										$msg = 'SUCCESS'."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
									}else{
										$msg = $apimessage."-".$errorMsg."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
									}
								} else{
						    		$msg = 'FAILED: User subscribed to services, please send Product/Package desubscription first!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
						        }
						    } else{
					  			$msg = "Customer is disabled, Can't process it..!!\n";
					  			file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
					  		}
				  		} else{
				  			$msg = "FAILED: STB BlackListed!\n";
				  			file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
				  		}	
		    		}elseif($is_RMA==1){
	    				$msg = 'FAILED: STB in RMA state.!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
	    			}elseif($is_suspend==1){
	    				$msg = 'FAILED: STB is suspended, Please resume first.!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
	    			}elseif($is_lco_suspend==1){
	    				$msg = 'FAILED: STB Belongs To LCO Is Suspended, Please Resume LCO First.!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
	    			}elseif($stbLen!='14' && $stbLen==''){
	    				$msg = 'FAILED: STBNO field is empty!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
	    			}elseif($stbLen!='14'){
	    				$msg = 'FAILED: STBNO length must be 14 digit!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
	    			} else { // End if status statement
		    			$msg = 'FAILED: Customer not Enabled/Paired/Box Activation not sent already!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    		}
						    	
					file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt",$log_separator, FILE_APPEND);	
				} // End while loop
				$user_id = "_".$this->session->data['user_id'];
				$gzfile = DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.$user_id.".gz";
				$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
				gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
				gzclose($fp);

		    	unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Deactivation/'.$current_date.".txt");
		    	$this->session->data['success'] = "Success: Please check the log file for detail!";
			}
		}
       	$this->getUploadForm();
  	} 

  	public function validateFile(){
  		if (!$this->user->hasPermission('modify', 'bulk/stbBulkDeactivation')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('bulk/stbBulkDeactivation');
		switch ($_FILES['filename']['error']) { 
			case UPLOAD_ERR_OK:
				$message = "";//"There is no error, the file uploaded with success";
				break;
            case UPLOAD_ERR_INI_SIZE: 
                $message = "The uploaded file exceeds the upload_max_filesize directive in php.ini"; 
                break; 
            case UPLOAD_ERR_FORM_SIZE: 
                $message = "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form"; 
                break; 
            case UPLOAD_ERR_PARTIAL: 
                $message = "The uploaded file was only partially uploaded"; 
                break; 
            case UPLOAD_ERR_NO_FILE: 
                $message = "No file was uploaded"; 
                break; 
            case UPLOAD_ERR_NO_TMP_DIR: 
                $message = "Missing a temporary folder"; 
                break; 
            case UPLOAD_ERR_CANT_WRITE: 
                $message = "Failed to write file to disk"; 
                break; 
            case UPLOAD_ERR_EXTENSION: 
                $message = "File upload stopped by extension"; 
                break; 
            default: 
                $message = "Unknown upload error"; 
                break; 
        }
        $mimes = array('text/csv','application/vnd.ms-excel');
		if(in_array($_FILES['filename']['type'],$mimes)){
			$lines = count(file($_FILES['filename']['tmp_name'])); 
			if( $lines > 1001)
				$message = "Can't process csv, records more than 1000!";
			elseif($_FILES['filename']['size']<2)
				$message = "Can't process csv, no records found!";
		}else{
			$message = "Accepts only .csv file!";
		}

		if(!empty($message))
			$this->error['warning'] = $message;
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

  	protected function validateDeactivate($user_id){
  		$this->load->model('commands/box_activation');
		$result = $this->model_commands_box_activation->canSendDeactivation($user_id);

		if ($result>0) {
	  		return false;
		} else {
	  		return true;
		}
  	}

  	public function WriteMessageLog($tx_id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
         // ---------------------------------------------------------------------------------------
        $log_file = fopen(DIR_LOGS."sms_stb_activation.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($tx_id,$status,$log_target_level,$log_target,$command_id,$resend_status);
        // ---------------------------------------------------------------------------------------
    }
  
  	protected function getUploadForm() {
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
  		$this->language->load('bulk/stbBulkDeactivation');
    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbBulkDeactivation', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['stb_bulk_deactivation'] = $this->url->link('bulk/stbBulkDeactivation/stb_bulk_deactivation', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$data = array(
			'start'   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'   => $this->config->get('config_admin_limit')
		);	
		/*=============================== Log History ===============================*/
		$this->data['bulk_stb_deactivation_log_list'] = array();
   		$total = $this->model_bulk_stbBulkDeactivation->getTotal();
		$results = $this->model_bulk_stbBulkDeactivation->getBulkRegistrationLogList($data);
		$count =0;
		if($results)
			foreach ($results as $result) {		
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){
					$useridwithextension = explode("_",$result['name']); 
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_stb_deactivation_log_list'][] = array(
							'name'    => $result['name'],
							'date'         => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		// $total = $count;
		/*=============================== Log History ===============================*/
		if(isset($this->status_array)){
			
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;
			// var_dump($this->data['status_array']);exit();
		}else{
			$this->data['status_array'] = array();
		}
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 
		
    	$this->data['cancel'] = $this->url->link('bulk/stbBulkDeactivation', 'token=' . $this->session->data['token'] . $url, 'SSL');		
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbBulkDeactivation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'bulk/stbBulkDeactivation.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}



}
?>