<?php 

class ControllerBulkProductwiseSubscription extends Controller {

public function index() {

		$this->language->load('bulk/productwisesubscription');		 
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/productwisesubscription');
    	$this->getList();
  	}

	public function broadcaster_packages(){
		$json = array();
		$this->load->model('bulk/productwisesubscription');

		$broadcaster_info = $this->model_bulk_productwisesubscription->getBroadcasterPackage($this->request->get['broadcaster_id']);

		if($broadcaster_info){
			foreach ($broadcaster_info as $value) {
				array_push($json, $value['package_name']);
			}	
		}
		$this->response->setOutput(json_encode(array_unique($json)));
	}

  	public function printPdf(){

  		if (isset($this->request->post['selected'])) {	
  			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
			$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);
			$this->load->model('bulk/productwisesubscription');

			// $package_name  = $this->model_bulk_productwisesubscription->getPackageName($this->request->post['selected'][0]);
			
			$this->pdf->Cell(170,6,'-: Product Wise Subscription (Sent in particular Month) :-'.$this->request->post['selected'][0].' -- '.$this->session->data['filter_month'],1,0,'C',1);

			$w = array(20,35,90,120,155); 
		    $c = array(15,55,30,35,35);
		    $this->pdf->SetY(40);
		    
			$header =  array('Sl.No','Product Name','STB No.','Subscription Date','Expiry Date');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
	        $data = array(
				'start'           => ($this->request->get['page'] - 1) * $this->config->get('config_admin_limit'),
				'limit'           => $this->config->get('config_admin_limit')
			);

	        $results = $this->model_bulk_productwisesubscription->getHistoricalDataMonthly($this->session->data['filter_product'],$data,$this->session->data['filter_month']);
	        $i = ($this->request->get['page'] - 1) * $this->config->get('config_admin_limit');

		    foreach($results as $result){
				$this->pdf->SetX(20);
		    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
		    	$this->pdf->Cell($c[1],6,$result["pname"],1,0,'L',0);
		    	$this->pdf->Cell($c[2],6,$result["STBNO"],1,0,'L',0);
		    	$this->pdf->Cell($c[3],6,$result["modify_date"],1,0,'L',0);
		    	$this->pdf->Cell($c[4],6,$result["exp_date"],1,0,'L',0);
		    	$this->pdf->Ln();
		     	$count++;
	        }	         

		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		 
		    $this->pdf->Output(); 
		}else{
			$this->language->load('bulk/productwisesubscription');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }

public function getList() {	

		if(!isset($_GET['page'])){
			unset($this->session->data['filter_product']);
		}

		$total  = '';
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_product'])) {
			$this->data['filter_product'] = $this->request->get['filter_product'];
		} else {
			$this->data['filter_product'] ='';
		}
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/productwisesubscription', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		if (isset($this->request->get['filter_product'])) {
			$data['filter_product']=$this->request->get['filter_product'];
			$this->data['filter_product'] = $this->request->get['filter_product'];
		} else {
			$this->data['filter_product'] = '';
		}

		if (isset($this->request->get['filter_product'])) {
			$this->session->data['filter_product'] = $this->request->get['filter_product'];
		}

		if (isset($this->request->get['filter_product'])) {
			$url .= '&filter_product=' . $this->request->get['filter_product'];
		}

		if (isset($this->request->get['filter_month'])) {
			$data['filter_month']		= $this->request->get['filter_month'];
			$this->data['filter_month'] = $this->request->get['filter_month'];
		} else {
			$this->data['filter_month'] = '';
		}

		if (isset($this->request->get['filter_month'])) {
			$this->session->data['filter_month'] = $this->request->get['filter_month'];
		}

		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}
	
		$this->data['prds'] = array();
		$resultProducts = $this->model_bulk_productwisesubscription->getProducts();
		
		foreach ($resultProducts as $product) {
			$this->data['products'][] = array(
				'product_name' 	=> $product['name'],
				'product_id'   => $product['product_id'],
				);
		}
		
		if($this->data['filter_product']!='' || isset($this->session->data['filter_product']))	{
			
			$total 	 = $this->model_bulk_productwisesubscription->getTotalHistoricalDataMonthly($this->session->data['filter_product'],$this->session->data['filter_month']);
			
			$results = $this->model_bulk_productwisesubscription->getHistoricalDataMonthly($this->session->data['filter_product'],$data,$this->session->data['filter_month']);
			
			foreach ($results as $result) {				
				$this->data['prds'][] = array(
				'product_name'  			=> $result['pname'],
				'stb_no' 			=> $result['STBNO'],
				'subs_date'  		=> $result['modify_date'],
				'exp_date' 			=> $result['exp_date'],
				'total'        		=> $total,
				'selected'      	=> isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);						
			}
			// $this->data['filter_product'] = '';
			// $filter_month = '';
		}	
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_prd_name'] = $this->language->get('column_prd_name');
		$this->data['column_stb_no'] = $this->language->get('column_stb_no');
		$this->data['column_subs'] = $this->language->get('column_subs');
		$this->data['column_expiry'] = $this->language->get('column_expiry');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_product'] = $this->language->get('entry_product');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		if (isset($this->request->get['page'])) {			
			$this->data['printPdf'] = $this->url->link('bulk/productwisesubscription/printPdf', 'token=' . $this->session->data['token'].'&page='.$this->request->get['page']. $url, 'SSL');
		} else {
			$this->data['printPdf'] = $this->url->link('bulk/productwisesubscription/printPdf', 'token=' . $this->session->data['token'].'&page='.'1'. $url, 'SSL');
		}

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/productwisesubscription', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/productwisesubscription.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
