<?php 

class ControllerBulkPkgwiseSubscription extends Controller {

	public function index() {
		$this->language->load('bulk/pkgwisesubscription');		 
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/pkgwisesubscription');
    	$this->getList();
  	}
	

  	public function broadcaster_packages(){
		$json = array();
		$this->load->model('bulk/pkgwisesubscription');

		$broadcaster_info = $this->model_bulk_pkgwisesubscription->getBroadcasterPackage($this->request->get['broadcaster_id']);

		if($broadcaster_info){
			foreach ($broadcaster_info as $value) {
				array_push($json, $value['package_name']);
			}	
		}
		$this->response->setOutput(json_encode(array_unique($json)));
	}


	function vcell($c_width,$c_height,$x_axis,$text){
		$w_w=$c_height/4;
		$w_w_1=$w_w+2;
		$w_w1=$w_w+$w_w+3;
		$w_w2=$w_w+$w_w+$w_w+4;
		$w_w3=$w_w+$w_w+$w_w+$w_w+4;
		$w_w4=$w_w+$w_w+$w_w+$w_w+$w_w+5;
		$len=strlen($text);// check the length of the cell and splits the text into 7 character each and saves in a array 
		if($len>22){
			$w_text=str_split($text,22);		
			$this->pdf->SetX($x_axis);
			if(isset($w_text[0])){
				$this->pdf->Cell($c_width,$w_w_1,$w_text[0],'','','');
				$this->pdf->SetX($x_axis);
			}
			if(isset($w_text[1])){
				$this->pdf->Cell($c_width,$w_w1,$w_text[1],'','','');
				$this->pdf->SetX($x_axis);
			}
			if(isset($w_text[2])){
				$this->pdf->Cell($c_width,$w_w2,$w_text[2],'','','');
				$this->pdf->SetX($x_axis);
			}
			if(isset($w_text[3])){
				$this->pdf->Cell($c_width,$w_w3,$w_text[3],'','','');
				$this->pdf->SetX($x_axis);
			}
			if(isset($w_text[4])){
				$this->pdf->Cell($c_width,$w_w4,$w_text[4],'','','');
				$this->pdf->SetX($x_axis);
			}
			$this->pdf->Cell($c_width,$c_height,'','LTRB',0,'L',0);
		}
		else{
		   	 $this->pdf->SetX($x_axis);
		   	 $this->pdf->Cell($c_width,$c_height,$text,'LTRB',0,'L',0);
			}
	}

  	public function printPdf(){

  		if (isset($this->request->get['filter_broadcaster']) && isset($this->request->get['filter_channel_name']) && isset($this->request->get['filter_month'])) {	

		    $this->pdf->AddPage('P',array(250,250));
		    $this->pdf->SetFillColor(232,232,232);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(10);
			$this->load->model('bulk/pkgwisesubscription');
			
			$broadcaster_name  = $this->model_bulk_pkgwisesubscription->getBroadcasterName($this->request->get['filter_broadcaster']);

			$this->pdf->Cell(225,6,'-: Broadcaster Wise Package Subscription (Sent in particular duration) :-'.$broadcaster_name."-".$this->request->get['filter_month'],1,0,'C',1);
			$this->pdf->SetY(33);
		    $w = array(45,45,45,45,45); 
		    
			$header =  array('Sl.No','Package Name','STB No.','Subscription Date','Expiry Date');
		    for($i = 0; $i < count($header); $i++) {
				$this->pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C');
			}
			$this->pdf->Ln();
	    	$this->pdf->SetFont('times','',8);
			
	        
		   	$i=0;
	        $count=0;
	        $data = array(
				'start'           => 0,
				'limit'           => 1000
			);
		    if (isset($this->request->post['channel_name'])){
		       	$product_id  = $this->model_bulk_pkgwisesubscription->getPackageID($this->request->post['channel_name']);
		        $results = $this->model_bulk_pkgwisesubscription->getHistoricalDataMonthly($product_id,$this->request->post['filter_month'],$data);
			    foreach($results as $result){
			    	$i=$i+1;
			    	
					$data[] = array($i,$result['pname'],$result['STBNO'],$result['modify_date'],$result['exp_date']);
			     $count++;
		        }	         
	       }

		    $column_width = $w[1];
	        for ($i=0; $i < $count ; $i++) {
			
				 if($data[$i][1]=="")
			 	       	$total_string_width=55;
			 	    else
			 	       $total_string_width = $this->pdf->GetStringWidth($data[$i][1]);
			 	       $number_of_lines = ceil( $total_string_width / ($column_width) );
			 	       $line_height = 6;
			 	       $yH = ceil( $number_of_lines * $line_height ); 
			 	     
			 	  for($j=0; $j < count($header) ; $j++){ 
			 	     $x_axis=$this->pdf->getx();
					 $c_width=45;// cell width 
					 $c_height=8;// cell height
					
					 $this->vcell($c_width,$c_height,$x_axis,$data[$i][$j]);
			 	  }
		    	$this->pdf->Ln();
		    }     

		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		 
		    $this->pdf->Output(); 
		}else{
			$this->language->load('bulk/pkgwisesubscription');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }


	public function countUppercase($string) {
      	return strlen(preg_replace('![^A-Z]+!', '', $string));
	}

public function getList() {

		if(!isset($_GET['page'])){
			unset($this->session->data['filter_broadcaster']);
		}

		$total  = '';

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$this->data['filter_broadcaster'] = $this->request->get['filter_broadcaster'];
		} else {
			$this->data['filter_broadcaster'] ='';
		}

		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
		} else {
			$filter_month = '';
		}

		if (isset($this->request->get['filter_channel_name'])) {
			$filter_channel_name = $this->request->get['filter_channel_name'];
		} else {
			$filter_channel_name = '';
		}

		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/pkgwisesubscription', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_broadcaster'])) {
			$data['filter_broadcaster']		  = $this->request->get['filter_broadcaster'];
			$this->data['filter_broadcaster'] = $this->request->get['filter_broadcaster'];
		} else {
			$this->data['filter_broadcaster'] = '';
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$this->session->data['filter_broadcaster'] = $this->request->get['filter_broadcaster'];
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$url .= '&filter_broadcaster=' . $this->request->get['filter_broadcaster'];
		}


		if (isset($this->request->get['filter_month'])) {
			$data['filter_month']		= $this->request->get['filter_month'];
			$this->data['filter_month'] = $this->request->get['filter_month'];
		} else {
			$this->data['filter_month'] = '';
		}

		if (isset($this->request->get['filter_month'])) {
			$this->session->data['filter_month'] = $this->request->get['filter_month'];
		}

		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}	

		if (isset($this->request->get['filter_channel_name'])) {
			$data['filter_channel_name']		=	$this->request->get['filter_channel_name'];
			$this->data['filter_channel_name'] 	= 	$this->request->get['filter_channel_name'];
		} else {
			$this->data['filter_channel_name']	= '';
		}

		if (isset($this->request->get['filter_channel_name'])) {
			$this->session->data['filter_channel_name'] = $this->request->get['filter_channel_name'];
		}

		if (isset($this->request->get['filter_channel_name'])) {
			$url .= '&filter_channel_name=' . $this->request->get['filter_channel_name'];
		}
		
		$this->data['channels'] = array();
		$resultPkgs = $this->model_bulk_pkgwisesubscription->getBroadcasters();
		
		foreach ($resultPkgs as $broadcaster) {
			$this->data['broadcasters'][] = array(
				'broadcaster_name' =>	$broadcaster['name'],
				'broadcaster_id'   =>	$broadcaster['broadcaster_id'],
			);
		}

		if($this->data['filter_broadcaster']!='' || isset($this->session->data['filter_broadcaster'])){
			
			$product_id  = $this->model_bulk_pkgwisesubscription->getPackageID($this->session->data['filter_channel_name']);

			$total = $this->model_bulk_pkgwisesubscription->getTotalHistoricalDataMonthly($product_id,$this->session->data['filter_month']);

			$results  = $this->model_bulk_pkgwisesubscription->getHistoricalDataMonthly($product_id,$this->session->data['filter_month'],$data);

			$broadcaster_name  = $this->model_bulk_pkgwisesubscription->getBroadcasterName($this->session->data['filter_broadcaster']);
			
			foreach ($results as $result) {	
				$this->data['channels'][] = array(
					'broadcaster_name' => $broadcaster_name,
					'channel_name' => $result['pname'],
					'stb_no'	   => $result['STBNO'],
					'subs_date'	   => $result['modify_date'],
					'exp_date'	   => $result['exp_date']
				);						
			}
			$this->data['filter_broadcaster'] = '';
			$filter_month = '';
		}	
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_broadcaster_name'] = $this->language->get('column_broadcaster_name');
		$this->data['column_channel_name'] = $this->language->get('column_ch_name');
		$this->data['column_stb_no'] = $this->language->get('column_stb_no');
		$this->data['column_subs'] = $this->language->get('column_subs');
		$this->data['column_expiry'] = $this->language->get('column_expiry');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_broadcaster'] = $this->language->get('entry_broadcaster');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		$this->data['printPdf'] = $this->url->link('bulk/pkgwisesubscription/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/pkgwisesubscription', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->data['filter_month'] = $filter_month;
		$this->template = 'bulk/pkgwisesubscription.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }


?> 
