<?php 
  /*
@File pkgwisechannellist.php(Controller)
ADMIN pkgwisechannellist PAGE
    This class show all the A la carte wise Active Conn to it.

@Author Ravi Ranjan
@date 8th Aug. 2016
*/
class ControllerBulkPkgwiseChannelList extends Controller {

public function index() {
// unset($this->session->data['filter_package']);
// var_dump($_GET['page']);
		$this->language->load('bulk/pkgwisechannellist');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/pkgwisechannellist');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		if (isset($this->request->post['selected']))
		{
			$this->load->model('bulk/pkgwisechannellist');
		    $this->pdf->AddPage('P',array(250,250));
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_bulk_pkgwisechannellist->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(30);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);
			$this->pdf->SetY(40);
			$this->pdf->SetX(10);
			$this->pdf->Cell(230,6,'-: Package Wise Channel Details :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(50);
			$this->pdf->SetX(10);
			$this->pdf->Cell(191,6,$this->request->post['pname'],0,0,'C',0);
			$this->pdf->SetY(55);
			$this->pdf->SetX(5);
			$this->pdf->SetFont('times','B',8);
		    $w = array(10,25,70,120,130,175,188,201,214,227,240);
		    $c = array(15,45,50,10,45, 13,13, 13, 13, 13 );//,55,60,65,70);
		    $header =  array('Channel ID','Channel Name','Category','Free','Broadcaster','M1Price','M3Price','M6Price','M9Price','Yearly');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->load->model('bulk/pkgwisechannellist');    
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=0;
	      	foreach ($this->request->post['selected'] as $product_id) {
				$res = $this->model_bulk_pkgwisechannellist->getOptions($product_id);
				$m1_price='-- --';
				$m3_price='-- --';
				$m6_price='-- --';
				$m9_price='-- --';
				$yearly='-- --';
				
				$category='';
				foreach ($res as $value) {
					if((substr($value['name'],0,strpos($value['name'],' '))==1 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m1_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==3 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m3_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==6 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m6_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==9 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m9_price=$value['price'];
					if(substr($value['name'],strpos($value['name'],' ')+1,3)=='yea')
						$yearly=$value['price'];
					}
				$catres = $this->model_bulk_pkgwisechannellist->getCategories($product_id);
				foreach ($catres as $value) {
					$category=$category.','.$value['category'];
				}
				$result = $this->model_bulk_pkgwisechannellist->getChannelDetail($product_id);
	      		
				if($result['broadcaster_id']!=-1){
					$broadcaster = $this->model_bulk_pkgwisechannellist->getBroadcasterName($result['broadcaster_id']);
				}
				else{
					$broadcaster='No Broadcaster';
				}
	      		if ($result) {	
					$data[] = array($result['product_id'],$result['name'],trim($category,','),$result['product_type'],$broadcaster,$m1_price,$m3_price,$m6_price,$m9_price,$yearly);
			     	$count++;
		     	}
        	} 	    
			// for ($i=0; $i < $count ; $i++) {
			// 	$this->pdf->SetX(10); 
		 // 	  	for($j=0; $j < count($header) ; $j++)
		 // 	  	{
		 // 	  		$this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'L',0);
		 //      	}   
		 //    	$this->pdf->Ln();
		 //    }   
		$rowheight=6;
	        $rows[]=array();
	        for($i=0; $i < $count ; $i++)
	        {
	        	for($j=0; $j < count($header) ; $j++)
		 	  	{
		 	  		$reqspace=0;
		 	  		$len=strlen($data[$i][$j]);
		 	  		$uppercase=$this->countUppercase($data[$i][$j]);
		 	  		$lower=$len-$uppercase;
		 	  		if($lower)
		 	  			$reqspace=$lower/0.82;
		 	  		if($uppercase)
		 	  			$reqspace=$reqspace+$uppercase/0.55;
	        		if($reqspace <= $c[$j]-5){
	        			$rows[$i][$j]=1;
	        		}
	        		else{
	        			$rows[$i][$j]=ceil($reqspace/($c[$j]));
	        		}
	        	}
	        }
			for ($i=0; $i < $count ; $i++) {
				$this->pdf->SetX(10); 
				$lastx=0;
		 	  	for($j=0; $j < count($header) ; $j++)
		 	  	{
		 	  		$max=max($rows[$i]);
		 	  		$height=($max/$rows[$i][$j])*$rowheight;
					$this->pdf->MultiCell($c[$j],$height,$data[$i][$j],1,'L');
					$x=$this->pdf->GetX();
					$y=$this->pdf->GetY();
					$lastx=$lastx+$c[$j];
					if($j!=count($header)-1)
		 	  			$this->pdf->SetXY($x+$lastx,$y-($height*$rows[$i][$j]));					
		      	} 
				$this->pdf->SetXY($x,$y-$height);					
			    $this->pdf->Ln();
		    } 
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/pkgwisechannellist');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/pkgwisechannellist');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();	
		}
    }

	public function countUppercase($string) {
      	return strlen(preg_replace('![^A-Z]+!', '', $string));
	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if(!isset($_GET['page'])){
			unset($this->session->data['filter_package']);
		}

		$total  = '';
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_package'])) {
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] ='';
		}
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/pkgwisechannellist', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_package'])) {
			$data['filter_package']=$this->request->get['filter_package'];
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] = '';
		}

		if (isset($this->request->get['filter_package'])) {
			$this->session->data['filter_package'] = $this->request->get['filter_package'];
		}

		if (isset($this->request->get['filter_package'])) {
			$url .= '&filter_package=' . $this->request->get['filter_package'];
		}
		// $total = 1;
		$this->data['channels'] = array();
		$resultPkgs = $this->model_bulk_pkgwisechannellist->getPackages();
		
		foreach ($resultPkgs as $package) {
			$this->data['packages'][] = array(
				'package_name' =>$package['name'],
				'package_id'   =>$package['product_id'],
				);
		}
		// var_dump($this->session->data['filter_package']);
		if($this->data['filter_package']!='' || isset($this->session->data['filter_package']))
		{
			$total 	 = $this->model_bulk_pkgwisechannellist->getTotalChannelListDetails($this->session->data['filter_package']);
			$results = $this->model_bulk_pkgwisechannellist->getChannelListDetails($this->session->data['filter_package'],$data);

			foreach ($results as $result) {	
				
				$res = $this->model_bulk_pkgwisechannellist->getOptions($result['product_id']);	

				$m1_price='-- --';
				$m3_price='-- --';
				$m6_price='-- --';
				$m9_price='-- --';
				$yearly='-- --';
				$category='';
				foreach ($res as $value) {

					if((substr($value['name'],0,strpos($value['name'],' '))==1 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m1_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==3 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m3_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==6 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m6_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==9 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m9_price=$value['price'];
					if(substr($value['name'],strpos($value['name'],' ')+1,3)=='yea')
						$yearly=$value['price'];
					}
				$catres = $this->model_bulk_pkgwisechannellist->getCategories($result['product_id']);
			
				$this->load->model('report/channel_list');
				if($result['broadcaster_id']!=-1){
					$broadcaster = $this->model_report_channel_list->getBroadcasterName($result['broadcaster_id']);
				}
				else{
					$broadcaster='No Broadcaster';
				}

				foreach ($catres as $value) {
					$category=$category.','.$value['category'];
				}
				$this->data['channels'][] = array(
				'product_id'  	=> $result['product_id'],
				'name' 			=> $result['name'],
				'category' 		=> trim($category,','),
				'free' 			=> ($result['product_type']==1 ? 'Paid':'FTA'),
				'digital' 		=> 'Digital',
				'broadcast' 	=> $broadcaster,
				'M1 Price'		=> $m1_price,
			    'M3 Price' 		=> $m3_price,
				'M6 Price' 		=> $m6_price,
				'M9 Price' 		=> $m9_price,				
				'yearly' 		=> $yearly,
				'total'        	=> $total,
				'selected'      => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);						
				
			}
		}	
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_channel_name'] = $this->language->get('column_ch_name');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['column_free'] = $this->language->get('column_free');
		$this->data['column_digital'] = $this->language->get('column_digital');
		$this->data['column_broadcaster'] = $this->language->get('column_broadcaster');
		$this->data['column_m1price'] = $this->language->get('column_m1price');
		$this->data['column_m3price'] = $this->language->get('column_m3price');
		$this->data['column_m6price'] = $this->language->get('column_m6price');
		$this->data['column_m9price'] = $this->language->get('column_m9price');
		$this->data['column_yearly'] = $this->language->get('column_yearly');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');

		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		$this->data['printPdf'] = $this->url->link('bulk/pkgwisechannellist/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/pkgwisechannellist', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/pkgwisechannellist.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
