<?php 
  /*
@File pkgwisechannellist.php(Controller)
ADMIN pkgwisechannellist PAGE
    This class show all the A la carte wise Active Conn to it.

@Author Ravi Ranjan
@date 8th Aug. 2016
*/
class ControllerBulkPkgwiseChannelcount extends Controller {

public function index() {


		$this->language->load('bulk/pkgwisechannelcount');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/pkgwisechannelcount');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){ 

			$this->load->model('bulk/pkgwisechannelcount');
			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		   	$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);

			$this->pdf->Cell(170,6,'-: Package Wise Channel Count :- ',1,0,'C',1);
			$this->pdf->Ln();
			$this->pdf->SetFont('times','B',8);
		    $w = array(40,55,80,140);
		    $c = array(15,25,50,25);
	    	$this->pdf->SetY(40);
		    
		    $header =  array('Sr.No.','Package Number','Package Name','Channel Count');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'C',1);
		    }
			$this->load->model('bulk/pkgwisechannelcount');    
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
		    $count=1;
		    
			$results = $this->model_bulk_pkgwisechannelcount->getChannelListDetails();
			 foreach($results as $result){
	    		$this->pdf->SetX(40);
		    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
	    		$this->pdf->Cell($c[1],6,$result['model'],1,0,'C',0);
	    		$this->pdf->Cell($c[2],6,$result['name'],1,0,'C',0);
	    		$this->pdf->Cell($c[3],6,$result['count'],1,0,'C',0);
	    		$this->pdf->Ln();
		 		$count++;
	       	}
			
			
			ob_clean();
		    $this->pdf->Output();

    }

	public function countUppercase($string) {
      	return strlen(preg_replace('![^A-Z]+!', '', $string));
	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		/*if (isset($this->request->get['filter_package'])) {
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] ='';
		}*/
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/pkgwisechannelcount', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		/*if (isset($this->request->get['filter_package'])) {
			$data['filter_package']=$this->request->get['filter_package'];
			$this->data['filter_package'] = $this->request->get['filter_package'];
			$url .= '&filter_package=' . $this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] = '';
		}*/
		$this->data['printPdf'] = $this->url->link('bulk/pkgwisechannelcount/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');
		// var_dump($this->data['printPdf']);exit();
		$total = 1;
		$this->data['channels'] = array();
		/*$resultPkgs = $this->model_bulk_pkgwisechannelcount->getPackages();*/
		
		/*foreach ($resultPkgs as $package) {
			$this->data['packages'][] = array(
				'package_name' =>$package['name'],
				'package_id' =>$package['product_id'],
				);
		}
		if($this->data['filter_package']!='')
		{*/
			$results = $this->model_bulk_pkgwisechannelcount->getChannelListDetails();

// var_dump($this->data['channels']);die;
			foreach ($results as $result) {
				$this->data['channels'][] = array(
				'product_id'  	=> $result['product_id'],
				'product_no'  	=> $result['model'],
				'product_name'  	=> $result['name'],
				'count'  		=> $result['count']
				);						
			}
		/*}*/	

			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_package_no'] = $this->language->get('column_package_no');
		$this->data['column_package_name'] = $this->language->get('column_package_name');
		$this->data['column_channel_count'] = $this->language->get('column_channel_count');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['column_free'] = $this->language->get('column_free');
		$this->data['column_digital'] = $this->language->get('column_digital');
		$this->data['column_broadcaster'] = $this->language->get('column_broadcaster');
		$this->data['column_m1price'] = $this->language->get('column_m1price');
		$this->data['column_m3price'] = $this->language->get('column_m3price');
		$this->data['column_m6price'] = $this->language->get('column_m6price');
		$this->data['column_m9price'] = $this->language->get('column_m9price');
		$this->data['column_yearly'] = $this->language->get('column_yearly');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');

		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		// $this->data['printPdf'] = $this->url->link('bulk/pkgwisechannelcount/printPdf', 'token=' . $this->session->data['token'].$url, 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

	
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/pkgwisechannelcount', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/pkgwisechannelcount.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
