<?php 
class ControllerBulkPackageSubscriptionCount extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/packageSubscriptionCount');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/packageSubscriptionCount');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){ 
	if(isset($this->request->post['selected'])){ 
	    $this->pdf->AddPage();
	    $this->load->model('bulk/packageSubscriptionCount');
	    $this->pdf->SetFillColor(232,232,232);
		$this->pdf->SetFont('times','B',10);
		$this->pdf->SetY(32);
		$this->pdf->SetX(20);
		
		$operatorName = $this->model_bulk_packageSubscriptionCount->getOperatorNameById($_REQUEST['filter_operator']);
		if($operatorName=='')
			$operatorName="ALL";
		
		if($_REQUEST['option']==1 && $_REQUEST['filter_option']==''){
		    $this->pdf->Cell(170,6,'-: Package Subscription Count :-',1,0,'C',1);
		}
		elseif($_REQUEST['filter_option']==1){
			$this->pdf->Cell(170,6,'-: Package Subscription Count :-   Result between:  '.$this->request->post['filter_date_start'].' TO '.$this->request->post['filter_date_end'].' (Operator :-  '.$operatorName.')' ,1,0,'C',1);
		}elseif ($_REQUEST['filter_option']==2) {
			$this->pdf->Cell(170,6,'-: Package Subscription Count :-   Result month of: '.$_REQUEST['filter_month'].' (Operator :-  '.$operatorName.')' ,1,0,'C',1);
		}elseif ($_REQUEST['filter_option']==3) {
			$this->pdf->Cell(170,6,'-: Package Subscription Count :-   Result year of:  '.$_REQUEST['filter_year'].' (Operator :-  '.$operatorName.')' ,1,0,'C',1);
		}
		
		$w = array(20,35,65,155);
		$c = array(15,30,90,35);
		$this->pdf->SetY(40);
	    $header =  array('Sr.No','Package.No.','Package Name','Subscription Count');
	    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
	    
	    $this->pdf->Ln();
		$this->pdf->SetFont('times','',8);
	    $count=1;
	    foreach ($this->request->post['selected'] as $package_id) { 
	        $results = $this->model_bulk_packageSubscriptionCount->getPackageDetailsForPDF($package_id,$this->request->get);
			         	
	    }

	    foreach($results as $result){
    		$this->pdf->SetX(20);
	    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
	    	$this->pdf->Cell($c[1],6,$result["package_number"],1,0,'L',0);
	    	$this->pdf->Cell($c[2],6,$result["name"],1,0,'L',0);
	    	$this->pdf->Cell($c[3],6,$result['count'],1,0,'L',0);
	    	$this->pdf->Ln();
	 		$count++;
    	}
	 	
	    /*$this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/ob_clean();
	    $this->pdf->Output();
		}else{
			$this->language->load('bulk/packageSubscriptionCount');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/packageSubscriptionCount');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }  	  	
  
public function getList() {	
		$this->load->model('bulk/packageSubscriptionCount');

		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
			$this->data['filter_option']	= $this->request->get['filter_option'];
		} else {
			$filter_option = '';
			$this->data['filter_option']	= '';
		}

		if (isset($this->request->get['filter_date_start'])) {
			$data['filter_date_start']=$this->request->get['filter_date_start'];
			$this->data['filter_date_start'] = $this->request->get['filter_date_start'];
		} else {
			$this->data['filter_date_start'] = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$data['filter_date_end']=$this->request->get['filter_date_end'];
			$this->data['filter_date_end'] = $this->request->get['filter_date_end'];
		} else {
			$this->data['filter_date_end'] = '';
		}
		
		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
			$this->data['filter_month']	= $this->request->get['filter_month'];
		} else {
			$filter_month = '';
			$this->data['filter_month']	= '';
		}
		if (isset($this->request->get['filter_year'])) {
			$filter_year = $this->request->get['filter_year'];
			$this->data['filter_year']	= $this->request->get['filter_year'];
		} else {
			$filter_year = '';
			$this->data['filter_year']	= '';
		}

		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
			$this->data['filter_operator'] = $this->request->get['filter_operator'];
		} else {
			$filter_operator = '';
			$this->data['filter_operator'] = '';
		}
				
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		

		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		if (isset($this->request->get['filter_year'])) {
			$url .= '&filter_year=' . $this->request->get['filter_year'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}

		$this->data['printPdf'] = $this->url->link('bulk/packageSubscriptionCount/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		
   // 		$this->data['breadcrumbs'][] = array(
   //     		'text'      => $this->language->get('heading_title'),
			// 'href'      => $this->url->link('bulk/packageSubscriptionCount', 'token=' . $this->session->data['token'] . $url, 'SSL'),
   //    		'separator' => ' :: '
   // 		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/packageSubscriptionCount', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);

   		$operatorList = $this->model_bulk_packageSubscriptionCount->getOperatorList();
		foreach ($operatorList as  $operator) {
			$this->data['operators'][] = array(
					'user_id' => $operator['user_id'],
					'username'=> $operator['username']
				);
		}
	
		$data = array(
			'filter_option'			 => $filter_option,	
			'filter_date_start'	     => $this->data['filter_date_start'], 
			'filter_date_end'	     => $this->data['filter_date_end'], 
			'filter_month'           => $filter_month,
			'filter_year' 			 => $filter_year,
			'filter_operator'   	 => $filter_operator,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$total = $this->model_bulk_packageSubscriptionCount->getTotalPackageCount($data); 
		$this->data['package_subs_list'] = array();
		$results = $this->model_bulk_packageSubscriptionCount->getPackageDetails($data);
		if (isset($results)) {
			foreach ($results as $result) {			
				$this->data['package_subs_list'][] = array(
					'package_id'	 => $result['package_id'],
					'package_number' => $result['package_number'],
					'name'       	 => $result['name'],
					'count'   	     => $result['count'],
					'selected'   	 => isset($this->request->post['selected']) && in_array($result['package_id'], $this->request->post['selected']),
				);	
			}
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_id'] = $this->language->get('column_id');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_count'] = $this->language->get('column_count');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/packageSubscriptionCount', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/packageSubscriptionCount.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/packageSubscriptionCount');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
