<?php 

class ControllerBulkPackageModificationLogs extends Controller {

public function index() {
		$this->language->load('bulk/packageModificationLogs');	
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/packageModificationLogs');
    	$this->getList();
  	}

	public function broadcaster_packages(){
		$json = array();
		$this->load->model('bulk/packageModificationLogs');

		$broadcaster_info = $this->model_bulk_packageModificationLogs->getBroadcasterPackage($this->request->get['broadcaster_id']);

		if($broadcaster_info){
			foreach ($broadcaster_info as $value) {
				array_push($json, $value['package_name']);
			}	
		}
		$this->response->setOutput(json_encode(array_unique($json)));
	}

 	public function printPdf(){
  		if (isset($this->request->post['selected'])) {	
  			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(32);
			$this->pdf->SetX(10);
			$this->load->model('bulk/packageModificationLogs');

			$this->pdf->Cell(190,6,'-: Package Modification Logs :-'.$this->request->post['selected'][0],1,0,'C',1);

		   	$w = array(10,20,60,70,85,113,141,180,190);
	    	$c = array(10,40,10,15,28,28,39,10,10);	
	    	$this->pdf->SetY(40);
	    	$header =  array('Sr.No','PKG NAME','PKNO','ACTION','FROM DATE','TO DATE','PRD NAME','PRNO','ACT');
			// $header =  array('Sl.No','Pkg Name','Pkg No.','Action','From Date','To Date','Ch Name','Ch No.','Ch Status');
		  	for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',7);
	        $count=1;
	        $data = array(
				'start'           => ($this->request->get['page'] - 1) * $this->config->get('config_admin_limit'),
				'limit'           => $this->config->get('config_admin_limit')
			);

			$list = array_unique($this->request->post['selected']);
 			$package_number_list = implode(',', $list);
 			

	        	$results = $this->model_bulk_packageModificationLogs->getPackageModificationLogs($package_number_list,$data);
		       // echo "<pre>"; print_r($results);die;
	        	$top=1;
			    $tempBatchNo = 0;
				foreach($results as $result){
					if($top==0 && $tempBatchNo==$result['batchno']){
					   	$this->pdf->Cell($c[0],4,"",0,0,'L',0);
					   	$this->pdf->Cell(121,4,"",0,0,'L',0);
					   	$this->pdf->Cell($c[6],4,$result["product_name"],0,0,'L',0);
					   	$this->pdf->Cell($c[7],4,$result["product_number"],0,0,'L',0);
					   	$this->pdf->Cell($c[8],4,$result["channel_status"],0,0,'L',0);
				   	}else{
				   		$tempBatchNo = $result["batchno"];
					   	$this->pdf->SetX(10);
					   	$this->pdf->Cell($c[0],4,$count,1,0,'L',0);
					   	$this->pdf->Cell($c[1],4,$result["package_name"],1,0,'L',0);
					   	$this->pdf->Cell($c[2],4,$result["package_number"],1,0,'L',0);
					   	$this->pdf->Cell($c[3],4,$result["action"],1,0,'L',0);
					   	$this->pdf->Cell($c[4],4,$result['startdate'],1,0,'L',0);
					   	$this->pdf->Cell($c[5],4,($result['enddate']!='' ? $result['enddate']: "Till Date"),1,0,'L',0);
					   	$this->pdf->Cell($c[6],4,$result["product_name"],1,0,'L',0);
					   	$this->pdf->Cell($c[7],4,$result["product_number"],1,0,'L',0);
					   	$this->pdf->Cell($c[8],4,$result["channel_status"],1,0,'L',0);
					   	$top=0;
					   	$count++;
				   	}
				   	$this->pdf->Ln();
			    }
		       
	        

		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		 
		    $this->pdf->Output(); 
		}else{
			$this->language->load('bulk/packageModificationLogs');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
	
public function getList() {	

		if(!isset($_GET['page'])){
			unset($this->session->data['filter_package']);
		}

		$total  = '';
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		
		if (isset($this->request->get['filter_package'])) {
			$filter_package = $this->request->get['filter_package'];
		} else {
			$filter_package = null;
		}

		if (isset($this->request->get['filter_package'])) {
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] ='';
		}
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/packageModificationLogs', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'filter_package'  => $filter_package,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		if (isset($this->request->get['filter_package'])) {
			$data['filter_package']=$this->request->get['filter_package'];
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			$this->data['filter_package'] = '';
		}

		/*if (isset($this->request->get['filter_package'])) {
			$this->session->data['filter_package'] = $this->request->get['filter_package'];
		}*/

		if (isset($this->request->get['filter_package'])) {
			$url .= '&filter_package=' . $this->request->get['filter_package'];
		}

		$this->data['pkgs'] = array();
		$resultPkgs = $this->model_bulk_packageModificationLogs->getPackages();
		
		foreach ($resultPkgs as $package) {
			$this->data['packages'][] = array(
				'package_name' 		=> $package['name'],
				'package_id'   		=> $package['product_id'],
				'package_number'    => $package['model'],
			);
		}
		
		// if($this->data['filter_package']!='' || isset($this->session->data['filter_package']))	{
			
			$total 	 = $this->model_bulk_packageModificationLogs->getTotalPackageModificationLogs($data);
			
			$results = $this->model_bulk_packageModificationLogs->getPackageModificationLogDetails($data);
			
			foreach ($results as $result) {				
				$this->data['pkgs'][] = array(
					'package_name'	  => $result['package_name'],	
					'package_number'  => $result['package_number'],
					'action' 	      => $result['action'],
					'from_date'   	  => $result['startdate'],
					'to_date'     	  => ($result['enddate']!='' ? $result['enddate']: "Till Date"),
					/*'product_name'	  => $result['product_name'],	
					'product_number'  => $result['product_number'],
					'channel_status'  => $result['channel_status'],*/
					'selected'   	=> isset($this->request->post['selected']) && in_array($result['package_name'], $this->request->post['selected']),
				);						
			}
			
		// }	
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_pkg_name'] = $this->language->get('column_pkg_name');
		$this->data['column_pkg_no'] = $this->language->get('column_pkg_no');		
		$this->data['column_stb_no'] = $this->language->get('column_stb_no');
		$this->data['column_subs'] = $this->language->get('column_subs');
		$this->data['column_expiry'] = $this->language->get('column_expiry');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		if (isset($this->request->get['page'])) {			
			$this->data['printPdf'] = $this->url->link('bulk/packageModificationLogs/printPdf', 'token=' . $this->session->data['token'].'&page='.$this->request->get['page']. $url, 'SSL');
		} else {
			$this->data['printPdf'] = $this->url->link('bulk/packageModificationLogs/printPdf', 'token=' . $this->session->data['token'].'&page='.'1'. $url, 'SSL');
		}

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/packageModificationLogs', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/packageModificationLogs.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
