<?php 
class ControllerBulkOperatorWiseReport extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/operator_wise_report');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/operator_wise_report');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){ 
	// if(isset($this->request->post['selected'])){ 
	    $this->pdf->AddPage('L');
	    $this->load->model('bulk/operator_wise_report');
  		$this->load->model('setting/setting');
  		$store_info = $this->model_setting_setting->getSetting('config', 0);	
        $taxId = $this->model_bulk_operator_wise_report->getGSTTaxClassId();
        $this->pdf->SetFont('times','',10);
		$this->pdf->SetY(20);
		$this->pdf->SetTextColor(0,0,0);
		$this->pdf->Cell(255,6,'INVOICE',0,0,'C',0);
		$this->pdf->SetFont('times','',8);
		$this->pdf->SetY(25);
		$this->pdf->Cell(255,6,'GSTIN: '.$store_info['config_gstin'],0,0,'C',0);
		$this->pdf->SetFont('times','',10);
		$this->pdf->SetDrawColor(188,188,188);
        $this->pdf->Line(10,30,295,30);
        $this->pdf->SetY(35);
        $this->pdf->SetTextColor(0,0,0);

	    $this->pdf->SetFillColor(232,232,232);
		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY($this->pdf->GetY());
		$this->pdf->SetX(10);		
				
		$this->pdf->Cell(285,6,'-:Monthly subscription for a-la-carte/Package operator wise:- ',1,0,'C',1);
		$this->pdf->Sety(45);
		$operatorDetails = $this->model_bulk_operator_wise_report->getOperatorNameById($_REQUEST['filter_operator']);
		if(empty($operatorDetails))
			$operatorName="ALL";
		else
			$operatorName=$operatorDetails['username'];

		if(isset($this->request->get['filter_operator']) && $this->request->get['filter_operator']!=''){
			$this->pdf->SetY($this->pdf->GetY());
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->Cell(100,4,"OPERATOR",1,0,'L',1);
			$this->pdf->SetFont('times','',8);
			$this->pdf->Cell(185,4,$operatorName,1,0,'L',0);
		}
		if(isset($this->request->get['filter_date'])&& $this->request->get['filter_date']!=''){
			$this->pdf->SetY($this->pdf->GetY()+4);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->Cell(100,4,"GENERATION DATE",1,0,'L',1);
			$this->pdf->SetFont('times','',8);
			$this->pdf->Cell(185,4,$this->request->get['filter_date'],1,0,'L',0);
		}
		if(!empty($operatorDetails)){
			$this->pdf->SetY($this->pdf->GetY()+4);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->Cell(100,4,"CONCAT PERSON",1,0,'L',1);
			$this->pdf->SetFont('times','',8);
			$this->pdf->Cell(185,4,$operatorDetails['firstname'].' '.$operatorDetails['lastname'],1,0,'L',0);

			$this->pdf->SetY($this->pdf->GetY()+4);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->Cell(100,4,"ADDRESS",1,0,'L',1);
			$this->pdf->SetFont('times','',8);
			$this->pdf->Cell(185,4,$operatorDetails['address'],1,0,'L',0);

			$this->pdf->SetY($this->pdf->GetY()+4);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->Cell(100,4,"CONCAT NUMBER",1,0,'L',1);
			$this->pdf->SetFont('times','',8);
			$this->pdf->Cell(185,4,$operatorDetails['mobile_no'],1,0,'L',0);

			$this->pdf->SetY($this->pdf->GetY()+4);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->Cell(100,4,"GSTIN",1,0,'L',1);
			$this->pdf->SetFont('times','',8);
			$this->pdf->Cell(185,4,isset($operatorDetails['gstin'])?$operatorDetails['gstin']:'',1,0,'L',0);
			
		}

		$this->pdf->SetY($this->pdf->GetY()+6);
		$header =  array('#','Opearator Name','Op. ID','Subs. Type','Prd/Pkg Id','Prd/Pkg Name','Number of subscribers of the channel on 7th day of the month','Number of subscribers of the channel on 14th day of the month','Number of subscribers of the channel on 21st day of the month','Number of subscribers of the channel on 28th day of the month','Average Subscription','Price/Month','Total Amount');

		$w = array(10,18,43,55,75,90,115,144,173,202,231,259,286,293);
    	$c = array(8,25,12,20,15,25,29,29,29,29,28,17,19);
	    $this->pdf->SetFont('times','B',8);
	    $count = 1;
	    for( $i = 0; $i < count($header) ; $i++){
		  	if($i==0)
	    		$this->pdf->SetX($w[0]);
	      	else
		   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			if($i>5){
				$x_axis=$this->pdf->getx();
				$this->pdf->vvcell($c[$i],12,$x_axis,$header[$i],21);
			}else
		   		$this->pdf->Cell($c[$i],12,$header[$i],1,0,'L',1);
	    }
	    $this->pdf->Ln();
		$this->pdf->SetFont('times','',8);
	    $count=1;
	    $TotalAmount=0.00;
	    $ReportData = $this->model_bulk_operator_wise_report->getOperatorSubscriptionReport($this->request->get,1);
	    if (isset($ReportData)) {
	    $PkgSubscriptionSlot_1 = $ReportData[0];
		$PkgSubscriptionSlot_2 = $ReportData[1];
		$PkgSubscriptionSlot_3 = $ReportData[2];
		$PkgSubscriptionSlot_4 = $ReportData[3];
		$PkgSubscriptionSlot_5 = $ReportData[4];
		$i=0;
		$cnt =1;
		$count=1;
		foreach ($PkgSubscriptionSlot_1 as $result) {
			$count =0;
			if (isset($PkgSubscriptionSlot_2)) {
			    $slot_2count = 0;
			    foreach ($PkgSubscriptionSlot_2 as $result2) {
				if (($result['product_id']== $result2['product_id'])) {
					$slot_2count = $result2['7count'];
					// $count =$count+1;
					$count =4;
				}
			  }	
			}		
			if (isset($PkgSubscriptionSlot_3)) {
			    $slot_3count = 0;
			    foreach ($PkgSubscriptionSlot_3 as $result3) {
				if (($result['product_id']== $result3['product_id'])) {
					$slot_3count = $result3['14count'];
					// $count =$count+1;
					$count =4;
				}
			  }	
			}
			if (isset($PkgSubscriptionSlot_4)) {
			    $slot_4count = 0;
			    foreach ($PkgSubscriptionSlot_4 as $result4) {
				if (($result['product_id']== $result4['product_id'])) {
					$slot_4count = $result4['21count'];
					// $count =$count+1;
					$count =4;
				}
			  }	
			}
			if (isset($PkgSubscriptionSlot_5)) {
			    $slot_5count = 0;
			    foreach ($PkgSubscriptionSlot_5 as $result5) {
				if (($result['product_id']== $result5['product_id'])) {
					$slot_5count = $result5['28count'];
					// $count =$count+1;
					$count =4;
				}
			  }	
			}
		    if ($count) {
			  $avrg = ($slot_2count+$slot_3count+$slot_4count+$slot_5count)/$count;	
			}else{
			  $avrg =0;		
			}	
			$c_width=20;
			$c_height=12;
			$total = $avrg*$result["price"]; 
    		$this->pdf->SetX(10);
	    	$this->pdf->Cell($c[0],6,$cnt,1,0,'L',0);
	    	$this->pdf->Cell($c[1],6,$result["username"],1,0,'L',0);
	    	$this->pdf->Cell($c[2],6,$result["operator_id"],1,0,'L',0);
	    	$this->pdf->Cell($c[3],6,$result['isPackage']==0?'A-la-carte':'Package',1,0,'L',0);
	    	$this->pdf->Cell($c[4],6,$result["product_id"],1,0,'L',0);
	    	// $x_axis=$this->pdf->getx();
			// $this->pdf->vcell($c_width,$c_height,$x_axis,$result["name"]);
	    	$this->pdf->Cell($c[5],6,$result["name"],1,0,'L',0);
	    	$this->pdf->Cell($c[6],6,$slot_2count,1,0,'L',0);
	    	$this->pdf->Cell($c[7],6,$slot_3count,1,0,'L',0);
	    	$this->pdf->Cell($c[8],6,$slot_4count,1,0,'L',0);
	    	$this->pdf->Cell($c[9],6,$slot_5count,1,0,'L',0);
	    	$this->pdf->Cell($c[10],6,sprintf("%.2f", $avrg),1,0,'L',0);
	    	$this->pdf->Cell($c[11],6,sprintf("%.2f", $result["price"]),1,0,'L',0);
	    	$this->pdf->Cell($c[12],6,sprintf("%.2f", $total),1,0,'L',0);

	    	$this->pdf->Ln();
	 		$cnt++;
	 		$TotalAmount = $TotalAmount + $total;
	 		$i=$i+1;
    	  }
        }
    	$this->pdf->Cell(265,6,'Sub-Total :',0,0,'R',1);
    	$this->pdf->Cell(20,6,sprintf("%.2f", $TotalAmount),0,0,'R',1);
    	$taxDetails = $this->model_bulk_operator_wise_report->getTaxRate($TotalAmount, $taxId);
    	$total_tax=0;
		foreach ($taxDetails as $taxDetail) {
			$this->pdf->Ln();
			$this->pdf->Cell(265,6,$taxDetail['name'],0,0,'R',0);
    		$this->pdf->Cell(20,6,sprintf("%.2f", $taxDetail['amount']),0,0,'R',0);
			$total_tax = $total_tax + $taxDetail['amount'];
		}
		$this->pdf->Ln();
		$TotalAmount = $TotalAmount+$total_tax;
		$this->pdf->Cell(265,6,'Payment Amount:',0,0,'R',1);
    	$this->pdf->Cell(20,6,sprintf("%.2f",$TotalAmount),0,0,'R',1);
	    ob_clean();
	    $this->pdf->Output();
/*		}else{
			$this->language->load('bulk/operator_wise_report');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/operator_wise_report');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}*/
    }  	  	
  
public function getList() {	
		$this->load->model('bulk/operator_wise_report');

		if (isset($this->request->get['filter_date'])) {
			$data['filter_date']=$this->request->get['filter_date'];
			$this->data['filter_date'] = $this->request->get['filter_date'];
		} else {
			$this->data['filter_date'] = '';
		}


		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
			$this->data['filter_operator'] = $this->request->get['filter_operator'];
		} else {
			$filter_operator = '';
			$this->data['filter_operator'] = '';
		}
				
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_date'])) {
			$url .= '&filter_date=' . $this->request->get['filter_date'];
		}
		
		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}

		$this->data['printPdf'] = $this->url->link('bulk/operator_wise_report/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/operator_wise_report', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);

   		$operatorList = $this->model_bulk_operator_wise_report->getOperatorList();
		foreach ($operatorList as  $operator) {
			$this->data['operators'][] = array(
					'user_id' => $operator['user_id'],
					'username'=> $operator['username']
				);
		}
	
		$data = array(
			'filter_date'	     => $this->data['filter_date'], 
			'filter_operator'   	 => $filter_operator,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);
		$this->data['opeartor_subs_list'] = array();
		$ReportData = $this->model_bulk_operator_wise_report->getOperatorSubscriptionReport($data,0);
		if (isset($ReportData)) {
		$PkgSubscriptionSlot_1 = $ReportData[0];
		$PkgSubscriptionSlot_2 = $ReportData[1];
		$PkgSubscriptionSlot_3 = $ReportData[2];
		$PkgSubscriptionSlot_4 = $ReportData[3];
		$PkgSubscriptionSlot_5 = $ReportData[4];
			$i=0;
			foreach ($PkgSubscriptionSlot_1 as $result) {
				$count =0;
				if (isset($PkgSubscriptionSlot_2)) {
				$slot_2count = 0;
				  foreach ($PkgSubscriptionSlot_2 as $result2) {
					if (($result['product_id']==$result2['product_id'])) {
						$slot_2count = $result2['7count'];
						// $count =$count+1;
						 $count =4;			
						}
				  }	
				}
				if (isset($PkgSubscriptionSlot_3)) {
				  $slot_3count = 0;
				  foreach ($PkgSubscriptionSlot_3 as $result3) {
					if (($result['product_id']==$result3['product_id'])) {
						$slot_3count = $result3['14count'];
						//$count =$count+1;
						$count =4;
					}
				  }
				} 	
				if (isset($PkgSubscriptionSlot_4)) {
				 $slot_4count = 0;
				 foreach ($PkgSubscriptionSlot_4 as $result4) {
					if (($result['product_id']==$result4['product_id'])) {
						$slot_4count = $result4['21count'];
						// $count =$count+1;
						$count =4;
					}
				 }	
				}	
				if (isset($PkgSubscriptionSlot_5)) {
				    $slot_5count = 0;
				    foreach ($PkgSubscriptionSlot_5 as $result5) {
					 if (($result['product_id']==$result5['product_id'])) {
						$slot_5count = $result5['28count'];
						// $count = $count+1;
						$count =4;
					 }
				   }
				}	
				if ($count) {
					$avrg = ($slot_2count+$slot_3count+$slot_4count+$slot_5count)/$count;
				}else{
					$avrg =0;
				}
				
				$this->data['opeartor_subs_list'][] = array(
					'username'	 => $result['username'],
					'type' => $result['isPackage']==0?'A-la-carte':'Package',
					'operator_id'       => $result['operator_id'],
					'product_id'   	    => $result['product_id'],
					'product_number'	=> $result['product_number'],
					'name' 				=> $result['name'],
					'7count'       	 	=> $slot_2count,
					'14count'       	=> $slot_3count,
					'21count'       	=> $slot_4count,
					'28count'       	=> $slot_5count,
					'average'   	    => sprintf("%.2f",$avrg),
					'price'   	     	=> sprintf("%.2f",$result['price']),
					'total'   	     	=> sprintf("%.2f",$result['price']*$avrg),
					'selected'   	 	=> isset($this->request->post['selected']) && in_array($result['operator_id'], $this->request->post['selected']),
				);
				$i=$i+1;	
			}
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_operator'] = $this->language->get('column_operator');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_operator_id'] = $this->language->get('column_operator_id');
		$this->data['column_package_id'] = $this->language->get('column_package_id');
		$this->data['column_package_name'] = $this->language->get('column_package_name');
		$this->data['column_count'] = $this->language->get('column_count');

		$this->data['column_slot1'] = $this->language->get('column_slot1');
		$this->data['column_slot2'] = $this->language->get('column_slot2');
		$this->data['column_slot3'] = $this->language->get('column_slot3');
		$this->data['column_slot4'] = $this->language->get('column_slot4');
		$this->data['column_avrg']  = $this->language->get('column_avrg');
		$this->data['column_price'] = $this->language->get('column_price');
		$this->data['column_total'] = $this->language->get('column_total');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $i;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/operator_wise_report', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/operator_wise_report.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/operator_wise_report');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
