<?php 
require_once(DIR_FPDF . 'fpdf.php');
class ControllerBulkHistoricalDeactivation extends Controller {
		private $error = array();
	
		public function index() {
			$this->language->load('bulk/historicaldeactivation');
		 
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/historicaldeactivation');
		
    		$this->getList();
  		}
  	
  	public function getList() {	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/historicaldeactivation', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		// $url = $url."&filter_option=2&filter_month_date=Jul-2016";
		$this->data['generate_report'] = $this->url->link('bulk/historicaldeactivation/generate', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_link'] = $this->language->get('column_link');
		$this->data['button_generate'] = $this->language->get('button_generate');
		$this->data['historical_deact_list'] = array();

		$data = array(
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$total = $this->model_bulk_historicaldeactivation->getTotal();
		$results = $this->model_bulk_historicaldeactivation->getZippedFiles($data);
		if($results)
			foreach ($results as $result) {			
				$this->data['historical_deact_list'][] = array(
					'name'    => $result['name'],
					'date'         => $result['date'],
					'download_url'	=> $result['download_url'],
					'user_id'	=> $result['user_id']
				);	
			}

		if(isset($this->request->get['fliteroption']))
			$this->data['filteroption']	= $this->request->get['fliteroption'];
		else
			$this->data['filteroption']=-1;

		if(isset($this->request->get['From']))
			$this->data['From']	= $this->request->get['From'];
		else
			$this->data['From']='';
		if(isset($this->request->get['To']))
			$this->data['To']	= $this->request->get['To'];
		else
			$this->data['To']='';
		if(isset($this->request->get['month']))
			$this->data['month']	= $this->request->get['month'];
		else
			$this->data['month']=-1;
		if(isset($this->request->get['year']))
			$this->data['year']	= $this->request->get['year'];
		else
			$this->data['year']=-1;
		
		$this->data['selectoptions'] = array('1'=>'From-To', '2'=>'Monthly', '3'=>'Yearly');
						
		$this->data['user_id'] = $this->session->data['user_id'];
		$this->data['token'] = $this->session->data['token'];
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/historicaldeactivation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();
		
		$this->template = 'bulk/historicaldeactivation.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

  	 function generate(){
  		$this->language->load('bulk/historicaldeactivation');
		$this->document->setTitle($this->language->get('heading_title'));
  		$this->load->model('bulk/historicaldeactivation');
  		$no_of_lines = 10000;
  		if($this->request->get['filter_option']==1)
  			$total = $this->model_bulk_historicaldeactivation->getTotalHistoricalDataDateWise($this->request->get['filter_to_date'],$this->request->get['filter_from_date']);
  		else if($this->request->get['filter_option']==2)
  			$total = $this->model_bulk_historicaldeactivation->getTotalHistoricalDataMonthly($this->request->get['filter_month_date']);
  		else if($this->request->get['filter_option']==3)
  			$total = $this->model_bulk_historicaldeactivation->getTotalHistoricalDataYearly($this->request->get['filter_year_date']);
  		
  		$no_of_files = ceil($total /$no_of_lines);

  		
  		if(!file_exists (DIR_APPLICATION."/log/bydesign"))
  			mkdir(DIR_APPLICATION."/log/bydesign");
  		$file_index=1;
  		while ($file_index <= $no_of_files) {
  			$this->createPDF("historicaldeactivation_".$file_index,(($file_index-1)*$no_of_lines),$no_of_lines);
  			$file_index++;
  		}

// ==============FOR COMPRESSING THE FOLDER===================
	    $rootPath = realpath(DIR_APPLICATION."/log/bydesign");//reports/Hist_Activation
		$datetime_obj = new DateTime("now", new DateTimeZone('Asia/Calcutta')); 
		$file_date = $datetime_obj->format('Y-m-d H:i:s');   
		$zip = new ZipArchive();
		$user_id = '_'.$this->session->data['user_id'];
		$zipname = 'reports/Hist_DeActivation/Hist_DeAct_'.$file_date.'.'.$user_id.'.zip';
		$zip->open($zipname ,  ZipArchive::CREATE | ZipArchive::OVERWRITE);
		$files = new RecursiveIteratorIterator( new RecursiveDirectoryIterator($rootPath), RecursiveIteratorIterator::LEAVES_ONLY);

		foreach ($files as $name => $file)
		{
		    // Skip directories (they would be added automatically)
		    if (!$file->isDir())
		    {
		        // Get real and relative path for current file
		        $filePath = $file->getRealPath();
		        $relativePath = substr($filePath, strlen($rootPath) + 1);

		        // Add current file to archive
		        $zip->addFile($filePath, $relativePath);
		    }
		}		  		
		$zip->close();
		
		$this->deleteDirectory(DIR_APPLICATION."/log/bydesign");
		if($no_of_files!=0){
			$this->session->data['success'] = "Report Generated Successfully!";
		}
		else{
			$this->session->data['success']="No Records in this duration!";
		}
		// $this->session->data['success']="Report Generated Successfully!";
	}
  	
  	function createPDF($filename,$start,$limit){
  			$this->ObjeFPDF = new PDF($this->config->get('config_name'),
	           $this->config->get('config_email'),
	           DIR_IMAGE.$this->config->get('config_logo'),
	           DIR_IMAGE.'data/channels/icas_logo.png',
	           $this->config->get('config_address'));
  			$this->ObjeFPDF->AddPage();
		    $this->load->model('report/blacklist');
		    $this->load->model('bulk/historicalactivation');
		    $this->load->model('bulk/historicaldeactivation');
		    $this->ObjeFPDF->SetFillColor(232,232,232);
		    $this->ObjeFPDF->SetFont('times','B',8);
			$this->ObjeFPDF->SetY(25);
			$this->ObjeFPDF->SetX(10);
			$this->ObjeFPDF->Ln();
		    
			if($_REQUEST['filter_option']==1){
			$this->ObjeFPDF->Cell(180,6,'-: Historical STB DeActivation :-   Result between:  '.$this->request->get['filter_to_date'].' TO '.$this->request->get['filter_from_date'] ,1,0,'C',1);
			}elseif ($_REQUEST['filter_option']==2) {
				$this->ObjeFPDF->Cell(180,6,'-: Historical STB DeActivation :-   Result month of: '.$this->request->get['filter_month_date'] ,1,0,'C',1);
			}elseif ($_REQUEST['filter_option']==3) {
				$this->ObjeFPDF->Cell(180,6,'-: Historical STB DeActivation :-   Result year of:  '.$this->request->get['filter_year_date'] ,1,0,'C',1);
			}
			$this->ObjeFPDF->SetY(40);
		    $w = array(10,25,45,95,130,160);
		    $c = array(15,20,50,35,30,30);	
		    $header =  array('Sl No.','Customer No','Customer Name','STB No','Triggered On','Operator');

		    for( $i = 0; $i < count($header) ; $i++){
			  if($i==0)
		    	$this->ObjeFPDF->SetX($w[0]);
		      else
			   $this->ObjeFPDF->SetX($w[$i-1]+$c[$i-1]);
			   $this->ObjeFPDF->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }

			$this->ObjeFPDF->Ln();
		    $this->ObjeFPDF->SetFont('times','',8);
 			
 			if($this->request->get['filter_option']==1)
  				$results = $this->model_bulk_historicaldeactivation->getHistoricalDataDateWise($this->request->get['filter_to_date'],$this->request->get['filter_from_date'],$start,$limit);
  			else if($this->request->get['filter_option']==2)
  				$results = $this->model_bulk_historicaldeactivation->getHistoricalDataMonthly($this->request->get['filter_month_date'],$start,$limit);
  			else if($this->request->get['filter_option']==3)
  				$results = $this->model_bulk_historicaldeactivation->getHistoricalDataYearly($this->request->get['filter_year_date'],$start,$limit);
  			$count=1;
			    foreach($results as $result){
			    	if($result["prev_stbno"]=='0'){
			    		$result["prev_stbno"] = "n/a";
			    	}
			    	if($result["STBNO"]=='' || $result["STBNO"]=='0'){
			    		$result["STBNO"] = "n/a";
			    	}
			    	$this->ObjeFPDF->SetX(10);
			    	$this->ObjeFPDF->Cell($c[0],6,$count,1,0,'L',0);
			    	$this->ObjeFPDF->Cell($c[1],6,$result["customer_unique_id"],1,0,'L',0);
			    	$this->ObjeFPDF->Cell($c[2],6,$result["name"],1,0,'L',0);
			    	$this->ObjeFPDF->Cell($c[3],6,$result["STBNO"],1,0,'L',0);
			    	$this->ObjeFPDF->Cell($c[4],6,$result['modify_date'],1,0,'L',0);
			    	$this->ObjeFPDF->Cell($c[5],6,substr(strtolower($result["username"]),0,14),1,0,'L',0);
			    	$this->ObjeFPDF->Ln();
			    	$count++;
		        }

		$this->ObjeFPDF->Ln();   
		/*$this->ObjeFPDF->Cell(70,6,'Date',0,0,'C',0);
		$this->ObjeFPDF->Cell(130,6,'Signature',0,0,'C',0);
		$this->ObjeFPDF->Ln(8);
		$this->ObjeFPDF->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		$this->ObjeFPDF->Cell(130,6,'--------------------',0,0,'C',0);*/
		$this->ObjeFPDF->Output(DIR_APPLICATION."/log/bydesign/".$filename.'.pdf','F');
		unset($this->ObjeFPDF);
  	}
	
	function deleteDirectory($dir) {
// $dir = $this->request->get['dir'];
    	// if (!file_exists($dir)) {
     //    	return true;
	    // }
	    // if (!is_dir($dir)) {
    	//     return unlink($dir);
    	// }
	    foreach (scandir($dir) as $item) {
    	    if ($item == '.' || $item == '..') {
        	    continue;
	        }else{
	        	unlink($dir."/".$item);
	    	}
    	}
    	rmdir($dir);
 	}


 }
