<?php 
  /*
@File deactvsubsageing.php(Controller)
ADMIN AGEING PAGE
    This class show the ageing of the subscriber on the particular channel or package

@Author Ravi Ranjan 
@date 5th Aug. 2016
*/
class ControllerBulkDeactvsubsageing extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the ageing of the subscriber on the particular channel or package and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the ageing data page
*/
public function index() {
		$this->language->load('bulk/deactvsubsageing');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/deactvsubsageing');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
	public function printPdf(){
		$this->load->model('bulk/deactvsubsageing');
		$this->language->load('bulk/deactvsubsageing');
		if (isset($this->request->post['selected']))
		{
		    $this->pdf->AddPage();
		    $this->load->model('report/casnetworkreport');
		    $this->pdf->SetFillColor(232,232,232);
		   	$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);

			$this->pdf->Cell(170,6,'-: Deactivated Subscriber ageing :-',1,0,'C',1);

		    $this->pdf->Ln();
			$this->pdf->SetFont('times','B',8);
		    $w = array(20,35,100,130,160);
	    	$c = array(15,65,30,30,30);		
		    $this->pdf->SetY(40);
		    $header =  array('Sl No.','Customer Name','STBNO','Deactivated Time','Elapsed duration (days)');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }

			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
		    $count=1;

		      	foreach ($this->request->post['selected'] as $customer_id) {		      	   
		      	   $customer_id = explode("~", $customer_id);
		      	   $sl_no = $customer_id[1];
		      	   $results = $this->model_bulk_deactvsubsageing->getAgeingCustomer($customer_id[0]);

		    		foreach($results as $result){
		    			$day=abs($result['duration']);
		    			$c_height=6;
		     			$this->pdf->SetX(20);
				    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
				    	$x_axis=$this->pdf->getx();
			    		$this->pdf->vcell($c[1],$c_height,$x_axis,$result["name"],25);
				    	$this->pdf->Cell($c[2],6,$result["STBNO"],1,0,'L',0);
				    	$this->pdf->Cell($c[3],6,$result['active_date'],1,0,'L',0);
				    	$this->pdf->Cell($c[3],6,$day." "."days" ,1,0,'L',0);
				    	$this->pdf->Ln();
				 		$count++;
	        		}
	        	}
		                  
		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		    $this->pdf->Output();
		}else{
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the ageing customer details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_stbno'])) {
			$this->data['filter_stbno'] = $this->request->get['filter_stbno'];
		} else {
			$this->data['filter_stbno'] ='';
		}

		if (isset($this->request->get['filter_stbno'])) {
			$filter_stbno = $this->request->get['filter_stbno'];
		} else {
			$filter_stbno = '';
		}

		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/deactvsubsageing', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'filter_stbno'	  => $filter_stbno,	
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total=$this->model_bulk_deactvsubsageing->getTotalageing($data);		
		$this->data['ageings'] = array();
		$results = $this->model_bulk_deactvsubsageing->getAgeing($data);
		$i = 0;
		foreach ($results as $result) {
			$i++;
			$days = abs($result['duration']);
			$this->data['ageings'][] = array(  
				'customer_id' 	=> $result['customer_id'],
				'customer_no'    =>($page - 1) * $this->config->get('config_admin_limit')+$i,
				'name'       	=> $result['name'],
				'stbno'       	=> $result['STBNO'],
				'date'       	=> $result['active_date'],
				'time'       	=> $days." "."days",
				'selected'   	=> isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);	
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_deactv_time'] = $this->language->get('column_deactv_time');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_time'] = $this->language->get('column_time');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		$this->data['printPdf'] = $this->url->link('bulk/deactvsubsageing/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		if (isset($this->request->get['filter_stbno'])) {
			$url .= '&filter_stbno=' . $this->request->get['filter_stbno'];
		}

		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/deactvsubsageing', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/deactvsubsageing.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
