<?php 
class ControllerBulkBroadcasterAvgActiveSubscriber extends Controller {
	private $error = array();
	public function index() {
		// var_dump("expression");die;
		$this->language->load('bulk/broadcaster_avg_active_subscriber');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/broadcaster_avg_active_subscriber');
    	$this->getList();
  	}
	public function printPdf(){   
	    $this->load->model('bulk/broadcaster_avg_active_subscriber');
	    $this->pdf->AddPage();
	    $this->pdf->SetFillColor(232,232,232);
		$this->pdf->SetFont('times','B',8);

		$final_count_array = array();
		if (isset($this->request->get['filter_month'])) {
			 $data = array(
					'filter_month'           => $this->request->get['filter_month'],
				);
			$ReportData = $this->model_bulk_broadcaster_avg_active_subscriber->BroadcasterAvgActSubscriber($data);
			$BroadcasterAvgActSubscriber_1 = $ReportData[0];
			$BroadcasterAvgActSubscriber_2 = $ReportData[1];
			$BroadcasterAvgActSubscriber_3 = $ReportData[2];
			$BroadcasterAvgActSubscriber_4 = $ReportData[3];
			$final_count_array=array ('SD'=>array(	
										'name'=>'Standard Definition',
										'slot_1'=>0,
										'slot_2'=>0,
										'slot_3'=>0,
										'slot_4'=>0),
						'HD'=>array(	'name'=> 'High Definition',
										'slot_1'=>0,
										'slot_2'=>0,
										'slot_3'=>0,
										'slot_4'=>0)
						);
			foreach ($BroadcasterAvgActSubscriber_1 as $value) {
				if($value['type']=='SD'){
					$final_count_array[$value['type']]['slot_1'] = $value['count'];	
				}elseif($value['type']=='HD'){
					$final_count_array[$value['type']]['slot_1'] = $value['count'];	
				}
			}
			if($BroadcasterAvgActSubscriber_2){			
				foreach ($BroadcasterAvgActSubscriber_2 as $value) {
					if($value['type']=='SD'){
						$final_count_array[$value['type']]['slot_2'] = $value['count'];	
					}elseif($value['type']=='HD'){
						$final_count_array[$value['type']]['slot_2'] = $value['count'];	
					}
				}
			}
			if($BroadcasterAvgActSubscriber_3){			
				foreach ($BroadcasterAvgActSubscriber_3 as $value) {
					if($value['type']=='SD'){
						$final_count_array[$value['type']]['slot_3'] = $value['count'];	
					}elseif($value['type']=='HD'){
						$final_count_array[$value['type']]['slot_3'] = $value['count'];	
					}
				}
			}
			if($BroadcasterAvgActSubscriber_4){			
				foreach ($BroadcasterAvgActSubscriber_4 as $value) {
					if($value['type']=='SD'){
						$final_count_array[$value['type']]['slot_4'] = $value['count'];	
					}elseif($value['type']=='HD'){
						$final_count_array[$value['type']]['slot_4'] = $value['count'];	
					}
				}
			}
			
			$final_count_array['SD']['average']=($final_count_array['SD']['slot_1']+$final_count_array['SD']['slot_2']+$final_count_array['SD']['slot_3']+$final_count_array['SD']['slot_4'])/4;
			$final_count_array['HD']['average']=($final_count_array['HD']['slot_1']+$final_count_array['HD']['slot_2']+$final_count_array['HD']['slot_3']+$final_count_array['HD']['slot_4'])/4;
		}
	
		$this->pdf->SetY($this->pdf->GetY()+4);
		$this->pdf->SetX(10);
		$this->pdf->Cell(190,6,'-:Average Active Subscriber Base In A Month In The Target Market:- ',1,0,'C',1);

		if(isset($this->request->get['filter_month']) && $this->request->get['filter_month']!=''){
			$this->pdf->SetY($this->pdf->GetY()+8);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->Cell(40,4,"FILTER MONTH",1,0,'L',1);
			$this->pdf->SetFont('times','',8);
			$this->pdf->Cell(150,4,$this->request->get['filter_month'],1,0,'L',0);
		}

	    $header =  array('#','Type of STB','Active Subscriber Base Count on 7th of Month','Active Subscriber Base Count on 14th of Month','Active Subscriber Base Count on 21st of Month','Active Subscriber Base Count on 28th of Month','Average Subscriber Base in the month');
		$w = array(10,20,50,80,110,140,170);
    	$c = array(10,30,30,30,30,30,30);

	    $this->pdf->SetY($this->pdf->GetY()+5);
	    $this->pdf->SetFont('times','B',8);
	    $count = 1;
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
			$x_axis=$this->pdf->getx();
			$this->pdf->vcell($c[$i],6,$x_axis,$header[$i],18);
	    }

		$this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
		foreach ($final_count_array as $values) {
			$this->pdf->SetX(10);
			$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
			
			$this->pdf->Cell($c[1],6,$values['name'],1,0,'C',0);
			$this->pdf->Cell($c[2],6,$values['slot_1'],1,0,'C',0);
			$this->pdf->Cell($c[3],6,$values['slot_2'],1,0,'C',0);
			$this->pdf->Cell($c[4],6,$values['slot_3'],1,0,'C',0);
			$this->pdf->Cell($c[5],6,$values['slot_4'],1,0,'C',0);
			$this->pdf->Cell($c[6],6,floor($values['average']),1,0,'C',0);
	    	$this->pdf->Ln();
	    	$count++;
		}
		$this->pdf->Output();
    }  	
  	
public function getList() {	 #var_dump($this->request->get['filter_region']);
		$this->load->model('bulk/broadcaster_avg_active_subscriber');
			
		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
			$this->data['filter_month']	= $this->request->get['filter_month'];
		} else {
			$filter_month = '';
			$this->data['filter_month']	='';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		$this->data['printPdf'] = $this->url->link('bulk/broadcaster_avg_active_subscriber/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/broadcaster_avg_active_subscriber', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);
	
		$data = array(
			'filter_month'           => $filter_month,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$this->data['brodcasterAvgActList']=array();
		$final_count_array = array();
		if (isset($this->request->get['filter_month'])) {
			$ReportData = $this->model_bulk_broadcaster_avg_active_subscriber->BroadcasterAvgActSubscriber($data);
			$BroadcasterAvgActSubscriber_1 = $ReportData[0];
			$BroadcasterAvgActSubscriber_2 = $ReportData[1];
			$BroadcasterAvgActSubscriber_3 = $ReportData[2];
			$BroadcasterAvgActSubscriber_4 = $ReportData[3];
			$final_count_array=array ('SD'=>array(	
										'name'=>'Standard Definition',
										'slot_1'=>0,
										'slot_2'=>0,
										'slot_3'=>0,
										'slot_4'=>0),
						'HD'=>array(	'name'=> 'High Definition',
										'slot_1'=>0,
										'slot_2'=>0,
										'slot_3'=>0,
										'slot_4'=>0)
						);
			foreach ($BroadcasterAvgActSubscriber_1 as $value) {
				if($value['type']=='SD'){
					$final_count_array[$value['type']]['slot_1'] = $value['count'];	
				}elseif($value['type']=='HD'){
					$final_count_array[$value['type']]['slot_1'] = $value['count'];	
				}
			}
			if($BroadcasterAvgActSubscriber_2){			
				foreach ($BroadcasterAvgActSubscriber_2 as $value) {
					if($value['type']=='SD'){
						$final_count_array[$value['type']]['slot_2'] = $value['count'];	
					}elseif($value['type']=='HD'){
						$final_count_array[$value['type']]['slot_2'] = $value['count'];	
					}
				}
			}
			if($BroadcasterAvgActSubscriber_3){			
				foreach ($BroadcasterAvgActSubscriber_3 as $value) {
					if($value['type']=='SD'){
						$final_count_array[$value['type']]['slot_3'] = $value['count'];	
					}elseif($value['type']=='HD'){
						$final_count_array[$value['type']]['slot_3'] = $value['count'];	
					}
				}
			}
			if($BroadcasterAvgActSubscriber_4){			
				foreach ($BroadcasterAvgActSubscriber_4 as $value) {
					if($value['type']=='SD'){
						$final_count_array[$value['type']]['slot_4'] = $value['count'];	
					}elseif($value['type']=='HD'){
						$final_count_array[$value['type']]['slot_4'] = $value['count'];	
					}
				}
			}
			
			$final_count_array['SD']['average']=($final_count_array['SD']['slot_1']+$final_count_array['SD']['slot_2']+$final_count_array['SD']['slot_3']+$final_count_array['SD']['slot_4'])/4;
			$final_count_array['HD']['average']=($final_count_array['HD']['slot_1']+$final_count_array['HD']['slot_2']+$final_count_array['HD']['slot_3']+$final_count_array['HD']['slot_4'])/4;
			// echo "<pre>"; echo count($final_count_array); print_r($final_count_array);die;
		}

		$total =0 ;
		if (isset($this->request->get['filter_month'])) {
			$total = count($final_count_array);
			$this->data['brodcasterAvgActList'] = $final_count_array;
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_pid'] = $this->language->get('column_pid');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_subscription_type'] = $this->language->get('column_subscription_type');
		$this->data['column_slot_1'] = $this->language->get('column_slot_1');
		$this->data['column_slot_2'] = $this->language->get('column_slot_2');
		$this->data['column_slot_3'] = $this->language->get('column_slot_3');
		$this->data['column_slot_4'] = $this->language->get('column_slot_4');
		$this->data['column_average'] = $this->language->get('column_average');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/broadcaster_avg_active_subscriber', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/broadcaster_avg_active_subscriber.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/broadcaster_avg_active_subscriber');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
