<?php 
 /*
@File customer.php(Controller)
ADMIN CUSTOMER PAGE
    This class show total authorized subscribers in the store

@Author Ravi Ranjan 
@date 26th Nov. 2015
*/ 
class ControllerBulkBlackList extends Controller { 
	private $error = array();
  /*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the authorized subscriber details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  authorized subscriber page
*/
  	public function index() {
		$this->language->load('bulk/blacklist');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/blacklist');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  
  	public function printPdf(){
  		if(isset($this->request->post['selected']))	{	
		    $this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
			$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);

			$this->pdf->Cell(170,6,'-: BlackList Subscriber List On Network :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    $w = array(20,40);
		    $c = array(20,150);
		    $this->pdf->SetY(40);	
		    $this->load->model('bulk/blacklist');
		    $header =  array('Sl No.','STB No');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}		
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;

			foreach($this->request->post['selected'] as $values){		    	
				$SelectedItems=substr($values,0,strpos($values,'~'));
		    	$BlacklistResult = $this->model_bulk_blacklist->getCustomerpdf($SelectedItems);
		    	foreach ($BlacklistResult as $result) {
				   	$this->pdf->SetX(20);
				   	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
				   	$this->pdf->Cell($c[1],6,$result["stb_no"],1,0,'L',0);			   
				   	$this->pdf->Ln();
					$count++;
				}
		    }
	              
		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		    ob_clean();
		    $this->pdf->Output();
    }
}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the authorized subscribers details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/    
  	public function getList() {	

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/blacklist', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		
		$this->data['customers'] = array();
		$this->load->model('bulk/blacklist');
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_bulk_blacklist->getTotalAuthSubs();
		$results = $this->model_bulk_blacklist->getCustomers($data);
 		
 		$i=0;
    	foreach ($results as $result) {
    		// $hw = $this->model_bulk_blacklist->getStbHw($result['STBNO']);
			$i=$i+1;
			$this->data['customers'][] = array(
				'customer_id'    => $result['customer_id'],
				'customer_no'    =>($page - 1) * $this->config->get('config_admin_limit')+$i,
			
				'STBNO'          => $result['stb_no'],

				'selected'       => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);
		}	
					
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_cas'] = $this->language->get('column_cas');
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');	
		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_default'] = $this->language->get('text_default');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_caf'] = $this->language->get('column_caf');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_operator_id'] = $this->language->get('column_operator_id');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_pay'] = $this->language->get('column_pay');
		$this->data['column_balance'] = $this->language->get('column_balance');
		$this->data['printPdf'] = $this->url->link('bulk/blacklist/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/blacklist', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
		
		$this->data['sort_name'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
	    $this->data['sort_stbno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=STBNO' . $url, 'SSL');
		$this->data['sort_casno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=CASNO' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';
		
		$this->template = 'bulk/blacklist.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
}
?>