<?php 
require_once(DIR_FPDF . 'fpdf.php');
class ControllerBulkActvDeactvsubscount extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/actvdeactvsubscount');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/actvdeactvsubscount');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		// var_dump($this->request->post);exit();
			$this->load->model('bulk/actvdeactvsubscount');
		    $this->pdf->AddPage('P',array(250,250));
		    $this->pdf->SetFillColor(232,232,232);

			$this->pdf->SetY(40);
			$this->pdf->SetX(20);
			// if($_REQUEST['option']==1 && $_REQUEST['filter_option']==''){
			// 	$this->pdf->Cell(214,6,'-: Total No. Of Subscriber Active/Deactive :-',1,0,'C',1);
			// }
			// else
			if($_REQUEST['filter_status']==1)
				$status = "Active";
			else
				$status = "Deactive";
			
			if($_REQUEST['filter_option']==1){
				$this->pdf->Cell(190,6,'-: Total No. Of Subscriber '.$status.' :-   Result between:  '.$this->request->post['filter_date_start'].' TO '.$this->request->post['filter_date_end'] ,1,0,'C',1);
			}elseif ($_REQUEST['filter_option']==2) {
				$this->pdf->Cell(190,6,'-: Total No. Of Subscriber '.$status.' :-   Result of month: '.$_REQUEST['filter_month'] ,1,0,'C',1);
			}elseif ($_REQUEST['filter_option']==3) {
				$this->pdf->Cell(190,6,'-: Total No. Of Subscriber '.$status.' :-   Result of year:  '.$_REQUEST['filter_year'] ,1,0,'C',1);
			}
			$this->pdf->SetY(48);
		    $w = array(45,105);
		    $c = array(60,60);
		    $header =  array('Time Duration','Total No. Of Subscriber '.$status.' Count');
			for( $i = 0; $i < count($header) ; $i++){
					if($i==0)
				    	$this->pdf->SetX($w[0]);
				    else
						$this->pdf->SetX($w[$i-1]+$c[$i-1]);
						$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
				}
	        // $count=0;
	    $time="";
		if($this->request->get['filter_option']==1){
			$time=($this->request->get['filter_date_start']."-".$this->request->get['filter_date_end']);
		}elseif($this->request->get['filter_option']==2){
			$time=$this->request->get['filter_month'];
		}elseif($this->request->get['filter_option']==3){
			$time=$this->request->get['filter_year'];
		}
		$i=0;
		// $results = $this->model_bulk_actvdeactvsubscount->getTotalActiveDeactive($this->request->get);
		// if($results){
		// $data[] = array($time,$results);
		// $count++;
		// }
	    $this->pdf->SetFont('times','',8);
        $rows[]=array();
        $this->pdf->Ln();
	 	$this->pdf->SetX(45);
	 	$this->pdf->Cell($c[0],6,$time,1,0,'L',0);
	 	$this->pdf->Cell($c[1],6,$this->request->get["count"],1,0,'L',0);
	 	$this->pdf->Ln(); 		

	   /* $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
	   	ob_clean();
	    $this->pdf->Output();
    }

    public function countUppercase($string) {
    	return strlen(preg_replace('![^A-Z]+!', '', $string));
	}
  	
  	public function getList() {
  		$this->load->model('bulk/actvdeactvsubscount');
  		if(isset($this->data['error_start']))
			$this->data['error_filter_date_start']=$this->data['error_start'];
		else
			$this->data['error_filter_date_start']='';

		if(isset($this->data['error_end']))
			$this->data['error_filter_date_end']=$this->data['error_end'];
		else
			$this->data['error_filter_date_end']='';

		if(isset($this->data['error_month']))
			$this->data['error_filter_month']=$this->data['error_month'];
		else
			$this->data['error_filter_month']='';

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
		} else {
			$filter_month = '';
		}
		
		if (isset($this->request->get['filter_year'])) {
			$filter_year = $this->request->get['filter_year'];
		} else {
			$filter_year = '';
		}	

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
			$this->data['filter_status']	= $this->request->get['filter_status'];
		} else {
			$filter_status = '';
			$this->data['filter_status']	= '';
		}	

		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
			$this->data['filter_option']	= $this->request->get['filter_option'];
		} else {
			$filter_option = '';
			$this->data['filter_option']	= '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		if (isset($this->request->get['filter_year'])) {
			$url .= '&filter_year=' . $this->request->get['filter_year'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}

  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   // 		$this->data['breadcrumbs'][] = array(
   //     		'text'      => $this->language->get('heading_title'),
			// 'href'      => $this->url->link('bulk/actvdeactvsubscount', 'token=' . $this->session->data['token'] . $url, 'SSL'),
   //    		'separator' => ' :: '
   // 		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/actvdeactvsubscount', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);
		// $url = $url."&filter_option=2&filter_month_date=Jul-2016";

		$this->data['generate_report'] = $this->url->link('bulk/actvdeactvsubscount/generate', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_count'] = $this->language->get('column_count');
		$this->data['column_time'] = $this->language->get('column_time');
		
		
		$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['historical_act_list'] = array();
		// $data = array(
		// 	'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
		// 	'limit'                  => $this->config->get('config_admin_limit')
		// );

		$data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end, 
			'filter_month'           => $filter_month,
			'filter_year' 		     => $filter_year,
			'filter_status' 		 => $filter_status,
			'filter_option' 		 => $filter_option,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);
		
		// var_dump($this->data['printPdf']);exit();
$i=0;
$active_counter=0;
$deactive_counter=0;
		$time="";
		if($data['filter_option']==1){
			$time=($data['filter_date_start']." To ".$data['filter_date_end']);
		}elseif($data['filter_option']==2){
			$time=$data['filter_month'];
		}elseif($data['filter_option']==3){
			$time=$data['filter_year'];
		}
		// $i=0;
		// $active_counter=0;
		// $deactive_counter=0;
		// $results = $this->model_bulk_actvdeactvsubscount->getTotalActiveDeactive($data);
		// // echo "<pre>"; print_r($results);
		// if (isset($results)) {
		// 	foreach ($results as $value) {
		// 		$cmd_id_status = $this->model_bulk_actvdeactvsubscount->getTotalActiveDeactive1($value['max_date'],$value['user_id']);
		// 		if($cmd_id_status!=''){					
		// 		foreach ($cmd_id_status as $value) {
		// 			if($data["filter_status"]==1 && $value['cmd_id']==0){
		// 				$active_counter=$active_counter+1;
		// 			} elseif($data["filter_status"]==0 && $value['cmd_id']==1){
		// 				$deactive_counter++;
		// 			}
		// 		}
		// 	  }			
		// 	}
		// }
				
		// if(isset($results)){
		// 	if($data['filter_status']==1){
		// 		$this->data['historical_act_list'][] = array(					
		// 			'time'    	=> $time,
		// 			'count'    	=> $active_counter,
		// 		);
		// 		$i=$i+1;
		// 	}else{
		// 		$this->data['historical_act_list'][] = array(
		// 			'time'    	=> $time,
		// 			'count'    	=> $deactive_counter,
		// 		);
		// 		$i=$i+1;
		// 	}
		// }

		if($data["filter_option"]){
			$results = $this->model_bulk_actvdeactvsubscount->getTotalActiveDeactive_26Nov($data);
			$this->data['historical_act_list'][] = array(
				'time'    	=> $time,
				'count'    	=> $results,
			);
		}

		if (isset($this->data['historical_act_list'][0]['count'])) {
			$this->data['printPdf'] = $this->url->link('bulk/actvdeactvsubscount/printPdf', 'token=' . $this->session->data['token']. $url.'&count='.$this->data['historical_act_list'][0]['count'], 'SSL');	
		}else{
			$this->data['printPdf'] = $this->url->link('bulk/actvdeactvsubscount/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');
		}
		
		$total=$i;	
		$this->data['token'] = $this->session->data['token'];
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/actvdeactvsubscount', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();

		$this->data['filter_date_start'] = $filter_date_start;
		$this->data['filter_date_end'] = $filter_date_end;
		$this->data['filter_month'] = $filter_month;

		$this->template = 'bulk/actvdeactvsubscount.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/actvdeactvsubscount');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && $this->validateDate()){

		 }
		$this->getList();
	}

	/*
FUNCTION NAME 		-	validateDate
DESCRIPTION 		-	validates the filter dates given to filter.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/	
	public function validateDate(){
		if(!isset($this->request->get['filter_date_start']))
		{
			$this->data['error_start'] = $this->language->get('error_startdate_req');;
		}
		else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_start']))
    	{
        		$this->data['error_start'] = $this->language->get('error_date_format');
        }
		if(!isset($this->request->get['filter_date_end']))
		{
			$this->data['error_end'] = $this->language->get('error_enddate_req');
		}
		else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_end']))
    			{
        			$this->data['error_end'] = $this->language->get('error_date_format');
        		}
        if(!isset($this->request->get['filter_month']))
		{
			$this->data['error_month'] = $this->language->get('error_startdate_req');;
		}		

	if (!$this->data) {
	  		return true;
		} else {
	  		return false;
		}

	}

  	function generate(){
  		$this->language->load('bulk/actvdeactvsubscount');
		$this->document->setTitle($this->language->get('heading_title'));
  		$this->load->model('bulk/actvdeactvsubscount');
  		$no_of_lines = 2;
  		if($this->request->get['filter_option']==1)
  			$total = $this->model_bulk_actvdeactvsubscount->getTotalHistoricalDataDateWise($this->request->get['filter_to_date'],$this->request->get['filter_from_date']);
  		else if($this->request->get['filter_option']==2)
  			$total = $this->model_bulk_actvdeactvsubscount->getTotalHistoricalDataMonthly($this->request->get['filter_month_date']);
  		else if($this->request->get['filter_option']==3)
  			$total = $this->model_bulk_actvdeactvsubscount->getTotalHistoricalDataYearly($this->request->get['filter_year_date']);
  		$no_of_files = ceil($total /$no_of_lines);
  		if(!file_exists ("bydesign"))
  			mkdir(DIR_APPLICATION."bydesign");
  		$file_index=1;
  		while ($file_index <= $no_of_files) {
  			$this->createPDF("historicalactivation_".$file_index,(($file_index-1)*$no_of_lines),$no_of_lines);
  			$file_index++;
  		}
// ==============FOR COMPRESSING THE FOLDER===================
	    $rootPath = realpath('bydesign');//reports/Hist_Activation
$datetime_obj = new DateTime("now", new DateTimeZone('Asia/Calcutta')); 
$file_date = $datetime_obj->format('Y-m-d H:i:s');   
		$zip = new ZipArchive();
		$zipname = 'reports/Hist_Activation/Hist_Act_'.$file_date.'.zip';
		$zip->open($zipname ,  ZipArchive::CREATE | ZipArchive::OVERWRITE);
		$files = new RecursiveIteratorIterator( new RecursiveDirectoryIterator($rootPath), RecursiveIteratorIterator::LEAVES_ONLY);
		foreach ($files as $name => $file)
		{
		    // Skip directories (they would be added automatically)
		    if (!$file->isDir())
		    {
		        // Get real and relative path for current file
		        $filePath = $file->getRealPath();
		        $relativePath = substr($filePath, strlen($rootPath) + 1);

		        // Add current file to archive
		        $zip->addFile($filePath, $relativePath);
		    }
		}
		$zip->close();
		$this->deleteDirectory("bydesign");
		$this->session->data['success']="Report Generated Successfully!";
	}
  	
  	function createPDF($filename,$start,$limit){
  		$this->pdf = new FPDF();
  			$this->pdf->AddPage();
		    $this->load->model('report/blacklist');
		   	$this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_blacklist->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(8);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(11);
			$this->pdf->SetX(65);
			$this->pdf->Cell(192,6,$user['email'],0,0,'C',0);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(20);
			$this->pdf->Cell(184,6,'-: Historical STB Activation:-',1,0,'C',1);
			$this->pdf->SetY(30);
		    $w = array(20, 42, 92,122,152);
		    $c = array(22, 50, 30,30,40);	
		    $header =  array('STB No','Customer Name','Activated','DeActivated','Operator');

		    for( $i = 0; $i < count($header) ; $i++){
			  if($i==0)
		    	$this->pdf->SetX($w[0]);
		      else
			   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
 			$this->load->model('bulk/actvdeactvsubscount');
 			if($this->request->get['filter_option']==1)
  				$results = $this->model_bulk_actvdeactvsubscount->getHistoricalDataDateWise($this->request->get['filter_to_date'],$this->request->get['filter_from_date'],$start,$limit);
  			else if($this->request->get['filter_option']==2)
  				$results = $this->model_bulk_actvdeactvsubscount->getHistoricalDataMonthly($this->request->get['filter_month_date'],$start,$limit);
  			else if($this->request->get['filter_option']==3)
  				$results = $this->model_bulk_actvdeactvsubscount->getHistoricalDataYearly($this->request->get['filter_year_date'],$start,$limit);
  			$this->pdf->Ln();
			$this->pdf->SetFont('times','',8);
			$this->pdf->SetX(20);
			$this->pdf->SetY(36);
			$temp=6;$i=1;
			    foreach($results as $result){
			    	$this->pdf->SetX(20);
			    	$this->pdf->Cell($c[0],6,$result["STBNO"],1,0,'L',0);
			    	$this->pdf->Cell($c[1],6,$result["name"],1,0,'L',0);
			    	$this->pdf->Cell($c[2],6,$result["modify_date"],1,0,'L',0);
			    	$this->pdf->Cell($c[3],6,$result["exp_date"],1,0,'L',0);
			    	// $this->pdf->Cell($c[4],6,$result["username"],1,0,'L',0);
			    	$this->pdf->Cell($c[4],6,'Admin',1,0,'L',0);
			    	$this->pdf->Ln();
			    	$i++;
		        }

		$this->pdf->Ln();
		$this->pdf->Ln();
		$this->pdf->Ln();
		$this->pdf->Ln();   
		$this->pdf->Cell(70,6,'Date',0,0,'C',0);
		$this->pdf->Cell(130,6,'Signature',0,0,'C',0);
		$this->pdf->Ln(8);
		$this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		$this->pdf->Cell(130,6,'--------------------',0,0,'C',0);
		$this->pdf->Output('bydesign/'.$filename.'.pdf','F');
  	}
  	function deleteDirectory($dir) {
// $dir = $this->request->get['dir'];
    	// if (!file_exists($dir)) {
     //    	return true;
	    // }
	    // if (!is_dir($dir)) {
    	//     return unlink($dir);
    	// }
	    foreach (scandir($dir) as $item) {
    	    if ($item == '.' || $item == '..') {
        	    continue;
	        }else{
	        	unlink($dir."/".$item);
	    	}
    	}
    	rmdir($dir);
 	}
 }
